<?php
    // فرض می‌کنیم این متغیرها از والد (LetterShow) ارسال می‌شوند
    $isReply = $isReply ?? false;
    $replyParentId = $replyParentId ?? null;

    // تعیین کلاس‌های استایل
    $boxClass = $isReply ? 'comment-box-reply' : 'shadow-sm';
    $wrapperClass = $isReply ? 'mt-3' : 'comment-box-wrapper';
    $borderStyle = $isReply ? 'border-right: 3px solid var(--primary-100); padding-right: 12px; margin-right: 8px;' : '';
?>

<div class="<?php echo e($wrapperClass); ?>" style="<?php echo e($borderStyle); ?>">
    <div class="comment-box <?php echo e($boxClass); ?>">

        <div class="comment-meta d-flex align-items-center gap-3">
            <img src="<?php echo e($this->getUserProfilePhotoUrl($comment->user)); ?>"
                 class="comment-avatar rounded-circle"
                 alt="<?php echo e($comment->user->name ?? 'کاربر'); ?>">
            <div>
                <div class="fw-bold"><?php echo e($comment->user->name ?? 'کاربر ناشناس'); ?></div>
                <div class="text-muted small">
                    <i class="far fa-clock me-1"></i>
                    <?php echo e($this->formatShamsiDate($comment->created_at, 'Y/m/d H:i')); ?>

                </div>
            </div>
        </div>

        <div class="comment-body mt-3">
            <?php echo nl2br(e($comment->body)); ?>

        </div>

        <?php if(!$isReply): ?>
            <div class="d-flex gap-2 mt-2">
                <button wire:click="replyTo(<?php echo e($comment->id); ?>)"
                        class="comment-action d-flex align-items-center btn btn-sm"
                        style="color: var(--primary); background: transparent; padding: 4px 8px !important;">
                    <i class="fas fa-reply me-1"></i> پاسخ
                </button>
                <?php if($comment->user_id === Auth::id()): ?>
                    <button wire:click="deleteComment(<?php echo e($comment->id); ?>)"
                            class="comment-action d-flex align-items-center btn btn-sm text-danger"
                            style="background: transparent; padding: 4px 8px !important;">
                        <i class="fas fa-trash me-1"></i> حذف
                    </button>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if($comment->replies->count()): ?>
            <div class="mt-4 ps-3" style="border-right: 3px solid var(--primary-100); margin-right: 12px;">
                <?php $__currentLoopData = $comment->replies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    
                    <?php echo $__env->make('livewire.admin.letter.partials.comment', [
                        'comment' => $reply,
                        'replyParentId' => $replyParentId,
                        'isReply' => true,
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\letter\partials\comment.blade.php ENDPATH**/ ?>