<div class="container py-4">
    <div class="card shadow-sm">
        <?php if(session()->has('message')): ?>
            <div class="alert alert-success alert-dismissible fade show m-3">
                <?php echo e(session('message')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <form wire:submit.prevent="upload">
            <div class="card-body p-4">
                <h5 class="fs-4 fw-semibold mb-4">آپلود فایل به مسیر Project/File</h5>

                <!-- انتخاب فایل -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">
                        <i class="fas fa-file-upload me-2"></i>
                        انتخاب فایل‌ها (چند انتخابی)
                    </label>
                    <input
                        type="file"
                        class="form-control"
                        wire:model="files"
                        multiple
                        required
                    >
                    <?php $__errorArgs = ['files.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- لیست فایل‌های انتخاب شده -->
                <?php if(count($uploadedFiles) > 0): ?>
                    <div class="mb-4">
                        <div class="list-group">
                            <?php $__currentLoopData = $uploadedFiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                    <div class="d-flex align-items-center gap-2">
                                        <i class="fas fa-file text-primary"></i>
                                        <span><?php echo e($file->getClientOriginalName()); ?></span>
                                    </div>
                                    <button
                                        type="button"
                                        class="btn btn-sm btn-outline-danger"
                                        wire:click="removeFile(<?php echo e($index); ?>)"
                                    >
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- دکمه آپلود -->
                <button
                    type="submit"
                    class="btn btn-primary w-100 py-3"
                    wire:loading.attr="disabled"
                >
                    <i class="fas fa-upload me-2"></i>
                    <span wire:loading.remove>آپلود فایل‌ها (<?php echo e(count($uploadedFiles)); ?>)</span>
                    <span wire:loading>در حال آپلود...</span>
                </button>
            </div>
        </form>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\project-files\project-file-upload.blade.php ENDPATH**/ ?>