<div wire:ignore.self class="modal fade" id="transmittalModal" tabindex="-1" aria-labelledby="transmittalModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header bg-info text-white" style="border-radius: 14px 14px 0 0;">
                <h5 class="modal-title" id="transmittalModalLabel">
                    <i class="fas fa-exchange-alt me-2"></i>
                    <?php echo e(__('تاریخچه ترنسمیتال‌ها')); ?>

                </h5>
                <button type="button" class="btn-close btn-close-white" wire:click="closeTransmittalModal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">
                <h6 class="fw-bold mb-3" style="color: var(--brand-dark);">
                    <?php echo e(__('مدرک')); ?>: <?php echo e($selectedDocNumber); ?>

                </h6>

                <?php $__empty_1 = true; $__currentLoopData = $selectedTransmittals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $td): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $trans = $td->transmittal;
                        $statusClass = match($trans?->status) {
                            'ارسال شده' => 'bg-primary',
                            'دریافت شده' => 'bg-success',
                            default => 'bg-secondary'
                        };
                    ?>
                    <?php if($trans): ?>
                        <div class="card mb-3 shadow-sm border-0 border-end border-3 border-<?php echo e($statusClass == 'bg-success' ? 'success' : 'primary'); ?>">
                            <div class="card-body p-3">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div>
                                        <h6 class="mb-1 fw-bold text-monospace">
                                            <a href="<?php echo e(route('transmittals.show', $trans->id)); ?>" target="_blank" class="text-decoration-none" style="color: var(--brand-dark);">
                                                <i class="fas fa-envelope-open-text me-1"></i> <?php echo e($trans->transmittal_number); ?>

                                            </a>
                                        </h6>
                                        <p class="mb-1 small text-muted">
                                            <?php echo e(__('تاریخ ارسال')); ?>: <?php echo e($trans->sent_at_formatted); ?>

                                            <?php if($trans->received_at): ?> | <?php echo e(__('تاریخ دریافت')); ?>: <?php echo e($trans->received_at_formatted); ?> <?php endif; ?>
                                        </p>
                                        <p class="mb-1 small">
                                            <i class="fas fa-arrow-up text-primary me-1"></i>
                                            <?php echo e(__('فرستنده')); ?>: <?php echo e($trans->sender?->name ?? 'سیستم'); ?>

                                        </p>
                                        <p class="mb-1 small">
                                            <i class="fas fa-arrow-down text-info me-1"></i>
                                            <?php echo e(__('گیرنده')); ?>: <?php echo e($trans->receiver?->name ?? 'نامشخص'); ?>

                                        </p>
                                    </div>
                                    <span class="badge <?php echo e($statusClass); ?> text-white py-2"><?php echo e($trans->status); ?></span>
                                </div>
                                <hr class="my-2">
                                <p class="mb-0 small fst-italic">
                                    <span class="fw-bold"><?php echo e(__('رویژن ارسالی')); ?>:</span> <?php echo e($td->revision_number ?? '-'); ?>

                                </p>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="alert alert-light text-center">
                        <i class="fas fa-exclamation-circle me-1"></i> <?php echo e(__('این مدرک تاکنون با هیچ ترنسمیتالی ارسال نشده است.')); ?>

                    </div>
                <?php endif; ?>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-modern" wire:click="closeTransmittalModal"><?php echo e(__('بستن')); ?></button>
            </div>
        </div>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\m-d-r\modals\transmittal-modal.blade.php ENDPATH**/ ?>