<div class="container-fluid py-4">
    <style>
        /* 💡 پالت رنگی سبز زمردی برای AR */
        .text-ar { color: #16a34a !important; }
        .bg-ar-dark { background-color: #10b981 !important; } /* Emerald Green */
        .bg-ar-subtle { background-color: #e6fbe6 !important; } /* Light Green BG */
        .table-ar-header th { background-color: #10b981 !important; color: white; font-weight: 600; }
        .rounded-3 { border-radius: 0.75rem !important; }
        .shadow-sm { box-shadow: 0 2px 4px rgba(0,0,0,0.05) !important; }
        .status-badge { padding: 0.375rem 0.75rem; border-radius: 50rem; font-weight: 600; font-size: 0.875rem; }
        .action-icon-group .btn { border-radius: 0.5rem; transition: all 0.2s; }
        .action-icon-group .btn:hover { transform: translateY(-1px); }
        .total-amount-cell { font-size: 1.1rem; font-weight: 700; }
    </style>

    <!-- هدر و عنوان -->
    <div class="card bg-ar-subtle shadow-sm mb-4 rounded-3">
        <div class="card-body px-4 py-3">
            <?php if(session()->has('message') || session()->has('error')): ?>
                <div class="alert alert-<?php echo e(session()->has('message') ? 'success' : 'danger'); ?> alert-dismissible fade show rounded-3 mb-3">
                    <?php echo e(session('message') ?? session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            <h4 class="fw-semibold mb-1 text-ar"><i class="ti ti-file-invoice me-2"></i> لیست فاکتورهای فروش (درآمد)</h4>
        </div>
    </div>

    <!-- فیلتر و جستجو -->
    <div class="card shadow-sm mb-4 rounded-3">
        <div class="card-body">
            <div class="row g-3 align-items-center">
                <div class="col-md-5">
                    <input type="text" class="form-control" wire:model.live.debounce.300ms="search" placeholder="جستجو بر اساس مشتری، شماره فاکتور یا شرح...">
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="statusFilter">
                        <option value="">وضعیت (همه)</option>
                        <option value="issued">صادر شده</option>
                        <option value="paid">پرداخت شده</option>
                        <option value="canceled">لغو شده</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="projectFilter">
                        <option value="">پروژه (همه)</option>
                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($project->id); ?>"><?php echo e($project->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-1 text-end">
                    <a href="<?php echo e(route('admin.sales.invoice.create')); ?>" class="btn btn-sm btn-success rounded-pill" title="ثبت فاکتور جدید">
                        <i class="ti ti-plus"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- جدول فاکتورها -->
    <div class="card shadow-lg rounded-4 overflow-hidden">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle mb-0">
                    <thead class="table-ar-header">
                    <tr>
                        <th class="py-3">شماره فاکتور</th>
                        <th class="py-3">پروژه</th>
                        <th class="py-3">مشتری</th>
                        <th class="py-3">مبلغ نهایی (<?php echo e($invoices->first()?->currency ?? 'IRR'); ?>)</th>
                        <th class="py-3">تاریخ صدور</th>
                        <th class="py-3">سررسید</th>
                        <th class="py-3">وضعیت</th>
                        <th class="py-3">عملیات</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $statusData = $this->getStatusData($invoice->status);
                        ?>
                        <tr wire:key="invoice-<?php echo e($invoice->id); ?>">
                            <td class="fw-bold text-accent"><?php echo e($invoice->invoice_number); ?></td>
                            <td><?php echo e($invoice->project->name ?? '—'); ?></td>
                            <td><?php echo e($invoice->client_name); ?></td>
                            <td class="total-amount-cell text-ar"><?php echo e(number_format($invoice->total_amount)); ?></td>
                            <td><?php echo e(\Morilog\Jalali\Jalalian::fromCarbon($invoice->issue_date)->format('Y/m/d')); ?></td>
                            <td><?php echo e(\Morilog\Jalali\Jalalian::fromCarbon($invoice->due_date)->format('Y/m/d')); ?></td>
                            <td>
                                <span class="status-badge bg-<?php echo e($statusData['color']); ?> text-white">
                                    <i class="ti <?php echo e($statusData['icon']); ?> me-1"></i>
                                    <?php echo e($statusData['label']); ?>

                                </span>
                            </td>
                            <td>
                                <div class="action-icon-group d-flex gap-2">
                                    <a href="<?php echo e(route('admin.sales.show', $invoice->id)); ?>" class="btn btn-sm btn-outline-info rounded-pill" title="مشاهده جزئیات">
                                        <i class="ti ti-eye"></i>
                                    </a>
                                    <?php if($invoice->status === 'issued'): ?>
                                        <button class="btn btn-sm btn-outline-success rounded-pill" title="ثبت پرداخت (دریافت)">
                                            <i class="ti ti-cash"></i>
                                        </button>
                                    <?php endif; ?>
                                    <?php if($invoice->status === 'issued' || $invoice->status === 'pending'): ?>
                                        <button class="btn btn-sm btn-outline-danger rounded-pill" title="لغو فاکتور" onclick="return confirm('آیا از لغو این فاکتور مطمئن هستید؟')">
                                            <i class="ti ti-x"></i>
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center py-5 text-muted fw-medium">
                                <i class="ti ti-info-circle fs-1 me-2"></i>
                                فاکتور فروشی یافت نشد.
                                <a href="<?php echo e(route('admin.sales.invoice.create')); ?>" class="btn btn-sm btn-link text-ar">ثبت اولین فاکتور</a>
                            </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- پگینیشن -->
        <div class="card-footer bg-light-subtle d-flex justify-content-center">
            <?php echo e($invoices->links()); ?>

        </div>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\sales\sales-invoice-list.blade.php ENDPATH**/ ?>