<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>درخواست خرید <?php echo e($request->id); ?></title>

    <style>
        body {
            font-family: 'Vazirmatn', sans-serif;
            margin: 0;
            padding: 0;
            font-size: 10pt;
            line-height: 1.6;
            color: #333;
        }
        .container {
            width: 100%;
            padding: 25px 30px; /* پدینگ بیشتر */
        }

        /* 1. HEADER & LOGO */
        .header {
            border-bottom: 2px solid #004d99; /* آبی تیره سازمانی */
            padding-bottom: 10px;
            margin-bottom: 25px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .header .title {
            font-size: 15pt;
            margin: 0;
            color: #004d99; /* آبی تیره */
            font-weight: 800;
        }
        .header .doc-meta {
            font-size: 9pt;
            text-align: left;
        }

        /* 2. META INFO TABLE */
        h2 {
            font-size: 12pt;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
            margin-bottom: 15px;
            color: #004d99;
            font-weight: 700;
        }
        .meta-info {
            width: 100%;
            border: 1px solid #ddd;
            border-collapse: collapse;
            margin-bottom: 25px;
        }
        .meta-info th, .meta-info td {
            padding: 8px 10px;
            border: 1px solid #eee;
            text-align: right;
            font-weight: normal;
            font-size: 9pt;
        }
        .meta-info th {
            width: 20%; /* کمی باریک‌تر */
            background-color: #f0f3f8; /* خاکستری روشن */
            font-weight: 600;
            color: #495057;
        }
        .meta-info td.full-width {
            width: 80%;
            background-color: #fcfcfc;
        }
        .meta-info .total-amount {
            font-weight: 700;
            color: #155724; /* سبز تیره */
            font-size: 11pt;
        }

        /* 3. ITEMS TABLE */
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }
        .items-table th, .items-table td {
            border: 1px solid #333;
            padding: 8px 10px;
            text-align: right;
            font-size: 9pt;
        }
        .items-table th {
            background-color: #004d99; /* آبی تیره */
            color: #fff;
        }
        /* Alignment for numbers */
        .items-table .num-col {
            text-align: left;
            direction: ltr;
        }
        .items-table .total-row td {
            background-color: #e9ecef;
            font-weight: 700;
            border-top: 2px solid #000;
            font-size: 10pt;
        }

        /* 4. SIGNATURE GRID (Workflow) */
        .signature-grid {
            margin-top: 35px;
            page-break-inside: avoid;
            border: 1px solid #ddd;
        }
        .signature-grid th, .signature-grid td {
            border: 1px solid #ddd;
            padding: 10px 5px;
            text-align: center;
            vertical-align: top;
            width: 25%;
            font-size: 9pt;
        }
        .signature-grid th {
            background-color: #004d99; /* آبی تیره */
            color: #fff;
            font-weight: 600;
        }
        .signature-grid .status-indicator {
            font-weight: bold;
            margin-top: 5px;
        }
        .status-ok { color: #28a745; }
        .status-fail { color: #dc3545; }
        .status-wait { color: #007bff; }
        .signature-area {
            height: 40px; /* فضای امضا */
            border-top: 1px dashed #666;
            margin-top: 10px;
            font-size: 8pt;
            padding-top: 3px;
        }
    </style>
</head>
<body>
<div class="container">

    <div class="header">
        <div>
            <img src="<?php echo e(public_path('panel/dist/images/logos/logo.png')); ?>" alt="Logo" style="max-width: 120px;">
        </div>
        <div class="title">درخواست خرید و تدارکات (PR)</div>
        <div class="doc-meta">
            <strong>شماره سند: PR-<?php echo e($request->id); ?></strong><br>
            تاریخ ثبت: <?php echo e(\Morilog\Jalali\Jalalian::fromCarbon($request->created_at)->format('Y/m/d')); ?>

        </div>
    </div>

    <h2>اطلاعات کلیدی درخواست</h2>
    <table class="meta-info">
        <tbody>
        <tr>
            <th>پروژه</th>
            <td><?php echo e($request->project->name ?? '---'); ?></td>
            <th>کاربر ثبت کننده</th>
            <td><?php echo e($request->user->name ?? '---'); ?></td>
        </tr>
        <tr>
            <th>نوع خرید</th>
            <td><?php echo e(['material' => 'کالا', 'service' => 'خدمات', 'asset' => 'دارایی'][$request->purchase_type] ?? '---'); ?></td>
            <th>سرفصل هزینه</th>
            <td><?php echo e($request->costCenter->name ?? '---'); ?></td>
        </tr>
        <tr>
            <th>تاریخ مورد نیاز</th>
            <td><?php echo e($request->required_by ? \Morilog\Jalali\Jalalian::fromCarbon(\Carbon\Carbon::parse($request->required_by))->format('Y/m/d') : '---'); ?></td>
            <th>وضعیت نهایی</th>
            <td>
                    <span style="font-weight: 700; color: <?php echo e($request->status == 'approved' ? '#28a745' : ($request->status == 'rejected' ? '#dc3545' : '#007bff')); ?>;">
                        <?php echo e($request->status == 'approved' ? 'تأیید شده' : ($request->status == 'rejected' ? 'رد شده' : 'در انتظار')); ?>

                    </span>
            </td>
        </tr>
        <tr>
            <th>شرح کلی درخواست</th>
            <td colspan="3" class="full-width"><?php echo e($request->description); ?></td>
        </tr>
        </tbody>
    </table>

    <h2>لیست اقلام مورد درخواست</h2>
    <table class="items-table">
        <thead>
        <tr>
            <th style="width: 5%;">ردیف</th>
            <th style="width: 10%;">نوع</th>
            <th style="width: 40%;">شرح کالا / خدمت</th>
            <th style="width: 10%;">تعداد</th>
            <th style="width: 15%;">قیمت واحد (ریال)</th>
            <th style="width: 20%;">جمع جزء (ریال)</th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $request->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($index + 1); ?></td>
                <td><?php echo e($item->isService() ? 'خدمت' : 'کالا'); ?></td>
                <td>
                    <?php echo e($item->displayName); ?>

                    <?php if(!$item->isService()): ?>
                        <div style="font-size: 8pt; color: #555;">(کد: <?php echo e($item->item->code ?? 'N/A'); ?>)</div>
                    <?php endif; ?>
                </td>
                <td><?php echo e(number_format($item->quantity)); ?></td>
                <td class="num-col"><?php echo e(number_format($item->price)); ?></td>
                <td class="num-col" style="font-weight: 700;"><?php echo e(number_format($item->subtotal)); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr class="total-row">
            <td colspan="5" style="text-align: left; font-size: 11pt;">جمع کل نهایی</td>
            <td class="num-col" style="font-size: 11pt; color: #004d99;"><?php echo e(number_format($request->total_price)); ?></td>
        </tr>
        </tbody>
    </table>

    <h2>گردش کار و تأییدیه‌ها</h2>
    <table class="signature-grid">
        <thead>
        <tr>
            <th>مرحله ۱: ثبت کننده</th>
            <th>مرحله ۲: تأیید کننده</th>
            <th>مرحله ۳: تأیید کننده</th>
            <th>مرحله ۴: تأیید کننده نهایی</th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td>
                <div style="font-weight: 600;"><?php echo e($request->user->name ?? '---'); ?></div>
                <div style="font-size: 8pt; color: #555;">تاریخ: <?php echo e(\Morilog\Jalali\Jalalian::fromCarbon($request->created_at)->format('Y/m/d')); ?></div>
                <div class="signature-area">امضا:</div>
            </td>

            <?php
                $approvals = $request->approvals->sortBy('priority')->all();
                $approval_count = count($approvals);
            ?>

            <?php for($i = 0; $i < 3; $i++): ?>
                <?php if(isset($approvals[$i])): ?>
                    <?php
                        $appr = $approvals[$i];
                        $status_class = $appr->is_approved === true ? 'status-ok' : ($appr->is_approved === false ? 'status-fail' : 'status-wait');
                        $status_text = $appr->is_approved === true ? 'تأیید شد' : ($appr->is_approved === false ? 'رد شد' : 'در انتظار');
                        $status_color = $appr->is_approved === true ? '#28a745' : ($appr->is_approved === false ? '#dc3545' : '#007bff');
                    ?>
                    <td>
                        <div style="font-weight: 600;"><?php echo e($appr->user->name ?? '---'); ?></div>
                        <span style="font-size: 8pt; color: #555;">(<?php echo e($appr->role->name ?? 'نقش نامشخص'); ?>)</span>
                        <div class="status-indicator" style="color: <?php echo e($status_color); ?>;">
                            <?php echo e($status_text); ?>

                        </div>
                        <?php if($appr->approved_at): ?>
                            <div style="font-size: 8pt;">تاریخ: <?php echo e(\Morilog\Jalali\Jalalian::fromCarbon(\Carbon\Carbon::parse($appr->approved_at))->format('Y/m/d')); ?></div>
                        <?php endif; ?>
                        <div class="signature-area">امضا:</div>
                    </td>
                <?php else: ?>
                    <td>
                        <div style="color: #aaa;">نیاز به تأیید نیست</div>
                        <div style="font-size: 8pt; color: #aaa;">(مرحله اختیاری)</div>
                        <div class="signature-area"></div>
                    </td>
                <?php endif; ?>
            <?php endfor; ?>
        </tr>
        </tbody>
    </table>

    <div style="margin-top: 25px; font-size: 9pt; text-align: center; border-top: 1px solid #ddd; padding-top: 10px;">
        این سند به صورت سیستمی تولید شده و اعتبار آن منوط به امضاهای ذیل است.
    </div>
</div>
</body>
</html><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\purchase\purchase-request-pdf.blade.php ENDPATH**/ ?>