<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['data']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['data']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<?php
    $d = $data;
    $title = $d['title'] ?? 'بدون عنوان';
    $content = $d['content'] ?? '<p style="text-align: right;">محتوایی موجود نیست</p>';
    $project = $d['project'] ?? (object)['name' => 'پروژه نامشخص'];
    $background = $d['background'] ?? null;
    $priority = $d['priority'] ?? 'normal';
    $priorityLabel = $d['priorityLabel'] ?? 'عادی';
    $from_who = $d['from_who'] ?? '---';
    $from_where = $d['from_where'] ?? '---';
    $letter_date = $d['letter_date'] ?? '---';
    $ccs = $d['ccs'] ?? [];
    $signer_name = $d['signer_name'] ?? 'نام امضاکننده';
    $signature_position = $d['signature_position'] ?? 'سمت امضاکننده';

    $showWatermark = $d['show_watermark'] ?? false;
    $layoutSections = $d['layoutSections'] ?? ['header' => false, 'footer' => false, 'title' => true, 'metadata' => true, 'content' => true, 'attachments' => true, 'signature' => true];

    $bgUrl = $background?->background
        ? Illuminate\Support\Facades\Storage::disk('letter_template')->url($background->background)
        : null;

    $contentPadding = '35mm 20mm 35mm 20mm';
    $contentDivStyle = $bgUrl ? 'position: relative; z-index: 2;' : '';
?>

<style>
    /* همۀ استایل‌هایی که داشتی، همین‌جا بماند */
    @page {
        size: A4 portrait;
        margin: 0;
        @top-center { content: element(letter-header); }
        @bottom-center { content: element(letter-footer); }
    }

    .letter-preview {
        width: 210mm;
        min-height: 297mm;
        margin: 0 auto;
        background: white;
        box-shadow: 0 0 10px rgba(0,0,0,0.2);
        font-family: 'IRANSans', 'Vazirmatn', 'Tahoma', sans-serif;
        line-height: 1.6;
        color: #333;
        position: relative;
        padding: 0;
        direction: rtl;
        text-align: right;
    }

    .print-header { position: running(letter-header); z-index: 1000; padding: 10mm 20mm 0 20mm; }
    .print-footer { position: running(letter-footer); z-index: 1000; padding: 0 20mm 10mm 20mm; }

    .background-layer {
        position: absolute;
        top: 0; left: 0; right: 0; bottom: 0;
        background-repeat: no-repeat;
        background-size: 100% 100%;
        z-index: 1;
        pointer-events: none;
    }

    .watermark {
        position: absolute;
        top: 50%; left: 50%;
        transform: translate(-50%, -50%) rotate(-45deg);
        font-size: 80px;
        color: rgba(0,0,0,0.05);
        z-index: 2;
        pointer-events: none;
    }

    .letter-inner-content {
        padding: <?php echo e($contentPadding); ?>;
        box-sizing: border-box;
        width: 100%;
        min-height: 297mm;
    }

    .section-content {
        font-size: 11pt;
        text-align: justify;
        line-height: 1.8;
        margin-bottom: 30px;
        word-wrap: break-word;
        page-break-inside: auto;
    }
    .section-content * {
        max-width: 100% !important;
        box-sizing: border-box;
        word-wrap: break-word;
        page-break-inside: auto;
    }

    .section-metadata {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        font-size: 10pt;
        margin-bottom: 30px;
        border-bottom: 1px solid #eee;
        padding-bottom: 15px;
    }
    .meta-label { font-weight: 600; color: #555; margin-left: 5px; }

    .section-bottom-area {
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        margin-top: 50px;
        page-break-before: avoid;
    }
    .signature-box {
        flex-basis: 30%;
        text-align: center;
        font-size: 10pt;
    }
    .cc-box {
        flex-basis: 60%;
        text-align: right;
        font-size: 9pt;
        color: #777;
        border-top: 1px dashed #ddd;
        padding-top: 10px;
    }

    .priority-indicator {
        display: inline-block;
        padding: 4px 10px;
        border-radius: 12px;
        font-size: 9pt;
        font-weight: bold;
        color: white;
        margin-right: 5px;
    }
    .priority-urgent { background: #E91E63; }
    .priority-high { background: #FF9800; }
    .priority-normal { background: #4CAF50; }
    .priority-low { background: #2196F3; }

    @media print {
        .letter-preview { box-shadow: none; margin: 0; padding: 0 !important; }
        .background-layer { display: none; }
        .letter-inner-content {
            padding: 35mm 20mm 35mm 20mm !important;
            min-height: auto;
        }
    }
</style>

<div class="letter-preview">

    <?php if($bgUrl): ?>
        <div class="background-layer" style="background-image: url('<?php echo e($bgUrl); ?>');"></div>
    <?php endif; ?>

    <?php if($showWatermark): ?>
        <div class="watermark">PREVIEW</div>
    <?php endif; ?>

    <div class="letter-inner-content" style="<?php echo $contentDivStyle; ?>">











        <?php if($layoutSections['metadata']): ?>
            <div class="section-metadata">
                <div style="flex-basis: 55%;">
                    <div class="meta-item"><span class="meta-label">📨 از:</span> <?php echo e($from_who); ?></div>
                    <div class="meta-item"><span class="meta-label">📬 به:</span> <?php echo e($from_where); ?></div>
                </div>

                <div style="flex-basis: 40%; text-align: left;">
                    <div class="meta-item" style="font-weight: bold; color: #555;"><?php echo e($project->name); ?></div>
                    <div class="meta-item"><span class="meta-label">📅 تاریخ:</span> <?php echo e($letter_date); ?></div>
                    <div class="meta-item">
                        <span class="meta-label">🎯 اولویت:</span>
                        <span class="priority-indicator priority-<?php echo e($priority); ?>">
                            <?php echo e($priorityLabel); ?>

                        </span>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <h2 class="section-title"><?php echo e($title); ?></h2>

        <div class="section-content">
            <?php echo $content; ?>

        </div>

        <?php if($layoutSections['attachments'] && !empty($d['attachments'] ?? [])): ?>
            <div class="section-attachments" style="border: 1px solid #ddd; padding: 10px; font-size: 10pt; margin-top: 20px; border-radius: 5px;">
                <strong>📎 پیوست‌ها:</strong>
                <ul style="list-style: disc; margin: 5px 0 0 20px; padding: 0; line-height: 1.5;">
                    <?php $__currentLoopData = $d['attachments']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li style="margin-right: 15px;"><?php echo e($attachment['original_name'] ?? ($attachment['name'] ?? 'فایل پیوست')); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <div class="section-bottom-area">
            <?php if(!empty($ccs)): ?>
                <div class="cc-box">
                    <strong>👥 رونوشت به:</strong>
                    <div style="margin-top: 5px; line-height: 1.6;">
                        <?php $__currentLoopData = $ccs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span style="display: inline-block; margin-left: 15px;">
                                <?php echo e($cc['name']); ?> <?php if($cc['position']): ?> (<?php echo e($cc['position']); ?>) <?php endif; ?>
                            </span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($layoutSections['signature']): ?>
                <div class="signature-box">
                    <div style="border-top: 1px solid #333; padding-top: 15px; margin-bottom: 5px;">
                        <?php echo e($signer_name); ?>

                    </div>
                    <p style="margin: 0;"><?php echo e($signature_position); ?></p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="print-footer">
        <?php if($layoutSections['footer']): ?>
            <p style="font-size: 10pt; color: #777; text-align: center; border-top: 1px solid #eee;">
                این سند به صورت الکترونیکی تولید شده است. (پروژه: <?php echo e($project->name); ?>)
            </p>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\components\letter-preview-content.blade.php ENDPATH**/ ?>