<div class="container-fluid py-5 px-lg-5 platinum-v19-wrapper" dir="rtl">
    <style>
        /* 💎 Visual Language v19 - Obsidian & Digital Indigo */
        :root {
            --p-navy: #0f172a; --p-indigo: #4f46e5; --p-emerald: #10b981;
            --p-rose: #f43f5e; --p-amber: #f59e0b; --p-slate: #64748b;
            --p-glass: rgba(255, 255, 255, 0.98);
            --shadow-base: 0 10px 30px -5px rgba(0, 0, 0, 0.05);
            --shadow-lux: 0 35px 80px -20px rgba(15, 23, 42, 0.25);
        }

        .platinum-v19-wrapper { background: #fcfdfe; min-height: 100vh; font-family: 'Vazirmatn', sans-serif; }

        /* 🏔️ Hero Command Center */
        .hero-command-v19 {
            background: linear-gradient(135deg, var(--p-navy) 0%, #1e293b 100%);
            border-radius: 45px; padding: 4rem; color: white;
            box-shadow: var(--shadow-lux); margin-bottom: 4rem; position: relative; overflow: hidden;
        }
        .hero-command-v19::after {
            content: ''; position: absolute; top: -30%; left: -10%; width: 600px; height: 600px;
            background: radial-gradient(circle, rgba(79, 70, 229, 0.12) 0%, transparent 70%);
            filter: blur(80px);
        }

        /* 🔍 Intelligent HUD Filter */
        .filter-console-v19 {
            background: white; border-radius: 35px; border: 1px solid #edf2f7;
            padding: 2.5rem; box-shadow: var(--shadow-base); margin-bottom: 4rem;
        }
        .lux-input-v19 {
            border: 2px solid #f1f5f9; border-radius: 20px; padding: 15px 25px;
            font-weight: 800; transition: 0.4s cubic-bezier(0.4, 0, 0.2, 1); background: #f8fafc;
        }
        .lux-input-v19:focus { border-color: var(--p-indigo); background: white; box-shadow: 0 0 0 6px rgba(79, 70, 229, 0.1); outline: none; }

        /* 📋 Table Hierarchy Design */
        .master-grid-v19 {
            background: white; border-radius: 50px; border: 1px solid #f1f5f9;
            box-shadow: var(--shadow-base); overflow: hidden;
        }
        .table thead th {
            background: #f8fafc; color: var(--p-slate); font-weight: 900;
            font-size: 0.75rem; text-transform: uppercase; padding: 2rem 1.5rem; border: none;
        }

        /* 🏢 Visual Grouping */
        .group-separator-company { background: #f1f5f9 !important; border-right: 10px solid var(--p-navy); }
        .group-separator-dept { background: #fcfdfe !important; border-right: 8px solid var(--p-indigo); }

        .pill-tag-v19 {
            background: white; padding: 6px 18px; border-radius: 50px;
            font-weight: 900; font-size: 0.8rem; box-shadow: 0 4px 10px rgba(0,0,0,0.03);
            border: 1px solid #e2e8f0;
        }

        /* 👤 User Row Micro-UI */
        .user-v19-row { transition: 0.3s; }
        .user-v19-row:hover { background: #f0f7ff !important; transform: scale(1.002); }

        .avatar-sq-lux {
            width: 60px; height: 60px; border-radius: 22px;
            padding: 4px; background: white; box-shadow: 0 10px 25px -5px rgba(0,0,0,0.1);
            border: 1px solid #edf2f7; transition: 0.3s;
        }
        .avatar-sq-lux:hover { transform: rotate(-5deg) scale(1.1); }

        .status-pulse-v19 {
            width: 12px; height: 12px; border-radius: 50%;
            display: inline-block; position: relative;
        }
        .status-pulse-v19::after {
            content: ''; position: absolute; width: 100%; height: 100%;
            border-radius: 50%; background: inherit; animation: pulse-ring 2s infinite;
        }
        @keyframes pulse-ring { 0% { transform: scale(0.5); opacity: 1; } 100% { transform: scale(2.5); opacity: 0; } }

        /* 🚀 Badges & Actions */
        .hud-role-badge {
            padding: 8px 22px; border-radius: 100px; font-weight: 900; font-size: 0.7rem;
            display: inline-flex; align-items: center; gap: 8px; text-transform: uppercase;
        }
        .role-admin { background: linear-gradient(135deg, #f43f5e, #be123c); color: white; }
        .role-manager { background: linear-gradient(135deg, #f59e0b, #b45309); color: white; }
        .role-default { background: linear-gradient(135deg, #4f46e5, #3730a3); color: white; }

        .btn-action-v19 {
            width: 44px; height: 44px; border-radius: 16px; display: inline-flex;
            align-items: center; justify-content: center; transition: 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            background: #fff; border: 2px solid #f1f5f9; color: var(--p-navy);
        }
        .btn-action-v19:hover { transform: translateY(-5px); background: var(--p-navy); color: white; border-color: var(--p-navy); }

        /* 📦 Modal Custom Architecture */
        .modal-platinum-v19 {
            background: rgba(15, 23, 42, 0.9); backdrop-filter: blur(20px);
        }
        .selectable-card-v19 {
            border: 2px solid #f1f5f9; border-radius: 24px; padding: 1.2rem;
            transition: 0.3s; cursor: pointer; background: white;
        }
        .selectable-card-v19:hover { border-color: var(--p-indigo); transform: translateX(-10px); background: #f8faff; }
        .form-check-input:checked + .selectable-card-v19 { border-color: var(--p-indigo); background: #f0f4ff; box-shadow: 0 10px 20px rgba(79, 70, 229, 0.1); }

        .reveal-node { opacity: 0; animation: revealUp 0.8s cubic-bezier(0.2, 1, 0.3, 1) forwards; }
        @keyframes revealUp { from { opacity: 0; transform: translateY(30px); } to { opacity: 1; transform: translateY(0); } }
    </style>

    
    <div class="hero-command-v19 d-flex justify-content-between align-items-center flex-wrap gap-5 reveal-node">
        <div>
            <div class="d-flex align-items-center gap-3 mb-3">
                <div class="p-3 bg-white bg-opacity-10 rounded-4 shadow-sm"><i class="ti ti-users-group fs-2 text-info"></i></div>
                <div class="h-divider bg-white opacity-20" style="width: 1px; height: 40px;"></div>
                <div>
                    <span class="badge bg-white bg-opacity-10 text-info px-3 py-2 rounded-pill fw-black smaller tracking-widest border border-info border-opacity-25 uppercase">Governance Unit</span>
                    <h5 class="mb-0 fw-bold text-white-50 mt-1 small">Project Identifier: <?php echo e($project->code); ?></h5>
                </div>
            </div>
            <h1 class="fw-black mb-0 display-4">اعضای کارگروه <span class="text-info opacity-75">/ مدیریت حاکمیت پروژه</span></h1>
        </div>
        <button class="btn btn-info rounded-pill px-5 py-4 fw-black shadow-lg border-0 transition-all hover-scale" wire:click="showAddForm">
            <i class="ti ti-user-plus me-2 fs-3"></i> الحاق عضو جدید
        </button>
    </div>

    
    <div class="filter-console-v19 reveal-node" style="animation-delay: 0.1s">
        <div class="row g-4 align-items-end text-start">
            <div class="col-md-5">
                <label class="form-label fw-black text-muted smaller ms-3 mb-2">جستجوی هوشمند اعضا</label>
                <div class="position-relative">
                    <i class="ti ti-search position-absolute top-50 start-0 translate-middle-y ms-4 text-muted fs-4"></i>
                    <input wire:model.live.debounce.400ms="search" type="text" class="form-control lux-input-v19 ps-5 shadow-none" placeholder="جستجو بر اساس نام، ایمیل یا واحد...">
                </div>
            </div>
            <div class="col-md-4">
                <label class="form-label fw-black text-muted smaller ms-3 mb-2">سطح دسترسی</label>
                <select wire:model.live="filterRoleId" class="form-select lux-input-v19 shadow-none">
                    <option value="">تمامی نقش‌های پروژه</option>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($role->id); ?>"><?php echo e($role->label ?? $role->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <button wire:click="refreshMembers" class="btn btn-dark w-100 py-3 rounded-pill fw-black shadow-sm transition-all hover-scale">
                    <i class="ti ti-refresh fs-4 me-2"></i> بازخوانی شبکه
                </button>
            </div>
        </div>
    </div>

    
    <div class="master-grid-v19 reveal-node" style="animation-delay: 0.2s">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead>
                <tr>
                    <th class="ps-5" style="width: 120px;">شناسه بصری</th>
                    <th>اطلاعات پرسنلی</th>
                    <th class="d-none d-lg-table-cell text-start">ایمیل سازمانی</th>
                    <th>نقش عملیاتی</th>
                    <th class="text-center">وضعیت</th>
                    <th class="text-end pe-5" style="width: 180px;">عملیات کنترل</th>
                </tr>
                </thead>
                <tbody>
                <?php
                    $groupedMembers = $members->groupBy(fn($u) => $u->department->company->name ?? 'سازمان متفرقه')
                                             ->map(fn($companyGroup) => $companyGroup->groupBy(fn($u) => $u->department->name ?? 'واحد عمومی'));
                ?>

                <?php $__empty_1 = true; $__currentLoopData = $groupedMembers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $companyName => $departmentsGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="group-separator-company">
                        <td colspan="6" class="ps-4 py-4 text-start">
                            <div class="d-flex align-items-center gap-3">
                                <div class="p-2 bg-navy text-white rounded-3 shadow-sm"><i class="ti ti-building-skyscraper fs-4"></i></div>
                                <span class="pill-tag-v19 text-navy">سازمان: <?php echo e($companyName); ?></span>
                                <span class="smaller fw-black text-muted opacity-50"><?php echo e($departmentsGroup->flatten()->count()); ?> کاربر ثبت شده</span>
                            </div>
                        </td>
                    </tr>

                    <?php $__currentLoopData = $departmentsGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $departmentName => $usersList): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="group-separator-dept text-start">
                            <td colspan="6" class="py-2 ps-5">
                                <div class="d-flex align-items-center gap-2 opacity-75">
                                    <i class="ti ti-hierarchy-3 text-indigo"></i>
                                    <span class="fw-black text-indigo smaller text-uppercase">دپارتمان: <?php echo e($departmentName); ?></span>
                                </div>
                            </td>
                        </tr>

                        <?php $__currentLoopData = $usersList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="user-v19-row">
                                <td class="ps-5">
                                    <div class="avatar-sq-lux position-relative">
                                        <img src="<?php echo e($user->image ? asset('storage/' . str_replace('public/', '', $user->image)) : asset('panel/dist/images/profile/user-1.jpg')); ?>"
                                             class="w-100 h-100 rounded-3 object-fit-cover shadow-sm"
                                             onerror="this.src='<?php echo e(asset('panel/dist/images/profile/user-1.jpg')); ?>'">
                                        <div class="position-absolute bottom-0 start-0 translate-middle-x ms-2 mb-1">
                                            <span class="status-pulse-v19 bg-success shadow-sm"></span>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="fw-black text-navy fs-5"><?php echo e($user->name); ?></div>
                                    <div class="smaller text-muted fw-bold d-lg-none mt-1"><?php echo e($user->email); ?></div>
                                </td>
                                <td class="text-muted d-none d-lg-table-cell fw-bold small text-start"><?php echo e($user->email); ?></td>
                                <td>
                                    <?php
                                        $roleId = $user->pivot->role_id ?? null;
                                        $roleData = $roleId ? ($allRolesArr[$roleId] ?? null) : null;
                                        $roleLabel = $roleData ? ($roleData['label'] ?? $roleData['name']) : 'بدون نقش';
                                        $roleType = $roleData ? $roleData['name'] : 'none';
                                        $rCls = match($roleType) { 'admin'=>'role-admin', 'manager'=>'role-manager', default=>'role-default' };
                                    ?>
                                    <span class="hud-role-badge <?php echo e($rCls); ?> shadow-sm"><?php echo e($roleLabel); ?></span>
                                </td>
                                <td class="text-center">
                                    <?php
                                        $status = $user->pivot->status ?? 'pending';
                                        $sCls = match($status) { 'active'=>'success', 'inactive'=>'danger', default=>'warning' };
                                        $sTxt = match($status) { 'active'=>'فعال', 'inactive'=>'مسدود', default=>'در انتظار' };
                                    ?>
                                    <div class="d-inline-flex align-items-center gap-2 px-3 py-2 bg-<?php echo e($sCls); ?> bg-opacity-10 rounded-pill">
                                        <span class="status-pulse-v19 bg-<?php echo e($sCls); ?>" style="width: 8px; height: 8px;"></span>
                                        <span class="fw-black text-<?php echo e($sCls); ?> smaller"><?php echo e($sTxt); ?></span>
                                    </div>
                                </td>
                                <td class="text-end pe-5 text-nowrap">
                                    <button wire:click="editMember(<?php echo e($user->id); ?>)" class="btn-action-v19 text-primary shadow-sm" title="تنظیمات">
                                        <i class="ti ti-settings-up"></i>
                                    </button>
                                    <button wire:click="removeUser(<?php echo e($user->id); ?>)" wire:confirm="آیا از حذف <?php echo e($user->name); ?> اطمینان دارید؟" class="btn-action-v19 text-danger shadow-sm" title="حذف">
                                        <i class="ti ti-trash-x"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="py-5 text-center opacity-30">
                            <i class="ti ti-users-off display-1 mb-3"></i>
                            <h4 class="fw-black text-navy">کارگروه پروژه هنوز تشکیل نشده است</h4>
                            <p class="fw-bold">جهت شروع، پرسنل مورد نظر را به پروژه الحاق کنید.</p>
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    
    <?php if($showModal): ?>
        <div class="modal fade show d-block modal-platinum-v19" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content overflow-hidden border-0">
                    <div class="modal-header border-0 p-4 bg-navy text-white" style="background: var(--p-navy);">
                        <div class="d-flex align-items-center gap-4 text-start">
                            <div class="p-3 bg-white bg-opacity-10 rounded-4 text-info shadow-lg"><i class="ti ti-user-plus fs-3"></i></div>
                            <div>
                                <h4 class="modal-title fw-black mb-0"><?php echo e($editing ? 'بروزرسانی سطح دسترسی' : 'الحاق پرسنل جدید به پروژه'); ?></h4>
                                <small class="text-info opacity-50 fw-bold uppercase tracking-widest">Compliance Access Protocol</small>
                            </div>
                        </div>
                        <button type="button" class="btn-close btn-close-white shadow-none" wire:click="closeModal"></button>
                    </div>
                    <div class="modal-body p-5 bg-white">
                        <form wire:submit.prevent="saveMember">
                            <?php if(!$editing): ?>
                                <div class="mb-5 text-start">
                                    <h6 class="fw-black mb-4 text-navy border-bottom pb-3 d-flex align-items-center gap-2">
                                        <i class="ti ti-search fs-4 text-primary"></i> ۱. منبع‌یابی کاربر از چارت سازمانی
                                    </h6>

                                    <div class="row g-4 mb-4">
                                        <div class="col-md-6">
                                            <label class="form-label small fw-black text-muted opacity-50 ms-2">سازمان مادر</label>
                                            <select wire:model.live="selectedCompanyId" class="form-select lux-input-v19 shadow-none">
                                                <option value="">-- تمامی سازمان‌ها --</option>
                                                <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($company->id); ?>"><?php echo e($company->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label small fw-black text-muted opacity-50 ms-2">واحد / دپارتمان</label>
                                            <select wire:model.live="selectedDepartmentId" class="form-select lux-input-v19 shadow-none" <?php if(!$selectedCompanyId): ?> disabled <?php endif; ?>>
                                                <option value="">-- تمامی بخش‌ها --</option>
                                                <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($department->id); ?>"><?php echo e($department->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-12 mt-2">
                                            <input wire:model.live.debounce.300ms="user_search" type="text" class="form-control lux-input-v19 shadow-none" placeholder="جستجوی سریع نام یا ایمیل...">
                                        </div>
                                    </div>

                                    <div class="accordion accordion-flush rounded-5 overflow-hidden border shadow-sm" id="modalUserAccordion">
                                        <?php $__empty_1 = true; $__currentLoopData = $groupedUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $companyName => $departmentsGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <div class="accordion-item border-0">
                                                <h2 class="accordion-header">
                                                    <button class="accordion-button collapsed fw-black bg-light bg-opacity-50" type="button" data-bs-toggle="collapse" data-bs-target="#m-<?php echo e(\Illuminate\Support\Str::slug($companyName)); ?>">
                                                        <i class="ti ti-building me-2 text-primary"></i> <?php echo e($companyName); ?>

                                                    </button>
                                                </h2>
                                                <div id="m-<?php echo e(\Illuminate\Support\Str::slug($companyName)); ?>" class="accordion-collapse collapse" data-bs-parent="#modalUserAccordion">
                                                    <div class="accordion-body p-0">
                                                        <?php $__currentLoopData = $departmentsGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $departmentName => $usersList): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="p-3 border-bottom bg-white">
                                                                <small class="fw-black text-primary mb-3 d-block uppercase small">> <?php echo e($departmentName); ?></small>
                                                                <div class="row g-2">
                                                                    <?php $__currentLoopData = $usersList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <div class="col-12">
                                                                            <input type="radio" wire:model="selectedUserId" id="modal-u-<?php echo e($user->id); ?>" value="<?php echo e($user->id); ?>" class="form-check-input d-none">
                                                                            <label for="modal-u-<?php echo e($user->id); ?>" class="selectable-card-v19 d-flex align-items-center justify-content-between shadow-xs">
                                                                                <div class="d-flex align-items-center gap-3 text-start">
                                                                                    <img src="<?php echo e($user->image ? asset('storage/' . str_replace('public/', '', $user->image)) : asset('panel/dist/images/profile/user-1.jpg')); ?>"
                                                                                         class="rounded-circle border" width="45" height="45"
                                                                                         onerror="this.src='<?php echo e(asset('panel/dist/images/profile/user-1.jpg')); ?>'">
                                                                                    <div>
                                                                                        <div class="fw-black text-navy"><?php echo e($user->name); ?></div>
                                                                                        <div class="smaller text-muted fw-bold"><?php echo e($user->email); ?></div>
                                                                                    </div>
                                                                                </div>
                                                                                <i class="ti ti-circle-check fs-4 text-primary opacity-0 check-icon"></i>
                                                                            </label>
                                                                        </div>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </div>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <div class="p-5 text-center text-muted">کاربر جدیدی یافت نشد.</div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="mb-5 text-start">
                                <h6 class="fw-black mb-4 text-navy border-bottom pb-3 d-flex align-items-center gap-2">
                                    <i class="ti ti-shield-check fs-4 text-primary"></i> ۲. تعیین سطح مسئولیت (نقش سیستم)
                                </h6>
                                <select wire:model="selectedRoleId" class="form-select lux-input-v19 shadow-none <?php $__errorArgs = ['selectedRoleId'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value="">-- نقش کاربر در این پروژه را انتخاب کنید --</option>
                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($role->id); ?>"><?php echo e($role->label ?? $role->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['selectedRoleId'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback fw-bold mt-2 ms-3"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="d-flex justify-content-end gap-3 pt-5 border-top">
                                <button type="button" class="btn btn-light rounded-pill px-5 fw-black border border-2 py-3 transition-all" wire:click="closeModal">انصراف</button>
                                <button class="btn btn-navy rounded-pill px-5 fw-black shadow-lg py-3 transition-all hover-scale" type="submit" style="background: var(--p-navy); color: white;">
                                    <i class="ti ti-device-floppy me-2"></i> تایید و الحاق به پروژه
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <style>
        /* ✨ Utility Animations & Logic */
        .selectable-card-v19 input:checked + label { border-color: var(--p-indigo); background: #f0f4ff; }
        .selectable-card-v19 input:checked + label .check-icon { opacity: 1; }

        .status-pulse-v19 { animation: pulse-v19 2s infinite; }
        @keyframes pulse-v19 { 0% { transform: scale(0.95); box-shadow: 0 0 0 0 rgba(16, 185, 129, 0.7); } 70% { transform: scale(1); box-shadow: 0 0 0 10px rgba(16, 185, 129, 0); } 100% { transform: scale(0.95); } }

        .hover-scale:hover { transform: scale(1.05); }
        .shadow-xs { box-shadow: 0 2px 4px rgba(0,0,0,0.05); }
        .scrollbar-lux::-webkit-scrollbar { width: 5px; }
        .scrollbar-lux::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 10px; }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\projects\edit-project-members.blade.php ENDPATH**/ ?>