

<style>
    /* --------------------------------------
       استایل‌های نهایی درخت ارجاع (MINIMAL)
    ----------------------------------------- */
    :root {
        --tree-line-default: #e5e7eb; /* Light Gray */
        --tree-spacing: 30px;
    }
    /* کانتینر اصلی گره */
    .referral-tree-node {
        position: relative;
        padding-inline-start: var(--tree-spacing); /* تغییر padding-right به padding-inline-start برای RTL */
        transition: all 0.3s ease-in-out;
    }

    /* خط عمودی اصلی */
    .referral-tree-node::before {
        content: '';
        position: absolute;
        inset-inline-start: calc(var(--tree-spacing) / 2);
        top: 0;
        bottom: 0;
        width: 2px;
        background-color: var(--tree-line-default);
        border-radius: 1px;
    }
    /* اگر گره تکمیل شده، خط را سبز کن */
    .referral-tree-node.is-completed::before {
        background-color: var(--bs-success); /* استفاده مستقیم از Bootstrap/CSS Vars */
    }
    /* خط افقی و اتصال */
    .referral-card-wrapper {
        position: relative;
        padding-top: 10px; /* فضای تنفس برای دایره وضعیت */
    }
    .referral-card-wrapper::before {
        content: '';
        position: absolute;
        inset-inline-start: calc(var(--tree-spacing) / 2);
        top: 22px; /* موقعیت خط افقی */
        width: 10px;
        height: 2px;
        background-color: var(--tree-line-default);
        z-index: 5;
    }
    .referral-tree-node.is-completed .referral-card-wrapper::before {
        background-color: var(--bs-success);
    }
    /* دایره وضعیت */
    .referral-status-icon {
        position: absolute;
        inset-inline-start: calc(var(--tree-spacing) / 2);
        top: 10px;
        transform: translateX(-50%);
        z-index: 20;
        width: 24px;
        height: 24px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 50%;
        color: white;
        border: 4px solid var(--bs-body-bg, #fff); /* حلقه سفید دور آیکون */
        box-shadow: 0 0 0 1px var(--tree-line-default);
    }
    /* کارت اطلاعات */
    .referral-info-card {
        border-radius: 12px;
        transition: all 0.2s;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.06);
        border-inline-start: 5px solid transparent;
        padding: 10px;
    }
    .referral-info-card:hover {
        transform: translateY(-1px);
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -4px rgba(0, 0, 0, 0.05);
    }
    .node-label {
        font-size: 1rem;
        font-weight: 700;
    }
    .node-meta {
        font-size: 0.75rem;
        color: var(--text-muted, #6b7280);
    }
    /* RTL Fix for recursion */
    .referral-tree-node > .referral-card-wrapper > .referral-info-card {
        margin-inline-start: 10px;
    }
</style>

<?php $__currentLoopData = $nodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $node): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        /** @var \App\Models\Referral $ref */
        $ref = $node['referral'];
        $user = $ref->user;
        $status = $ref->status;
        $level = $level ?? 0;

        // Map وضعیت‌ها به کلاس‌های Bootstrap
        $statusMap = match($status) {
            \App\Models\Referral::STATUS_COMPLETED => ['color' => 'success', 'icon' => 'fa-check'],
            \App\Models\Referral::STATUS_REJECTED => ['color' => 'danger', 'icon' => 'fa-times'],
            \App\Models\Referral::STATUS_VIEWED => ['color' => 'info', 'icon' => 'fa-eye'],
            \App\Models\Referral::STATUS_PENDING => ['color' => 'warning', 'icon' => 'fa-hourglass-half'],
            default => ['color' => 'secondary', 'icon' => 'fa-question'],
        };
        $statusColor = $statusMap['color'];
        $statusIcon = $statusMap['icon'];

        // Map نوع ارجاع به آیکون و رنگ (با کمی تغییر برای وضوح)
        $typeMap = match($ref->type) {
            \App\Models\Referral::TYPE_APPROVAL => ['icon' => 'fa-signature', 'color' => 'success', 'label' => 'تأیید/امضا'],
            \App\Models\Referral::TYPE_ACTION => ['icon' => 'fa-tools', 'color' => 'warning', 'label' => 'اقدام و اجرا'],
            \App\Models\Referral::TYPE_INFORMATION => ['icon' => 'fa-bullhorn', 'color' => 'info', 'label' => 'صرفاً اطلاع'],
            \App\Models\Referral::TYPE_CONSULTATION => ['icon' => 'fa-comment-dots', 'color' => 'primary', 'label' => 'مشاوره/نظر'],
            \App\Models\Referral::TYPE_CORRECTION => ['icon' => 'fa-redo-alt', 'color' => 'danger', 'label' => 'برگشت جهت تصحیح'],
            \App\Models\Referral::TYPE_OTHER => ['icon' => 'fa-thumbtack', 'color' => 'secondary', 'label' => 'سایر اعمال'],
            default => ['icon' => 'fa-paper-plane', 'color' => 'secondary', 'label' => 'نامشخص'],
        };

        $isCompleted = $ref->status === \App\Models\Referral::STATUS_COMPLETED;
        $nodeClass = $isCompleted ? 'is-completed' : '';
    ?>

    <div class="referral-tree-node <?php echo e($nodeClass); ?>" style="animation: fadeInUp 0.4s ease forwards; opacity: 0; animation-delay: <?php echo e($level * 0.1); ?>s;">

        <div class="referral-card-wrapper d-flex align-items-center">

            
            <div class="referral-status-icon bg-<?php echo e($statusColor); ?>">
                <i class="fas <?php echo e($statusIcon); ?> fa-xs"></i>
            </div>

            
            <div class="flex-grow-1 referral-info-card bg-white w-100 border-<?php echo e($typeMap['color']); ?>"
                 style="border-inline-start-color: var(--bs-<?php echo e($typeMap['color']); ?>); border-inline-start-width: 5px;">

                <div class="d-flex align-items-start gap-3">

                    
                    <div class="flex-shrink-0 pt-1">
                        <img src="<?php echo e($this->getUserProfilePhotoUrl($user)); ?>"
                             class="node-avatar" alt="<?php echo e($user->name ?? 'سیستم'); ?>" style="width: 36px; height: 36px;">
                    </div>

                    <div class="flex-grow-1">

                        
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="node-label text-dark">
                                <?php echo e($user->name ?? 'کاربر نامشخص'); ?>

                            </span>
                            <span class="badge bg-<?php echo e($statusColor); ?>-subtle text-<?php echo e($statusColor); ?> fw-bold rounded-pill px-3 py-1 node-meta">
                                <?php echo e($ref->statusLabel()); ?>

                            </span>
                        </div>

                        
                        <div class="d-flex justify-content-between align-items-center mt-1 node-meta">
                            <span class="badge bg-<?php echo e($typeMap['color']); ?>-subtle text-<?php echo e($typeMap['color']); ?> fw-normal px-2 py-1" style="font-size: 0.7rem;">
                                <i class="fas <?php echo e($typeMap['icon']); ?> me-1"></i>
                                <?php echo e($typeMap['label']); ?>

                            </span>
                            <span class="node-meta">
                                <i class="far fa-calendar-alt me-1"></i>
                                <?php echo e($this->formatShamsiDate($ref->created_at, 'Y/m/d H:i')); ?>

                            </span>
                        </div>

                        
                        <?php if($ref->correction_message): ?>
                            <div class="mt-2 p-2 rounded-2 bg-danger-subtle text-danger fw-bold border border-danger-subtle" style="font-size: 0.8rem;">
                                <i class="fas fa-exclamation-triangle me-1"></i>
                                <span class="me-1">پیام برگشت:</span>
                                <?php echo e(Str::limit($ref->correction_message, 80)); ?>

                            </div>
                        <?php endif; ?>

                        
                        <?php if($ref->isApproval() && $isCompleted): ?>
                            <div class="mt-2 p-2 rounded-2 bg-success-subtle text-success fw-bold border border-success-subtle" style="font-size: 0.8rem;">
                                <i class="fas fa-check-double me-1"></i>
                                تأیید نهایی و امضا انجام شد.
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        </div>

        <?php if(! empty($node['children'])): ?>
            
            <div class="ps-4 mt-3 position-relative">
                <?php $__currentLoopData = $node['children']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo $__env->make('livewire.admin.letter.partials.referral-tree-node', [
                        'nodes' => [$child],
                        'level' => $level + 1
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\letter\partials\referral-tree-node.blade.php ENDPATH**/ ?>