<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-lg-9">
            <div class="card shadow">
                <div class="card-header bg-primary text-light d-flex justify-content-between align-items-center">
                    <h4 class="mb-0"><i class="bi bi-building"></i> فرم پروژه مدرن</h4>
                    <span class="badge bg-light text-primary">واکنش‌گرا و مطمئن</span>
                </div>
                <div class="card-body">

                    <?php if(session()->has('message')): ?>
                        <div class="alert alert-success"><i class="bi bi-check-circle-fill"></i> <?php echo e(session('message')); ?></div>
                    <?php endif; ?>
                    <?php if(session()->has('error')): ?>
                        <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i> <?php echo e(session('error')); ?></div>
                    <?php endif; ?>

                    <form wire:submit.prevent="save">
                        <div class="row g-3 mb-3">
                            <div class="col-md-4">
                                <label class="form-label">کد پروژه</label>
                                <input type="text" wire:model.defer="project_code" class="form-control"/>
                                <?php $__errorArgs = ['project_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">کد مالیاتی</label>
                                <input type="text" wire:model.defer="tax_code" class="form-control"/>
                                <?php $__errorArgs = ['tax_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">وضعیت پروژه</label>
                                <select wire:model.defer="status" class="form-select">
                                    <option value="">انتخاب وضعیت</option>
                                    <option value="شروع نشده">شروع نشده</option>
                                    <option value="در حال اجرا">در حال اجرا</option>
                                    <option value="اتمام">اتمام</option>
                                </select>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="row g-3 mb-3">
                            <div class="col-md-6">
                                <label class="form-label">نوع پروژه (انتخاب چندگانه)</label>
                                <select wire:model.defer="project_types" class="form-select" multiple>
                                    <?php $__currentLoopData = $projectTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($type->id); ?>"><?php echo e($type->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['project_types'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <div class="mt-2 d-flex flex-wrap gap-1">
                                    <span class="fw-bold">انتخاب شده:</span>
                                    <?php $__currentLoopData = $project_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $typeId): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge bg-info"><?php echo e($projectTypes->firstWhere('id', $typeId)?->name); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">شرکت مدیر پروژه</label>
                                <select wire:model="manager_company_id" class="form-select">
                                    <option value="">انتخاب شرکت</option>
                                    <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($company->id); ?>"><?php echo e($company->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['manager_company_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <label class="form-label mt-2">دپارتمان مدیر پروژه</label>
                                <select wire:model="manager_department_id" class="form-select">
                                    <option value="">انتخاب دپارتمان</option>
                                    <?php $__currentLoopData = $managerDepartments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($dept->id); ?>"><?php echo e($dept->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <label class="form-label mt-2">مدیر پروژه</label>
                                <select wire:model="manager_id" class="form-select">
                                    <option value="">انتخاب مدیر</option>
                                    <?php $__currentLoopData = $managerCandidates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manager): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($manager->id); ?>"><?php echo e($manager->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($managerCandidates && count($managerCandidates)==0): ?>
                                    <div class="text-warning small mt-1">هیچ مدیر فعالی در این شرکت یا دپارتمان وجود ندارد.</div>
                                <?php endif; ?>
                                <?php $__errorArgs = ['manager_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="mb-3 border p-2 rounded bg-light">
                            <strong>نقش‌های پروژه</strong>
                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="row mb-2 align-items-center" wire:key="role-<?php echo e($i); ?>">
                                    <div class="col-md-5">
                                        <select wire:model.defer="roles.<?php echo e($i); ?>.role_type" class="form-select">
                                            <option value="">نقش</option>
                                            <option value="کارفرمای اصلی">کارفرمای اصلی</option>
                                            <option value="کارفرمای فرعی">کارفرمای فرعی</option>
                                            <option value="مشاور">مشاور</option>
                                        </select>
                                    </div>
                                    <div class="col-md-5">
                                        <select wire:model.defer="roles.<?php echo e($i); ?>.company_id" class="form-select">
                                            <option value="">شرکت</option>
                                            <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($company->id); ?>"><?php echo e($company->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-2 text-center">
                                        <button type="button" wire:click="removeRole(<?php echo e($i); ?>)" class="btn btn-outline-danger btn-sm px-3">
                                            حذف <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <button type="button" wire:click="addRole" class="btn btn-outline-primary btn-sm mt-2 w-100">
                                <i class="bi bi-plus-circle"></i> افزودن نقش جدید
                            </button>
                            <?php if($roleDuplicateError): ?>
                                <div class="text-warning mt-2"><i class="bi bi-exclamation-triangle"></i> نقش/شرکت تکراری است.</div>
                            <?php endif; ?>
                        </div>
                        <button type="submit" class="btn btn-success w-100 mt-3" wire:loading.attr="disabled">
                            <span wire:loading.remove>ذخیره</span>
                            <span wire:loading>
                                <span class="spinner-border spinner-border-sm"></span> در حال ذخیره...
                            </span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\projects\project-detail-create.blade.php ENDPATH**/ ?>