<div x-data="{
        showPreview: false,
        previewTitle: '',
        previewContent: '', // اطمینان از وجود متغیر

        openPreview(title, content) {
            this.previewTitle = title;
            this.previewContent = content;
            this.showPreview = true;
        },
        // متد امن Alpine برای ارزیابی محتوا
        isContentImage() {
            return this.previewContent && this.previewContent.match(/\.(jpeg|jpg|gif|png|webp|svg|bmp)$/i);
        },
        isContentShort() {
            return this.previewContent && !this.isContentImage() && this.previewContent.length < 50;
        }
     }"
     class="container-fluid py-4">

    <!-- مرحله‌بندی بصری (مرکز شده و تمیز) -->
    <div class="d-flex align-items-center justify-content-center gap-3 mb-5 flex-wrap">
        <span class="step-badge step-active bg-primary text-white px-3 py-1 rounded-pill shadow-lg">۱</span>
        <span class="fw-bold small text-primary">انتخاب سربرگ</span>
        <span class="step-divider mx-2"></span>
        <span class="step-badge bg-light px-3 py-1 rounded-pill text-secondary">۲</span>
        <span class="small text-secondary">نگارش متن</span>
        <span class="step-divider mx-2"></span>
        <span class="step-badge bg-light px-3 py-1 rounded-pill text-secondary">۳</span>
        <span class="small text-secondary">گیرنده و ارسال</span>
    </div>

    <div class="d-flex justify-content-between align-items-center mb-5 flex-wrap gap-3 border-bottom pb-3">
        <h1 class="mb-0 fs-4 fw-bold text-dark">لیست سربرگ‌های قابل انتخاب برای نامه</h1>
        <a href="<?php echo e(route('admin.letter.form.create')); ?>" class="btn btn-primary rounded-pill px-4 py-2 shadow-lg">
            <i class="ti ti-plus me-1"></i> افزودن سربرگ جدید
        </a>
    </div>

    <div class="row mb-5 g-3 align-items-center">
        <div class="col-md-6">
            <div class="input-group input-group-lg shadow-sm rounded-pill overflow-hidden">
                <span class="input-group-text bg-white border-0"><i class="ti ti-search text-muted"></i></span>
                <input type="text" wire:model.debounce.400ms="search" class="form-control border-0 ps-0 pe-4" placeholder="جستجوی نام سربرگ...">
            </div>
        </div>
        <div class="col-md-6 text-md-end text-muted small">
            تعداد سربرگ‌های یافت شده: <span class="fw-bold text-primary"><?php echo e($letterForms->count()); ?></span>
        </div>
    </div>

    <div class="row g-4">
        <?php $__empty_1 = true; $__currentLoopData = $letterForms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $form): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                <div class="card letterform-card border-0 shadow-xl h-100 p-4">
                    <div class="card-body text-center d-flex flex-column p-0">
                        <div class="bg-light border border-dashed border-gray-300 d-flex align-items-center justify-content-center letter-template-img mb-4 rounded-3 p-2 overflow-hidden">
                            <!-- نمایش تصویر یا Placeholder -->
                            <?php
                                $imageUrl = asset('app/template/' . ($form->background ?? ''));
                            ?>
                            <img src="<?php echo e($imageUrl); ?>"
                                 onerror="this.onerror=null;this.src='https://placehold.co/150x120/f0f4f8/9ca3af?text=بدون+عکس';"
                                 alt="<?php echo e($form->name); ?>"
                                 class="img-fluid rounded-2 shadow-xs"
                                 style="max-height:100%; max-width: 100%; object-fit:contain;">
                        </div>

                        <h5 class="card-title fw-bolder mt-2 mb-3 text-dark flex-grow-1"><?php echo e($form->name); ?></h5>

                        <div class="d-flex justify-content-between gap-2 mt-auto">
                            <!-- دکمه پیش‌نمایش (باز کردن مودال) -->
                            <button @click="openPreview('<?php echo e($form->name); ?>', <?php echo \Illuminate\Support\Js::from($form->background ?? '')->toHtml() ?>)"
                                    class="btn btn-outline-info rounded-pill flex-grow-1 py-2 shadow-sm">
                                <i class="ti ti-eye me-1"></i> پیش‌نمایش
                            </button>

                            <!-- دکمه انتخاب -->
                            <button wire:click="selectForm(<?php echo e($form->id); ?>)"
                                    wire:loading.attr="disabled"
                                    class="btn btn-primary rounded-pill flex-grow-1 py-2 shadow-md hover:shadow-lg transition-all">
                                <span wire:loading wire:target="selectForm(<?php echo e($form->id); ?>)" class="spinner-border spinner-border-sm me-1"></span>
                                انتخاب
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12">
                <div class="alert alert-info text-center fw-bold py-5 rounded-4 shadow-sm">
                    <i class="ti ti-alert-triangle me-2 fs-5"></i> هیچ سربرگی با کلمه جستجوی شما پیدا نشد.
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Modal پیش‌نمایش سربرگ (Alpine.js) -->
    <div x-show="showPreview" x-cloak
         x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition ease-in duration-200"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         class="fixed inset-0 z-50 overflow-y-auto bg-black bg-opacity-50 flex items-center justify-center p-4"
         style="backdrop-filter: blur(5px);">

        <div @click.outside="showPreview = false"
             x-transition:enter="transition ease-out duration-300 transform"
             x-transition:enter-start="scale-90"
             x-transition:enter-end="scale-100"
             x-transition:leave="transition ease-in duration-200 transform"
             x-transition:leave-start="scale-100"
             x-transition:leave-end="scale-90"
             class="bg-white rounded-xl shadow-2xl w-full max-w-4xl max-h-[90vh] overflow-y-auto" style="min-height: 400px;">

            <!-- Modal Header -->
            <div class="p-4 border-b d-flex justify-content-between align-items-center">
                <h3 class="text-xl fw-bold text-dark" x-text="'پیش‌نمایش: ' + previewTitle"></h3>
                <button @click="showPreview = false" class="btn btn-light rounded-circle p-2">
                    <i class="ti ti-x"></i>
                </button>
            </div>

            <!-- Modal Body (نمایش محتوای HTML) -->
            <div class="p-5" style="direction: rtl; text-align: right;">
                <div class="preview-content-box border border-dashed border-dark p-4 rounded-lg bg-light"
                     :style="isContentImage() ? 'background-image: url(\'' + previewContent + '\'); background-size: contain; background-repeat: no-repeat; background-position: center; height: 500px; border: none !important;' : 'min-height: 200px;'"
                     x-html="isContentImage() ? '' : previewContent">

                    <!-- اگر محتوا HTML نباشد و تصویر هم نمایش داده نشود (Fallback) -->
                    <p x-show="isContentShort()" class="text-muted text-center py-5">
                        محتوای سربرگ نامشخص است یا بارگذاری نشد.
                    </p>
                </div>
            </div>

            <!-- Modal Footer -->
            <div class="p-4 border-t text-end">
                <button @click="showPreview = false" class="btn btn-secondary rounded-pill px-4">بستن</button>
            </div>
        </div>
    </div>

    <style>
        .letterform-card {
            border-radius:1.5rem;
            transition:box-shadow .2s,transform .15s;
            background: white;
        }
        .letterform-card:hover {
            box-shadow:0 10px 30px rgba(0,0,0,0.08);
            transform: translateY(-5px) scale(1.02);
            border: 1px solid #409fff30 !important;
        }
        .letter-template-img {
            height: 140px;
            min-height: 140px;
            background-color:#f7f9fb;
            border: 1px solid #e0e6ee !important;
            position: relative;
        }

        .step-badge {font-size:.98em; min-width:2em; text-align:center; transition: all 0.3s;}
        .step-active { box-shadow:0 0 0 4px #409fff50;}
        .step-divider {width:29px;height:2.7px;background:#e0e6ee;display:inline-block;border-radius:1px;}
        .text-dark { color: #1f2937 !important; }
        .shadow-xs { box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05); }
        .btn-outline-info {
            color: #0d6efd;
            border-color: #0d6efd;
            background-color: transparent;
        }
        .btn-outline-info:hover {
            color: white;
            background-color: #0d6efd;
        }
    </style>

    <?php $__env->startPush('scripts'); ?>
        <!-- SweetAlert2 CDN -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script>
            // مدیریت پیام‌های خطای زیبا با SweetAlert2
            window.addEventListener('show-sweet-alert', function(e){
                Swal.fire({
                    icon: e.detail.icon || 'success',
                    title: e.detail.title || 'پیام',
                    text: e.detail.text || '',
                    confirmButtonText: 'تایید',
                    customClass: {
                        container: 'swal2-container-rtl',
                        popup: 'swal2-popup-rtl',
                    },
                    allowOutsideClick: true
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\letter\form\letter-form-list.blade.php ENDPATH**/ ?>