<div class="container-fluid py-5 px-lg-5" dir="rtl" style="font-family: 'Vazirmatn', sans-serif; background: #f8fafc; min-height: 100vh;">
    <style>
        :root {
            --p-azure: #0ea5e9; --p-indigo: #4361ee; --p-slate: #0f172a;
            --p-border: rgba(226, 232, 240, 0.7); --p-glass: rgba(255, 255, 255, 0.85);
        }

        .reveal-up { animation: luxFadeUp 1s cubic-bezier(0.16, 1, 0.3, 1) both; }
        @keyframes luxFadeUp { from { opacity: 0; transform: translateY(30px) scale(0.98); } to { opacity: 1; transform: translateY(0) scale(1); } }

        /* 🏔️ هدر فوق لوکس پانوراما */
        .sky-command-center {
            background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
            border-radius: 40px; padding: 75px 65px; color: white;
            position: relative; overflow: hidden;
            box-shadow: 0 45px 80px -20px rgba(15, 23, 42, 0.3);
            margin-bottom: 60px; border: 1px solid rgba(255,255,255,0.08);
        }

        /* ویجت‌های شیشه‌ای داخل هدر */
        .header-metric {
            background: rgba(255, 255, 255, 0.04);
            backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 28px; padding: 22px 30px;
            transition: 0.4s ease;
        }
        .header-metric:hover { background: rgba(255, 255, 255, 0.08); transform: translateY(-5px); border-color: var(--p-azure); }

        /* ✨ بدنه اصلی (Elite Bento) */
        .lux-card-main {
            background: var(--p-glass); backdrop-filter: blur(25px);
            border-radius: 42px; border: 1px solid #fff;
            box-shadow: 0 30px 60px -15px rgba(0,0,0,0.04);
            overflow: hidden;
        }

        /* 📄 ردیف‌های لیست کریستالی */
        .file-entry {
            background: #fff; border-radius: 24px; padding: 22px 32px;
            margin-bottom: 16px; border: 1px solid #f1f5f9;
            display: flex; align-items: center; justify-content: space-between;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
        }
        .file-entry:hover {
            transform: scale(1.02) translateX(-10px);
            border-color: var(--p-azure);
            box-shadow: 0 20px 40px rgba(14, 165, 233, 0.08);
            z-index: 2;
        }

        /* 🔘 دکمه‌های کنترلی پلاتینیوم */
        .btn-prime-action {
            width: 48px; height: 48px; border-radius: 16px;
            display: inline-flex; align-items: center; justify-content: center;
            transition: 0.3s; background: #f8fafc; border: 1px solid #eef2f6; color: #64748b;
        }
        .btn-prime-action:hover { transform: translateY(-4px) scale(1.1); color: white; box-shadow: 0 10px 20px rgba(0,0,0,0.1); }
        .btn-dl:hover { background: var(--p-azure); border-color: var(--p-azure); }
        .btn-tr:hover { background: #ef4444; border-color: #ef4444; }

        /* 🖋️ فیلد جستجوی مدرن */
        .crystal-input {
            border-radius: 20px !important; border: 2px solid #edf2f7 !important; padding: 16px 26px !important;
            background: #fff !important; transition: 0.3s; font-weight: 700; color: var(--p-slate);
        }
        .crystal-input:focus { border-color: var(--p-azure) !important; box-shadow: 0 0 0 8px rgba(14, 165, 233, 0.08) !important; }
    </style>

    <div class="sky-command-center reveal-up">
        <div class="row align-items-center position-relative z-index-2">
            <div class="col-lg-7">

                <h1 class="fw-black display-2 mb-4 text-white" style="letter-spacing: -2px;">آرشیو مستندات</h1>
                <p class="opacity-50 fs-5 lh-lg mb-0 pe-lg-5 text-justify fw-medium">
                    سامانه هوشمند آرشیو و مدیریت دارایی‌های دیجیتال با امنیت
                    <span class="text-info fw-black">AES-256</span>
                    و کلاسترینگ خودکار فازهای مهندسی.
                </p>
            </div>

            <div class="col-lg-5 mt-5 mt-lg-0">
                <div class="row g-4 justify-content-lg-end">
                    <div class="col-sm-6">
                        <div class="header-metric text-center">
                            <i class="ti ti-file-analytics fs-2 text-info mb-2"></i>
                            <div class="fw-black fs-2 text-white"><?php echo e($this->stats['total_count']); ?></div>
                            <small class="text-white opacity-30 fw-bold text-uppercase mt-1" style="font-size: 0.6rem; letter-spacing: 1px;">Cloud Assets</small>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="header-metric text-center">
                            <i class="ti ti-database-heart fs-2 text-primary mb-2"></i>
                            <div class="fw-black fs-2 text-primary text-ltr"><?php echo e($this->stats['formatted_size']); ?></div>
                            <small class="text-white opacity-30 fw-bold text-uppercase mt-1" style="font-size: 0.6rem; letter-spacing: 1px;">Data Scale</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 mb-5 reveal-up" style="animation-delay: 0.1s">
        <div class="col-md-5">
            <div class="position-relative h-100">
                <i class="ti ti-search position-absolute top-50 start-0 translate-middle-y ms-4 text-primary fs-4"></i>
                <input type="text" wire:model.live.debounce.400ms="search" class="form-control crystal-input ps-5 h-100 border-0 shadow-sm" placeholder="جستجوی متای فایل، پروژه یا فاز...">
            </div>
        </div>
        <div class="col-md-4">
            <select wire:model.live="filterProject" class="form-select crystal-input h-100 border-0 shadow-sm shadow-none">
                <option value="">فیلتر پورتفولیو پروژه‌ها...</option>
                <?php $__currentLoopData = $this->projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($project->id); ?>"><?php echo e($project->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="col-md-3">
            <a href="<?php echo e(route('admin.create.file')); ?>" class="btn btn-primary w-100 h-100 rounded-4 fw-black d-flex align-items-center justify-content-center gap-3 shadow-primary py-3">
                <i class="ti ti-layout-grid-add fs-4"></i> بارگذاری مستند جدید
            </a>
        </div>
    </div>

    <div class="lux-card-main p-4 p-md-5 reveal-up" style="animation-delay: 0.2s">
        <div class="row px-5 mb-5 text-muted small fw-black opacity-40 d-none d-md-flex text-uppercase tracking-widest">
            <div class="col-md-5">Asset Metadata</div>
            <div class="col-md-3 text-center">Module Classification</div>
            <div class="col-md-2 text-center border-start border-end">Specifications</div>
            <div class="col-md-2 text-center pe-4">Command</div>
        </div>

        <div class="position-relative" wire:loading.class="opacity-50">
            <?php $__empty_1 = true; $__currentLoopData = $projectFiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="file-entry shadow-sm" wire:key="file-<?php echo e($file->id); ?>">
                    <div class="col-md-5 d-flex align-items-center gap-4">
                        <div class="form-check custom-check">
                            <input type="checkbox" wire:model.live="selectedFiles" value="<?php echo e($file->id); ?>" class="form-check-input primary border-2 shadow-none">
                        </div>
                        <div class="file-icon-box text-primary" style="width: 55px; height: 55px; background: #f8fafc; border-radius: 18px; display: flex; align-items: center; justify-content: center; border: 1px solid #f1f5f9;">
                            <i class="fa <?php echo e($file->icon); ?> fs-3"></i>
                        </div>
                        <div>
                            <h6 class="fw-black text-dark fs-5 mb-1"><?php echo e(Str::limit($file->name, 45)); ?></h6>
                            <div class="d-flex align-items-center gap-2">
                                <span class="badge bg-light text-muted border px-2 py-1 rounded-pill small fw-bold">ID: #<?php echo e(1000 + $file->id); ?></span>
                                <span class="text-muted small fw-bold opacity-75">توسط: <?php echo e($file->user->name); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 d-none d-md-block text-center border-start border-light px-3">
                        <span class="fw-black text-dark small d-block mb-1"><?php echo e($file->project->name); ?></span>
                        <div class="badge bg-info bg-opacity-10 text-info border border-info border-opacity-20 px-3 py-1 rounded-pill small fw-bold">
                            <?php echo e($file->section->name); ?>

                        </div>
                    </div>

                    <div class="col-md-2 text-center d-none d-md-block border-start border-end border-light px-3">
                        <code class="bg-indigo-soft text-indigo px-3 py-1 rounded-pill small fw-black d-inline-block mb-1"><?php echo e($file->formatted_size); ?></code>
                        <div class="text-muted fw-bold" style="font-size: 0.65rem;"><?php echo e(jdate($file->created_at)->ago()); ?></div>
                    </div>

                    <div class="col-md-2 d-flex justify-content-center gap-3">
                        <button wire:click="downloadFile(<?php echo e($file->id); ?>)" class="btn-prime-action btn-dl" title="Download Asset">
                            <i class="ti ti-download fs-4"></i>
                        </button>
                        <?php if(Auth::user()->isAdmin()): ?>
                            <button wire:click="deleteFile(<?php echo e($file->id); ?>)" wire:confirm="آیا از پاکسازی دائمی این سند اطمینان دارید؟" class="btn-prime-action btn-tr" title="Delete Asset">
                                <i class="ti ti-trash-x fs-4"></i>
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center py-5 opacity-20">
                    <i class="ti ti-layers-subtract display-1 d-block mb-3"></i>
                    <h4 class="fw-black">دیتابیس در این لایه خالی است</h4>
                </div>
            <?php endif; ?>
        </div>

        <div class="d-flex justify-content-between align-items-center mt-5 px-3">
            <div class="text-muted small fw-black opacity-50 tracking-widest">ASSET FEED: <?php echo e($projectFiles->total()); ?> TOTAL</div>
            <div class="lux-pagination shadow-sm rounded-pill overflow-hidden border">
                <?php echo e($projectFiles->links('livewire::bootstrap')); ?>

            </div>
        </div>
    </div>

    <?php if(count($selectedFiles) > 0 && Auth::user()->isAdmin()): ?>
        <div class="fixed-bottom mb-5 d-flex justify-content-center reveal-up">
            <div class="bg-dark text-white px-5 py-4 rounded-pill shadow-2xl d-flex align-items-center gap-5 border border-white border-opacity-10" style="backdrop-filter: blur(20px); background: rgba(15, 23, 42, 0.98) !important;">
                <div class="d-flex align-items-center gap-3 border-start ps-5">
                    <div class="p-3 bg-primary rounded-circle shadow-primary"><i class="ti ti-check fs-4 text-white"></i></div>
                    <div>
                        <span class="fw-black fs-4 d-block" style="line-height: 1;"><?php echo e(count($selectedFiles)); ?></span>
                        <small class="opacity-50 fw-bold">فایل انتخاب شده</small>
                    </div>
                </div>
                <div class="d-flex gap-3">
                    <button wire:click="deleteSelected" wire:confirm="پاکسازی دسته جمعی انجام شود؟" class="btn btn-danger rounded-pill px-5 fw-black py-3 shadow-lg">حذف نهایی</button>
                    <button wire:click="$set('selectedFiles', [])" class="btn btn-light rounded-pill px-4 fw-bold py-3 border-0">انصراف</button>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\project-files\list-files.blade.php ENDPATH**/ ?>