<div class="container-fluid py-4" style="background: #f4f7fe; min-height: 100vh;">
    <style>
        /* 💎 پالت رنگی و متغیرهای لوکس */
        :root {
            --p-dark: #003366;
            --p-main: #004d99;
            --p-soft: #eef2ff;
            --glass: rgba(255, 255, 255, 0.95);
        }

        .fw-black { font-weight: 900 !important; }
        .fs-xs { font-size: 0.75rem !important; }

        /* ✨ افکت شیشه‌ای مدرن (Glassmorphism) */
        .glass-card {
            background: var(--glass);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.4);
            border-radius: 1.5rem;
            transition: all 0.4s cubic-bezier(0.165, 0.84, 0.44, 1);
        }
        .glass-card:hover { transform: translateY(-5px); box-shadow: 0 20px 40px rgba(0, 0, 0, 0.06) !important; }

        /* 🔘 استایل تب‌ها (Modern Segmented Control) */
        .nav-pills-custom .nav-link {
            border-radius: 12px;
            padding: 10px 20px;
            color: #64748b;
            font-weight: 700;
            transition: 0.3s;
            border: 1px solid transparent;
        }
        .nav-pills-custom .nav-link.active {
            background: white;
            color: var(--p-main);
            border-color: rgba(0,0,0,0.05);
            box-shadow: 0 10px 15px -3px rgba(0,0,0,0.05);
        }

        /* 💰 نشانگر مبلغ هوشمند */
        .badge-price-lux {
            background: linear-gradient(135deg, #f0fdf4 0%, #dcfce7 100%);
            color: #166534;
            border: 1px solid #bbf7d0;
            padding: 8px 16px;
            border-radius: 12px;
            font-weight: 900;
            letter-spacing: 0.5px;
        }

        /* 👤 آواتار حرفه‌ای */
        .avatar-box {
            width: 42px; height: 42px;
            background: var(--p-soft);
            color: var(--p-main);
            border-radius: 12px;
            display: flex; align-items: center; justify-content: center;
            font-weight: 900; box-shadow: inset 0 2px 4px rgba(0,0,0,0.05);
        }

        /* 🚀 انیمیشن دکمه‌ها */
        .btn-hover-scale { transition: 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275); }
        .btn-hover-scale:hover { transform: scale(1.05); }

        /* ⏳ تایم‌لاین گردش کار فوق حرفه‌ای */
        .workflow-track { position: relative; padding-left: 30px; }
        .workflow-track::before {
            content: ''; position: absolute; left: 9px; top: 5px; bottom: 5px;
            width: 3px; background: #f1f5f9; border-radius: 10px;
        }
        .workflow-node {
            position: absolute; left: 0; width: 22px; height: 22px;
            border-radius: 8px; border: 4px solid white; box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }

        .line-clamp-1 { display: -webkit-box; -webkit-line-clamp: 1; -webkit-box-orient: vertical; overflow: hidden; }
    </style>

    
    <div class="row align-items-center mb-5">
        <div class="col-md-7">
            <h2 class="fw-black text-dark mb-1">صندوق عملیات تایید</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0 small fw-bold">
                    <li class="breadcrumb-item text-muted">داشبورد مدیریتی</li>
                    <li class="breadcrumb-item text-primary active">تدارکات و لجستیک</li>
                </ol>
            </nav>
        </div>
        <div class="col-md-5 text-md-end">
            <?php if(session()->has('message')): ?>
                <div class="d-inline-block bg-white border border-success border-opacity-20 shadow-sm py-2 px-4 rounded-4 animate__animated animate__bounceIn">
                    <span class="text-success fw-black small"><i class="ti ti-circle-check me-2"></i><?php echo e(session('message')); ?></span>
                </div>
            <?php endif; ?>
        </div>
    </div>

    
    <div class="row g-4 mb-4 align-items-center">
        <div class="col-lg-7">
            <div class="bg-white p-2 d-inline-flex rounded-4 shadow-sm nav-pills-custom">
                <button class="nav-link <?php if($activeTab == 'pending'): ?> active <?php endif; ?>" wire:click="$set('activeTab', 'pending')">
                    <i class="ti ti-clock-play me-1"></i> نیاز به اقدام فوری
                    <span class="badge bg-danger rounded-pill ms-2 fw-black shadow-sm"><?php echo e($this->pendingRequests->total()); ?></span>
                </button>
                <button class="nav-link <?php if($activeTab == 'history'): ?> active <?php endif; ?>" wire:click="$set('activeTab', 'history')">
                    <i class="ti ti-calendar-check me-1"></i> تاریخچه تصمیمات شما
                </button>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="input-group glass-card border-white shadow-sm overflow-hidden p-1">
                <span class="input-group-text border-0 bg-transparent ps-3"><i class="ti ti-search text-muted"></i></span>
                <input type="text" class="form-control border-0 py-2 fw-bold text-dark shadow-none" wire:model.live.debounce.300ms="search" placeholder="جستجوی هوشمند در پرونده‌ها...">
            </div>
        </div>
    </div>

    
    <div class="glass-card shadow-sm border-0 overflow-hidden">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light bg-opacity-50">
                <tr class="text-muted small fw-black text-uppercase">
                    <th class="py-4 ps-4">شناسنامه پرونده / متقاضی</th>
                    <th>ارزش برآورد (ریال)</th>
                    <th>تاریخ ثبت</th>
                    <th>شرح فنی</th>
                    <?php if($activeTab == 'pending'): ?> <th style="width: 280px;">یادداشت مدیریتی</th> <?php endif; ?>
                    <th class="text-center">وضعیت اقدام</th>
                </tr>
                </thead>
                <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $activeTab == 'pending' ? $this->pendingRequests : $this->historyRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr wire:key="request-<?php echo e($request->id); ?>" class="border-bottom border-light transition-all">
                        <td class="ps-4">
                            <div class="d-flex align-items-center py-2">
                                <div class="avatar-box me-3 shadow-sm"><?php echo e(mb_substr($request->user?->name, 0, 1)); ?></div>
                                <div>
                                    <div class="fw-black text-dark mb-0">PR-<?php echo e($request->id); ?></div>
                                    <div class="badge bg-primary-subtle text-primary fw-black fs-xs rounded-pill px-2">
                                        <?php echo e($request->project?->name); ?>

                                    </div>
                                </div>
                            </div>
                        </td>
                        <td><span class="badge-price-lux"><?php echo e(number_format($request->total_amount)); ?></span></td>
                        <td class="text-muted fw-bold small"><?php echo e(\Morilog\Jalali\Jalalian::fromCarbon($request->created_at)->format('Y/m/d')); ?></td>
                        <td>
                            <div class="d-flex flex-column">
                                <span class="text-dark small fw-bold line-clamp-1" style="max-width: 250px;"><?php echo e($request->description); ?></span>
                                <a href="javascript:void(0)" class="text-primary fw-black fs-xs text-decoration-none mt-1" wire:click="showDetails(<?php echo e($request->id); ?>)">
                                    <i class="ti ti-external-link"></i> مشاهده کامل مستندات
                                </a>
                            </div>
                        </td>
                        <?php if($activeTab == 'pending'): ?>
                            <td>
                                    <textarea class="form-control form-control-sm border-light bg-light bg-opacity-30 rounded-4 shadow-none fw-bold p-2"
                                              wire:model.blur="comment.<?php echo e($request->id); ?>"
                                              placeholder="توضیحات یا یادداشت فنی..." rows="1"></textarea>
                            </td>
                            <td class="text-center">
                                <div class="d-flex gap-2 justify-content-center">
                                    <button class="btn btn-sm btn-success btn-hover-scale rounded-3 px-3 fw-black shadow-sm" wire:click="approveRequest(<?php echo e($request->id); ?>)" wire:loading.attr="disabled">
                                        <i class="ti ti-check me-1"></i>تأیید
                                    </button>
                                    <button class="btn btn-sm btn-outline-danger btn-hover-scale rounded-3 px-3 fw-bold" wire:click="rejectRequest(<?php echo e($request->id); ?>)" wire:loading.attr="disabled">
                                        <i class="ti ti-x me-1"></i>رد
                                    </button>
                                </div>
                            </td>
                        <?php else: ?>
                            <td class="text-center">
                                <?php
                                    $userAppr = $request->approvals->firstWhere('user_id', auth()->id());
                                    $status_color = $userAppr?->is_approved ? 'success' : 'danger';
                                ?>
                                <div class="badge bg-<?php echo e($status_color); ?> bg-opacity-10 text-<?php echo e($status_color); ?> rounded-pill px-4 py-2 fw-black border border-<?php echo e($status_color); ?> border-opacity-10">
                                    <?php echo e($userAppr?->is_approved ? 'تأیید نهایی شد' : 'رد صلاحیت شد'); ?>

                                </div>
                            </td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="10" class="text-center py-5">
                            <img src="https://cdn-icons-png.flaticon.com/512/7486/7486744.png" width="80" class="opacity-25 grayscale mb-3">
                            <h6 class="fw-black text-muted">صندوق شما در حال حاضر خالی است</h6>
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="mt-4">
        <?php echo e(($activeTab == 'pending' ? $this->pendingRequests : $this->historyRequests)->links()); ?>

    </div>

    
    <?php if($selectedRequest): ?>
        <div class="modal fade show d-block" tabindex="-1" style="background: rgba(15,23,42,0.7); backdrop-filter: blur(12px);">
            <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content rounded-5 border-0 shadow-2xl overflow-hidden bg-white">

                    <div class="modal-header bg-dark text-white py-4 px-5 border-0">
                        <div class="d-flex align-items-center">
                            <div class="p-3 bg-primary rounded-4 me-4 shadow-lg animate__animated animate__rotateIn"><i class="ti ti-file-analytics fs-1 text-white"></i></div>
                            <div>
                                <h4 class="modal-title fw-black mb-1">پرونده الکترونیک PR-<?php echo e($selectedRequest->id); ?></h4>
                                <div class="d-flex gap-3 fs-xs fw-bold opacity-50">
                                    <span><i class="ti ti-category me-1"></i><?php echo e($selectedRequest->purchase_type); ?></span>
                                    <span><i class="ti ti-building-bank me-1"></i><?php echo e($selectedRequest->costCenter?->name); ?></span>
                                </div>
                            </div>
                        </div>
                        <button type="button" class="btn-close btn-close-white shadow-none" wire:click="closeDetailModal"></button>
                    </div>

                    <div class="modal-body p-0 bg-light-subtle">
                        <div class="row g-0">
                            <div class="col-lg-8 border-end border-light">
                                <div class="p-5">
                                    <div class="bg-white rounded-5 shadow-sm p-4 border border-light mb-4">
                                        <h5 class="fw-black text-dark mb-4 d-flex align-items-center">
                                            <span class="p-2 bg-primary-subtle rounded-3 me-2"><i class="ti ti-list-details text-primary"></i></span>
                                            لیست اقلام و خدمات برآورد شده
                                        </h5>
                                        <div class="table-responsive">
                                            <table class="table table-hover align-middle">
                                                <thead class="bg-light rounded-4">
                                                <tr class="fw-black small text-muted">
                                                    <th class="ps-3">شرح قلم تدارکاتی</th>
                                                    <th class="text-center">تعداد</th>
                                                    <th class="text-center">فی (ریال)</th>
                                                    <th class="text-end pe-3">جمع ردیف</th>
                                                </tr>
                                                </thead>
                                                <tbody class="fw-bold">
                                                <?php $__currentLoopData = $selectedRequest->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td class="ps-3"><?php echo e($item->displayName); ?></td>
                                                        <td class="text-center"><span class="badge bg-light text-dark px-3"><?php echo e($item->quantity); ?></span></td>
                                                        <td class="text-center text-muted small"><?php echo e(number_format($item->price)); ?></td>
                                                        <td class="text-end pe-3 text-primary"><?php echo e(number_format($item->quantity * $item->price)); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="bg-white rounded-5 shadow-sm p-4 border border-light">
                                        <h6 class="fw-black text-primary mb-2 small text-uppercase">شرح ضرورت و توضیحات فنی:</h6>
                                        <p class="text-dark fw-medium leading-relaxed mb-0" style="text-align: justify;"><?php echo e($selectedRequest->description); ?></p>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="p-5">
                                    <div class="bg-white rounded-5 shadow-sm p-4 border border-light mb-4">
                                        <h6 class="fw-black text-dark mb-4">خلاصه وضعیت مالی</h6>
                                        <div class="d-flex justify-content-between mb-2">
                                            <span class="text-muted fw-bold small">مبلغ کل برآورد:</span>
                                            <span class="fw-black text-dark"><?php echo e(number_format($selectedRequest->total_amount)); ?></span>
                                        </div>
                                        <div class="progress-lux mt-3"><div class="progress-bar-animated-lux h-100" style="width: 100%"></div></div>
                                    </div>

                                    <h6 class="fw-black text-dark mb-4 ms-2">زنجیره امضا و گردش کار</h6>
                                    <div class="workflow-track">
                                        <?php $__currentLoopData = $selectedRequest->approvals->sortBy('priority'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $status_cfg = match($appr->is_approved) {
                                                    true => ['color' => '#10b981', 'label' => 'تایید کرد', 'icon' => 'ti-check'],
                                                    false => ['color' => '#ef4444', 'label' => 'رد کرد', 'icon' => 'ti-x'],
                                                    default => ['color' => '#cbd5e1', 'label' => 'در صف انتظار', 'icon' => 'ti-clock'],
                                                };
                                            ?>
                                            <div class="mb-5 position-relative">
                                                <div class="workflow-node" style="background: <?php echo e($status_cfg['color']); ?>;"></div>
                                                <div class="ps-2">
                                                    <div class="d-flex justify-content-between align-items-start">
                                                        <span class="fw-black small text-dark d-block"><?php echo e($appr->role?->name); ?></span>
                                                        <span class="badge bg-light text-muted fs-xs"><?php echo e($status_cfg['label']); ?></span>
                                                    </div>
                                                    <small class="text-muted fw-bold"><?php echo e($appr->user?->name ?: '---'); ?></small>
                                                    <?php if($appr->comment): ?>
                                                        <div class="p-2 mt-2 bg-light rounded-3 small border-0 fw-medium italic text-secondary">
                                                            <i class="ti ti-quote me-1"></i><?php echo e($appr->comment); ?>

                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="modal-footer bg-white py-4 px-5 border-0 shadow-lg">
                        <button type="button" class="btn btn-light rounded-pill px-4 fw-black border" wire:click="closeDetailModal">بستن پرونده</button>
                        <div class="ms-auto d-flex gap-2">
                            <button class="btn btn-outline-danger rounded-pill px-5 fw-black btn-hover-scale" wire:click="rejectRequest(<?php echo e($selectedRequest->id); ?>)">رد درخواست</button>
                            <button class="btn btn-success rounded-pill px-5 fw-black shadow-primary btn-hover-scale" wire:click="approveRequest(<?php echo e($selectedRequest->id); ?>)">تأیید و امضا</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    <?php endif; ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\purchase\approval-inbox.blade.php ENDPATH**/ ?>