<div class="container-fluid">
    <div class="card bg-light-info shadow-none position-relative overflow-hidden">
        <div class="card-body px-4 py-3">
            <h4 class="fw-semibold mb-8">جزئیات پروژه</h4>

            <!-- نمایش اطلاعات پروژه -->
            <?php if($project): ?>
                <div class="mb-3">
                    <strong>نام پروژه:</strong> <?php echo e($project->name); ?>

                </div>

                <div class="mb-3">
                    <strong>کد پروژه:</strong> <?php echo e($project->details->project_code ?? 'اطلاعات موجود نیست'); ?>

                </div>

                <div class="mb-3">
                    <strong>کد مالیاتی:</strong> <?php echo e($project->details->tax_code ?? 'اطلاعات موجود نیست'); ?>

                </div>

                <div class="mb-3">
                    <strong>کارفرمای اصلی:</strong> <?php echo e($project->details->mainClient->name ?? 'اطلاعات موجود نیست'); ?>

                </div>

                <div class="mb-3">
                    <strong>کارفرمای فرعی:</strong> <?php echo e($project->details->subClient->name ?? 'اطلاعات موجود نیست'); ?>

                </div>

                <div class="mb-3">
                    <strong>پیمانکار:</strong> <?php echo e($project->details->contractor->name ?? 'اطلاعات موجود نیست'); ?>

                </div>

                <div class="mb-3">
                    <strong>مدیر پروژه:</strong> <?php echo e($project->details->manager->name ?? 'اطلاعات موجود نیست'); ?>

                </div>

                <div class="mb-3">
                    <strong>وضعیت پروژه:</strong> <?php echo e($project->details->status ?? 'اطلاعات موجود نیست'); ?>

                </div>

                <div class="mb-3">
                    <strong>انواع پروژه:</strong>
                    <ul>
                        <?php $__currentLoopData = $project->projectTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($type->name); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>

                <!-- بخش زمان‌بندی پروژه -->
                <div class="mt-5">
                    <h5 class="fw-semibold mb-4">زمان‌بندی پروژه</h5>
                    <?php if($project->schedule): ?>
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th>تاریخ واگذاری (LOA)</th>
                                <th>تاریخ قرارداد</th>
                                <th>تاریخ پایان واقعی</th>
                                <th>مدت زمان اجرا (روز)</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td><?php echo e($project->schedule->LOA_date ?? 'اطلاعات موجود نیست'); ?></td>
                                <td><?php echo e($project->schedule->contract_date ?? 'اطلاعات موجود نیست'); ?></td>
                                <td><?php echo e($project->schedule->actual_completion_date ?? 'اطلاعات موجود نیست'); ?></td>
                                <td><?php echo e($project->schedule->execution_duration ?? 'اطلاعات موجود نیست'); ?> روز</td>
                            </tr>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <p>هیچ زمان‌بندی برای این پروژه ثبت نشده است.</p>
                    <?php endif; ?>
                </div>

                <!-- بخش بیمه‌های پروژه -->
                <div class="mt-5">
                    <h5 class="fw-semibold mb-4">بیمه‌های پروژه</h5>
                    <?php if($project->insurances->isNotEmpty()): ?>
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th>شرکت بیمه</th>
                                <th>تاریخ شروع</th>
                                <th>تاریخ پایان</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $project->insurances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insurance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($insurance->company->name ?? 'اطلاعات موجود نیست'); ?></td>
                                    <td><?php echo e($insurance->start_date ?? 'اطلاعات موجود نیست'); ?></td>
                                    <td><?php echo e($insurance->end_date ?? 'اطلاعات موجود نیست'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <p>هیچ بیمه‌ای برای این پروژه ثبت نشده است.</p>
                    <?php endif; ?>
                </div>

            <?php else: ?>
                <p>پروژه یافت نشد.</p>
            <?php endif; ?>

            <a href="<?php echo e(route('admin.list.projects')); ?>" class="btn btn-secondary mt-3">بازگشت به لیست پروژه‌ها</a>
        </div>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\projects\project-view-component.blade.php ENDPATH**/ ?>