<div class="container-fluid py-4">

    
    <?php if(session()->has('success') || session()->has('error')): ?>
        <div class="alert alert-<?php echo e(session()->has('success') ? 'success' : 'danger'); ?> alert-dismissible fade show rounded-4 shadow-sm mb-4 border-0" role="alert">
            <i class="ti ti-<?php echo e(session()->has('success') ? 'check' : 'alert-triangle'); ?> me-2 fs-5"></i>
            <span class="fw-bold"><?php echo e(session('success') ?? session('error')); ?></span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    
    <?php if($project->mainContract): ?>
        <div class="card border-0 rounded-4 shadow-sm mb-4 bg-gradient-light-info">
            <div class="card-body p-4">
                <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
                    <div class="d-flex align-items-center">
                        <div class="bg-white p-3 rounded-circle shadow-sm me-3">
                            <i class="ti ti-report-money fs-3 text-info"></i>
                        </div>
                        <div>
                            <h6 class="mb-1 text-muted fw-normal">جمع کل مبلغ قرارداد</h6>
                            <div class="d-flex align-items-baseline flex-wrap gap-2">
                                <span class="h4 fw-bold text-success">
                                    <?php echo e(number_format($project->mainContract->total_amount)); ?>

                                </span>
                                <span class="badge bg-light text-info fw-medium">
                                    <?php echo e($project->mainContract->currency_unit); ?>

                                </span>
                                <?php if($project->mainContract->currency_unit !== 'IRR' && $project->mainContract->exchange_rate): ?>
                                    <span class="text-muted">
                                        (معادل: <?php echo e(number_format($project->mainContract->total_amount * $project->mainContract->exchange_rate)); ?> ریال)
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex align-items-center gap-3">
                        <?php if($project->mainContract->addenda->count() > 0): ?>
                            <span class="badge bg-light-info text-info px-3 py-2 rounded-pill fw-medium">
                                <i class="ti ti-file-plus me-1"></i>
                                <?php echo e($project->mainContract->addenda->count()); ?> الحاقیه
                            </span>
                        <?php endif; ?>
                        <span class="badge
                            <?php if($project->mainContract->end_date && strtotime($project->mainContract->end_date) < time()): ?>
                                bg-light-danger text-danger
                            <?php else: ?>
                                bg-light-success text-success
                            <?php endif; ?>
                            px-3 py-2 rounded-pill fw-medium">
                            <?php if($project->mainContract->end_date && strtotime($project->mainContract->end_date) < time()): ?>
                                منقضی‌شده
                            <?php else: ?>
                                فعال
                            <?php endif; ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="row g-4">
        
        <div class="col-lg-8">
            <div class="card shadow-lg border-0 rounded-4 overflow-hidden">
                <div class="card-header bg-gradient-deep-blue text-white py-4 position-relative">
                    <div class="position-absolute top-0 start-0 w-100 h-100 opacity-10">
                        <i class="ti ti-file-contract fs-1"></i>
                    </div>
                    <h4 class="mb-0 fw-bold position-relative">
                        <i class="ti ti-file-contract me-2"></i>
                        قرارداد اصلی پروژه
                        <span class="text-action-primary ms-2">«<?php echo e($project->name); ?>»</span>
                    </h4>
                </div>
                <div class="card-body p-5">
                    <form wire:submit.prevent="saveContract">
                        <div class="row g-4">
                            <div class="col-12">
                                <label class="form-label fw-medium text-primary-dark d-flex justify-content-between align-items-center">
                                    <span>عنوان قرارداد <span class="text-danger">*</span></span>
                                    <i class="ti ti-info-circle text-muted fs-6" data-bs-toggle="tooltip" title="عنوان رسمی قرارداد مانند: «قرارداد اجرای سازه‌های فولادی»"></i>
                                </label>
                                <input type="text" wire:model="title" class="form-control form-control-lg <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="مثال: قرارداد اجرای سازه‌های فولادی">
                                <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 col-md-6">
                                <label class="form-label fw-medium text-primary-dark">شماره قرارداد</label>
                                <input type="text" wire:model="number" class="form-control form-control-lg" placeholder="مثال: 1403/001">
                            </div>

                            <div class="col-12 col-md-6">
                                <label class="form-label fw-medium text-primary-dark">واحد پولی</label>
                                <select wire:model.live="currency_unit" class="form-select form-select-lg">
                                    <option value="IRR">ریال ایران (IRR) — ﷼</option>
                                    <option value="USD">دلار آمریکا (USD) — $</option>
                                    <option value="EUR">یورو (EUR) — €</option>
                                    <option value="GBP">پوند استرلینگ (GBP) — £</option>
                                    <option value="AED">درهم امارات (AED) — د.إ</option>
                                    <option value="CAD">دلار کانادا (CAD) — C$</option>
                                    <option value="JPY">ین ژاپن (JPY) — ¥</option>
                                    <option value="TRY">لیر ترکیه (TRY) — ₺</option>
                                    <option value="CNY">یوان چین (CNY) — ¥</option>
                                </select>
                            </div>

                            <div class="col-12 col-md-6">
                                <label class="form-label fw-medium text-primary-dark d-flex justify-content-between align-items-center">
                                    <span>مبلغ پایه <span class="text-danger">*</span></span>
                                    <i class="ti ti-info-circle text-muted fs-6" data-bs-toggle="tooltip" title="مبلغ اصلی قرارداد بدون الحاقیه"></i>
                                </label>
                                <div class="input-group input-group-lg">
                                    <input
                                        type="text"
                                        wire:model.live="display_base_amount"
                                        class="form-control form-control-lg text-end <?php $__errorArgs = ['base_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="مثال: 5,000,000,000"
                                        inputmode="decimal"
                                    >
                                    <span class="input-group-text fw-bold">
                                        <?php echo e($this->currencyIcon); ?>

                                    </span>
                                </div>
                                <?php $__errorArgs = ['base_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 col-md-6">
                                <label class="form-label fw-medium text-primary-dark d-flex justify-content-between align-items-center">
                                    <span>نرخ تبدیل (به ریال)</span>
                                    <i class="ti ti-info-circle text-muted fs-6" data-bs-toggle="tooltip" title="نرخ تبدیل واحد پولی به ریال ایران"></i>
                                </label>
                                <input
                                    type="number"
                                    wire:model="exchange_rate"
                                    class="form-control form-control-lg"
                                    placeholder="<?php echo e($currency_unit !== 'IRR' ? 'مثال: 580000' : '—'); ?>"
                                    <?php echo e($currency_unit === 'IRR' ? 'disabled' : ''); ?>

                                    step="0.01"
                                    min="0"
                                >
                                <div class="form-text text-muted">
                                    فقط برای واحدهای غیر از ریال وارد شود
                                </div>
                            </div>

                            <div class="col-12 col-md-6">
                                <label class="form-label fw-medium text-primary-dark">تاریخ شروع</label>
                                <input type="date" wire:model="start_date" class="form-control form-control-lg">
                            </div>

                            <div class="col-12 col-md-6">
                                <label class="form-label fw-medium text-primary-dark">تاریخ پایان</label>
                                <input type="date" wire:model="end_date" class="form-control form-control-lg">
                            </div>

                            <div class="col-12">
                                <label class="form-label fw-medium text-primary-dark">تاریخ امضا</label>
                                <input type="date" wire:model="signed_at" class="form-control form-control-lg">
                            </div>

                            <div class="col-12">
                                <label class="form-label fw-medium text-primary-dark">توضیحات</label>
                                <textarea wire:model="description" class="form-control" rows="3" placeholder="توضیحات تکمیلی درباره قرارداد..."></textarea>
                            </div>
                        </div>

                        <div class="mt-5 d-flex justify-content-end gap-3">
                            <a href="<?php echo e(route('single.project.dashboard', $project->id)); ?>" class="btn btn-outline-secondary px-4 py-2">
                                <i class="ti ti-arrow-left me-2"></i> بازگشت
                            </a>
                            <button type="submit" class="btn btn-action-primary fw-bold px-5 py-2 d-flex align-items-center" wire:loading.attr="disabled">
                                <span wire:loading.remove wire:target="saveContract">
                                    <i class="ti ti-device-floppy me-2"></i> ذخیره قرارداد
                                </span>
                                <span wire:loading wire:target="saveContract" class="d-flex align-items-center">
                                    <span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>
                                    در حال ذخیره...
                                </span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        
        <div class="col-lg-4">
            
            <div class="card shadow-lg border-0 rounded-4 mb-4">
                <div class="card-header bg-gradient-deep-blue text-white py-3 rounded-top-4 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold">
                        <i class="ti ti-file-plus me-2"></i> الحاقیه‌ها
                    </h5>
                    <button class="btn btn-sm btn-action-primary" wire:click="openAddendumModal" <?php if(!$project->mainContract): echo 'disabled'; endif; ?>>
                        <i class="ti ti-plus me-1"></i> جدید
                    </button>
                </div>
                <div class="card-body p-3">
                    <?php if(!$project->mainContract): ?>
                        <div class="text-center text-muted py-4">
                            <div class="bg-light rounded-circle d-inline-flex p-3 mb-3">
                                <i class="ti ti-file-off fs-2 text-muted"></i>
                            </div>
                            <p class="mb-0">ابتدا قرارداد اصلی را ذخیره کنید.</p>
                        </div>
                    <?php elseif($project->mainContract->addenda->isEmpty()): ?>
                        <div class="text-center text-muted py-4">
                            <div class="bg-light rounded-circle d-inline-flex p-3 mb-3">
                                <i class="ti ti-file-off fs-2 text-muted"></i>
                            </div>
                            <p class="mb-0">الحاقیه‌ای ثبت نشده است.</p>
                        </div>
                    <?php else: ?>
                        <div class="space-y-3">
                            <?php $__currentLoopData = $project->mainContract->addenda; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addendum): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="border rounded-3 p-3 hover-shadow transition-all">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <div class="me-2">
                                            <h6 class="fw-bold mb-1"><?php echo e($addendum->title); ?></h6>
                                            <div class="d-flex align-items-center gap-2">
                                                <span class="badge bg-light text-muted fw-medium">
                                                    <?php echo e($addendum->currency_unit); ?>

                                                </span>
                                                <?php if($addendum->currency_unit !== 'IRR' && $addendum->exchange_rate): ?>
                                                    <span class="text-sm text-muted">
                                                        (<?php echo e(number_format($addendum->exchange_rate)); ?>)
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="d-flex gap-2">
                                            <button class="btn btn-sm btn-outline-primary" wire:click="openAddendumModal(<?php echo e($addendum->id); ?>)">
                                                <i class="ti ti-edit"></i>
                                            </button>
                                            <button class="btn btn-sm btn-outline-danger" wire:click="deleteAddendum(<?php echo e($addendum->id); ?>)" wire:confirm="آیا مطمئن هستید؟">
                                                <i class="ti ti-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-between text-sm mt-2">
                                        <span class="text-muted">
                                            <?php echo e($addendum->effective_date?->format('Y/m/d') ?? '—'); ?>

                                        </span>
                                        <span class="fw-bold text-success">
                                            <?php echo e(number_format($addendum->amount)); ?>

                                        </span>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            
            <div class="card shadow-lg border-0 rounded-4">
                <div class="card-header bg-gradient-action-blue text-white py-3 rounded-top-4">
                    <h5 class="mb-0 fw-bold">
                        <i class="ti ti-file-upload me-2"></i> اسناد قرارداد
                    </h5>
                </div>
                <div class="card-body">
                    <form wire:submit.prevent="uploadDocument" class="mb-4">
                        <div class="mb-3">
                            <label class="form-label fw-medium">عنوان سند <span class="text-danger">*</span></label>
                            <input type="text" wire:model="document_title" class="form-control <?php $__errorArgs = ['document_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="مثال: قرارداد اصلی - امضا شده">
                            <?php $__errorArgs = ['document_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-medium">فایل (PDF, DOC) <span class="text-danger">*</span></label>
                            <input type="file" wire:model="document_file" class="form-control <?php $__errorArgs = ['document_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" accept=".pdf,.doc,.docx">
                            <?php $__errorArgs = ['document_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="form-text text-muted">حداکثر حجم: 10 مگابایت</div>
                        </div>
                        <button type="submit" class="btn btn-outline-primary w-100" wire:loading.attr="disabled">
                            <span wire:loading.remove wire:target="uploadDocument">آپلود سند</span>
                            <span wire:loading wire:target="uploadDocument">در حال آپلود...</span>
                        </button>
                    </form>

                    
                    <?php if($documents->count() > 0): ?>
                        <div class="mt-4">
                            <h6 class="fw-bold text-muted mb-3">اسناد آپلود شده:</h6>
                            <div class="space-y-2">
                                <?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="d-flex justify-content-between align-items-center p-2 bg-light rounded-3">
                                        <div class="d-flex align-items-center">
                                            <i class="ti ti-file-text text-primary me-2 fs-5"></i>
                                            <span class="text-truncate" style="max-width: 180px;"><?php echo e($doc->title); ?></span>
                                        </div>
                                        <div class="d-flex gap-2">
                                            <button class="btn btn-sm btn-outline-success" wire:click="downloadDocument(<?php echo e($doc->id); ?>)">
                                                <i class="ti ti-download"></i>
                                            </button>
                                            <button class="btn btn-sm btn-outline-danger" wire:click="deleteDocument(<?php echo e($doc->id); ?>)" wire:confirm="آیا مطمئن هستید؟">
                                                <i class="ti ti-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="addendumModal" tabindex="-1" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content rounded-4 shadow-lg border-0">
                <div class="modal-header bg-gradient-deep-blue text-white rounded-top-4">
                    <h5 class="modal-title fw-bold">
                        <?php echo e($addendum_id ? 'ویرایش الحاقیه' : 'الحاقیه جدید'); ?>

                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label fw-medium">عنوان <span class="text-danger">*</span></label>
                        <input type="text" wire:model="addendum_title" class="form-control <?php $__errorArgs = ['addendum_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="مثال: الحاقیه افزایش حجم عملیات">
                        <?php $__errorArgs = ['addendum_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-medium">مبلغ <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input
                                type="text"
                                wire:model.live="display_addendum_amount"
                                class="form-control <?php $__errorArgs = ['addendum_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="مثال: 500,000,000"
                                inputmode="decimal"
                            >
                            <span class="input-group-text">
                                <?php echo e($addendum_currency_unit ? $this->getCurrencyIcon($addendum_currency_unit) : '﷼'); ?>

                            </span>
                        </div>
                        <?php $__errorArgs = ['addendum_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-medium">واحد پولی</label>
                        <select wire:model.live="addendum_currency_unit" class="form-select">
                            <option value="IRR">ریال ایران (IRR) — ﷼</option>
                            <option value="USD">دلار آمریکا (USD) — $</option>
                            <option value="EUR">یورو (EUR) — €</option>
                            <option value="GBP">پوند استرلینگ (GBP) — £</option>
                            <option value="AED">درهم امارات (AED) — د.إ</option>
                            <option value="CAD">دلار کانادا (CAD) — C$</option>
                            <option value="JPY">ین ژاپن (JPY) — ¥</option>
                            <option value="TRY">لیر ترکیه (TRY) — ₺</option>
                            <option value="CNY">یوان چین (CNY) — ¥</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-medium">نرخ تبدیل (به ریال)</label>
                        <input
                            type="number"
                            wire:model="addendum_exchange_rate"
                            class="form-control"
                            placeholder="<?php echo e($addendum_currency_unit !== 'IRR' ? 'مثال: 580000' : '—'); ?>"
                            <?php echo e($addendum_currency_unit === 'IRR' ? 'disabled' : ''); ?>

                            step="0.01"
                            min="0"
                        >
                        <div class="form-text text-muted">
                            فقط برای واحدهای غیر از ریال وارد شود
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-medium">تاریخ اجرایی</label>
                        <input type="date" wire:model="addendum_effective_date" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-medium">توضیحات</label>
                        <textarea wire:model="addendum_description" class="form-control" rows="2" placeholder="توضیحات تکمیلی..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">انصراف</button>
                    <button type="button" class="btn btn-action-primary" wire:click="saveAddendum" wire:loading.attr="disabled">
                        <span wire:loading.remove>
                            <?php echo e($addendum_id ? 'به‌روزرسانی' : 'ذخیره الحاقیه'); ?>

                        </span>
                        <span wire:loading>در حال پردازش...</span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    
    <script>
        document.addEventListener('livewire:initialized', () => {
            // فعال‌سازی Tooltip
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });

            // باز کردن مودال الحاقیه
            Livewire.on('open-addendum-modal', () => {
                const modal = new bootstrap.Modal(document.getElementById('addendumModal'));
                modal.show();
            });
        });
    </script>

    
    <style>
        .hover-shadow {
            transition: all 0.3s ease;
        }
        .hover-shadow:hover {
            box-shadow: 0 4px 12px rgba(0,0,0,0.12) !important;
            transform: translateY(-2px);
        }
        .bg-gradient-light-info {
            background: linear-gradient(135deg, #f0f9ff 0%, #e6f7ff 100%) !important;
        }
        .transition-all {
            transition: all 0.3s ease;
        }
        .text-sm {
            font-size: 0.875rem;
        }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\projects\financial\project-contract-manager.blade.php ENDPATH**/ ?>