<div class="container py-4 modern-task-create-form">
    <?php if(session()->has('message')): ?>
        <div class="alert alert-success alert-dismissible fade show rounded-3 mb-4 shadow-sm border-0 bg-success-soft text-success">
            <i class="ti ti-check me-2 fs-5"></i><?php echo e(session('message')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if(session()->has('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show rounded-3 mb-4 shadow-sm border-0">
            <i class="ti ti-alert-triangle me-2 fs-5"></i><?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow-xl border-0 rounded-4 fadein-box">
        <div class="card-body px-5 py-5">
            <h4 class="fw-bold text-dark-primary mb-4 border-bottom pb-3 d-flex align-items-center">
                <i class="ti ti-tool me-2 text-action-primary fs-4"></i>
                ساخت تسک جدید
                <span class="badge bg-info-soft text-info rounded-pill ms-3 shadow-sm">پروژه: <?php echo e($project->name); ?></span>
            </h4>

            <form wire:submit.prevent="saveTask" autocomplete="off" class="needs-validation">

                <div class="row g-5">
                    <!-- بخش چپ: جزئیات -->
                    <div class="col-lg-6 border-end-lg pe-lg-5 card-section-hover">
                        <h6 class="fw-bold mb-4 text-action-primary">
                            <i class="ti ti-info-circle me-2"></i> جزئیات و مسئولیت
                        </h6>

                        <div class="mb-4">
                            <label class="form-label text-dark-primary">عنوان تسک <span class="text-danger">*</span></label>
                            <input wire:model="title" type="text"
                                   class="form-control rounded-pill <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   placeholder="خلاصه کار مورد نیاز" required>
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-4">
                            <label class="form-label text-dark-primary">مسئول انجام</label>
                            <select wire:model="assigned_to" class="form-select rounded-pill <?php $__errorArgs = ['assigned_to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="">انتخاب مسئول...</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['assigned_to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-4">
                            <label class="form-label text-dark-primary">بخش پروژه</label>
                            <select wire:model="section_id" class="form-select rounded-pill <?php $__errorArgs = ['section_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="">بدون بخش</option>
                                <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($section->id); ?>"><?php echo e($section->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['section_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-4">
                            <label class="form-label text-dark-primary">توضیحات</label>
                            <textarea wire:model="description" class="form-control rounded-3 <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="4"
                                      placeholder="جزئیات کامل تسک، نیازمندی‌ها..."></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <!-- بخش راست: زمان‌بندی و ساختار -->
                    <div class="col-lg-6 ps-lg-5 card-section-hover">
                        <h6 class="fw-bold mb-4 text-success">
                            <i class="ti ti-clock me-2"></i> زمان‌بندی و وضعیت
                        </h6>

                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <label class="form-label text-dark-primary">وضعیت</label>
                                <select wire:model="status" class="form-select rounded-pill">
                                    <option value="new">جدید</option>
                                    <option value="in_progress">درحال انجام</option>
                                    <option value="done">انجام شده</option>
                                    <option value="on_hold">متوقف</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label text-dark-primary">اولویت</label>
                                <select wire:model="priority" class="form-select rounded-pill">
                                    <option value="low">پایین</option>
                                    <option value="normal">متوسط</option>
                                    <option value="high">زیاد</option>
                                    <option value="critical">بحرانی</option>
                                </select>
                            </div>
                        </div>

                        <!-- تاریخ‌ها — بدون wire:ignore کامل، ولی با wire:key و مدیریت دستی -->
                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <label class="form-label text-dark-primary">تاریخ شروع</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="ti ti-calendar-event"></i></span>
                                    <input type="text"
                                           x-data x-init="$nextTick(() => initDatePicker('start'))"
                                           x-ref="start_date"
                                           wire:model="start_date"
                                           wire:key="start_date_<?php echo e(uniqid()); ?>"
                                           class="form-control <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           placeholder="مثال: 1402/01/01" autocomplete="off">
                                </div>
                                <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback d-block"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label text-dark-primary">مهلت نهایی</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="ti ti-calendar-x"></i></span>
                                    <input type="text"
                                           x-data x-init="$nextTick(() => initDatePicker('due'))"
                                           x-ref="due_date"
                                           wire:model="due_date"
                                           wire:key="due_date_<?php echo e(uniqid()); ?>"
                                           class="form-control <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           placeholder="مثال: 1402/01/15" autocomplete="off">
                                </div>
                                <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback d-block"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <h6 class="fw-bold text-info mt-5 mb-3">
                            <i class="ti ti-link me-2"></i> ساختار و وابستگی‌ها
                        </h6>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">وابسته به تسک</label>
                                <select wire:model="dependency_id" class="form-select rounded-pill">
                                    <option value="">بدون وابستگی</option>
                                    <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($task->id); ?>">#<?php echo e($task->id); ?> - <?php echo e(Str::limit($task->title, 30)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">تسک والد</label>
                                <select wire:model="parent_id" class="form-select rounded-pill">
                                    <option value="">ندارد (تسک اصلی)</option>
                                    <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($task->id); ?>">#<?php echo e($task->id); ?> - <?php echo e(Str::limit($task->title, 30)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="mt-5 pt-3 border-top">
                            <label class="form-label text-dark-primary">
                                درصد پیشرفت:
                                <span class="fw-bold text-action-primary ms-2"><?php echo e($progress_percent); ?>%</span>
                                <i class="ti ti-circle-half me-1 text-secondary-light"></i>
                            </label>
                            <input type="range"
                                   wire:model.live.debounce.200ms="progress_percent"
                                   min="0" max="100"
                                   class="form-range custom-range-slider"
                                   style="--progress-value: <?php echo e($progress_percent); ?>%">
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-end mt-5 pt-4 border-top">
                    <a href="<?php echo e(route('admin.project.task.list', $project)); ?>"
                       class="btn btn-outline-secondary fw-bold px-4 py-2 rounded-pill me-2">
                        <i class="ti ti-x me-1"></i> انصراف و بازگشت
                    </a>
                    <button type="submit"
                            class="btn btn-action-primary fw-bold px-5 py-2 rounded-pill shadow-action-btn"
                            wire:loading.attr="disabled">
                        <span wire:loading.remove>
                            <i class="ti ti-device-floppy me-1"></i> ثبت تسک
                        </span>
                        <span wire:loading>
                            <span class="spinner-border spinner-border-sm me-1" role="status"></span>
                            در حال ذخیره...
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            window.faToEn = function(str) {
                if (!str) return str;
                const fa = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
                const ar = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩'];
                const en = ['0','1','2','3','4','5','6','7','8','9'];

                return str
                    .replace(/[۰-۹]/g, d => en[fa.indexOf(d)])
                    .replace(/[٠-٩]/g, d => en[ar.indexOf(d)]);
            };

            // تابع اینیشیال دیت‌پیکر — با پشتیبانی از Livewire re-renders
            function initDatePicker(type) {
                const input = document.querySelector(`[x-ref="${type}_date"]`);
                if (!input || input.dataset.pickerInitialized) return;

                const pickerOptions = {
                    format: 'YYYY/MM/DD',
                    autoClose: true,
                    observer: true,
                    persianDigit: false, // خروجی انگلیسی (1402/01/01)
                    initialValueType: 'persian',
                };

                // برای تاریخ پایان: محدودیت minDate
                if (type === 'due') {
                    const startDateInput = document.querySelector('[x-ref="start_date"]');
                    const startVal = startDateInput?.value;
                    if (startVal) {
                        try {
                            const jalali = window.persianDate(startVal);
                            pickerOptions.minDate = jalali.valueOf();
                        } catch (e) {}
                    }
                }

                // اینیشیال
                const picker = $(input).persianDatepicker(pickerOptions);
                input.dataset.pickerInitialized = 'true';

                // هندل انتخاب
                $(input).off('select').on('select', function (unix) {
                    let val = $(this).val();
                    if (val) val = window.faToEn(val); // ✅ تبدیل فارسی به انگلیسی
                    window.Livewire.find('<?php echo e($_instance->getId()); ?>').set(`${type}_date`, val);
                });

                // هندل تغییر دستی (برای اطمینان بیشتر)
                $(input).off('input').on('input', function () {
                    let val = $(this).val();
                    if (val) val = window.faToEn(val);
                    window.Livewire.find('<?php echo e($_instance->getId()); ?>').set(`${type}_date`, val);
                });

                // بروزرسانی دیت‌پیکر والد برای minDate
                if (type === 'start') {
                    $(input).on('select', function () {
                        const unix = $(this).val() ? window.persianDate($(this).val()).valueOf() : null;
                        const duePicker = document.querySelector('[x-ref="due_date"]');
                        if (duePicker && $(duePicker).data('datepicker')) {
                            $(duePicker).persianDatepicker('setOptions', { minDate: unix });
                        }
                    });
                }
            }

            // پشتیبانی از Livewire
            document.addEventListener('livewire:init', () => {
                Livewire.hook('element.updated', (el, component) => {
                    if (el.closest('[x-ref="start_date"], [x-ref="due_date"]')) {
                        setTimeout(() => {
                            const type = el.closest('[x-ref="start_date"]') ? 'start' : 'due';
                            initDatePicker(type);
                        }, 10);
                    }
                });
            });

            // برای صفحاتی که از Alpine + Livewire استفاده می‌کنند (نسخه جدید)
            document.addEventListener('alpine:init', () => {
                Alpine.data('datePicker', () => ({
                    init(type) {
                        setTimeout(() => initDatePicker(type), 50);
                    }
                }));
            });
        </script>
    <?php $__env->stopPush(); ?>
        <style>
            :root {
                --primary-color: #4361ee;
                --primary-dark: #3A0CA3;
                --action-color: var(--primary-color);
                --success-color: #10B981;
                --warning-color: #F59E0B;
                --info-color: #03A9F4;
                --dark-color: #1F2937;
                --muted-color: #6B7280;
                --border-color: #E5E7EB;
                --card-bg: #FFFFFF;
                --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
                --shadow-action-btn: 0 4px 12px rgba(67, 97, 238, 0.3);
                --primary-light-bg: #F0F3FF;
                --success-soft: #ECFDF5;
            }

            .custom-range-slider {
                height: 1.5rem;
                background-color: #F1F5F9;
                border-radius: 8px;
                cursor: pointer;
                -webkit-appearance: none;
                background: linear-gradient(to right,
                var(--action-color) 0%,
                var(--action-color) var(--progress-value, 0%),
                #F1F5F9 var(--progress-value, 0%),
                #F1F5F9 100%
                );
            }
            .custom-range-slider::-webkit-slider-thumb {
                -webkit-appearance: none;
                width: 18px;
                height: 18px;
                border-radius: 50%;
                background: white;
                border: 3px solid var(--action-color);
                box-shadow: 0 0 5px rgba(0,0,0,0.1);
                cursor: pointer;
            }
        </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\task\create-task.blade.php ENDPATH**/ ?>