
<div wire:ignore.self class="modal fade" id="approvalModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-2xl" style="border-radius: 35px; background: rgba(255, 255, 255, 0.98); backdrop-filter: blur(15px);">
            <div class="modal-body p-5 text-center">
                <div class="mb-4 d-inline-flex p-4 rounded-circle bg-<?php echo e($action === 'approve' ? 'success' : 'danger'); ?>-subtle text-<?php echo e($action === 'approve' ? 'success' : 'danger'); ?>">
                    <i class="ti ti-<?php echo e($action === 'approve' ? 'circle-check' : 'circle-x'); ?> display-4"></i>
                </div>

                <h3 class="fw-black text-dark mb-2">
                    <?php echo e($action === 'approve' ? 'تأیید هوشمند درخواست' : 'عدم تأیید درخواست'); ?>

                </h3>
                <p class="text-muted fw-bold mb-4">
                    درخواست شماره <span class="text-indigo">#<?php echo e($selectedId); ?></span> جهت بررسی نهایی در اختیار شماست.
                </p>

                <div class="text-start bg-light p-4 rounded-4 mb-4">
                    <label class="form-label fw-black smaller-8 text-muted mb-3 d-flex align-items-center">
                        <i class="ti ti-message-dots me-2 fs-5"></i> توضیحات یا پیوست نظری (اختیاری)
                    </label>
                    <textarea wire:model="comments"
                              class="form-control border-0 bg-white rounded-3 p-3 shadow-none fw-bold"
                              rows="4"
                              placeholder="دلیل یا ملاحظات خود را بنویسید..."></textarea>
                    <?php $__errorArgs = ['comments'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2 smaller fw-black"><i class="ti ti-alert-circle me-1"></i> <?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="d-flex gap-3 mt-4">
                    <button type="button" class="btn btn-light rounded-pill px-4 py-2 fw-bold flex-grow-1" data-bs-dismiss="modal">بازگشت</button>
                    <button type="button" wire:click="submit" class="btn btn-<?php echo e($action === 'approve' ? 'success' : 'danger'); ?> rounded-pill px-4 py-2 fw-black flex-grow-1 shadow-lg">
                        <?php echo e($action === 'approve' ? 'تایید و امضای سیستمی' : 'ثبت رد درخواست'); ?>

                    </button>
                </div>
            </div>
        </div>
    </div>
</div>


<?php if($detailRequest): ?>
    <div wire:ignore.self class="modal fade" id="detailsModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content border-0 shadow-2xl" style="border-radius: 40px; background: #fcfdfe;">

                <div class="modal-header border-0 p-4 bg-white shadow-sm d-flex justify-content-between align-items-center" style="border-radius: 40px 40px 0 0; z-index: 10;">
                    <div class="d-flex align-items-center gap-3">
                        <div class="bg-indigo-gradient p-3 rounded-4 text-white shadow-primary" style="background: linear-gradient(135deg, #6366f1, #3b82f6);">
                            <i class="ti ti-file-invoice fs-4"></i>
                        </div>
                        <div>
                            <h5 class="fw-black mb-0 text-dark">آنالیز درخواست تنخواه <span class="text-primary">#<?php echo e($detailRequest->id); ?></span></h5>
                            <div class="smaller fw-bold text-muted mt-1">
                                <i class="ti ti-calendar-event me-1"></i> ثبت شده در: <?php echo e(jdate($detailRequest->created_at)->format('Y/m/d - H:i')); ?>

                            </div>
                        </div>
                    </div>
                    <button type="button" class="btn-close shadow-none p-3" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body p-4 p-md-5 custom-scroll">

                    
                    <div class="row g-4 mb-5">
                        <div class="col-md-6">
                            <div class="bg-white p-4 rounded-5 border shadow-sm h-100 d-flex align-items-center gap-3">
                                <div class="position-relative">
                                    <img src="<?php echo e($this->getUserProfilePhotoUrl($detailRequest->user)); ?>" class="rounded-circle border border-3 border-light shadow-sm" width="70" height="70" style="object-fit: cover;">
                                    <span class="position-absolute bottom-0 end-0 p-2 bg-success border border-white rounded-circle animate-pulse"></span>
                                </div>
                                <div>
                                    <span class="d-block text-muted smaller fw-black opacity-50">درخواست دهنده</span>
                                    <h6 class="fw-black text-dark fs-5 mb-0"><?php echo e($detailRequest->user->name); ?></h6>
                                    <span class="badge bg-light text-muted rounded-pill mt-1">Personnel ID: <?php echo e($detailRequest->user->id); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="bg-white p-4 rounded-5 border shadow-sm h-100 text-center position-relative overflow-hidden">
                                <div class="position-absolute top-0 end-0 p-3 opacity-10"><i class="ti ti-coin fs-1 text-success"></i></div>
                                <span class="d-block text-muted smaller fw-black mb-1 opacity-50 uppercase">Total Amount</span>
                                <div class="fw-black text-success display-6 mb-0" dir="ltr"><?php echo e(number_format($detailRequest->amount)); ?></div>
                                <small class="fw-bold text-muted">تومان (ریال ایران)</small>
                            </div>
                        </div>
                    </div>

                    
                    <div class="bg-primary-subtle border border-primary-subtle p-4 rounded-5 mb-5 shadow-sm">
                        <h6 class="fw-black text-primary mb-3 d-flex align-items-center gap-2">
                            <i class="ti ti-info-circle fs-4"></i> موضوع و دلیل هزینه‌کرد
                        </h6>
                        <p class="mb-0 fw-bold text-dark fs-6 line-height-2"><?php echo e($detailRequest->reason); ?></p>
                    </div>

                    
                    <?php if($detailRequest->details_json): ?>
                        <div class="mb-5 px-1">
                            <h6 class="fw-black text-dark mb-4 d-flex align-items-center gap-2">
                                <i class="ti ti-list-details fs-4 text-muted"></i> تفکیک اقلام فاکتور
                            </h6>
                            <div class="table-responsive border-0">
                                <table class="table align-middle">
                                    <thead>
                                    <tr class="text-muted smaller fw-black">
                                        <th class="border-0 pb-3">شرح کالا / سرویس</th>
                                        <th class="text-center border-0 pb-3">تعداد</th>
                                        <th class="border-0 pb-3">بهای واحد</th>
                                        <th class="border-0 pb-3">جمع ردیف</th>
                                    </tr>
                                    </thead>
                                    <tbody class="fw-bold">
                                    <?php $__currentLoopData = $detailRequest->details_json; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="border-bottom border-light">
                                            <td class="py-3 text-dark"><?php echo e($item['item']); ?></td>
                                            <td class="text-center"><span class="badge bg-light text-dark rounded-pill"><?php echo e($item['qty']); ?></span></td>
                                            <td><?php echo e(number_format($item['price'])); ?></td>
                                            <td class="text-primary"><?php echo e(number_format($item['qty'] * $item['price'])); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    <?php endif; ?>

                    
                    <div class="mb-2">
                        <h6 class="fw-black text-dark mb-4 d-flex align-items-center gap-2">
                            <i class="ti ti-history fs-4 text-muted"></i> گردش کار و تاییدات سیستم
                        </h6>
                        <div class="bg-white rounded-5 border p-5 shadow-sm position-relative overflow-hidden">
                            <div class="timeline-v11">
                                
                                <div class="timeline-item-v11 active">
                                    <div class="timeline-icon-v11 bg-primary text-white shadow-primary"><i class="ti ti-plus"></i></div>
                                    <div class="timeline-content-v11">
                                        <h6 class="fw-black mb-1 small">ثبت اولیه توسط متقاضی</h6>
                                        <small class="text-muted fw-bold opacity-75"><?php echo e(jdate($detailRequest->created_at)->format('H:i - Y/m/d')); ?></small>
                                    </div>
                                </div>

                                <?php $__currentLoopData = $detailRequest->approvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ap): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="timeline-item-v11 active">
                                        <div class="timeline-icon-v11 bg-<?php echo e($ap->statusColor()); ?> text-white shadow-sm">
                                            <i class="ti ti-<?php echo e($ap->status === 'approved' ? 'check' : 'x'); ?>"></i>
                                        </div>
                                        <div class="timeline-content-v11 bg-light p-3 rounded-4 mt-1">
                                            <div class="d-flex align-items-center gap-2 mb-2">
                                                <img src="<?php echo e($this->getUserProfilePhotoUrl($ap->approver)); ?>" class="rounded-circle border" width="28" height="28">
                                                <h6 class="fw-black mb-0 small text-dark"><?php echo e($ap->approver->name); ?></h6>
                                                <span class="badge bg-white text-<?php echo e($ap->statusColor()); ?> border border-<?php echo e($ap->statusColor()); ?>-subtle rounded-pill smaller-8 fw-bold"><?php echo e($ap->statusLabel()); ?></span>
                                            </div>
                                            <?php if($ap->comments): ?>
                                                <div class="bg-white p-2 rounded-3 smaller fw-medium text-muted fst-italic border-start border-3 border-<?php echo e($ap->statusColor()); ?>">
                                                    «<?php echo e($ap->comments); ?>»
                                                </div>
                                            <?php endif; ?>
                                            <div class="smaller text-muted mt-2 opacity-75"><?php echo e(jdate($ap->approved_at)->format('H:i - Y/m/d')); ?></div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                
                                <?php if($detailRequest->status == 'paid'): ?>
                                    <div class="timeline-item-v11 active">
                                        <div class="timeline-icon-v11 bg-success text-white shadow-success animate-pulse"><i class="ti ti-currency-dollar"></i></div>
                                        <div class="timeline-content-v11">
                                            <h6 class="fw-black text-success mb-1">تسویه نهایی تراکنش</h6>
                                            <small class="text-muted fw-bold">تأیید مالی و پرداخت وجه انجام شد.</small>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer border-0 p-4 bg-light shadow-inset d-flex justify-content-between" style="border-radius: 0 0 40px 40px; z-index: 10;">
                    <button type="button" class="btn btn-white rounded-pill px-5 fw-bold shadow-sm border" data-bs-dismiss="modal">بستن آنالیز</button>

                    <?php if($detailRequest->status === 'pending' && $detailRequest->isApprover(auth()->id())): ?>
                        <?php
                            $alreadyDone = $detailRequest->approvals->where('user_id', auth()->id())->isNotEmpty();
                        ?>
                        <?php if(!$alreadyDone): ?>
                            <div class="d-flex gap-3">
                                <button wire:click="confirmAction(<?php echo e($detailRequest->id); ?>, 'reject')" class="btn btn-outline-danger rounded-pill px-4 fw-black shadow-sm" data-bs-dismiss="modal">
                                    <i class="ti ti-x me-1"></i> رد کردن
                                </button>
                                <button wire:click="confirmAction(<?php echo e($detailRequest->id); ?>, 'approve')" class="btn btn-success rounded-pill px-5 fw-black shadow-lg" data-bs-dismiss="modal">
                                    <i class="ti ti-check me-1"></i> تأیید نهایی
                                </button>
                            </div>
                        <?php else: ?>
                            <span class="badge bg-success-subtle text-success rounded-pill px-4 py-2 fw-black"><i class="ti ti-discount-check me-1"></i> نظر شما قبلاً ثبت شده است</span>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<style>
    /* 🌊 Custom Scroll Logic */
    .custom-scroll::-webkit-scrollbar { width: 6px; }
    .custom-scroll::-webkit-scrollbar-track { background: #f8fafc; }
    .custom-scroll::-webkit-scrollbar-thumb { background: #e2e8f0; border-radius: 10px; }
    .custom-scroll::-webkit-scrollbar-thumb:hover { background: var(--p-indigo); }

    /* 📏 Timeline v11 Styling */
    .timeline-v11 { position: relative; padding-right: 25px; }
    .timeline-v11::before {
        content: ''; position: absolute; right: 8px; top: 0; bottom: 0;
        width: 2px; background: #f1f5f9;
    }
    .timeline-item-v11 { position: relative; padding-bottom: 2rem; }
    .timeline-icon-v11 {
        position: absolute; right: -25px; top: 0;
        width: 18px; height: 18px; border-radius: 50%;
        display: flex; align-items: center; justify-content: center;
        font-size: 0.6rem; z-index: 2; border: 3px solid #fff;
    }
    .timeline-item-v11.active::before {
        content: ''; position: absolute; right: -17px; top: 18px; bottom: 0;
        width: 2px; background: var(--p-indigo); opacity: 0.3;
    }
    .timeline-content-v11 { padding-right: 15px; }

    .animate-pulse { animation: pulse 2s infinite; }
    @keyframes pulse { 0% { transform: scale(0.95); opacity: 0.8; } 70% { transform: scale(1); opacity: 1; } 100% { transform: scale(0.95); opacity: 0.8; } }
</style><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\petty-cash\partials\modals.blade.php ENDPATH**/ ?>