





<?php if($showActionModal): ?>
    <div class="modal fade show d-block" style="background: rgba(0,0,0,0.6); z-index: 1055;">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 rounded-4 shadow-xl">
                <div class="modal-header text-white rounded-top-4"
                     style="background: <?php switch($actionType): case ('approve'): ?> var(--success) <?php break; ?> <?php case ('reject'): ?> var(--danger) <?php break; ?> <?php case ('correction'): ?> var(--warning) <?php break; ?> <?php default: ?> var(--primary) <?php endswitch; ?>;">
                    <h5 class="modal-title fw-bold">
                        <?php switch($actionType):
                            case ('approve'): ?> <i class="fas fa-check-circle me-2"></i> تأیید و تکمیل <?php break; ?>
                            <?php case ('reject'): ?> <i class="fas fa-times-circle me-2"></i> رد نامه <?php break; ?>
                            <?php case ('view'): ?> <i class="fas fa-eye me-2"></i> مشاهده شد <?php break; ?>
                            <?php case ('correction'): ?> <i class="fas fa-undo-alt me-2"></i> بازگشت برای تصحیح <?php break; ?>
                        <?php endswitch; ?>
                    </h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="$set('showActionModal', false)"></button>
                </div>
                <form wire:submit.prevent="submitAction">
                    <div class="modal-body">
                        <?php if(in_array($actionType, ['approve', 'reject', 'correction'])): ?>
                            <div class="mb-3">
                                <label class="form-label fw-bold">یادداشت شما <span class="text-danger small"><?php if($actionType === 'correction'): ?> (اجباری) <?php else: ?> <?php endif; ?></span></label>
                                <textarea wire:model="opinion" class="form-control rounded-3" rows="3"
                                          placeholder="<?php if($actionType === 'correction'): ?> دلیل نیاز به تصحیح و اقدامات لازم را وارد کنید... <?php else: ?> توضیح یا نظر خود را وارد کنید... <?php endif; ?>"></textarea>
                                <?php $__errorArgs = ['opinion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <?php endif; ?>
                        <div class="alert alert-light small p-3 rounded-3 text-muted">
                            <i class="fas fa-info-circle me-1"></i> این اقدام وضعیت ارجاع فعلی شما را نهایی می‌کند.
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary rounded-pill" wire:click="$set('showActionModal', false)">
                            انصراف
                        </button>
                        <button type="submit" class="btn text-white rounded-pill"
                                style="background: <?php switch($actionType): case ('approve'): ?> var(--success) <?php break; ?> <?php case ('reject'): ?> var(--danger) <?php break; ?> <?php case ('correction'): ?> var(--warning) <?php break; ?> <?php default: ?> var(--primary) <?php endswitch; ?>;"
                                wire:loading.attr="disabled">
                            <span wire:loading.remove>
                                <i class="fas fa-check me-1"></i> اقدام نهایی
                            </span>
                            <span wire:loading>
                                <span class="spinner-border spinner-border-sm"></span>
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php endif; ?>


<?php if($showHandoffModal): ?>
    <div class="modal fade show d-block" style="background: rgba(0,0,0,0.6); z-index: 1055;">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 rounded-4 shadow-xl">
                <div class="modal-header text-white rounded-top-4" style="background: var(--primary);">
                    <h5 class="modal-title fw-bold"><i class="fas fa-exchange-alt me-2"></i> واگذاری/ارجاع مجدد کار</h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="$set('showHandoffModal', false)"></button>
                </div>
                <form wire:submit.prevent="submitHandoff">
                    <div class="modal-body">
                        <div class="alert alert-warning small rounded-3" role="alert">
                            <i class="fas fa-exclamation-triangle me-1"></i>
                            **توجه:** این عمل ارجاع فعلی شما را تکمیل کرده و کار را به کاربر جدید منتقل می‌کند.
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">ارجاع به کاربر:</label>
                            <select wire:model="handoffUserId" class="form-select rounded-3">
                                <option value="">انتخاب همکار...</option>
                                <?php $__currentLoopData = $this->availableUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['handoffUserId'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">هدف ارجاع جدید:</label>
                            <select wire:model="handoffPurpose" class="form-select rounded-3">
                                <?php $__currentLoopData = $this->purposesOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purpose): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($purpose); ?>"><?php echo e($purpose); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary rounded-pill" wire:click="$set('showHandoffModal', false)">
                            انصراف
                        </button>
                        <button type="submit" class="btn btn-primary rounded-pill" wire:loading.attr="disabled">
                        <span wire:loading.remove>
                            <i class="fas fa-share me-1"></i> واگذاری و تکمیل
                        </span>
                            <span wire:loading>
                            <span class="spinner-border spinner-border-sm"></span>
                        </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php endif; ?>


<?php if($showReferralTreeModal): ?>
    <div class="modal fade show d-block" style="background: rgba(0,0,0,0.6); z-index: 1055;">
        <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content border-0 rounded-4 shadow-xl">
                <div class="modal-header text-white rounded-top-4" style="background: var(--primary-700);">
                    <h5 class="modal-title fw-bold"><i class="fas fa-sitemap me-2"></i> درخت ارجاعات و تاریخچه گردش</h5>
                    <button type="button" class="btn-close btn-close-white" wire:click="closeReferralTreeModal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        
                        <ul class="nav nav-tabs nav-fill mb-4" id="referralTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active fw-bold" id="tree-tab" data-bs-toggle="tab" data-bs-target="#referral-tree" type="button" role="tab" aria-controls="referral-tree" aria-selected="true">
                                    <i class="fas fa-code-branch me-1"></i> مسیر ارجاع
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link fw-bold" id="history-tab" data-bs-toggle="tab" data-bs-target="#referral-history" type="button" role="tab" aria-controls="referral-history" aria-selected="false">
                                    <i class="fas fa-history me-1"></i> تایم‌لاین رویدادها
                                </button>
                            </li>
                        </ul>

                        <div class="tab-content" id="referralTabContent">

                            
                            <div class="tab-pane fade show active" id="referral-tree" role="tabpanel" aria-labelledby="tree-tab">
                                <div class="p-3 border rounded-4 bg-light">
                                    <?php if(empty($referralTree)): ?>
                                        <p class="text-center text-muted m-0"><i class="fas fa-info-circle me-1"></i> هنوز ارجاعی ثبت نشده است.</p>
                                    <?php else: ?>
                                        
                                        <?php echo $__env->make('livewire.admin.letter.partials.referral-tree-node', ['nodes' => $referralTree, 'level' => 0], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>

                            
                            <div class="tab-pane fade" id="referral-history" role="tabpanel" aria-labelledby="history-tab">
                                <div class="timeline">
                                    <?php $__empty_1 = true; $__currentLoopData = $historyTimeline; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <div class="timeline-item d-flex mb-4">
                                            <div class="timeline-badge me-3 p-2 rounded-circle text-white shadow-sm"
                                                 style="background: <?php if(Str::contains($item->type, ['approve', 'completed'])): ?> var(--success) <?php elseif(Str::contains($item->type, ['reject', 'canceled', 'correction'])): ?> var(--danger) <?php else: ?> var(--primary) <?php endif; ?>;">
                                                <i class="fas <?php if(Str::contains($item->type, 'approve')): ?> fa-check <?php elseif(Str::contains($item->type, 'reject')): ?> fa-times <?php elseif(Str::contains($item->type, 'correction')): ?> fa-undo <?php elseif(Str::contains($item->type, 'handoff')): ?> fa-exchange-alt <?php else: ?> fa-info <?php endif; ?>"></i>
                                            </div>
                                            <div class="timeline-panel flex-grow-1 p-3 border rounded-4 bg-white shadow-sm">
                                                <div class="timeline-heading fw-bold">
                                                    <?php echo e($item->description); ?>

                                                </div>
                                                <p class="timeline-body small text-muted mb-0 mt-1">
                                                    <i class="fas fa-user me-1"></i> توسط: <?php echo e($item->user->name ?? 'سیستم'); ?>

                                                    <span class="ms-3"><i class="far fa-clock me-1"></i> <?php echo e($this->formatShamsiDate($item->date, 'Y/m/d H:i')); ?></span>
                                                </p>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="text-center py-4 text-muted">
                                            <i class="fas fa-hourglass-half fs-3 mb-2"></i>
                                            <p>تاریخچه رویدادها خالی است.</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\letter\partials\modals-styled.blade.php ENDPATH**/ ?>