<div>
    
    <style>
        /* 💡 پالت رنگی مدرن و جذاب */
        :root {
            /* رنگ‌های اصلی */
            --primary-main: #4a7cff;
            --primary-light: #e6f0ff;
            --success-main: #28a745;
            --success-light: #e6ffed;
            --danger-main: #dc3545;
            --danger-light: #fbe6e6; /* رنگ بسیار روشن برای پس زمینه خطر */
            --warning-main: #ffc107;
            --warning-light: #fffde7;
            --info-main: #17a2b8;
            --info-light: #e8f9fb;

            /* مقادیر طراحی */
            --background-light: #f8f9fa;
            --text-dark: #212529;
            --text-muted: #6c757d;
            --border-color: #e9ecef;
            --shadow-subtle: 0 8px 25px rgba(0, 0, 0, 0.1);
            --dropdown-width: 380px;
            --avatar-icon-size: 2.5rem;
        }

        /* --- انیمیشن‌ها و پایه‌ها --- */
        .notification-anchor {
            position: relative;
            display: inline-block;
            line-height: 1;
        }

        .notification-dropdown {
            width: var(--dropdown-width);
            max-width: 100%;
            border-radius: 12px;
            box-shadow: var(--shadow-subtle);
            border: 1px solid var(--border-color);
            overflow: hidden;
            background-color: white;
            animation: dropdownFadeIn 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94) forwards;
            transform-origin: top right;
            z-index: 1050;
        }
        @keyframes dropdownFadeIn {
            from { opacity: 0; transform: scale(0.95) translateY(-10px); }
            to { opacity: 1; transform: scale(1) translateY(0); }
        }
        /* افکت نبض برای آیکون اعلان نخوانده */
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(220, 53, 69, 0.7); }
            70% { box-shadow: 0 0 0 8px rgba(220, 53, 69, 0); }
            100% { box-shadow: 0 0 0 0 rgba(220, 53, 69, 0); }
        }
        .spin-animation { animation: spin 1s linear infinite; }
        @keyframes spin { from { transform: rotate(0deg); } to { transform: rotate(360deg); } }

        /* --- Header --- */
        .dropdown-header-custom {
            background: linear-gradient(135deg, var(--primary-main), #2c58e5);
            color: white;
            font-weight: 600;
            padding: 1rem 1.2rem;
            border-bottom: 1px solid rgba(255, 255, 255, 0.15);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .dropdown-header-custom .btn {
            font-size: 0.8rem;
            padding: 0.3rem 0.8rem;
            border-radius: 40px;
            background-color: rgba(255, 255, 255, 0.2);
            border: none;
            color: white;
            transition: background-color 0.2s ease;
        }

        /* --- آیتم‌های لیست --- */
        .message-body {
            max-height: 420px;
            overflow-y: auto;
            /* مخفی کردن نوار اسکرول */
            -ms-overflow-style: none;
            scrollbar-width: none;
        }
        .message-body::-webkit-scrollbar {
            display: none;
        }

        .notification-item {
            transition: background-color 0.2s ease, box-shadow 0.2s ease;
            border-bottom: 1px solid var(--border-color);
            padding: 0.9rem 1.2rem;
            display: flex;
            align-items: center;
            gap: 0.8rem;
            text-decoration: none;
            color: var(--text-dark);
            position: relative;
        }
        .notification-item:hover {
            background-color: var(--background-light) !important;
            box-shadow: 0 1px 6px rgba(0, 0, 0, 0.05);
        }
        .notification-item.unread {
            /* استایل پیش فرض نخوانده */
            background-color: #fcfcfc;
            border-right: 4px solid var(--primary-main);
        }
        /* 💡 استایل خاص برای اعلان‌های خطر (فعال‌سازی) */
        .notification-item.unread.danger-type {
            border-right: 4px solid var(--danger-main);
            background-color: var(--danger-light) !important;
            animation: none !important; /* حذف انیمیشن نبض اگر روی خود آیتم اعمال شده بود */
        }
        .notification-item.unread.danger-type:hover {
            background-color: #ffe6e6 !important;
        }


        /* آیکون آواتار */
        .avatar-notif {
            width: var(--avatar-icon-size);
            height: var(--avatar-icon-size);
            border-radius: 8px;
            flex-shrink: 0;
            font-size: 1.1rem;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white; /* آیکون سفید برای کنتراست بهتر */
        }
        /* رنگ پس‌زمینه آیکون‌ها */
        .bg-primary { background-color: var(--primary-main) !important; }
        .bg-success { background-color: var(--success-main) !important; }
        .bg-danger { background-color: var(--danger-main) !important; }
        .bg-warning { background-color: var(--warning-main) !important; }
        .bg-info { background-color: var(--info-main) !important; }

        .badge-dot {
            position: absolute;
            top: -2px;
            right: -2px;
            width: 8px;
            height: 8px;
            border: 2px solid white;
            background-color: var(--danger-main) !important;
            border-radius: 50%;
        }

        .text-content-wrap {
            flex-grow: 1;
            margin-right: 35px;
        }
        .text-title {
            font-weight: 700;
            font-size: 0.95rem;
            line-height: 1.2;
            margin-bottom: 0.1rem;
        }
        .text-content-message {
            font-size: 0.8rem;
            color: var(--text-muted);
            line-height: 1.3;
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
        }

        .notification-meta {
            margin-top: 0.4rem;
            padding-top: 0.3rem;
            border-top: 1px dashed rgba(0, 0, 0, 0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 0.75rem;
            color: var(--text-muted);
        }
        .text-sender-name {
            font-weight: 700;
            color: var(--text-dark);
        }
        .text-time {
            white-space: nowrap;
        }

        /* دکمه علامت‌گذاری تکی */
        .btn-mark-as-read {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            left: 10px;
            z-index: 10;
            border: none;
            background: none;
            padding: 8px;
            border-radius: 50%;
            cursor: pointer;
            opacity: 0;
            transition: opacity 0.2s ease, background-color 0.2s ease;
        }
        .notification-item:hover .btn-mark-as-read {
            opacity: 1;
        }
        .btn-mark-as-read:hover {
            background-color: rgba(40, 167, 69, 0.1);
        }
        .btn-mark-as-read i {
            color: var(--success-main);
            font-size: 1.1rem;
        }

        /* Footer */
        .dropdown-footer-custom {
            padding: 0.8rem 1.2rem;
            border-top: 1px solid var(--border-color);
        }

        /* حالت خالی */
        .empty-notifications-state {
            padding: 2rem;
            color: var(--text-muted);
            text-align: center;
        }
        .empty-notifications-state i {
            font-size: 3rem;
            color: var(--border-color);
        }
    </style>

    
    <div wire:poll.60s="loadNotifications">

        
        <a class="nav-link nav-icon-hover notification-anchor"
           href="javascript:void(0)"
           id="drop2"
           data-bs-toggle="dropdown"
           aria-expanded="false"
           aria-label="اعلان‌ها">

            <i class="ti ti-bell-ringing fs-5"></i>

            <?php if($unreadCount > 0): ?>
                <span class="position-absolute badge rounded-circle bg-danger"
                      style="width: 10px; height: 10px; padding: 0; border: 1px solid white; animation: pulse 1.5s infinite; top: 5px; right: 2px;">
                    <span class="visually-hidden"><?php echo e($unreadCount); ?> اعلان جدید</span>
                </span>
            <?php endif; ?>
        </a>

        <div class="dropdown-menu notification-dropdown dropdown-menu-end p-0 mt-2" aria-labelledby="drop2">

            
            <div class="dropdown-header-custom">
                <h6 class="mb-0 fw-bold">اعلان‌ها (<?php echo e($unreadCount); ?>)</h6>
                <?php if($unreadCount > 0): ?>
                    <button wire:click="markAllAsRead"
                            class="btn"
                            wire:loading.attr="disabled"
                            wire:target="markAllAsRead">

                        <span wire:loading.remove wire:target="markAllAsRead">
                            <i class="ti ti-checks me-1"></i> علامت‌گذاری همه
                        </span>

                        <span wire:loading wire:target="markAllAsRead" class="d-flex align-items-center">
                            <i class="ti ti-loader me-1 spin-animation"></i>
                            <span class="ms-1">در حال انجام...</span>
                        </span>

                    </button>
                <?php endif; ?>
            </div>

            
            <div class="message-body">
                <?php if(empty($notifications)): ?>
                    <div class="empty-notifications-state">
                        <div class="mb-3"><i class="ti ti-bell-off"></i></div>
                        <div class="fw-semibold">اعلان جدیدی وجود ندارد</div>
                        <div class="small mt-1">همهٔ اعلان‌ها خوانده شده‌اند.</div>
                    </div>
                <?php else: ?>
                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notif): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php $dangerClass = ($notif['is_read'] === false && $notif['color'] === 'danger') ? 'danger-type' : ''; ?>

                        
                        <div wire:key="<?php echo e($notif['id']); ?>">
                            <a href="<?php echo e($notif['url']); ?>"
                               class="notification-item <?php echo e($notif['is_read'] ? '' : 'unread'); ?> <?php echo e($dangerClass); ?>"
                               style="display: block;">

                                
                                <div class="avatar-notif bg-<?php echo e($notif['color']); ?>">
                                    <i class="<?php echo e($notif['icon']); ?>"></i>
                                    <?php if(! $notif['is_read']): ?>
                                        <span class="badge-dot position-absolute"></span>
                                    <?php endif; ?>
                                </div>

                                
                                <div class="text-content-wrap">
                                    <h6 class="text-title"><?php echo e($notif['title']); ?></h6>
                                    <p class="text-content-message"><?php echo e($notif['message']); ?></p>

                                    <div class="notification-meta">
                                        <span class="text-sender-name">ارسال از: **<?php echo e($notif['sender']); ?>**</span>

                                        
                                        <span class="text-time">
                                            <?php
                                                // تبدیل رشته به شیء Carbon (اگر هنوز تبدیل نشده)
                                                $time = is_string($notif['time']) ? \Carbon\Carbon::parse($notif['time']) : $notif['time'];
                                            ?>
                                            <?php if($time instanceof \Carbon\Carbon): ?>
                                                <?php echo e($time->diffForHumans()); ?>

                                            <?php else: ?>
                                                نا مشخص
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                </div>

                                
                                <?php if(! $notif['is_read']): ?>
                                    <button wire:click.prevent="markAsRead('<?php echo e($notif['id']); ?>', '<?php echo e($notif['type']); ?>')"
                                            class="btn-mark-as-read"
                                            title="علامت‌گذاری به‌عنوان خوانده شده">
                                        <i class="ti ti-check"></i>
                                    </button>
                                <?php endif; ?>
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

                
                <?php if($hasMore): ?>
                    <div class="text-center p-3 border-top">
                        <button wire:click="increaseLimit" class="btn btn-sm btn-outline-secondary w-75">
                            <span wire:loading.remove wire:target="increaseLimit"><i class="ti ti-dots me-1"></i> مشاهده ۸ مورد بیشتر</span>
                            <span wire:loading wire:target="increaseLimit">در حال بارگذاری...</span>
                        </button>
                    </div>
                <?php endif; ?>
            </div>

            
            <div class="dropdown-footer-custom">
                <a href="<?php echo e(route('user.inbox')); ?>" class="btn btn-primary w-100">
                    <i class="ti ti-eye me-1"></i> مشاهده همه موارد (صندوق ورودی)
                </a>
            </div>
        </div>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\layout\notifications-dropdown.blade.php ENDPATH**/ ?>