<div>
    <div class="letters-container rtl" dir="rtl"
         x-data="{
            toastStore: {
                toasts: [],
                add(type, msg, isGlobal = false) {
                    const id = Date.now();
                    const toastType = isGlobal ? 'global' : type;
                    this.toasts.push({id, type: toastType, message: msg, visible: true});
                    setTimeout(() => {
                        const t = this.toasts.find(t => t.id === id);
                        if (t) t.visible = false;
                        setTimeout(() => this.toasts = this.toastStore.toasts.filter(t => t.id !== id), isGlobal ? 6500 : 3800);
                    }, isGlobal ? 6500 : 3800);
                }
            },
            init() {
                Livewire.on('show-toast', (e) => {
                    const data = Array.isArray(e) ? e[0] : e;
                    this.toastStore.add(data.type || 'info', data.message || 'پیام نامشخص');
                });
                Livewire.on('show-confirmation', (e) => {
                    const data = Array.isArray(e) ? e[0] : e;
                    if (typeof Swal !== 'undefined') {
                        Swal.fire({
                            title: data.title || 'آیا مطمئن هستید؟',
                            text: data.text || 'این عملیات قابل بازگشت نیست.',
                            icon: data.icon || 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#3085d6',
                            cancelButtonColor: '#d33',
                            confirmButtonText: data.confirmButtonText || 'بله، انجام بده!',
                            cancelButtonText: 'انصراف'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.Livewire.find('<?php echo e($_instance->getId()); ?>').dispatch('confirmed', {
                                    method: data.method,
                                    params: data.params || []
                                });
                            }
                        });
                    }
                });
                if (!this.datePickersInitialized) {
                    this.initShamsiDatePickers();
                    this.datePickersInitialized = true;
                }
            },
            datePickersInitialized: false,
            initShamsiDatePickers() {
                if (typeof $ === 'function' && $.fn.persianDatepicker) {
                    const datepickerOptions = {
                        altField: '',
                        altFormat: 'YYYY-MM-DD',
                        format: 'YYYY/MM/DD',
                        timePicker: false,
                        dayPicker: { enabled: true },
                        autoClose: true
                    };
                    $('#filter-from-date').persianDatepicker({
                        ...datepickerOptions,
                        altField: '#filter-from-date-alt',
                        onSelect: function(unix, obj) {
                            const greg = $('#filter-from-date-alt').val();
                            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('filterFromDate', greg);
                        }
                    });
                    $('#filter-to-date').persianDatepicker({
                        ...datepickerOptions,
                        altField: '#filter-to-date-alt',
                        onSelect: function(unix, obj) {
                            const greg = $('#filter-to-date-alt').val();
                            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('filterToDate', greg);
                        }
                    });
                }
            }
         }"
         style="font-family: 'Vazirmatn', 'Segoe UI', sans-serif;"
    >
        <style>
            :root {
                --primary: hsl(217, 91%, 55%);
                --primary-50: hsl(217, 91%, 95%);
                --primary-100: hsl(217, 91%, 90%);
                --primary-600: hsl(217, 91%, 35%);
                --secondary: hsl(200, 15%, 55%);
                --accent: hsl(170, 100%, 45%);
                --bg: #f3f4f6;
                --card: #ffffff;
                --text: #1f2937;
                --text-muted: #6b7280;
                --border: #e5e7eb;
                --shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
                --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.06);
                --shadow-lg: 0 10px 25px -3px rgba(15, 23, 42, 0.55), 0 4px 6px -4px rgba(15, 23, 42, 0.4);
                --transition: all 0.25s cubic-bezier(0.16, 1, 0.3, 1);
                --success: #10b981;
                --warning: #f59e0b;
                --info: #3b82f6;
            }
            .letters-container {
                max-width: 1600px;
                margin: 0 auto;
                padding: 24px 16px 40px;
            }
            .page-header {
                background:
                    radial-gradient(circle at top left, rgba(255,255,255,0.16), transparent 55%),
                    linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%);
                border-radius: 24px;
                padding: 30px 28px 26px;
                color: white;
                position: relative;
                overflow: hidden;
                box-shadow: var(--shadow-lg);
                margin-bottom: 20px;
            }
            .page-header::after {
                content: '';
                position: absolute;
                inset-inline-start: -70px;
                inset-block-start: -70px;
                width: 220px;
                height: 220px;
                border-radius: 50%;
                background: rgba(255,255,255,0.12);
                filter: blur(30px);
                opacity: 0.8;
            }
            .header-main-title {
                font-size: 2.3rem;
                font-weight: 900;
                margin-bottom: 4px;
                color: #fff;
                text-shadow: 0 3px 10px rgba(0,0,0,0.3);
            }
            .header-sub-title {
                opacity: 0.96;
                font-size: 0.98rem;
                color: #f9fafb;
            }
            .header-icon-wrapper {
                background: rgba(255,255,255,0.2);
                border: 1px solid rgba(255,255,255,0.35);
                border-radius: 18px;
                padding: 16px;
                display: inline-flex;
                align-items: center;
                justify-content: center;
                margin-left: 24px;
                backdrop-filter: blur(8px);
            }
            .filter-section {
                margin-top: 24px;
                padding: 18px 20px;
                border-radius: 18px;
                background: rgba(15,23,42,0.18);
                backdrop-filter: blur(14px);
                border: 1px solid rgba(255,255,255,0.3);
                box-shadow: 0 8px 24px rgba(15,23,42,0.3);
            }
            .filter-section label {
                color: #f9fafb !important;
                font-weight: 600;
                text-shadow: 0 1px 2px rgba(0,0,0,0.3);
            }
            .filter-section input,
            .filter-section select {
                background: rgba(255,255,255,0.94) !important;
                border: 1px solid rgba(15,23,42,0.08) !important;
                color: #111827 !important;
                font-weight: 500;
                border-radius: 10px !important;
                box-shadow: 0 1px 2px rgba(15,23,42,0.15);
            }
            .filter-section input::placeholder {
                color: #6b7280 !important;
            }
            .filter-section .input-group-text {
                background: rgba(255,255,255,0.95) !important;
                border-radius: 10px 0 0 10px;
                border: 1px solid rgba(15,23,42,0.08) !important;
            }
            .active-filters-wrapper {
                margin-top: 14px;
                padding-top: 10px;
                border-top: 1px dashed rgba(255,255,255,0.35);
            }
            .active-filter-badge {
                background: rgba(255,255,255,0.22);
                border: 1px solid rgba(255,255,255,0.6);
                color: #fefefe;
                padding: 5px 12px;
                border-radius: 999px;
                font-size: 0.8rem;
                display: inline-flex;
                align-items: center;
                gap: 6px;
                backdrop-filter: blur(4px);
            }
            .active-filter-badge .btn-close {
                filter: invert(1);
                opacity: .8;
            }
            .stat-row {
                margin-top: 16px;
            }
            .stat-card {
                background: rgba(15,23,42,0.14);
                border: 1px solid rgba(255,255,255,0.28);
                backdrop-filter: blur(12px);
                color: white;
                padding: 14px 16px 12px;
                border-radius: 16px;
                transition: var(--transition);
                box-shadow: 0 4px 16px rgba(15,23,42,0.35);
            }
            .stat-card:hover {
                transform: translateY(-3px);
                box-shadow: 0 10px 28px rgba(15,23,42,0.5);
                background: rgba(15,23,42,0.22);
            }
            .stat-label {
                font-size: 0.78rem;
                letter-spacing: .04em;
                text-transform: uppercase;
                opacity: 0.9;
            }
            .stat-icon {
                width: 30px;
                height: 30px;
                border-radius: 999px;
                display: flex;
                align-items: center;
                justify-content: center;
                background: rgba(15,23,42,0.55);
                border: 1px solid rgba(255,255,255,0.35);
                font-size: 0.85rem;
            }
            .main-content-card {
                background-color: var(--card);
                border-radius: 18px;
                box-shadow: var(--shadow);
                overflow: hidden;
                margin-top: 18px;
            }
            .table-responsive {
                overflow-x: auto;
                scrollbar-width: thin;
                scrollbar-color: var(--border) transparent;
            }
            .table-responsive::-webkit-scrollbar {
                height: 8px;
            }
            .table-responsive::-webkit-scrollbar-track {
                background: transparent;
            }
            .table-responsive::-webkit-scrollbar-thumb {
                background-color: var(--border);
                border-radius: 4px;
            }
            .table {
                min-width: 100%;
                margin-bottom: 0;
            }
            .table thead th {
                color: var(--text);
                background: linear-gradient(to bottom, #f9fafb, #eef2ff);
                border-bottom: 2px solid var(--primary-100);
                font-weight: 700;
                font-size: 0.85rem;
                padding: 12px 10px;
                white-space: nowrap;
            }
            .table tbody td {
                padding: 12px 10px;
                vertical-align: middle;
                font-size: 0.88rem;
                border-color: var(--border);
            }
            .table-hover tbody tr {
                transition: var(--transition);
            }
            .table-hover tbody tr:hover {
                background-color: var(--primary-50);
            }
            .avatar {
                width: 36px;
                height: 36px;
                min-width: 36px;
                min-height: 36px;
                border-radius: 50%;
                overflow: hidden;
                background-color: #e5e7eb;
                display: flex;
                align-items: center;
                justify-content: center;
                flex-shrink: 0;
                box-shadow: var(--shadow-sm);
            }
            .avatar img {
                width: 100%;
                height: 100%;
                object-fit: cover;
            }
            .avatar-xs {
                width: 28px;
                height: 28px;
                min-width: 28px;
                min-height: 28px;
            }
            .letter-title {
                font-weight: 600;
                color: var(--primary);
                cursor: pointer;
                transition: var(--transition);
                display: inline-block;
                font-size: 0.9rem;
            }
            .letter-title:hover {
                color: var(--primary-600);
                text-decoration: underline;
                text-decoration-thickness: 1.5px;
                text-underline-offset: 3px;
            }
            .status-badge {
                display: inline-flex;
                align-items: center;
                gap: 6px;
                padding: 5px 12px;
                border-radius: 999px;
                font-size: 0.75rem;
                font-weight: 600;
                white-space: nowrap;
            }
            .status-badge.pending { background-color: #fffbeb; color: #d97706; }
            .status-badge.approved { background-color: #ecfdf5; color: #059669; }
            .status-badge.rejected { background-color: #fef2f2; color: #dc2626; }
            .status-badge.draft { background-color: #f3f4f6; color: #6b7280; }
            .status-badge.archived { background-color: #e5e7eb; color: #4b5563; }
            .badge-soft-danger {
                background-color: #fee2e2;
                color: #b91c1c;
            }
            .badge-soft-warning {
                background-color: #fef3c7;
                color: #92400e;
            }
            .bg-danger-subtle { background-color: #fee2e2; }
            .text-danger { color: #dc2626; }
            .border-danger-subtle { border-color: #fee2e2 !important; }
            .bg-success-subtle { background-color: #ecfdf5; }
            .text-success { color: #059669; }
            .bg-warning-subtle { background-color: #fffbeb; }
            .text-warning { color: #d97706; }
            .bg-primary-subtle { background-color: #eef2ff; }
            .text-primary { color: var(--primary); }
            .bg-secondary-subtle { background-color: #f3f4f6; }
            .text-secondary { color: #6b7280; }
            .action-dropdown {
                position: relative;
            }
            .action-dropdown-btn {
                width: 32px;
                height: 32px;
                border-radius: 10px;
                display: flex;
                align-items: center;
                justify-content: center;
                background: #f9fafb;
                border: 1px solid var(--border);
                color: var(--text-muted);
                transition: var(--transition);
                font-size: 0.85rem;
            }
            .action-dropdown-btn:hover {
                background: var(--primary-50);
                color: var(--primary);
                border-color: var(--primary);
            }
            .action-dropdown-menu {
                position: absolute;
                top: 100%;
                left: 50%;
                transform: translateX(-50%) translateY(-8px);
                margin-top: 8px;
                background: white;
                border-radius: 14px;
                box-shadow: var(--shadow);
                min-width: 190px;
                padding: 8px 0;
                z-index: 1000;
                opacity: 0;
                visibility: hidden;
                transition: opacity 0.2s, transform 0.2s;
            }
            .action-dropdown:hover .action-dropdown-menu {
                opacity: 1;
                visibility: visible;
                transform: translateX(-50%) translateY(0);
            }
            .action-dropdown-item {
                display: flex;
                align-items: center;
                gap: 10px;
                padding: 8px 14px;
                font-size: 0.85rem;
                color: var(--text);
                text-decoration: none;
                transition: var(--transition);
                cursor: pointer;
            }
            .action-dropdown-item:hover {
                background: var(--primary-50);
                color: var(--primary);
            }
            .action-dropdown-item i {
                width: 18px;
                text-align: center;
            }
            .due-date-wrapper {
                font-size: 0.8rem;
                display: inline-flex;
                align-items: center;
                gap: .35rem;
            }
            .due-date-wrapper.critical {
                color: #dc2626;
                font-weight: 600;
            }
            .due-date-wrapper.warning {
                color: #d97706;
            }
            .empty-state {
                padding: 64px 24px;
                text-align: center;
            }
            .empty-icon {
                width: 80px;
                height: 80px;
                margin: 0 auto 24px;
                background: #f3f4f6;
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                color: #9ca3af;
                font-size: 2rem;
            }
            .timeline {
                position: relative;
                padding-right: 16px;
            }
            .timeline::before {
                content: '';
                position: absolute;
                inset-block-start: 4px;
                inset-inline-end: 8px;
                width: 2px;
                height: 100%;
                background: linear-gradient(to bottom, #e5e7eb, #cbd5f5);
            }
            .modal-body-referral {
                display: flex;
                padding: 0;
                min-height: 500px;
            }
            .user-list-pane {
                max-height: 500px;
                overflow-y: auto;
                border-inline-end: 1px solid var(--border);
                padding: 1.5rem;
            }
            .user-card-referral {
                transition: all 0.2s;
                border: 1px solid var(--border);
                cursor: pointer;
            }
            .user-card-referral:hover {
                background: var(--primary-50);
                border-color: var(--primary);
            }
            .purpose-pane {
                padding: 1.5rem;
                max-height: 500px;
                overflow-y: auto;
            }
            .purpose-toggle-grid {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
                gap: 10px;
                margin-top: 15px;
            }
            .purpose-toggle-button {
                border-radius: 8px !important;
                font-weight: 600;
                padding: 12px 15px;
                transition: all 0.2s;
                box-shadow: var(--shadow-sm);
            }
            .purpose-toggle-button:hover {
                transform: translateY(-2px);
            }
            .user-card-selected {
                background: var(--primary-50) !important;
                border-color: var(--primary) !important;
            }
        </style>

        <?php $__env->startPush('scripts'); ?>
            <script>
                document.addEventListener('livewire:initialized', () => {
                    Livewire.hook('element.updated', (el) => {
                        if (el.querySelector('[data-bs-toggle="tooltip"]')) {
                            const tooltipTriggerList = [].slice.call(el.querySelectorAll('[data-bs-toggle="tooltip"]'));
                            tooltipTriggerList.forEach(tooltipTriggerEl => {
                                const tooltip = bootstrap.Tooltip.getInstance(tooltipTriggerEl);
                                if (tooltip) tooltip.dispose();
                                new bootstrap.Tooltip(tooltipTriggerEl, {
                                    placement: 'top',
                                    trigger: 'hover',
                                    container: 'body'
                                });
                            });
                        }
                    });
                });
            </script>
            <?php if(file_exists(public_path('assets/js/sweetalert2.min.js'))): ?>
                <script src="<?php echo e(asset('assets/js/sweetalert2.min.js')); ?>"></script>
            <?php endif; ?>
        <?php $__env->stopPush(); ?>

        <?php
            $statusLabelMap = [
                'pending'  => 'در انتظار',
                'approved' => 'تایید شده',
                'rejected' => 'رد شده',
                'draft'    => 'پیش‌نویس',
                'archived' => 'بایگانی',
            ];
            $purposesOptions = $this->purposesOptions;
        ?>

            <!-- Toast Container -->
        <div class="notification-container position-fixed top-0 end-0 p-3" style="z-index: 1200;">
            <template x-for="t in toastStore.toasts" :key="t.id">
                <div x-show="t.visible"
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 translate-x-full"
                     x-transition:enter-end="opacity-100 translate-x-0"
                     x-transition:leave="transition ease-in duration-300"
                     x-transition:leave-start="opacity-100 translate-x-0"
                     x-transition:leave-end="opacity-0 translate-x-full"
                     class="toast show fade-in rounded-3 shadow-lg mb-3 overflow-hidden"
                     role="alert">
                    <div class="toast-header p-3"
                         :class="{
                             'bg-success text-white': t.type === 'success',
                             'bg-danger text-white': t.type === 'error',
                             'bg-info text-white': t.type === 'info',
                             'bg-primary text-white': t.type === 'global'
                         }">
                        <i class="me-2"
                           :class="{
                               'fas fa-check-circle': t.type === 'success',
                               'fas fa-exclamation-triangle': t.type === 'error',
                               'fas fa-info-circle': t.type === 'info',
                               'fas fa-bell': t.type === 'global'
                           }"></i>
                        <strong class="me-auto"
                                x-text="t.type === 'success' ? 'موفقیت' : (t.type === 'error' ? 'خطا' : (t.type === 'global' ? 'اطلاعیه' : 'اطلاعات'))">
                        </strong>
                        <button type="button" class="btn-close btn-close-white" @click="t.visible = false"></button>
                    </div>
                    <div class="toast-body bg-white text-dark" x-text="t.message"></div>
                </div>
            </template>
        </div>

        <!-- Header + Filters -->
        <div class="page-header position-relative">
            <div class="d-flex flex-column flex-md-row align-items-center justify-content-between gap-4">
                <div class="d-flex align-items-center flex-wrap">
                    <span class="header-icon-wrapper shadow-sm">
                        <i class="fas fa-file-contract text-white fs-2"></i>
                    </span>
                    <div class="ms-4">
                        <h1 class="header-main-title">نامه‌های پروژه: <?php echo e($project->name); ?></h1>
                        <div class="header-sub-title">
                            مدیریت، ارجاع و رهگیری نامه‌های پروژه در یک چارچوب یکپارچه
                        </div>
                    </div>
                </div>
                <a href="<?php echo e(route('admin.projects.letters.create', ['project' => $project->id])); ?>"
                   class="btn px-5 py-3 fw-bold rounded-3 d-flex align-items-center gap-2"
                   style="background: white; color: var(--primary); box-shadow: var(--shadow);">
                    <i class="fas fa-plus ms-1"></i>
                    <span>نامه جدید</span>
                </a>
            </div>

            <div class="filter-section mt-3">
                <div class="d-flex flex-wrap align-items-end gap-3">
                    <div class="flex-fill" style="max-width: 300px;">
                        <label class="form-label small mb-1">جستجو</label>
                        <div class="input-group">
                            <span class="input-group-text">
                                <i class="fas fa-search text-primary"></i>
                            </span>
                            <input type="text"
                                   wire:model.live.debounce.400ms="searchLetter"
                                   class="form-control"
                                   placeholder="عنوان یا محتوا...">
                        </div>
                    </div>
                    <div wire:ignore class="d-flex flex-column gap-1">
                        <label class="form-label small mb-1">بازه تاریخ</label>
                        <div class="d-flex gap-2">
                            <input type="text" id="filter-from-date" class="form-control form-control-sm"
                                   placeholder="از" style="width: 120px;">
                            <input type="text" id="filter-to-date" class="form-control form-control-sm"
                                   placeholder="تا" style="width: 120px;">
                            <input type="hidden" id="filter-from-date-alt" wire:model="filterFromDate">
                            <input type="hidden" id="filter-to-date-alt" wire:model="filterToDate">
                        </div>
                    </div>
                    <div class="d-flex flex-column gap-1">
                        <label class="form-label small mb-1">فرستنده</label>
                        <select class="form-select form-select-sm" wire:model.live="filterSender" style="width: 150px">
                            <option value="">همه فرستندگان</option>
                            <?php $__currentLoopData = $projectMembers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>"><?php echo e(Str::limit($user->name, 20)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="d-flex flex-column gap-1">
                        <label class="form-label small mb-1">وضعیت</label>
                        <select class="form-select form-select-sm" wire:model.live="filterStatus" style="width: 150px">
                            <option value="">همه (بایگانی نشده)</option>
                            <option value="pending">در انتظار</option>
                            <option value="approved">تایید شده</option>
                            <option value="rejected">رد شده</option>
                            <option value="draft">پیش‌نویس</option>
                        </select>
                    </div>
                    <div class="d-flex flex-column gap-1">
                        <label class="form-label small mb-1">ارجاع به</label>
                        <select class="form-select form-select-sm" wire:model.live="filterReferralUserId" style="width: 150px">
                            <option value="">همه کاربران</option>
                            <?php $__currentLoopData = $projectMembers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="d-flex flex-column gap-1">
                        <label class="form-label small mb-1">فوری</label>
                        <div class="form-check form-switch p-0 mt-1">
                            <input class="form-check-input ms-3 mt-2" type="checkbox" role="switch"
                                   wire:model.live="filterUrgent" id="filterUrgentSwitch" style="font-size: 1.1rem;">
                            <label class="form-check-label text-white fw-bold small" for="filterUrgentSwitch">
                                <i class="fas fa-exclamation-triangle text-danger me-1"></i> فقط فوری
                            </label>
                        </div>
                    </div>
                    <div class="d-flex flex-column gap-1">
                        <label class="form-label small mb-1">صفحه‌بندی</label>
                        <select class="form-select form-select-sm" wire:model.live="perPage" style="width: 100px">
                            <option value="10">10</option>
                            <option value="25">25</option>
                            <option value="50">50</option>
                        </select>
                    </div>
                    <div class="ms-auto">
                        <button wire:click="resetFilters"
                                class="btn btn-outline-light btn-sm d-flex align-items-center gap-1 rounded-pill px-3">
                            <i class="fas fa-undo"></i> ریست
                        </button>
                    </div>
                </div>

                <?php if($filterStatus || $filterFromDate || $filterToDate || $searchLetter || $filterSender || $filterReferralUserId || $filterUrgent): ?>
                    <div class="active-filters-wrapper">
                        <div class="d-flex flex-wrap align-items-center gap-2">
                            <span class="text-white fw-bold small">فیلترهای فعال:</span>
                            <?php if($searchLetter): ?>
                                <span class="active-filter-badge">
                                    <i class="fas fa-search"></i> <?php echo e(Str::limit($searchLetter, 18)); ?>

                                    <button wire:click="$set('searchLetter', '')" class="btn-close btn-close-white ms-1"></button>
                                </span>
                            <?php endif; ?>
                            <?php if($filterStatus): ?>
                                <span class="active-filter-badge">
                                    <i class="fas fa-flag"></i>
                                    <?php echo e($statusLabelMap[$filterStatus] ?? $filterStatus); ?>

                                    <button wire:click="$set('filterStatus', '')" class="btn-close btn-close-white ms-1"></button>
                                </span>
                            <?php endif; ?>
                            <?php if($filterSender): ?>
                                <span class="active-filter-badge">
                                    <i class="fas fa-user"></i>
                                    فرستنده: <?php echo e($projectMembers->firstWhere('id', $filterSender)?->name ?? 'ناشناس'); ?>

                                    <button wire:click="$set('filterSender', '')" class="btn-close btn-close-white ms-1"></button>
                                </span>
                            <?php endif; ?>
                            <?php if($filterReferralUserId): ?>
                                <span class="active-filter-badge">
                                    <i class="fas fa-paper-plane"></i>
                                    ارجاع به: <?php echo e($projectMembers->firstWhere('id', $filterReferralUserId)?->name ?? 'ناشناس'); ?>

                                    <button wire:click="$set('filterReferralUserId', '')" class="btn-close btn-close-white ms-1"></button>
                                </span>
                            <?php endif; ?>
                            <?php if($filterUrgent): ?>
                                <span class="active-filter-badge bg-danger-subtle text-danger border-danger-subtle">
                                    <i class="fas fa-exclamation-triangle"></i> فقط فوری
                                    <button wire:click="$set('filterUrgent', false)" class="btn-close btn-close-white ms-1"></button>
                                </span>
                            <?php endif; ?>
                            <?php if($filterFromDate): ?>
                                <span class="active-filter-badge">
                                    <i class="far fa-calendar-alt"></i>
                                    از: <?php echo e($this->formatShamsiDate($filterFromDate, 'Y/m/d')); ?>

                                    <button wire:click="$set('filterFromDate', '')" class="btn-close btn-close-white ms-1"></button>
                                </span>
                            <?php endif; ?>
                            <?php if($filterToDate): ?>
                                <span class="active-filter-badge">
                                    <i class="far fa-calendar-alt"></i>
                                    تا: <?php echo e($this->formatShamsiDate($filterToDate, 'Y/m/d')); ?>

                                    <button wire:click="$set('filterToDate', '')" class="btn-close btn-close-white ms-1"></button>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Stats -->
            <div class="row g-3 mt-3 stat-row">
                <div class="col-md-3 col-6">
                    <div class="stat-card">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <span class="stat-label">کل نامه‌ها</span>
                            <span class="stat-icon">
                                <i class="fas fa-layer-group"></i>
                            </span>
                        </div>
                        <div class="fs-4 fw-bold"><?php echo e($statusCounts->sum()); ?></div>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="stat-card">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <span class="stat-label">در انتظار</span>
                            <span class="stat-icon">
                                <i class="fas fa-clock"></i>
                            </span>
                        </div>
                        <div class="fs-4 fw-bold text-warning"><?php echo e($statusCounts['pending'] ?? 0); ?></div>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="stat-card">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <span class="stat-label">تایید شده</span>
                            <span class="stat-icon">
                                <i class="fas fa-check-circle"></i>
                            </span>
                        </div>
                        <div class="fs-4 fw-bold text-success"><?php echo e($statusCounts['approved'] ?? 0); ?></div>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="stat-card">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <span class="stat-label">پیش‌نویس / رد</span>
                            <span class="stat-icon">
                                <i class="fas fa-pen"></i>
                            </span>
                        </div>
                        <div class="fs-4 fw-bold text-light">
                            <?php echo e(($statusCounts['rejected'] ?? 0) + ($statusCounts['draft'] ?? 0)); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Table -->
        <div class="main-content-card">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead>
                    <tr>
                        <th class="ps-4">عنوان نامه</th>
                        <th class="text-center d-none d-md-table-cell">فرستنده</th>
                        <th class="text-center d-none d-lg-table-cell">تاریخ ایجاد</th>
                        <th class="text-center d-none d-lg-table-cell">سررسید</th>
                        <th class="text-center d-none d-lg-table-cell">خواندن</th>
                        <th class="text-center">ارجاعات</th>
                        <th class="text-center d-none d-lg-table-cell">مسئول فعلی</th>
                        <th class="text-center">وضعیت</th>
                        <th class="pe-4 text-end">عملیات</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $letters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $letter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr wire:key="letter-<?php echo e($letter->id); ?>">
                            <td class="ps-4">
                                <div class="d-flex align-items-center gap-2">
                                    <div class="avatar flex-shrink-0">
                                        <img src="<?php echo e($this->getUserProfilePhotoUrl($letter->sender)); ?>"
                                             alt="<?php echo e($letter->sender->name ?? '—'); ?>">
                                    </div>
                                    <div>
                                        <a wire:click="showPreview(<?php echo e($letter->id); ?>)" class="letter-title">
                                            <?php echo e(Str::limit($letter->title, 40)); ?>

                                        </a>
                                        <div class="text-muted small mt-1 d-flex align-items-center gap-2" style="font-size: 0.75rem;">
                                            <?php if($letter->confidential): ?>
                                                <i class="fas fa-lock text-danger" data-bs-toggle="tooltip" title="محرمانه"></i>
                                            <?php endif; ?>
                                            <i class="far fa-calendar-alt me-1"></i>
                                            <?php echo e($this->formatShamsiDate($letter->created_at, 'Y/m/d')); ?>

                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td class="text-center d-none d-md-table-cell">
                                <div class="d-flex align-items-center justify-content-center gap-2">
                                    <div class="avatar avatar-xs">
                                        <img src="<?php echo e($this->getUserProfilePhotoUrl($letter->sender)); ?>">
                                    </div>
                                    <span class="fw-medium"><?php echo e(Str::limit($letter->sender->name ?? '—', 12)); ?></span>
                                </div>
                            </td>
                            <td class="text-center d-none d-lg-table-cell text-muted small">
                                <?php echo e($this->formatShamsiDate($letter->created_at, 'Y/m/d')); ?>

                            </td>
                            <td class="text-center d-none d-lg-table-cell">
                                <?php if($letter->due_date): ?>
                                    <?php $daysDiff = $letter->due_date->diffInDays(now(), false); ?>
                                    <span class="due-date-wrapper <?php echo e($letter->due_date->isPast() ? 'critical' : ($daysDiff <= 3 ? 'warning' : '')); ?>">
                                        <?php echo e($this->formatShamsiDate($letter->due_date, 'Y/m/d')); ?>

                                        <?php if($letter->due_date->isPast()): ?>
                                            <span class="badge badge-soft-danger rounded-pill px-2 py-1">گذشته</span>
                                        <?php elseif($daysDiff <= 3): ?>
                                            <span class="badge badge-soft-warning rounded-pill px-2 py-1">نزدیک سررسید</span>
                                        <?php endif; ?>
                                    </span>
                                <?php else: ?>
                                    <span class="text-muted">—</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center d-none d-lg-table-cell">
                                <?php if($letter->receivers()->exists()): ?>
                                    <?php
                                        $percentage = $letter->read_percentage;
                                        $color = match (true) {
                                            $percentage === 100 => 'success',
                                            $percentage >= 50 => 'warning',
                                            default => 'danger',
                                        };
                                    ?>
                                    <span class="badge bg-<?php echo e($color); ?>-subtle text-<?php echo e($color); ?> rounded-pill px-3 py-1 fw-normal"
                                          data-bs-toggle="tooltip"
                                          title="خوانده شده: <?php echo e($letter->read_count); ?> / <?php echo e($letter->receivers_count); ?>">
                                        <?php echo e($percentage); ?>%
                                    </span>
                                <?php else: ?>
                                    <span class="text-muted small">—</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                                <?php if($letter->referrals_count): ?>
                                    <span class="badge bg-primary-subtle text-primary rounded-pill px-3 py-1 fw-normal">
                                        <?php echo e($letter->referrals_count); ?> ارجاع
                                    </span>
                                <?php else: ?>
                                    <span class="badge bg-secondary-subtle text-secondary rounded-pill px-3 py-1 fw-normal">
                                        —
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center d-none d-lg-table-cell">
                                <?php
                                    $currentReferral = $letter->latestActiveReferral ?? $letter->latestReferral;
                                ?>
                                <?php if($currentReferral): ?>
                                    <div class="d-flex align-items-center justify-content-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img src="<?php echo e($this->getUserProfilePhotoUrl($currentReferral->user)); ?>">
                                        </div>
                                        <div>
                                            <span class="fw-bold small d-block" data-bs-toggle="tooltip" title="ارجاع از: <?php echo e($currentReferral->creator->name ?? 'سیستم'); ?>">
                                                <?php echo e(Str::limit($currentReferral->user->name ?? '—', 15)); ?>

                                            </span>
                                            <span class="badge bg-<?php echo e($currentReferral->status === \App\Models\Referral::STATUS_PENDING ? 'warning-subtle text-warning' : 'success-subtle text-success'); ?> rounded-pill px-2" style="font-size: 0.65rem;">
                                                <?php echo e($currentReferral->typeLabel()); ?>

                                            </span>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <span class="text-muted small">—</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                                <span class="status-badge <?php echo e($letter->status ?? 'draft'); ?>">
                                    <?php switch($letter->status):
                                        case ('approved'): ?>
                                            <i class="fas fa-check-circle"></i> تایید شده
                                            <?php break; ?>
                                        <?php case ('rejected'): ?>
                                            <i class="fas fa-times-circle"></i> رد شده
                                            <?php break; ?>
                                        <?php case ('pending'): ?>
                                            <i class="fas fa-clock"></i> در انتظار
                                            <?php break; ?>
                                        <?php case ('archived'): ?>
                                            <i class="fas fa-box-archive"></i> بایگانی
                                            <?php break; ?>
                                        <?php default: ?>
                                            <i class="fas fa-pen"></i> پیش‌نویس
                                    <?php endswitch; ?>
                                </span>
                            </td>
                            <td class="pe-4 text-end">
                                <div class="d-flex justify-content-end align-items-center gap-2">
                                    <?php if($letter->status === 'draft' && $letter->sender_id === auth()->id()): ?>
                                        <button class="btn btn-sm btn-success rounded-pill px-3 py-1 fw-bold"
                                                wire:click="quickSendForSign(<?php echo e($letter->id); ?>)"
                                                data-bs-toggle="tooltip" title="ارسال سریع برای امضا">
                                            <i class="fas fa-share-square me-1"></i> ارسال
                                        </button>
                                    <?php endif; ?>
                                    <div class="action-dropdown">
                                        <button class="action-dropdown-btn">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="action-dropdown-menu shadow">
                                            <div class="action-dropdown-item" wire:click="showPreview(<?php echo e($letter->id); ?>)">
                                                <i class="fas fa-eye"></i> پیش‌نمایش
                                            </div>
                                            <?php if(
                                                $letter->sender_id === auth()->id() ||
                                                $letter->referrals()->where('user_id', auth()->id())->where('status', \App\Models\Referral::STATUS_PENDING)->exists()
                                            ): ?>
                                                <div class="action-dropdown-item" wire:click="openSendPurposeModal(<?php echo e($letter->id); ?>)">
                                                    <i class="fas fa-paper-plane"></i> ارجاع
                                                </div>
                                            <?php endif; ?>
                                            <div class="action-dropdown-item" wire:click="cloneLetterContent(<?php echo e($letter->id); ?>)">
                                                <i class="fas fa-copy"></i> استفاده از متن
                                            </div>
                                            <?php if($letter->status === 'pending' && $letter->referrals_count > 0): ?>
                                                <div class="action-dropdown-item" wire:click="sendReferralReminder(<?php echo e($letter->id); ?>)">
                                                    <i class="fas fa-bell"></i> یادآوری
                                                </div>
                                            <?php endif; ?>
                                            <?php if(
                                                $letter->sender_id === auth()->id() &&
                                                $letter->status !== \App\Models\Letter::STATUS_ARCHIVED &&
                                                $letter->status !== \App\Models\Letter::STATUS_PENDING
                                            ): ?>
                                                <div class="action-dropdown-item text-secondary"
                                                     wire:click="confirmArchive(<?php echo e($letter->id); ?>)">
                                                    <i class="fas fa-box-archive"></i> بایگانی
                                                </div>
                                            <?php endif; ?>
                                            <div class="action-dropdown-item" wire:click="openReferralTreeModal(<?php echo e($letter->id); ?>)">
                                                <i class="fas fa-sitemap"></i> تاریخچه
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="empty-state">
                                <div class="empty-icon">
                                    <i class="fas fa-inbox"></i>
                                </div>
                                <h5 class="fw-bold text-gray-700">هیچ نامه‌ای یافت نشد</h5>
                                <p class="text-muted mb-4">در این پروژه هنوز نامه‌ای ایجاد یا ثبت نشده است.</p>
                                <div class="d-flex justify-content-center gap-2">
                                    <button wire:click="resetFilters"
                                            class="btn btn-outline-secondary btn-sm rounded-pill px-3">
                                        <i class="fas fa-filter me-1"></i> ریست فیلترها
                                    </button>
                                    <a href="<?php echo e(route('admin.projects.letters.create', ['project' => $project->id])); ?>"
                                       class="btn btn-primary btn-sm rounded-pill px-3">
                                        <i class="fas fa-plus me-1"></i> نامه جدید
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if($letters->hasPages()): ?>
                <div class="p-4 d-flex flex-column flex-md-row justify-content-between align-items-center gap-3 border-top">
                    <div class="text-muted small">
                        نمایش <b><?php echo e($letters->firstItem()); ?></b> تا <b><?php echo e($letters->lastItem()); ?></b> از <b><?php echo e($letters->total()); ?></b> مورد
                    </div>
                    <?php echo e($letters->links('pagination::bootstrap-5')); ?>

                </div>
            <?php endif; ?>
        </div>

        <!-- Modals -->
        <?php if($showPreviewModal && $previewLetter): ?>
            <div class="modal fade show d-block" style="background: rgba(15, 23, 42, 0.7);" tabindex="-1">
                <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content border-0 rounded-4 shadow-lg">
                        <div class="modal-header" style="background: var(--primary); color: white;">
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-sm bg-white bg-opacity-20 text-white rounded-circle me-3">
                                    <i class="fas fa-file-alt"></i>
                                </div>
                                <h5 class="modal-title fw-bold">
                                    پیش‌نمایش نامه: <?php echo e(Str::limit($previewLetter->title, 50)); ?>

                                </h5>
                            </div>
                            <button type="button" class="btn-close btn-close-white" wire:click="closePreviewModal"></button>
                        </div>
                        <div class="modal-body p-0">
                            <div class="border-bottom p-4 bg-light">
                                <div class="d-flex justify-content-between flex-wrap gap-3">
                                    <div>
                                        <span class="badge bg-primary me-2">کد: <?php echo e($previewLetter->code ?? 'LTR-'.$previewLetter->id); ?></span>
                                        <span class="badge bg-secondary">
                                            تاریخ: <?php echo e($this->formatShamsiDate($previewLetter->created_at, 'Y/m/d')); ?>

                                        </span>
                                        <?php if($previewLetter->receivers()->exists()): ?>
                                            <span class="badge bg-info text-white me-2">
                                                <i class="fas fa-eye me-1"></i> <?php echo e($previewLetter->read_percentage); ?>% خوانده شده
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar avatar-xs me-2">
                                            <img src="<?php echo e($this->getUserProfilePhotoUrl($previewLetter->sender)); ?>">
                                        </div>
                                        <span class="text-muted small"><?php echo e($previewLetter->sender->name ?? '—'); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="p-4" style="min-height: 400px; max-height: 600px; overflow-y: auto;">
                                <div class="bg-white rounded-3 p-4 shadow-sm border">
                                    <?php echo $previewLetter->content; ?>

                                </div>
                            </div>
                        </div>
                        <div class="modal-footer bg-light p-4 d-flex justify-content-between">
                            <button class="btn btn-outline-secondary px-4 rounded-3" wire:click="closePreviewModal">
                                بستن
                            </button>
                            <div class="d-flex gap-2">
                                <?php if($previewLetterId && (auth()->id() === $previewLetter->sender_id || $previewLetter->status === 'pending')): ?>
                                    <button class="btn btn-primary px-4 rounded-3"
                                            wire:click="openSendPurposeModal(<?php echo e($previewLetterId); ?>)">
                                        <i class="fas fa-paper-plane me-1"></i> ارسال/ارجاع
                                    </button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Send Purpose Modal -->
        <?php if($showSendPurposeModal): ?>
            <?php
                $currentLetter = \App\Models\Letter::find($letter_id);
                $signerUser = $currentLetter?->user;
            ?>
            <div class="modal fade show d-block" style="background: rgba(15, 23, 42, 0.85);">
                <div class="modal-dialog modal-xl modal-dialog-centered">
                    <div class="modal-content border-0 rounded-4 shadow-lg">
                        <div class="modal-header" style="background: linear-gradient(90deg, #3b82f6 0%, var(--primary) 100%); color: white;">
                            <div class="d-flex flex-column">
                                <h5 class="modal-title fw-bold mb-1">
                                    <i class="fas fa-paper-plane me-2"></i> ارجاع نامه: <?php echo e(Str::limit($currentLetter?->title ?? 'نامه نامشخص', 60)); ?>

                                </h5>
                                <div class="text-white small opacity-75">
                                    <?php if($signerUser): ?>
                                        <i class="fas fa-signature me-1"></i> امضاکننده: <?php echo e($signerUser->name ?? '—'); ?>

                                        <?php if($currentLetter->signature_position): ?><span class="ms-1">(<?php echo e($currentLetter->signature_position); ?>)</span><?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <button type="button" class="btn-close btn-close-white" wire:click="closeSendPurposeModal"></button>
                        </div>
                        <form wire:submit.prevent="submitSendPurpose">
                            <div class="modal-body-referral">
                                <div class="col-md-5 user-list-pane">
                                    <div class="sticky-top bg-white pt-0 pb-3 border-bottom mb-3">
                                        <h6 class="fw-bold text-primary mb-2">انتخاب گیرندگان</h6>
                                        <div class="input-group mb-3">
                                            <span class="input-group-text rounded-start-3"><i class="fas fa-search text-primary"></i></span>
                                            <input type="text" class="form-control rounded-end-3"
                                                   wire:model.live.debounce.300ms="searchUser"
                                                   placeholder="جستجوی کاربران...">
                                        </div>
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox"
                                                       wire:click="toggleSelectAllUsers"
                                                       id="selectAllUsers"
                                                    <?php if(count($selectedUsers) === $users->count() && $users->isNotEmpty()): echo 'checked'; endif; ?>>
                                                <label class="form-check-label small fw-bold" for="selectAllUsers">
                                                    <i class="fas fa-users me-1 text-primary"></i> انتخاب همه
                                                </label>
                                            </div>
                                            <span class="badge bg-primary rounded-pill px-3 py-1 fw-bold">
                                                <?php echo e(count($selectedUsers)); ?> انتخاب شده
                                            </span>
                                        </div>
                                    </div>
                                    <div class="row g-2">
                                        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <?php
                                                $selected = in_array($user->id, $selectedUsers);
                                                $isSigner = ($user->id === $signerUser?->id);
                                            ?>
                                            <div class="col-12" wire:key="user-<?php echo e($user->id); ?>">
                                                <div class="card user-card-referral rounded-3 shadow-none <?php if($selected): ?> user-card-selected <?php endif; ?>">
                                                    <div class="card-body p-3">
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <label class="form-check-label d-flex align-items-center flex-grow-1" for="user_<?php echo e($user->id); ?>">
                                                                <div class="avatar avatar-sm me-3">
                                                                    <img src="<?php echo e($user->photo_url); ?>" alt="<?php echo e($user->name); ?>">
                                                                </div>
                                                                <div>
                                                                    <div class="fw-bold text-dark">
                                                                        <?php echo e($user->name); ?>

                                                                        <?php if($isSigner): ?>
                                                                            <i class="fas fa-user-tag text-accent small ms-1" title="امضاکننده نهایی"></i>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                    <div class="text-muted small"><?php echo e(Str::limit($user->email, 25)); ?></div>
                                                                </div>
                                                            </label>
                                                            <input class="form-check-input flex-shrink-0" type="checkbox"
                                                                   wire:model.live="selectedUsers"
                                                                   value="<?php echo e($user->id); ?>"
                                                                   id="user_<?php echo e($user->id); ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <div class="text-center py-5">
                                                <i class="fas fa-user-slash fa-3x text-muted mb-3"></i>
                                                <p class="text-muted fw-bold">کاربری یافت نشد.</p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-7 purpose-pane">
                                    <?php if(count($selectedUsers)): ?>
                                        <h5 class="fw-bold text-primary mb-4">
                                            <i class="fas fa-tasks me-2"></i> تعیین هدف ارجاع
                                        </h5>
                                        <?php $__currentLoopData = $selectedUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userId): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $user = $users->firstWhere('id', $userId);
                                                if (!$user) continue;
                                                $isSigner = ($userId === $signerUser?->id);
                                            ?>
                                            <div class="mb-4 p-3 rounded-3" style="border: 1px solid var(--border); background: var(--primary-50);">
                                                <h6 class="fw-bold mb-3 d-flex align-items-center text-dark">
                                                    <div class="avatar avatar-xs me-2">
                                                        <img src="<?php echo e($user->photo_url); ?>" alt="">
                                                    </div>
                                                    <?php echo e($user->name); ?>

                                                    <?php if($isSigner): ?> <span class="badge bg-accent ms-2">امضاکننده</span> <?php endif; ?>
                                                </h6>
                                                <div class="purpose-toggle-grid">
                                                    <?php $__currentLoopData = $purposesOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purpose => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $isSignerOption = ($purpose === 'امضا');
                                                            $hideOption = $isSignerOption && !$isSigner;
                                                        ?>
                                                        <?php if($hideOption): ?> <?php continue; ?> <?php endif; ?>

                                                        <input type="checkbox" class="btn-check"
                                                               wire:model="selectedPurposes.<?php echo e($userId); ?>.<?php echo e($purpose); ?>"
                                                               id="purpose_<?php echo e($userId); ?>_<?php echo e(Str::slug($purpose)); ?>"
                                                               autocomplete="off"
                                                            <?php if($isSignerOption && $isSigner && ($this->selectedPurposes[$userId][$purpose] ?? true)): echo 'checked'; endif; ?>>

                                                        <label class="btn purpose-toggle-button <?php echo e($details['color'] === 'success' ? 'btn-outline-success' : ($details['color'] === 'warning' ? 'btn-outline-warning' : ($details['color'] === 'info' ? 'btn-outline-info' : ($details['color'] === 'primary' ? 'btn-outline-primary' : 'btn-outline-secondary')))); ?>"
                                                               for="purpose_<?php echo e($userId); ?>_<?php echo e(Str::slug($purpose)); ?>"
                                                               data-bs-toggle="tooltip"
                                                               title="<?php echo e($details['description']); ?>">
                                                            <i class="<?php echo e($details['icon']); ?> me-1"></i>
                                                            <?php echo e($purpose); ?>

                                                        </label>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                                <?php $__errorArgs = ["selectedPurposes.{$userId}"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="text-danger small mt-2 fw-bold">
                                                    <i class="fas fa-exclamation-triangle me-1"></i> <?php echo e($message); ?>

                                                </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <div class="text-center py-5 border rounded-3 bg-light">
                                            <i class="fas fa-mouse-pointer fa-3x text-muted mb-3"></i>
                                            <p class="text-muted fw-bold">ابتدا کاربران را از سمت چپ انتخاب کنید.</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="modal-footer bg-light p-4">
                                <button type="button" class="btn btn-outline-secondary rounded-3 px-4"
                                        wire:click="closeSendPurposeModal">
                                    <i class="fas fa-times me-1"></i> انصراف
                                </button>
                                <button type="submit" class="btn btn-primary rounded-3 px-4"
                                        wire:loading.attr="disabled">
                                    <span wire:loading.remove>
                                        <i class="fas fa-paper-plane me-1"></i> ارسال ارجاع (<?php echo e(count($selectedUsers)); ?>)
                                    </span>
                                    <span wire:loading>
                                        <span class="spinner-border spinner-border-sm me-2"></span> در حال ارسال...
                                    </span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Referral Tree Modal -->
        <?php if($showReferralTreeModal): ?>
            <div class="modal fade show d-block" style="background: rgba(15, 23, 42, 0.7);">
                <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content border-0 rounded-4 shadow-lg">
                        <div class="modal-header" style="background: var(--secondary); color: white;">
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-sm bg-white bg-opacity-20 text-white rounded-circle me-3">
                                    <i class="fas fa-history"></i>
                                </div>
                                <h5 class="modal-title fw-bold">تاریخچه و مسیر ارجاعات</h5>
                            </div>
                            <button type="button" class="btn-close btn-close-white" wire:click="closeReferralTreeModal"></button>
                        </div>
                        <div class="modal-body p-0">
                            <div class="row g-0">
                                <div class="col-md-6 border-end">
                                    <div class="p-4">
                                        <h5 class="fw-bold text-primary mb-3">
                                            <i class="fas fa-sitemap me-2"></i> درخت ارجاعات
                                        </h5>
                                        <?php if(count($referralTree)): ?>
                                            <div class="ps-3">
                                                <?php $__currentLoopData = $referralTree; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $node): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php echo $__env->make('livewire.admin.letter.partials.referral-tree-node', [
                                                        'nodes' => [$node],
                                                        'level' => 0
                                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php else: ?>
                                            <div class="text-center py-4 bg-light rounded-3">
                                                <i class="fas fa-info-circle text-muted fs-1 mb-2"></i>
                                                <p class="text-muted">هیچ ارجاعی ثبت نشده است.</p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="p-4">
                                        <h5 class="fw-bold text-secondary mb-4">
                                            <i class="fas fa-list-ul me-2"></i> خط زمانی رویدادها
                                        </h5>
                                        <?php if($historyTimeline->isNotEmpty()): ?>
                                            <div class="timeline">
                                                <?php $__currentLoopData = $historyTimeline; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="d-flex mb-4">
                                                        <div class="avatar avatar-sm me-3 mt-1">
                                                            <img src="<?php echo e($this->getUserProfilePhotoUrl($event->user)); ?>">
                                                        </div>
                                                        <div class="text-start flex-grow-1">
                                                            <div class="fw-bold small mb-1"><?php echo e($event->user->name ?? '—'); ?></div>
                                                            <div class="text-muted small mb-1">
                                                                <i class="far fa-clock me-1"></i>
                                                                <?php echo e($this->formatShamsiDate($event->created_at, 'Y/m/d H:i')); ?>

                                                                <span class="badge bg-light text-dark ms-2"><?php echo e($event->type); ?></span>
                                                            </div>
                                                            <?php if($event->description): ?>
                                                                <div class="mt-1 bg-light p-2 rounded-2 small border">
                                                                    <?php echo e($event->description); ?>

                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php else: ?>
                                            <div class="text-center py-4 bg-light rounded-3">
                                                <i class="fas fa-clock text-muted fs-1 mb-2"></i>
                                                <p class="text-muted">هیچ رویدادی ثبت نشده است.</p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer bg-light p-4">
                            <button type="button" class="btn btn-outline-secondary rounded-3 px-4"
                                    wire:click="closeReferralTreeModal">
                                بستن
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <style>
        .bg-danger-subtle { background-color: #fee2e2; }
        .text-danger { color: #dc2626; }
        .bg-success-subtle { background-color: #f0fdf4; }
        .text-success { color: #059669; }
        .bg-warning-subtle { background-color: #fffbeb; }
        .text-warning { color: #d97706; }
        .bg-info-subtle { background-color: #eff6ff; }
        .text-info { color: #3b82f6; }
        .bg-primary-subtle { background-color: #eef2ff; }
        .text-primary { color: var(--bs-primary); }
        .bg-secondary-subtle { background-color: #f3f4f6; }
        .text-secondary { color: #6b7280; }
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(15px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .referral-tree-node {
            padding-inline-start: 35px;
        }
        .referral-tree-node > .referral-card-wrapper {
            padding-top: 15px;
        }
        .referral-tree-node::before {
            inset-inline-start: 12px;
            background-color: #e5e7eb;
        }
        .referral-tree-node.is-completed::before {
            background-color: var(--bs-success);
        }
        .referral-status-icon {
            width: 18px;
            height: 18px;
            border-width: 3px !important;
            left: 12px;
            margin-top: 3px;
        }
        .referral-tree-node .ps-4 {
            padding-inline-start: 24px !important;
        }
        .referral-tree-node .ps-4 > .w-px {
            left: 12px;
        }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\projects\project-letters-index.blade.php ENDPATH**/ ?>