<?php
    // ابزارهای کوچک برای تاریخ و لینک
    $toFa = function ($dt) {
        if (!$dt) return '-';
        try {
            if (function_exists('jdate')) return jdate($dt)->format('Y/m/d');
            return \Carbon\Carbon::parse($dt)->format('Y/m/d');
        } catch (\Throwable $e) { return '-'; }
    };
    $lastTrans = function ($doc) {
        return optional($doc->transmittalDocuments)->sortByDesc(
            fn($td)=> optional($td->transmittal)->sent_at
        )->first();
    };
?>

    <!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="utf-8">
    <title>MDR PDF - <?php echo e($project->name ?? ''); ?></title>
    <style>
        @page { margin: 90px 40px 70px 40px; }
        body { font-family: DejaVu Sans, sans-serif; direction: rtl; font-size: 12px; color: #222; }

        /* Header / Footer */
        header { position: fixed; top: -70px; left: 0; right: 0; height: 60px; }
        footer { position: fixed; bottom: -50px; left: 0; right: 0; height: 40px; font-size: 11px; color:#666; }

        .hdr {
            display:flex; justify-content:space-between; align-items:center; border-bottom:1px solid #ddd; padding-bottom:8px;
        }
        .hdr .title { font-size: 16px; font-weight: bold; }
        .meta { margin: 6px 0 0; font-size: 11px; color:#555; }
        .chips { margin-top: 6px; display:flex; flex-wrap:wrap; gap:6px; }
        .chip { background:#f3f4f6; border:1px solid #e5e7eb; padding:3px 8px; border-radius:6px; font-size:10px; }

        .stats { display:flex; gap:10px; margin: 10px 0 14px; }
        .stat { background:#f9fafb; border:1px solid #e5e7eb; border-radius:10px; padding:8px 10px; font-size:11px; }
        .stat b { font-size:12px; }

        h3.sec { margin:18px 0 8px; font-size:14px; color:#111; }

        table { width:100%; border-collapse: collapse; }
        th, td { border:1px solid #e5e7eb; padding:6px 8px; text-align:center; }
        thead th { background:#eef2ff; font-weight:bold; }
        tbody tr:nth-child(even) { background:#fafafa; }

        .badge { border-radius: 999px; padding:3px 8px; font-size:10px; display:inline-block; }
        .bg-success { background:#16a34a; color:#fff; }
        .bg-danger  { background:#dc2626; color:#fff; }
        .bg-warning { background:#f59e0b; color:#111; }
        .bg-secondary { background:#9ca3af; color:#fff; }

        .muted { color:#777; }
        .rtl { direction: rtl; text-align: right; }
        .page-break { page-break-after: always; }

        /* جلوگیری از شکستن ردیف‌ها وسط صفحه */
        tr { page-break-inside: avoid; }
        .group-head { background:#e5e7eb; font-weight:bold; text-align:right; }

        a { color:#0d6efd; text-decoration: none; }
        a:hover { text-decoration: underline; }
    </style>
</head>
<body>


<header>
    <div class="hdr">
        <div class="title">گزارش MDR پروژه</div>
        <div style="font-size:13px; font-weight:bold"><?php echo e($project->name ?? '-'); ?></div>
    </div>
    <div class="meta">
        تاریخ تهیه: <?php echo e($toFa(now())); ?>

        — کد پروژه: <?php echo e($project->code ?? '-'); ?>

    </div>
    <div class="chips">
        <span class="chip">جستجو: <?php echo e($filters['search'] ?? '-'); ?></span>
        <span class="chip">وضعیت: <?php echo e($filters['status'] ?: 'همه'); ?></span>
        <span class="chip">دیسپلین: <?php echo e($filters['discipline_id'] ?: 'همه'); ?></span>
        <span class="chip">وضعیت ترنسمیتال: <?php echo e($filters['transmittal_status'] ?: 'همه'); ?></span>
    </div>
    <div class="stats">
        <div class="stat">کل: <b><?php echo e($stats['total'] ?? 0); ?></b></div>
        <div class="stat">ارسال شده: <b><?php echo e($stats['sent'] ?? 0); ?></b></div>
        <div class="stat">تایید شده: <b><?php echo e($stats['approved'] ?? 0); ?></b></div>
        <div class="stat">رد شده: <b><?php echo e($stats['rejected'] ?? 0); ?></b></div>
    </div>
</header>


<footer>
    <div style="text-align:center;">مدیریت مدارک پروژه (MDR)</div>
    <script type="text/php">
        if (isset($pdf)) {
            $text = "صفحه {PAGE_NUM} از {PAGE_COUNT}";
            $size = 9;
            $font = $fontMetrics->get_font("DejaVu Sans", "normal");
            $pdf->page_text(520, 820, $text, $font, $size, array(0,0,0));
        }
    </script>
</footer>

<main>
    <?php
        // گروه‌بندی بر اساس نام دیسپلین (یا "نامشخص")
        $grouped = $documents->groupBy(fn($d)=> optional($d->discipline)->name ?? 'نامشخص');
        $row = 1;
        $discIndex = 0;
        $discTotal = $grouped->count();
    ?>

    <?php $__currentLoopData = $grouped; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $discName => $rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <h3 class="sec">دیسپلین: <?php echo e($discName); ?></h3>
        <table>
            <thead>
            <tr>
                <th>#</th>
                <th>شماره سند</th>
                <th class="rtl" style="text-align:right;">عنوان</th>
                <th>دسته‌بندی</th>
                <th>نوع</th>
                <th>نسخه</th>
                <th>وضعیت</th>
                <th>آخرین ترنسمیتال</th>
                <th>وضعیت ترنسمیتال</th>
                <th>تاریخ ارسال</th>
                <th>لینک فایل</th>
            </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $td = $lastTrans($doc);
                    $tr = $td?->transmittal;

                    $latestFile = $doc->documentFiles->first();
                    $fileUrl = $latestFile ? (Storage::disk('public')->url($latestFile->file_path)) : null;

                    $status = $doc->status ?: 'نامشخص';
                    $badgeClass =
                        $status === 'تایید شده' ? 'bg-success' :
                        ($status === 'رد شده' ? 'bg-danger' :
                        ($status === 'ارسال شده' ? 'bg-warning' : 'bg-secondary'));

                    $tStatus = $tr?->status ?: '-';
                    $tBadge =
                        $tStatus === 'تایید شده' ? 'bg-success' :
                        ($tStatus === 'رد شده' ? 'bg-danger' :
                        ($tStatus === 'ارسال شده' ? 'bg-warning' : 'bg-secondary'));

                    $sentAt = $tr?->sent_at ? $toFa($tr->sent_at) : '-';
                ?>
                <tr>
                    <td><?php echo e($row++); ?></td>
                    <td><?php echo e($doc->document_number); ?></td>
                    <td class="rtl" style="text-align:right;"><?php echo e($doc->title); ?></td>
                    <td><?php echo e($doc->category?->name ?? '-'); ?></td>
                    <td><?php echo e($doc->document_type ?? '-'); ?></td>
                    <td><?php echo e($doc->revision ?? '-'); ?></td>
                    <td><span class="badge <?php echo e($badgeClass); ?>"><?php echo e($status); ?></span></td>
                    <td><?php echo e($tr?->transmittal_number ?? '-'); ?></td>
                    <td><span class="badge <?php echo e($tBadge); ?>"><?php echo e($tStatus); ?></span></td>
                    <td><?php echo e($sentAt); ?></td>
                    <td>
                        <?php if($fileUrl): ?>
                            <a href="<?php echo e($fileUrl); ?>">دانلود</a>
                        <?php else: ?>
                            <span class="muted">-</span>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <?php $discIndex++; ?>
        <?php if($discIndex < $discTotal): ?>
            <div class="page-break"></div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</main>

</body>
</html>
<?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\exports\mdr-pdf.blade.php ENDPATH**/ ?>