<div class="card rounded-xl shadow-lg border-0 reminder-component-wrapper" dir="rtl">
    <div class="card-body p-4 p-md-5">

        <h2 class="fw-bolder mb-2 text-primary d-flex align-items-center">
            <i class="ti ti-alarm-plus me-2 fs-3"></i>
            مدیریت یادآوری‌های تماس 📞
        </h2>
        <p class="text-muted mb-5">
            یادآوری‌های خود را برنامه‌ریزی و پیگیری‌های ضروری را با دقت مدیریت کنید.
        </p>

        
        <div class="accordion" id="reminderAccordion">
            <div class="accordion-item border-0 rounded-xl shadow-sm mb-4">
                <h3 class="accordion-header">
                    <button class="accordion-button bg-primary-subtle fw-bold text-primary rounded-xl" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                        <i class="ti ti-calendar-plus me-2 fs-5"></i>
                        ایجاد یادآوری جدید
                    </button>
                </h3>
                <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#reminderAccordion">
                    <div class="accordion-body border-top p-4 bg-light-subtle rounded-bottom-xl">

                        
                        <form wire:submit.prevent="saveReminder" wire:loading.class="opacity-75" wire:target="saveReminder">
                            <div class="row g-4">

                                
                                <div class="col-md-6">
                                    <label class="form-label small fw-medium text-dark">مخاطب <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-white"><i class="ti ti-user-circle text-primary"></i></span>
                                        <select wire:model.live="contactId" class="form-select <?php $__errorArgs = ['contactId'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> rounded-end p-2">
                                            <option value="">— انتخاب مخاطب —</option>
                                            <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($contact->id); ?>"><?php echo e($contact->display_name ?? $contact->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['contactId'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                
                                <div class="col-md-6">
                                    <label class="form-label small fw-medium text-dark">تاریخ و زمان یادآوری (شمسی) <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-white"><i class="ti ti-calendar-time text-primary"></i></span>
                                        <input type="text" wire:model.live="reminderDateJalali" id="reminder_date_jalali"
                                               class="form-control <?php $__errorArgs = ['reminderDate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> rounded-end p-2 fw-bold text-success border-success"
                                               placeholder="مثال: ۱۴۰۴/۰۱/۳۰ ۰۹:۰۰">
                                        <?php $__errorArgs = ['reminderDate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        
                                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                
                                <div class="col-md-12">
                                    <label class="form-label small fw-medium text-dark">پیام یادآوری (اختیاری)</label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-white"><i class="ti ti-message-dots text-primary"></i></span>
                                        <input type="text" wire:model="newReminderMessage"
                                               class="form-control <?php $__errorArgs = ['newReminderMessage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> rounded-end p-2"
                                               placeholder="مثال: پیگیری فاکتور مشتری یا تماس جهت تبریک">
                                        <?php $__errorArgs = ['newReminderMessage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                
                                <div class="col-12 d-flex flex-column flex-md-row justify-content-between align-items-center gap-3 mt-4 pt-3 border-top">

                                    
                                    <button type="submit"
                                            wire:loading.attr="disabled"
                                            class="btn btn-primary px-4 rounded-pill shadow-sm flex-fill"
                                            
                                            wire:target="saveReminder"
                                            wire:dirty.attr="data-bs-toggle"
                                            wire:dirty.attr="data-bs-placement"
                                            title="برای ذخیره، فیلدهای مخاطب و تاریخ را پر کنید">

                                        <span wire:loading.remove wire:target="saveReminder"><i class="ti ti-check me-2"></i> ذخیره یادآوری</span>
                                        <span wire:loading wire:target="saveReminder"><i class="ti ti-loader ti-spin me-2"></i> در حال ذخیره‌سازی...</span>
                                    </button>

                                    
                                    <button type="button"
                                            wire:click="createSmartReminder" 
                                            wire:loading.attr="disabled"
                                            class="btn btn-outline-info px-4 rounded-pill shadow-sm flex-fill"
                                            data-bs-toggle="tooltip" data-bs-placement="top" title="ایجاد یادآوری برای عدم پیگیری‌های طولانی (زمان‌بندی: فردا ساعت ۱۰:۰۰)">
                                        <span wire:loading.remove wire:target="createSmartReminder"><i class="ti ti-robot me-1"></i> یادآوری هوشمند</span>
                                        <span wire:loading wire:target="createSmartReminder"><i class="ti ti-loader ti-spin me-2"></i> در حال بررسی وضعیت...</span>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        ---

        
        <h3 class="fw-bold mb-4 mt-5 d-flex align-items-center">
            <i class="ti ti-list-check me-2 text-dark fs-4"></i>
            یادآوری‌های فعال و آینده
            <span class="badge bg-danger rounded-pill me-2 fs-6 ms-auto"><?php echo e(number_format($callReminders->count())); ?></span>
        </h3>

        
        <div wire:poll.10s="loadReminders" wire:transition.opacity>
            <?php if($callReminders->isEmpty()): ?>
                <div class="text-center py-5 bg-light rounded-xl border border-dashed">
                    <i class="ti ti-inbox-off fs-1 text-muted d-block mb-3"></i>
                    <p class="text-muted fw-medium">هیچ یادآوری فعالی برای پیگیری وجود ندارد. وضعیت شما سبز است! 🎉</p>
                </div>
            <?php else: ?>
                <div class="list-group custom-reminder-list">
                    <?php $__currentLoopData = $callReminders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reminder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            // ... (منطق تعیین کلاس رنگی)
                            $diffInDays = $reminder->reminder_time->diffInDays(now(), false);
                            $diffForHumans = $reminder->reminder_time->diffForHumans();
                            $messageClass = 'text-dark';

                            if ($diffInDays == 0) { // امروز
                                $badgeClass = 'bg-warning-subtle text-warning border-warning-subtle';
                                $icon = 'ti ti-bell-ringing';
                                $borderClass = 'border-warning';
                            } elseif ($diffInDays <= 3 && $diffInDays > 0) { // 1 تا 3 روز آینده
                                $badgeClass = 'bg-danger-subtle text-danger border-danger-subtle';
                                $icon = 'ti ti-alert-triangle';
                                $borderClass = 'border-danger';
                                $messageClass = 'text-danger';
                            } else { // بیشتر از 3 روز
                                $badgeClass = 'bg-success-subtle text-success border-success-subtle';
                                $icon = 'ti ti-calendar-check';
                                $borderClass = 'border-success';
                            }
                        ?>
                        <div class="list-group-item d-flex justify-content-between align-items-center rounded-xl mb-3 p-3 shadow-hover <?php echo e($borderClass); ?>">

                            
                            <div class="d-flex align-items-start gap-3 flex-grow-1">
                                <div class="fw-bolder fs-4 flex-shrink-0 pt-1 text-primary">
                                    <i class="<?php echo e($icon); ?>"></i>
                                </div>
                                <div>
                                    <strong class="<?php echo e($messageClass); ?> d-block mb-1"><?php echo e($reminder->message); ?></strong>
                                    <span class="text-muted small">
                                        پیگیری مخاطب:
                                        <span class="fw-medium text-primary" data-bs-toggle="tooltip" data-bs-placement="top" title="شماره: <?php echo e($reminder->contact->phone_number ?? 'نامشخص'); ?>"><?php echo e($reminder->contact->display_name ?? $reminder->contact->name ?? '—'); ?></span>
                                    </span>
                                </div>
                            </div>

                            
                            <div class="text-end flex-shrink-0 ms-3 d-flex align-items-center gap-3">
                                <div>
                                    <span class="badge <?php echo e($badgeClass); ?> fw-bold border py-2 px-3 text-nowrap"><?php echo e($this->formatReminderTime($reminder->reminder_time)); ?></span>
                                    <small class="text-secondary d-block mt-1">(<?php echo e($diffForHumans); ?>)</small>
                                </div>

                                
                                <button class="btn btn-sm btn-outline-success p-2 rounded-circle shadow-sm"
                                        wire:click="completeReminder(<?php echo e($reminder->id); ?>)"
                                        wire:confirm="آیا مطمئن هستید که این یادآوری انجام شده است؟"
                                        data-bs-toggle="tooltip" data-bs-placement="top" title="انجام شد">
                                    <i class="ti ti-circle-check fs-6"></i>
                                </button>

                                
                                <button class="btn btn-sm btn-outline-danger p-2 rounded-circle shadow-sm"
                                        wire:click="deleteReminder(<?php echo e($reminder->id); ?>)"
                                        wire:confirm="آیا مطمئن هستید که می‌خواهید این یادآوری را حذف کنید؟"
                                        data-bs-toggle="tooltip" data-bs-placement="top" title="حذف یادآوری">
                                    <i class="ti ti-trash fs-6"></i>
                                </button>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </div>

    </div>

    
    <?php $__env->startPush('styles'); ?>
        <style>
            .reminder-component-wrapper { border: none; }
            .accordion-button:not(.collapsed) { background-color: var(--bs-primary-bg-subtle) !important; color: var(--bs-primary) !important; box-shadow: none; }
            .accordion-button:focus { box-shadow: none; }
            .custom-reminder-list .list-group-item {
                border: 1px solid #e5e7eb;
                transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
                background-color: #ffffff;
                border-right-width: 6px !important;
                border-right-style: solid !important;
                border-left: 1px solid #e5e7eb; /* تثبیت border-left */
            }
            .custom-reminder-list .list-group-item.border-warning { border-right-color: var(--bs-warning) !important; }
            .custom-reminder-list .list-group-item.border-danger { border-right-color: var(--bs-danger) !important; }
            .custom-reminder-list .list-group-item.border-success { border-right-color: var(--bs-success) !important; }

            .custom-reminder-list .list-group-item:hover {
                background-color: #f8f9fa;
                box-shadow: 0 4px 12px rgba(0,0,0,0.05);
                transform: translateY(-1px);
            }
        </style>
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('scripts'); ?>
        <script>
            // 💡 نام تابع برای persian-datepicker معمولاً 'persianDatepicker' است.
            window.initJalaliDatePicker = function() {
                const dateInput = document.getElementById('reminder_date_jalali');

                // اطمینان از وجود jQuery و تابع مورد نظر
                if (dateInput && typeof jQuery !== 'undefined' && typeof jQuery(dateInput).persianDatepicker === 'function') {

                    jQuery(dateInput).persianDatepicker({
                        format: 'YYYY/MM/DD HH:mm', // فرمت مورد نیاز شما
                        timePicker: {
                            enabled: true,
                            meridian: { enabled: false } // 24 ساعته
                        },
                        calendar: {
                            persian: { locale: 'en' }
                        },
                        autoClose: false,
                        initialValueType: 'persian',

                        // برای Livewire، بهتر است onSelect مقدار را به Livewire بفرستد
                        onSelect: function(unixTimestamp) {
                            const selectedDate = jQuery(dateInput).val();
                            // ارسال مقدار انتخاب شده (با فرمت YYYY/MM/DD HH:mm) به Livewire
                            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('reminderDateJalali', selectedDate);
                        }
                    });

                    console.log("Persian Date Picker initialized successfully.");

                } else if (dateInput) {
                    // اگر Date Picker لود نشده، این خطا نمایش داده می‌شود:
                    console.error("Error: Persian Date Picker library or jQuery is not defined or not initialized correctly.");
                }
            };

            // اجرای Date Picker پس از لود اولیه و در هر بار ناوبری Livewire
            document.addEventListener('livewire:initialized', () => {
                window.initJalaliDatePicker();
            });

            document.addEventListener('livewire:navigated', () => {
                window.initJalaliDatePicker();

                // فعال‌سازی Tooltip ها
                const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
                const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))
            });
        </script>
    <?php $__env->stopPush(); ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\contact\call-reminder-component.blade.php ENDPATH**/ ?>