<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>حساب کاربری غیرفعال | <?php echo e(config('app.name', 'Laravel')); ?></title>

    
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>


    <style>
        /* تنظیم فونت و رنگ پس‌زمینه جدید */
        body {
            /* استفاده از Tahoma به عنوان فونت پشتیبان شیک */
            font-family: Tahoma, 'IRANSans', Arial, sans-serif;
            background-color: #f0f2f5; /* خاکستری روشن و ملایم */
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            color: #34495e; /* رنگ متن اصلی */
        }

        /* استایل Container شیک‌تر */
        .container {
            background-color: #ffffff;
            padding: 50px 40px; /* فضای داخلی بیشتر */
            border-radius: 16px; /* گوشه‌های گردتر */
            /* سایه متریال عمیق‌تر و ظریف‌تر */
            box-shadow: 0 12px 30px rgba(0, 0, 0, 0.15);
            max-width: 480px; /* کمی پهن‌تر */
            width: 90%;
            text-align: center;
            border: 1px solid #e0e0e0; /* حاشیه نازک برای عمق بیشتر */
        }

        /* آیکون هشدار */
        .icon {
            font-size: 3.5rem;
            color: #f39c12;
            margin-bottom: 15px;
            animation: pulse 1.5s infinite;
        }
        .icon-title-group {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 20px;
        }

        /* عنوان اصلی */
        h1 {
            color: #2c3e50;
            font-size: 2.1rem;
            font-weight: 700;
            margin: 0;
        }

        /* پاراگراف توضیحی */
        p {
            color: #7f8c8d;
            line-height: 1.8;
            font-size: 1rem;
            margin-bottom: 35px;
        }

        /* دکمه‌ها */
        .action-button {
            display: inline-block;
            padding: 14px 30px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: bold;
            font-size: 1rem;
            transition: all 0.3s ease;
            margin: 8px;
            border: none;
            cursor: pointer;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        /* دکمه بازگشت به ورود */
        .btn-login {
            background-color: #bdc3c7;
            color: #34495e;
            margin-top: 25px !important;
        }
        .btn-login:hover {
            background-color: #95a5a6;
            color: white;
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }

        /* خط جداکننده اطلاعات پشتیبانی */
        .separator {
            margin-top: 40px !important;
            border: 0;
            border-top: 1px solid #ecf0f1;
        }

        /* اطلاعات پشتیبانی */
        .support-info {
            font-size: 0.9rem;
            color: #95a5a6;
            margin-top: 20px;
            line-height: 1.6;
        }
        .support-info strong {
            color: #7f8c8d;
        }

        /* انیمیشن برای آیکون هشدار */
        @keyframes pulse {
            0% { transform: scale(1); opacity: 1; }
            50% { transform: scale(1.05); opacity: 0.8; }
            100% { transform: scale(1); opacity: 1; }
        }
    </style>
</head>
<body>
<div class="container">
    <div class="icon-title-group">
        <div class="icon">⚠️</div>
        <h1 style="margin-right: 15px;">حساب کاربری غیرفعال</h1>
    </div>

    <p>
        **دسترسی شما موقتاً محدود شده است.** حساب کاربری شما در حال حاضر غیرفعال است.
        <br>
        شما می‌توانید با استفاده از دکمه زیر، از مدیر سیستم **درخواست فعال‌سازی مجدد** ارسال کنید.
    </p>

    
    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('account-inactive-notifier');

$__html = app('livewire')->mount($__name, $__params, 'lw-4226916984-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

    <a href="<?php echo e(route('login')); ?>" class="action-button btn-login">
        بازگشت به صفحه ورود
    </a>

    <hr class="separator">
    <p class="support-info">
        **مشکل فوری دارید؟** برای دریافت کمک سریع‌تر، با پشتیبانی تماس بگیرید:
        <br>
        ایمیل: <a href="mailto:support@yourcompany.com" style="color: #3498db; text-decoration: none;">support@yourcompany.com</a> | تلفن: <span style="direction: ltr; display: inline-block;">(۹۸) ۲۱ - ۱۲۳۴۵۶۷۸</span>
    </p>
</div>


<?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

</body>
</html>
<?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\account-inactive.blade.php ENDPATH**/ ?>