<div class="letter-show-container rtl" dir="rtl"
     x-data="{
         // تعریف تابع به صورت فشرده برای جلوگیری از خطای Alpine Syntax
         showTooltip() {
             if (typeof bootstrap !== 'undefined') {
                 var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle=&quot;tooltip&quot;]'));
                 tooltipTriggerList.map(function (tooltipTriggerEl) {
                     return new bootstrap.Tooltip(tooltipTriggerEl)
                 })
             }
         }
     }"
     x-init="() => {
         showTooltip();
         Livewire.on('focus-comment-input', () => {
             document.getElementById('newCommentInput').focus();
         });
     }"
     style="font-family: 'Vazirmatn', 'Segoe UI', sans-serif;"
>
    
    <style>
        :root {
            --primary: #3B82F6; /* Blue 500 */
            --primary-700: #1F2937; /* Slate 800 - رنگ جدید و حرفه‌ای هدر */
            --primary-50: #EFF6FF; /* Blue 50 */
            --success: #059669;
            --warning: #D97706;
            --danger: #DC2626;
            --gray-100: #F3F4F6;
            --gray-300: #D1D5DB;
            --gray-900: #111827;
            --card-bg: #FFFFFF;
            --border-color: #E5E7EB;
            --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);
            --info: #0EA5E9;
            --text-light: #F3F4F6;
        }

        .letter-show-container { max-width: 1400px; margin: 0 auto; padding: 24px; }
        .card { background: var(--card-bg); border-radius: 18px; border: 1px solid var(--border-color); overflow: hidden; box-shadow: none; }
        .card-header-styled { padding: 16px 24px; font-weight: 700; font-size: 1.1rem; border-bottom: 1px solid var(--border-color); background: var(--gray-100); color: var(--gray-900); }
        .letter-content { font-size: 1.05rem; line-height: 1.8; color: var(--gray-900); padding: 24px; min-height: 200px; }

        /* ✨ هدر جدید: تم مشکی/آبی حرفه‌ای و تمیز */
        .letter-header {
            position: relative; padding: 20px 30px; border-radius: 16px;
            background: var(--primary-700);
            color: white; box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.2); margin-bottom: 24px;
        }
        .header-title {
            font-size: 2rem;
            font-weight: 700;
            line-height: 1.2;
            color: white;
        }

        /* نوار اطلاعاتی زیر هدر */
        .header-info-bar {
            background: rgba(255, 255, 255, 0.1);
            padding: 10px 20px;
            border-radius: 10px;
            margin-top: 15px;
            display: flex;
            justify-content: space-between;
            gap: 10px;
            flex-wrap: wrap;
        }
        .info-item {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 0.9rem;
            padding: 5px 0;
        }
        .info-item-icon { /* کنترل رنگ آیکون‌ها در نوار اطلاعات */
            background: rgba(255, 255, 255, 0.2);
            padding: 4px 6px;
            border-radius: 5px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-width: 25px;
        }


        .referral-avatar { width: 48px; height: 48px; border-radius: 50%; object-fit: cover; }
        .comment-avatar { width: 36px; height: 36px; }
        .active-referral-list { padding: 16px 24px; display: flex; align-items: center; gap: 12px; flex-wrap: wrap; }
        .status-dot { position: absolute; top: -2px; right: -2px; width: 12px; height: 12px; border-radius: 50%; border: 3px solid white; z-index: 10; }
        .status-dot.completed { background-color: var(--success); }
        .status-dot.pending { background-color: var(--warning); }
        .status-dot.canceled { background-color: var(--danger); }
        .status-dot.viewed { background-color: var(--primary); }

        /* استایل‌های آکاردئون */
        .accordion-item { border: 1px solid var(--border-color); border-radius: 18px !important; margin-bottom: 15px; box-shadow: var(--shadow-xl); overflow: hidden; }
        .accordion-button:not(.collapsed) { color: var(--primary-700); background-color: var(--primary-50); box-shadow: none; border-bottom: 1px solid var(--border-color); }
        .accordion-button { padding: 16px 24px; font-weight: 700; font-size: 1.1rem; }
        .accordion-flush .accordion-item { border-left: none; border-right: none; border-bottom: none; }
        .accordion-flush .accordion-item:last-child { border-bottom: none; }
        .accordion-flush .accordion-item:first-child { border-top: none; }
    </style>

    
    <div class="letter-header">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start gap-3">
            <div class="d-flex flex-column">
                
                <h1 class="header-title"><?php echo e($letter->title); ?></h1>
                <p class="text-gray-300 mt-1 mb-0" style="font-size: 1rem;">
                    ایجاد شده توسط: <?php echo e($letter->sender->name ?? '—'); ?>

                </p>
            </div>

            
            <div class="header-actions d-flex gap-3 flex-wrap justify-content-end align-items-center">

                <button wire:click="downloadPdf" class="btn btn-light d-flex align-items-center gap-1 fw-bold rounded-pill text-primary">
                    <i class="fas fa-file-pdf"></i> PDF
                </button>

                <button wire:click="openReferralTreeModal" class="btn btn-outline-light d-flex align-items-center gap-1 fw-bold rounded-pill">
                    <i class="fas fa-sitemap"></i> گردش کار
                </button>

                <?php if($this->canEdit): ?>
                    <a href="<?php echo e(route('admin.edit.letter', ['letter' => $letter->id])); ?>"
                       class="btn btn-outline-light d-flex align-items-center gap-1 fw-bold rounded-pill">
                        <i class="fas fa-edit"></i> ویرایش
                    </a>
                <?php endif; ?>
            </div>
        </div>

        
        <div class="header-info-bar">

            
            <div class="info-item">
                <span class="info-item-icon"><i class="fas fa-hashtag"></i></span> <span class="fw-medium text-gray-200">کد:</span> <span class="fw-bold"><?php echo e($letter->code ?? '—'); ?></span>
            </div>

            
            <div class="info-item">
                <span class="info-item-icon"><i class="far fa-calendar-alt"></i></span> <span class="fw-medium text-gray-200">تاریخ:</span> <span><?php echo e($this->shamsiCreatedDate); ?></span>
            </div>

            
            <?php
                $priorityColor = match($letter->priority) { 'urgent' => 'var(--danger)', 'high' => 'var(--warning)', default => 'var(--success)', };
            ?>
            <div class="info-item">
                <span class="info-item-icon" style="background: <?php echo e($priorityColor); ?>;"><i class="fas fa-star"></i></span> <span class="fw-medium text-gray-200">اولویت:</span> <span><?php echo e($letter->priorityLabel()); ?></span>
            </div>

            
            <div class="info-item">
                <span class="info-item-icon"><i class="fas fa-check-double"></i></span> <span class="fw-medium text-gray-200">وضعیت:</span>
                <span class="badge rounded-pill" style="background: var(--primary); font-weight: 500;"><?php echo e($letter->statusLabel()); ?></span>
            </div>
        </div>
    </div>

    <div class="row g-5">
        
        <div class="col-lg-8">
            <div class="card mb-5" style="box-shadow: var(--shadow-xl);">
                <div class="card-header-styled"><i class="fas fa-file-alt text-primary me-2"></i> متن اصلی نامه</div>
                <div class="letter-content">
                    <?php echo $letter->content; ?>

                </div>
            </div>

            
            <?php if(in_array($letter->status, ['approved', 'completed', 'signed'])): ?>
                <div class="card p-4 mb-5 border-success shadow-xl" style="border-radius: 18px; border-left: 6px solid var(--success);">
                    <div class="d-flex align-items-center gap-3">
                        <i class="fas fa-signature fs-2 text-success"></i>
                        <div>
                            <h5 class="mb-0 fw-bold text-success">امضای رسمی و تکمیل‌شده</h5>
                            <p class="text-muted small mb-0">این نامه با موفقیت توسط مرجع ذی‌صلاح تأیید نهایی شده است.</p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            
            <?php if($letter->attachments->count()): ?>
                <div class="accordion accordion-flush" id="attachmentsAccordion">
                    <div class="accordion-item card" style="box-shadow: var(--shadow-xl);">
                        <h2 class="accordion-header">
                            <button class="accordion-button fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAttachments" aria-expanded="true" aria-controls="collapseAttachments" style="background: var(--gray-100);">
                                <i class="fas fa-paperclip text-primary me-2"></i> پیوست‌ها (<?php echo e($letter->attachments->count()); ?>)
                            </button>
                        </h2>
                        <div id="collapseAttachments" class="accordion-collapse collapse show" data-bs-parent="#attachmentsAccordion">
                            <div class="card-body p-0">
                                <?php $__currentLoopData = $letter->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $att): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="d-flex align-items-center justify-content-between p-4 border-bottom">
                                        <div class="d-flex align-items-center gap-3">
                                            <div class="attachment-icon d-flex align-items-center justify-content-center text-primary" style="width: 48px; height: 48px; border-radius: 10px; background: var(--primary-50);">
                                                <i class="fas fa-file-alt fs-5"></i>
                                            </div>
                                            <div>
                                                <div class="fw-bold"><?php echo e($att->file_name); ?></div>
                                                <div class="text-muted small">
                                                    <?php echo e(number_format($att->file_size / 1024, 1)); ?> KB
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-flex gap-2">
                                            <a href="<?php echo e(Storage::url($att->file_path)); ?>" class="btn btn-primary btn-sm rounded-pill" download>
                                                <i class="fas fa-download me-1"></i> دانلود
                                            </a>
                                            <?php if(in_array(strtolower(pathinfo($att->file_name, PATHINFO_EXTENSION)), ['jpg', 'jpeg', 'png', 'pdf'])): ?>
                                                <a href="<?php echo e(Storage::url($att->file_path)); ?>" class="btn btn-outline-secondary btn-sm rounded-pill" target="_blank">
                                                    <i class="fas fa-eye me-1"></i> پیش‌نمایش
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        
        <div class="col-lg-4">

            
            <?php if($referral): ?>
                <div class="card p-4 mb-4" style="box-shadow: var(--shadow-xl); border-left: 6px solid <?php if($referral->status === 'pending'): ?> var(--warning) <?php elseif($referral->status === 'viewed'): ?> var(--info) <?php elseif($referral->status === 'canceled'): ?> var(--danger) <?php else: ?> var(--success) <?php endif; ?>;">
                    <h5 class="fw-bold mb-1 d-flex align-items-center gap-2"
                        style="color: <?php if($referral->status === 'pending'): ?> var(--warning) <?php elseif($referral->status === 'viewed'): ?> var(--info) <?php elseif($referral->status === 'canceled'): ?> var(--danger) <?php else: ?> var(--success) <?php endif; ?>;">
                        <i class="fas fa-bullhorn"></i> وضعیت ارجاع شما:
                    </h5>
                    <p class="fw-bolder mb-0 fs-5">
                        <?php echo e($this->referral->statusLabel()); ?>

                    </p>
                    <p class="text-muted small mt-2 mb-0">ارجاع توسط: <?php echo e($referral->creator->name ?? 'سیستم'); ?> در <?php echo e($this->shamsiReferralDate); ?></p>
                    <?php if($referral->comment): ?>
                        <div class="alert alert-light small p-2 mt-3 mb-0 border-primary rounded-3">
                            <i class="fas fa-comment me-1 text-primary"></i> **یادداشت ارجاع‌دهنده:** <?php echo e($referral->comment); ?>

                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            
            <div class="accordion accordion-flush" id="sidebarAccordion">

                
                <?php if($referral && $this->canAct): ?>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button fw-bold collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseActions" aria-expanded="false" aria-controls="collapseActions" style="background: var(--gray-100);">
                                <i class="fas fa-cogs text-primary me-2"></i> اقدامات مورد نیاز
                            </button>
                        </h2>
                        <div id="collapseActions" class="accordion-collapse collapse" data-bs-parent="#sidebarAccordion">
                            <div class="accordion-body p-4">
                                <div class="action-btn-group d-grid gap-3">
                                    <div class="d-flex gap-3">
                                        <button wire:click="openActionModal('approve')" class="btn btn-success flex-grow-1 rounded-pill">
                                            <i class="fas fa-check me-1"></i> تأیید نهایی / تکمیل
                                        </button>
                                        <button wire:click="openActionModal('correction')" class="btn btn-warning flex-grow-1 rounded-pill">
                                            <i class="fas fa-undo me-1"></i> بازگشت برای تصحیح
                                        </button>
                                    </div>
                                    <button wire:click="openActionModal('view')" class="btn btn-outline-primary btn-sm rounded-pill">
                                        <i class="fas fa-eye me-1"></i> صرفاً مشاهده شد
                                    </button>

                                    <hr class="my-2">

                                    <button wire:click="openHandoffModal" class="btn btn-outline-secondary rounded-pill">
                                        <i class="fas fa-exchange-alt me-1"></i> واگذاری/ارجاع به همکار
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                
                <?php if($this->activeReferrals->isNotEmpty()): ?>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button fw-bold collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseReferrals" aria-expanded="false" aria-controls="collapseReferrals" style="background: var(--gray-100);">
                                <i class="fas fa-users-cog text-primary me-2"></i> ارجاع‌گیرندگان فعال
                            </button>
                        </h2>
                        <div id="collapseReferrals" class="accordion-collapse collapse" data-bs-parent="#sidebarAccordion">
                            <div class="accordion-body p-0">
                                <div class="active-referral-list">
                                    <?php $__currentLoopData = $this->activeReferrals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ref): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="active-referral-item"
                                             data-bs-toggle="tooltip"
                                             data-bs-placement="top"
                                             data-bs-html="true"
                                             title="<div class='text-start small fw-bold mb-1'><?php echo e($ref->name); ?></div><div class='small'><?php echo e($ref->typeLabel); ?> | وضعیت: <?php echo e($ref->statusLabel); ?></div><div class='small text-muted'>داخلی: <?php echo e($ref->internalNumber); ?></div>">

                                            <img src="<?php echo e($ref->photoUrl); ?>" class="referral-avatar" alt="<?php echo e($ref->name); ?>">

                                            <span class="status-dot <?php if($ref->status === 'completed'): ?> completed <?php elseif($ref->status === 'pending'): ?> pending <?php elseif($ref->status === 'canceled'): ?> canceled <?php else: ?> viewed <?php endif; ?>"></span>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                
                <?php if($referral || $letter->sender_id === Auth::id()): ?>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseComments" aria-expanded="true" aria-controls="collapseComments" style="background: var(--gray-100);">
                                <i class="fas fa-comments text-primary me-2"></i> گفتگو و نظرات
                            </button>
                        </h2>
                        <div id="collapseComments" class="accordion-collapse collapse show" data-bs-parent="#sidebarAccordion">
                            <div class="accordion-body p-4">

                                
                                <div class="d-flex justify-content-end align-items-center mb-3">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <button type="button"
                                                wire:click="$set('sortOrder', 'latest')"
                                                class="btn <?php if(isset($sortOrder) && $sortOrder === 'latest'): ?> btn-primary <?php else: ?> btn-outline-secondary <?php endif; ?> rounded-start-pill">
                                            <i class="fas fa-sort-amount-down-alt me-1"></i> جدیدترین
                                        </button>
                                        <button type="button"
                                                wire:click="$set('sortOrder', 'oldest')"
                                                class="btn <?php if(isset($sortOrder) && $sortOrder === 'oldest'): ?> btn-primary <?php else: ?> btn-outline-secondary <?php endif; ?> rounded-end-pill">
                                            <i class="fas fa-sort-amount-up-alt me-1"></i> قدیمی‌ترین
                                        </button>
                                    </div>
                                </div>

                                <?php $__errorArgs = ['newComment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="alert alert-danger small"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                
                                <?php if($referral || $letter->sender_id === Auth::id()): ?>
                                    <form wire:submit.prevent="postComment" class="mb-4 bg-light p-3 rounded-4 border">
                                        <h6 class="fw-bold small mb-2 text-primary">ارسال پیام:</h6>
                                        <textarea class="form-control rounded-3" wire:model="newComment" id="newCommentInput"
                                                  placeholder="<?php echo e($replyParentId ? 'در حال پاسخ به یک نظر...' : 'نظر خود را بنویسید...'); ?>"
                                                  rows="3" required></textarea>
                                        <div class="d-flex justify-content-between align-items-center mt-3">
                                            <button type="submit" class="btn btn-primary btn-sm rounded-pill">
                                                <i class="fas fa-paper-plane me-1"></i> ارسال
                                            </button>
                                            <?php if($replyParentId): ?>
                                                <button type="button" wire:click="$set('replyParentId', null)"
                                                        class="btn btn-outline-secondary btn-sm rounded-pill">
                                                    <i class="fas fa-times me-1"></i> لغو پاسخ
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </form>
                                <?php endif; ?>

                                
                                <div class="comment-list">
                                    <?php $__empty_1 = true; $__currentLoopData = $this->allComments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php echo $__env->make('livewire.admin.letter.partials.comment-styled', [
                                            'comment' => $comment,
                                            'replyParentId' => $replyParentId,
                                            'isReply' => false,
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="text-center py-5 text-muted">
                                            <i class="fas fa-comment-dots fs-3 mb-2"></i>
                                            <p>هنوز گفتگویی انجام نشده است.</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <?php echo $__env->make('livewire.admin.letter.partials.modals-styled', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\letter\PdfShow.blade.php ENDPATH**/ ?>