<div class="letter-edit-container rtl" dir="rtl"
     x-data="{
         cc_name: <?php if ((object) ('cc_name') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('cc_name'->value()); ?>')<?php echo e('cc_name'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('cc_name'); ?>')<?php endif; ?>.live,
         cc_position: <?php if ((object) ('cc_position') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('cc_position'->value()); ?>')<?php echo e('cc_position'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('cc_position'); ?>')<?php endif; ?>.defer,
         confidential: <?php if ((object) ('confidential') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('confidential'->value()); ?>')<?php echo e('confidential'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('confidential'); ?>')<?php endif; ?>.defer,

         removeAttachment(index) {
             window.Livewire.find('<?php echo e($_instance->getId()); ?>').removeAttachment(index);
         },
         isCcNameEmpty() {
             return !cc_name || (typeof cc_name === 'string' && cc_name.trim() === '');
         }
     }" x-cloak>
    <style>
        :root {
            --primary: #4f46e5;
            --primary-light: #eef2ff;
            --danger: #ef4444;
            --success: #10b981;
            --warning: #ff9f1c;
            --border: #e5e7eb;
            --light: #f9fafb;
            --shadow: 0 8px 16px rgba(0,0,0,0.05);
            --header-bg: #f5f7f9;
        }
        .letter-edit-container { max-width: 1000px; margin: 0 auto; padding: 20px; }
        .page-header { background: white; border-radius: 16px; padding: 24px; box-shadow: var(--shadow); }
        .form-card { border-radius: 16px; box-shadow: var(--shadow-lg); padding: 30px; background: white; }
        .form-label { font-weight: 700; color: #374151; font-size: 0.95rem; margin-bottom: 0.6rem; display: flex; align-items: center; }
        .form-control, .form-select { border-radius: 12px; border: 1px solid #d1d5db; padding: 0.85rem 1rem; font-size: 1rem; }
        .required::after { content: ' *'; color: var(--danger); }
        .field-grid-2 { display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 1.5rem; }
        .revision-alert { border: 2px solid var(--warning); background: #fffbeb; color: var(--warning); padding: 15px; border-radius: 12px; font-weight: 600; }
        .cc-suggestions { position: absolute; z-index: 10; background: white; border: 1px solid var(--border); border-radius: 8px; box-shadow: var(--shadow); max-height: 200px; overflow-y: auto; width: 100%; top: 100%; margin-top: 2px; }
        .cc-suggestions-item:hover { background-color: var(--primary-light); color: var(--primary); }
        .cc-tag { background: var(--primary-light); color: var(--primary); padding: 6px 12px; border-radius: 20px; font-weight: 600; margin: 4px 4px 4px 0; display: inline-flex; align-items: center; }
        .uploader-box { border: 2px dashed var(--primary); background: var(--primary-light); border-radius: 12px; padding: 2rem; text-align: center; cursor: pointer; }
        .file-list li { list-style: none; border: 1px solid var(--primary-light); background: #f7f7f7; border-radius: 8px; padding: 10px 15px; display: flex; justify-content: space-between; align-items: center; }
    </style>

    <div class="container-fluid">
        <div class="page-header mb-4">
            <h2 class="fw-bold text-gray-800" style="color: var(--primary-700);">
                <i class="fas fa-<?php echo e($isEditing ? 'edit' : 'plus-circle'); ?> me-2"></i> <?php echo e($pageTitle); ?>

            </h2>
            <?php if($isCreatingNewRevision): ?>
                <div class="revision-alert mt-3">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    در حال ایجاد **نسخه جدید** از نامه امضا شده (ID: #<?php echo e($letter->id); ?>). این نسخه پیش‌نویس خواهد بود.
                </div>
            <?php endif; ?>
        </div>

        <form wire:submit.prevent="save" class="form-card">

            <div class="form-section p-0 m-0 border-0 shadow-none">
                <h4><i class="fas fa-info-circle me-2"></i> اطلاعات پایه</h4>

                <div class="mb-4">
                    <label class="form-label required">عنوان نامه</label>
                    <input type="text" wire:model.defer="title" class="form-control" placeholder="موضوع اصلی نامه">
                    <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="field-grid-2 mb-4">
                    <div>
                        <label class="form-label required">از طرف</label>
                        <input type="text" class="form-control" wire:model.defer="from_who" placeholder="نام یا واحد فرستنده">
                        <?php $__errorArgs = ['from_who'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div>
                        <label class="form-label required">به:</label>
                        <input type="text" class="form-control" wire:model.defer="to_who" placeholder="نام یا واحد گیرنده">
                        <?php $__errorArgs = ['to_who'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="field-grid-2">
                    <div wire:ignore>
                        <label class="form-label required"><i class="fas fa-calendar-alt select-icon"></i> تاریخ نامه (شمسی)</label>
                        <input
                            type="text"
                            class="form-control"
                            wire:model.live="letter_date_shamsi"
                            id="shamsi-date-input"
                            placeholder="انتخاب تاریخ شمسی"
                        >
                        <input type="hidden" wire:model="letter_date" id="letter-date-gregorian">
                        <?php $__errorArgs = ['letter_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php $__errorArgs = ['letter_date_shamsi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div>
                        <label class="form-label required"><i class="fas fa-file-image select-icon"></i> قالب سربرگ</label>
                        <select class="form-select" wire:model.defer="background_id">
                            <option value="">-- انتخاب کنید --</option>
                            <?php $__currentLoopData = $forms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $form): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($form->id); ?>"><?php echo e($form->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['background_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="form-section mt-4">
                <h4><i class="fas fa-pen-nib me-2"></i> محتوای نامه</h4>
                <label class="form-label required">متن نامه</label>
                <div class="tinymce-container" wire:ignore>
                    <textarea id="letter-content"><?php echo e($content); ?></textarea>
                </div>
                <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-section mt-4">
                <h4><i class="fas fa-signature me-2"></i> امضا و ارجاع</h4>
                <div class="field-grid-2">
                    <div>
                        <label class="form-label required"><i class="fas fa-user-check select-icon"></i> امضاکننده</label>
                        <select class="form-select" wire:model.live="signer_id">
                            <option value="">-- انتخاب کنید --</option>
                            <?php $__currentLoopData = $allUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['signer_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div>
                        <label class="form-label required">سمت امضاکننده</label>
                        <select class="form-select" wire:model.defer="signature_position" <?php if(empty($signerPositions)): ?> disabled <?php endif; ?>>
                            <?php if(empty($signerPositions)): ?>
                                <option value="">امضاکننده را انتخاب کنید</option>
                            <?php else: ?>
                                <option value="">انتخاب سمت</option>
                                <?php $__currentLoopData = $signerPositions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $position): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($position); ?>"><?php echo e($position); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                        <?php $__errorArgs = ['signature_position'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="form-section mt-4">
                <h4><i class="fas fa-cogs me-2"></i> تنظیمات متفرقه</h4>

                <div class="field-grid-2">
                    <div>
                        <label class="form-label"><i class="fas fa-hourglass-half select-icon"></i> اولویت</label>
                        <select class="form-select" wire:model.defer="priority">
                            <?php $__currentLoopData = ['low' => 'کم', 'normal' => 'عادی', 'high' => 'بالا', 'urgent' => 'فوری']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($value); ?>"><?php echo e($label); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['priority'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div>
                        <label class="form-label"><i class="fas fa-tags select-icon"></i> طبقه‌بندی (اختیاری)</label>
                        <select class="form-select" wire:model.defer="classification_id">
                            <option value="">-- انتخاب کنید --</option>
                            <?php $__currentLoopData = $classifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($classification->id); ?>"><?php echo e($classification->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['classification_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div>
                        <label class="form-label"><i class="fas fa-user-shield select-icon"></i> محرمانگی</label>
                        <div class="form-check pt-2">
                            <input class="form-check-input" type="checkbox" wire:model.defer="confidential" id="confidential" style="width:20px;height:20px;">
                            <label class="form-check-label text-gray-600 me-2" for="confidential">
                                این نامه محرمانه است
                            </label>
                        </div>
                    </div>

                </div>
            </div>

            <div class="form-section mt-4">
                <h4><i class="fas fa-users me-2"></i> رونوشت (CC)</h4>
                <div class="input-group mb-3 d-flex gap-3">
                    <div class="position-relative" style="flex: 1.5;">
                        <input type="text" class="form-control" wire:model.live.debounce.250ms="cc_name" placeholder="نام رونوشت (مثلا: مدیریت یا نام کاربر)">

                        <?php if(!empty($cc_users_suggestions)): ?>
                            <div class="cc-suggestions">
                                <?php $__currentLoopData = $cc_users_suggestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="cc-suggestions-item" wire:click="selectCcUser(<?php echo e($user->id); ?>, '<?php echo e($user->name); ?>')">
                                        <?php echo e($user->name); ?>

                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                    </div>

                    <input type="text" class="form-control" wire:model.defer="cc_position" placeholder="سمت (اختیاری)" style="flex: 1;">
                    <button class="btn btn-primary" type="button" wire:click="addCc" :disabled="isCcNameEmpty()">
                        <i class="fas fa-plus"></i> افزودن
                    </button>
                </div>
                <?php $__errorArgs = ['cc_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                <div class="mt-3" style="min-height: 20px;">
                    <?php $__currentLoopData = $ccs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $cc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span class="cc-tag" wire:key="cc-<?php echo e($i); ?>">
                            <?php echo e($cc['name']); ?> <?php if($cc['position']): ?> (<?php echo e($cc['position']); ?>) <?php endif; ?>
                            <button type="button" wire:click="removeCc(<?php echo e($i); ?>)"><i class="fas fa-times"></i></button>
                        </span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <div class="form-section mt-4">
                <h4><i class="fas fa-paperclip me-2"></i> پیوست‌ها</h4>

                <div class="mt-4">
                    <label class="form-label">انتخاب فایل‌ها (اختیاری)</label>
                    <label for="attachment-uploader" class="uploader-box">
                        <div class="uploader-icon-container">
                            <i class="fas fa-cloud-upload-alt"></i>
                        </div>
                        <p class="text-gray-600 font-semibold mb-1">فایل‌ها را بکشید و رها کنید</p>
                        <span class="text-sm text-gray-500">یا برای انتخاب فایل کلیک کنید (حداکثر ۱۰ مگابایت)</span>
                    </label>
                    <input type="file" id="attachment-uploader" class="form-control" multiple wire:model="attachments" style="display:none;">

                    <?php if(count($attachments)): ?>
                        <ul class="file-list mt-3 list-unstyled">
                            <?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li wire:key="attachment-<?php echo e($index); ?>">
                                    <span>
                                        <i class="fas fa-file-alt me-2"></i>
                                        <span class="text-truncate" style="max-width: 250px;"><?php echo e(is_string($file) ? $file : $file->getClientOriginalName()); ?></span>
                                    </span>
                                    <button type="button" class="text-danger hover:text-red-700" wire:click="removeAttachment(<?php echo e($index); ?>)">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php endif; ?>
                    <?php $__errorArgs = ['attachments.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="d-flex justify-content-between align-items-center pt-4 border-top mt-4 px-3">
                <button type="button" class="btn btn-outline-secondary" wire:click="previewLetter">
                    <i class="fas fa-eye me-2"></i> پیش‌نمایش
                </button>
                <div class="d-flex gap-3">
                    <button type="button" class="btn btn-outline-secondary" wire:click="resetForm">
                        <i class="fas fa-undo me-2"></i> انصراف/ریست
                    </button>
                    <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                        <span wire:loading.remove>
                            <i class="fas fa-save me-2"></i>
                            <?php echo e($isCreatingNewRevision ? 'ایجاد نسخه جدید' : ($isEditing ? 'به‌روزرسانی نامه' : 'ذخیره پیش‌نویس')); ?>

                        </span>
                        <span wire:loading>
                            <span class="spinner-border spinner-border-sm me-2" role="status"></span> در حال ذخیره...
                        </span>
                    </button>
                </div>
            </div>
        </form>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script src="<?php echo e(url('panel/plugin/tinymce/tinymce.min.js')); ?>"></script>

        <script>
            document.addEventListener('livewire:init', () => {

                function initTinyMCE() {
                    // ... (تنظیمات اصلی TinyMCE)
                    if (tinymce.get('letter-content')) {
                        tinymce.get('letter-content').remove();
                    }
                    if (!document.getElementById('letter-content')) return;

                    const container = document.querySelector('.tinymce-container');
                    let placeholder = container.querySelector('.editor-placeholder');
                    if (!placeholder) {
                        placeholder = document.createElement('div');
                        placeholder.className = 'editor-placeholder';
                        placeholder.textContent = 'متن نامه را اینجا بنویسید...';
                        container.appendChild(placeholder);
                    }


                    tinymce.init({
                        selector: '#letter-content',
                        license_key: 'gpl',
                        language: 'fa',
                        directionality: 'rtl',
                        height: 500,
                        menubar: 'file edit view insert format tools table help',
                        plugins: 'preview importcss searchreplace autolink directionality visualblocks visualchars fullscreen image link media codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
                        toolbar: 'undo redo | bold italic underline strikethrough | fontfamily fontsize blocks | alignleft aligncenter alignright alignjustify | outdent indent | numlist bullist | forecolor backcolor removeformat | table | link | fullscreen preview print | ltr rtl',
                        toolbar_mode: 'sliding',
                        quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',
                        fontsize_formats: '8pt 10pt 12pt 14pt 16pt 18pt 20pt 24pt 36pt',
                        font_family_formats: 'IRANSans=IRANSans, sans-serif; PeydaWebNoEn=PeydaWebNoEn, sans-serif; Vazir=Vazir, sans-serif; B Yekan=B Yekan, sans-serif; IranNastaliq=IranNastaliq, serif; dana=dana, sans-serif; Tahoma=Tahoma, Geneva, sans-serif; Arial=Arial, Helvetica, sans-serif; Times New Roman=Times New Roman, serif;',
                        content_style: `
                        body {
                            font-family: IRANSans, PeydaWebNoEn, Vazir, Tahoma, Arial, sans-serif;
                            font-size: 14pt;
                            direction: rtl;
                            text-align: right;
                            line-height: 1.7;
                            color: #1f2937;
                            padding: 1.2rem;
                        }
                    `,
                        branding: false,
                        promotion: false,
                        relative_urls: false,
                        remove_script_host: false,
                        convert_urls: true,
                        // ✨ استفاده از Promise ایمن برای رفع خطای "then"
                        images_upload_handler: function (blobInfo, success, failure) {
                            return new Promise((resolve, reject) => {
                                const formData = new FormData();
                                formData.append('image', blobInfo.blob(), blobInfo.filename());
                                formData.append('_token', '<?php echo e(csrf_token()); ?>');

                                const uploadUrl = '<?php echo e(route("upload.tinymce.image")); ?>';

                                fetch(uploadUrl, {
                                    method: 'POST',
                                    body: formData,
                                    headers: {
                                        'X-Requested-With': 'XMLHttpRequest'
                                    }
                                })
                                    .then(response => {
                                        if (!response.ok) {
                                            return response.json().then(errorData => {
                                                throw new Error(errorData.message || `خطای HTTP! وضعیت: ${response.status}`);
                                            }).catch(() => {
                                                throw new Error(`خطای آپلود ناشناخته. وضعیت: ${response.status}`);
                                            });
                                        }
                                        return response.json();
                                    })
                                    .then(data => {
                                        if (data.location) {
                                            resolve(data.location);
                                        } else {
                                            reject(data.error?.message || data.message || 'آپلود تصویر با خطا مواجه شد. (مسیر بازگردانده نشد)');
                                        }
                                    })
                                    .catch(error => {
                                        failure('خطا در آپلود: ' + error.message);
                                        reject('خطا در آپلود: ' + error.message);
                                    });
                            });
                        },
                        setup: editor => {
                            editor.on('init', () => {
                                const content = editor.getContent({ format: 'text' }).trim();
                                placeholder.style.display = content ? 'none' : 'block';

                                if (window.Livewire.find('<?php echo e($_instance->getId()); ?>').content) {
                                    editor.setContent(window.Livewire.find('<?php echo e($_instance->getId()); ?>').content);
                                }
                            });
                            editor.on('change keyup', () => {
                                window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('content', editor.getContent(), true);
                                const content = editor.getContent({ format: 'text' }).trim();
                                placeholder.style.display = content ? 'none' : 'block';
                            });
                            editor.on('blur', () => {
                                window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('content', editor.getContent());
                            });

                            Livewire.hook('element.updated', (el, component) => {
                                if (el.id === 'letter-content' && editor.getContent() !== component.get('content')) {
                                    editor.setContent(component.get('content') || '');
                                }
                            });
                        }
                    });
                }

                // اجرای اولیه TinyMCE
                if (document.getElementById('letter-content')) {
                    initTinyMCE();
                }

                // =============================================================
                // ✨ منطق تاریخ شمسی (Date Picker)
                // =============================================================
                if (typeof $ === 'function' && $.fn.persianDatepicker) {
                    $('#shamsi-date-input').persianDatepicker({
                        altFormat: 'YYYY-MM-DD',
                        altField: '#shamsi-date-input',
                        format: 'YYYY/MM/DD',
                        calendar: {
                            persian: {
                                locale: 'fa'
                            }
                        },
                        onSelect: function(unix, obj) {
                            const shamsiDate = obj.options.altField.val();
                            // ✨ این متد Livewire را فراخوانی می‌کند و تبدیل به تاریخ گرگوری را در کامپوننت انجام می‌دهد
                            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('letter_date_shamsi', shamsiDate);
                        },
                        // اضافه شدن onchange برای وارد کردن دستی
                        onchange: function(value) {
                            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('letter_date_shamsi', value);
                        }
                    });
                } else {
                    $('#shamsi-date-input').attr('type', 'date'); // بازگشت به date picker مرورگر
                }

                Livewire.on('clear-tinymce-content', () => {
                    if (tinymce.get('letter-content')) {
                        tinymce.get('letter-content').setContent('');
                        const container = document.querySelector('.tinymce-container');
                        const placeholder = container.querySelector('.editor-placeholder');
                        if (placeholder) placeholder.style.display = 'block';
                    }
                });
            });
        </script>

        <div style="position:fixed;top:24px;left:50%;transform:translateX(-50%);z-index:10000;width:380px;pointer-events:none;">
            <template x-for="t in toastStore.toasts" :key="t.id">
                <div x-show="t.visible" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-2" x-transition:enter-end="opacity-100 translate-y-0" x-transition:leave="transition ease-in duration-300" x-transition:leave-start="opacity-100 translate-y-0" x-transition:leave-end="opacity-0 translate-y-2" class="rounded-xl shadow-lg mb-4 overflow-hidden" :class="{
                    'bg-green-500': t.type === 'success',
                    'bg-blue-500': t.type === 'info',
                    'bg-yellow-500': t.type === 'warning',
                    'bg-red-500': t.type === 'error'
                }" style="pointer-events:auto;">
                    <div class="flex items-center gap-3 p-4 text-white">
                        <i :class="{
                            'fas fa-check-circle': t.type === 'success',
                            'fas fa-info-circle': t.type === 'info',
                            'fas fa-exclamation-triangle': t.type === 'warning',
                            'fas fa-times-circle': t.type === 'error'
                        }" class="text-xl"></i>
                        <span x-text="t.msg"></span>
                    </div>
                </div>
            </template>
        </div>
    <?php $__env->stopPush(); ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\letter\create-edit-letter.blade.php ENDPATH**/ ?>