<div class="container-fluid">

    <!-- کارت‌های خلاصه -->
    <div class="row g-3 mb-4">
        <div class="col-md-4">
            <div class="card bg-warning bg-opacity-10 border-0 shadow-sm">
                <div class="card-body d-flex flex-column align-items-center">
                    <i class="ti ti-clock fs-2 text-warning mb-2"></i>
                    <div class="fw-semibold">در انتظار تأیید من</div>
                    <div class="h3 mb-0"><?php echo e($pendingCount); ?></div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-success bg-opacity-10 border-0 shadow-sm">
                <div class="card-body d-flex flex-column align-items-center">
                    <i class="ti ti-check fs-2 text-success mb-2"></i>
                    <div class="fw-semibold">تأیید شده</div>
                    <div class="h3 mb-0"><?php echo e($approvedCount); ?></div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-danger bg-opacity-10 border-0 shadow-sm">
                <div class="card-body d-flex flex-column align-items-center">
                    <i class="ti ti-x fs-2 text-danger mb-2"></i>
                    <div class="fw-semibold">رد شده</div>
                    <div class="h3 mb-0"><?php echo e($rejectedCount); ?></div>
                </div>
            </div>
        </div>
    </div>

    <!-- تب‌های وضعیت -->
    <div class="mb-3">
        <button class="btn btn-outline-warning rounded-pill me-2 <?php if($tab==='pending'): ?> active <?php endif; ?>" wire:click="$set('tab','pending')">
            <i class="ti ti-clock"></i> در انتظار تأیید من
        </button>
        <button class="btn btn-outline-secondary rounded-pill <?php if($tab==='history'): ?> active <?php endif; ?>" wire:click="$set('tab','history')">
            <i class="ti ti-history"></i> تاریخچه تأییدهای من
        </button>
    </div>

    <!-- فیلتر و جستجو -->
    <div class="card mb-4 border-0 shadow-sm">
        <div class="card-body">
            <div class="row g-3 align-items-end">
                <div class="col-md-4">
                    <div class="input-group">
                        <span class="input-group-text"><i class="ti ti-search"></i></span>
                        <input type="text" class="form-control" wire:model.lazy="search" placeholder="جستجوی درخواست...">
                    </div>
                </div>
                <div class="col-md-4">
                    <select class="form-select" wire:model="projectFilter">
                        <option value="">همه پروژه‌ها</option>
                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($project->id); ?>"><?php echo e($project->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div wire:loading class="mt-2">
                <div class="spinner-border text-primary" role="status"><span class="visually-hidden">در حال بارگذاری...</span></div>
            </div>
        </div>
    </div>

    <!-- لیست درخواست‌های تاییدی من -->
    <div class="card shadow-sm border-0">
        <div class="card-body">
            <h5 class="mb-4 text-primary">
                <i class="ti ti-list me-2"></i>
                درخواست‌هایی که باید تأیید کنم
            </h5>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light sticky-top">
                    <tr>
                        <th>پروژه</th>
                        <th>توضیحات</th>
                        <th>تاریخ</th>
                        <th>مبلغ کل</th>
                        <th>وضعیت کلی</th>
                        <th>وضعیت من</th>
                        <th>کامنت/نظر</th>
                        <th>عملیات</th>
                        <th>جزئیات</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $approvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $request = $approval->request;
                            $sum = $request->items->sum(fn($item) => $item->pivot->quantity * $item->pivot->price);
                            $isPending = is_null($approval->is_approved);
                        ?>
                        <tr class="<?php if($approval->is_approved === true): ?> table-success <?php elseif($approval->is_approved === false): ?> table-danger <?php else: ?> table-warning <?php endif; ?>">
                            <td><?php echo e($request->project->name ?? '-'); ?></td>
                            <td><?php echo e($request->description); ?></td>
                            <td><?php echo e(\Morilog\Jalali\Jalalian::fromCarbon($request->created_at)->format('Y/m/d')); ?></td>
                            <td><span class="fw-bold text-primary"><?php echo e(number_format($sum)); ?></span></td>
                            <td>
                                <?php if($request->status == 'approved'): ?>
                                    <span class="badge bg-success"><i class="ti ti-check"></i> تأیید شده</span>
                                <?php elseif($request->status == 'rejected'): ?>
                                    <span class="badge bg-danger"><i class="ti ti-x"></i> رد شده</span>
                                <?php else: ?>
                                    <span class="badge bg-warning text-dark"><i class="ti ti-clock"></i> در انتظار</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($approval->is_approved === true): ?>
                                    <span class="badge bg-success"><i class="ti ti-check"></i> تأیید</span>
                                <?php elseif($approval->is_approved === false): ?>
                                    <span class="badge bg-danger"><i class="ti ti-x"></i> رد</span>
                                <?php else: ?>
                                    <span class="badge bg-warning text-dark"><i class="ti ti-clock"></i> در انتظار</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($isPending): ?>
                                    <textarea class="form-control mb-2" wire:model.defer="comment.<?php echo e($approval->id); ?>" placeholder="نظر (اختیاری)"></textarea>
                                <?php else: ?>
                                    <span class="text-muted"><?php echo e($approval->comment ?? '-'); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="d-flex gap-2">
                                    <button class="btn btn-success rounded-pill" wire:click="approve(<?php echo e($approval->id); ?>)" <?php if(!$isPending): ?> disabled <?php endif; ?>>
                                        <i class="ti ti-check me-1"></i>تأیید
                                    </button>
                                    <button class="btn btn-danger rounded-pill" wire:click="reject(<?php echo e($approval->id); ?>)" <?php if(!$isPending): ?> disabled <?php endif; ?>>
                                        <i class="ti ti-x me-1"></i>رد
                                    </button>
                                    <button class="btn btn-secondary rounded-pill" wire:click="return(<?php echo e($approval->id); ?>)" <?php if(!$isPending): ?> disabled <?php endif; ?>>
                                        <i class="ti ti-arrow-back me-1"></i>بازگشت
                                    </button>
                                </div>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-info rounded-pill" data-bs-toggle="modal" data-bs-target="#detailModal<?php echo e($request->id); ?>">
                                    <i class="ti ti-eye me-1"></i>جزئیات
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center text-muted py-4">
                                <i class="ti ti-info-circle fs-2"></i><br>
                                موردی برای نمایش وجود ندارد.
                            </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-3">
                <?php echo e($approvals->links()); ?>

            </div>
            <?php if(session()->has('message')): ?>
                <div class="alert alert-success alert-dismissible fade show mt-4">
                    <div class="d-flex align-items-center">
                        <i class="ti ti-check me-2"></i>
                        <?php echo e(session('message')); ?>

                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- مودال جزئیات -->
    <?php $__currentLoopData = $approvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php $request = $approval->request; ?>
        <div class="modal fade" id="detailModal<?php echo e($request->id); ?>" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">
                            <i class="ti ti-file-info me-2"></i>
                            جزئیات درخواست خرید #<?php echo e($request->id); ?>

                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <p><strong>پروژه:</strong> <?php echo e($request->project->name); ?></p>
                                <p><strong>کاربر:</strong> <?php echo e($request->user->name); ?></p>
                            </div>
                            <div class="col-md-6">
                                <p><strong>تاریخ:</strong> <?php echo e(\Morilog\Jalali\Jalalian::fromCarbon($request->created_at)->format('Y/m/d')); ?></p>
                                <p><strong>وضعیت کلی:</strong>
                                    <?php if($request->status == 'approved'): ?>
                                        <span class="badge bg-success">تأیید شده</span>
                                    <?php elseif($request->status == 'rejected'): ?>
                                        <span class="badge bg-danger">رد شده</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning">در انتظار تأیید</span>
                                    <?php endif; ?>
                                </p>
                                <p><strong>وضعیت من:</strong>
                                    <?php if($approval->is_approved === true): ?>
                                        <span class="badge bg-success"><i class="ti ti-check"></i> تأیید</span>
                                    <?php elseif($approval->is_approved === false): ?>
                                        <span class="badge bg-danger"><i class="ti ti-x"></i> رد</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning text-dark"><i class="ti ti-clock"></i> در انتظار</span>
                                    <?php endif; ?>
                                </p>
                                <p><strong>نظر من:</strong> <?php echo e($approval->comment ?? '-'); ?></p>
                            </div>
                        </div>
                        <div class="mb-4">
                            <h6 class="mb-3 text-primary">لیست آیتم‌ها</h6>
                            <table class="table table-sm">
                                <thead>
                                <tr>
                                    <th>کالا</th>
                                    <th>تعداد</th>
                                    <th>قیمت</th>
                                    <th>جمع</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $request->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($item->name); ?> (<?php echo e($item->code); ?>)</td>
                                        <td><?php echo e($item->pivot->quantity); ?></td>
                                        <td><?php echo e(number_format($item->pivot->price)); ?></td>
                                        <td><?php echo e(number_format($item->pivot->quantity * $item->pivot->price)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tr class="table-light">
                                    <td colspan="3" class="text-end"><strong>جمع کل:</strong></td>
                                    <td class="text-success fw-bold fs-5">
                                        <?php echo e(number_format($request->items->sum(fn($item) => $item->pivot->quantity * $item->pivot->price))); ?>

                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                        <div>
                            <h6 class="mb-3 text-primary">تایم‌لاین تأیید</h6>
                            <div class="d-flex flex-wrap gap-2">
                                <?php $__currentLoopData = $request->approvals->sortBy('priority'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge
                                        <?php if($appr->is_approved === true): ?> bg-success
                                        <?php elseif($appr->is_approved === false): ?> bg-danger
                                        <?php else: ?> bg-secondary
                                        <?php endif; ?>
                                        ">
                                        <?php echo e($appr->role->name); ?>: <?php echo e($appr->user->name); ?>

                                        <?php if($appr->is_approved === true): ?> <i class="ti ti-check"></i>
                                        <?php elseif($appr->is_approved === false): ?> <i class="ti ti-x"></i>
                                        <?php else: ?> <i class="ti ti-clock"></i>
                                        <?php endif; ?>
                                    </span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <div class="table-responsive mt-3">
                                <table class="table table-sm">
                                    <thead>
                                    <tr>
                                        <th>نام</th>
                                        <th>نقش</th>
                                        <th>وضعیت</th>
                                        <th>تاریخ</th>
                                        <th>نظر/امضا</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $request->approvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($appr->user->name); ?></td>
                                            <td><?php echo e($appr->role->name); ?></td>
                                            <td>
                                                <?php if($appr->is_approved === true): ?>
                                                    <span class="badge bg-success">تأیید شده</span>
                                                <?php elseif($appr->is_approved === false): ?>
                                                    <span class="badge bg-danger">رد شده</span>
                                                <?php else: ?>
                                                    <span class="badge bg-warning">در انتظار</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($appr->approved_at): ?>
                                                    <?php
                                                        $apprDate = is_string($appr->approved_at) ? \Carbon\Carbon::parse($appr->approved_at) : $appr->approved_at;
                                                    ?>
                                                    <?php echo e(\Morilog\Jalali\Jalalian::fromCarbon($apprDate)->format('Y/m/d H:i')); ?>

                                                <?php else: ?>
                                                    -
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php echo e($appr->comment ?? '-'); ?>

                                                <?php if($appr->is_approved === true): ?>
                                                    <span class="ms-2 text-success"><i class="ti ti-signature"></i></span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary rounded-pill" data-bs-dismiss="modal">بستن</button>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <style>
        .table-hover tbody tr:hover {
            background-color: rgba(0, 123, 255, 0.05) !important;
            transition: background-color 0.2s ease;
        }
        .table-success { background-color: #e9fbe5 !important; }
        .table-warning { background-color: #fffbe6 !important; }
        .table-danger { background-color: #fbeaea !important; }
        .btn.rounded-pill { border-radius: 50px !important; }
        .sticky-top { position: sticky; top: 0; z-index: 10; }
        .fw-bold { font-weight: bold; }
        .fs-6 { font-size: 1.1rem; }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\purchase\purchase-request-approval.blade.php ENDPATH**/ ?>