<div class="container-fluid py-4">
    <style>
        /* Modern Clean Blog Editor Style - Tweaked for Higher Polish */
        :root {
            --primary: #4f46e5; /* Indigo */
            --primary-light: #eef2ff;
            --success: #10b981;
            --danger: #ef4444;
            --border: #e5e7eb;
            --text-dark: #1f2937;
            /* Enhanced Shadow */
            --shadow-lg: 0 15px 30px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.08);
            --shadow-input-focus: 0 0 0 5px rgba(79, 70, 229, 0.3); /* Slightly bolder focus ring */
        }

        .input-focus-ring:focus {
            border-color: var(--primary);
            box-shadow: var(--shadow-input-focus);
        }

        .header-gradient {
            background-image: linear-gradient(135deg, #1e3a8a 0%, #4f46e5 100%); /* Slightly deeper indigo */
            border-bottom: 5px solid var(--primary-light);
            border-top-left-radius: calc(1rem - 1px);
            border-top-right-radius: calc(1rem - 1px);
        }

        .image-preview-box, .media-file-box {
            border: 2px dashed var(--primary); /* Dashed primary border */
            padding: 1.25rem;
            border-radius: 0.75rem;
            background-color: var(--primary-light);
            position: relative;
            transition: all 0.3s ease;
        }
        .image-preview-box:hover, .media-file-box:hover {
            box-shadow: 0 0 0 2px var(--primary-light);
        }

        .image-preview-box img {
            max-height: 250px;
            object-fit: cover;
            width: 100%;
            border-radius: 0.5rem;
        }

        .remove-image-btn {
            background: rgba(239, 68, 68, 0.9); /* Darker background for visibility */
        }

        /* New style for file name display within media box */
        .uploaded-file-name-display {
            border: 1px solid #d1d5db;
            background: white;
            padding: 0.75rem;
            border-radius: 0.5rem;
            transition: box-shadow 0.2s;
        }
        .uploaded-file-name-display:hover {
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.06);
        }

        /* Animation for loading states */
        .animate-spin {
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
    </style>

    <div class="row justify-content-center">
        <div class="col-12 col-lg-9">

            
            <?php if(session()->has('success') || session()->has('error')): ?>
                <div class="alert alert-<?php echo e(session()->has('success') ? 'success' : 'danger'); ?> d-flex align-items-center justify-content-between rounded-3 shadow-sm mb-4" role="alert">
                    <div>
                        <i class="ti ti-<?php echo e(session()->has('success') ? 'check-circle' : 'alert-triangle'); ?> me-2"></i>
                        <?php echo e(session('success') ?? session('error')); ?>

                    </div>
                    <button class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="card border-0 shadow-lg rounded-4">
                <div class="card-header header-gradient text-white p-4">
                    <h4 class="mb-0 fw-bold d-flex align-items-center gap-2">
                        <i class="ti ti-pencil-code fs-4"></i>
                        فرم ایجاد/ویرایش محتوا
                    </h4>
                </div>

                <div class="card-body p-4 p-md-5">
                    <form wire:submit.prevent="createPost" enctype="multipart/form-data">

                        
                        <div class="row mb-5">
                            
                            <div class="col-md-8 mb-4 mb-md-0" x-data="{ count: $wire.title ? $wire.title.length : 0 }" x-init="$watch('$wire.title', value => count = value ? value.length : 0)">
                                <label class="form-label fw-bold d-flex align-items-center justify-content-between">
                                    <span>عنوان پست <span class="text-danger">*</span></span>
                                    <small class="text-muted" style="font-size: 0.8rem;"><i class="ti ti-ruler"></i> <span x-text="count">0</span> / 255</small>
                                </label>
                                <input type="text" class="form-control form-control-lg input-focus-ring <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       wire:model.defer="title" maxlength="255" placeholder="یک عنوان جذاب و SEO-friendly انتخاب کنید...">
                                <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            
                            <div class="col-md-4">
                                <label for="category_id" class="form-label fw-bold">دسته‌بندی <span class="text-danger">*</span></label>
                                <select id="category_id" wire:model.defer="category_id"
                                        class="form-select form-select-lg input-focus-ring <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value="">-- انتخاب کنید --</option>
                                    
                                    <?php $__currentLoopData = $this->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        
                        <div class="mb-5">
                            <label class="form-label fw-bold"><i class="ti ti-file-text-ai me-1"></i> متن پست <span class="text-danger">*</span></label>
                            
                            <textarea class="form-control input-focus-ring <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model.defer="content" rows="12" placeholder="محتوای اصلی مقاله یا خبر..."></textarea>
                            <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="row mb-5 border-top pt-4">

                            
                            <div class="col-md-6 mb-4 mb-md-0">
                                <label class="form-label fw-bold d-flex align-items-center gap-2">
                                    <i class="ti ti-photo-plus text-primary"></i> تصویر شاخص (Thumbnail)
                                </label>

                                <?php if($imagePreviewUrl): ?>
                                    <div class="image-preview-box mt-3 position-relative">
                                        <button type="button" class="remove-image-btn" wire:click="removeImage" title="حذف تصویر">
                                            <i class="ti ti-x"></i>
                                        </button>
                                        <img src="<?php echo e($imagePreviewUrl); ?>" alt="پیش‌نمایش" class="rounded">
                                    </div>
                                <?php else: ?>
                                    <div class="image-preview-box mt-3 p-4 text-center">
                                        <div wire:loading.remove wire:target="image">
                                            <i class="ti ti-upload text-primary fs-3 d-block mb-2"></i>
                                            <input type="file" class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                   wire:model="image"
                                                   accept="image/*">
                                        </div>
                                        <div wire:loading wire:target="image" class="text-primary fw-bold">
                                            <i class="ti ti-loader animate-spin me-1"></i> در حال آپلود...
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            
                            <div class="col-md-6">
                                <label class="form-label fw-bold d-flex align-items-center gap-2">
                                    <i class="ti ti-paperclip text-success"></i> فایل پیوست (PDF, Video, Doc)
                                </label>

                                <div class="media-file-box mt-3 p-4">
                                    <div wire:loading.remove wire:target="media_file">
                                        <i class="ti ti-file-upload text-success fs-3 d-block mb-2"></i>
                                        <input type="file" class="form-control <?php $__errorArgs = ['media_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               wire:model="media_file"
                                               accept=".pdf,.docx,.xlsx,.mp4,.avi,.mov">
                                    </div>
                                    <div wire:loading wire:target="media_file" class="text-primary fw-bold">
                                        <i class="ti ti-loader animate-spin me-1"></i> در حال آپلود فایل پیوست...
                                    </div>

                                    <?php if($media_file && $mediaFileName): ?>
                                        <div class="uploaded-file-name-display d-flex align-items-center justify-content-between mt-3 shadow-sm">
                                            <div class="d-flex align-items-center gap-2 text-dark overflow-hidden">
                                                <i class="ti ti-file-check fs-5 text-success"></i>
                                                <span class="text-truncate fw-medium" title="<?php echo e($mediaFileName); ?>"><?php echo e($mediaFileName); ?></span>
                                            </div>
                                            <button type="button" class="btn btn-sm btn-outline-danger border-0" wire:click="removeMediaFile" title="حذف فایل پیوست">
                                                <i class="ti ti-trash"></i>
                                            </button>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <?php $__errorArgs = ['media_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        
                        <div class="d-flex justify-content-between align-items-center border-top pt-4">

                            
                            <div class="form-check form-switch form-check-lg p-0">
                                <label class="form-label fw-bold mb-1">وضعیت انتشار</label>
                                <div class="p-2 bg-light rounded-3 d-flex align-items-center gap-3">
                                    <input class="form-check-input my-0" type="checkbox" wire:model.defer="is_published" id="is_published" style="transform: scale(1.5);">
                                    <label class="form-check-label fw-bold text-dark user-select-none" for="is_published">
                                        <span class="<?php echo e($is_published ? 'text-success' : 'text-danger'); ?>">
                                            <i class="ti ti-<?php echo e($is_published ? 'world' : 'lock'); ?> fs-5 me-1"></i>
                                            <?php echo e($is_published ? 'منتشر شده' : 'پیش‌نویس'); ?>

                                        </span>
                                    </label>
                                </div>
                            </div>

                            
                            <div class="d-flex gap-3">
                                <button type="button" class="btn btn-outline-secondary btn-lg rounded-3" wire:click="reset(['title', 'content', 'category_id', 'image', 'media_file', 'is_published', 'imagePreviewUrl', 'mediaFileName'])">
                                    <i class="ti ti-eraser fs-5 me-2"></i>
                                    بازنشانی فرم
                                </button>
                                <button type="submit" class="btn btn-primary btn-lg rounded-3"
                                        style="box-shadow: 0 8px 25px -8px var(--primary);"
                                        wire:loading.attr="disabled"
                                        wire:target="createPost, image, media_file">

                                    <span wire:loading.remove wire:target="createPost, image, media_file"><i class="ti ti-cloud-upload fs-5 me-2"></i> ذخیره و انتشار</span>
                                    <span wire:loading wire:target="createPost"><i class="ti ti-loader animate-spin fs-5 me-2"></i> در حال ذخیره...</span>
                                    <span wire:loading.remove wire:target="createPost" wire:loading wire:target="image, media_file"><i class="ti ti-refresh-dot animate-spin fs-5 me-2"></i> در حال آپلود فایل‌ها...</span>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\post\create-post.blade.php ENDPATH**/ ?>