<div x-data="{
    cc_name: <?php if ((object) ('cc_name') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('cc_name'->value()); ?>')<?php echo e('cc_name'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('cc_name'); ?>')<?php endif; ?>.live,
    cc_position: <?php if ((object) ('cc_position') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('cc_position'->value()); ?>')<?php echo e('cc_position'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('cc_position'); ?>')<?php endif; ?>.defer,
    confidential: <?php if ((object) ('confidential') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('confidential'->value()); ?>')<?php echo e('confidential'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('confidential'); ?>')<?php endif; ?>.defer,
    previewHtml: '',

    removeAttachment(index) {
        window.Livewire.find('<?php echo e($_instance->getId()); ?>').removeAttachment(index);
    },

    isCcNameEmpty() {
        return !window.Livewire.find('<?php echo e($_instance->getId()); ?>').cc_name || (typeof window.Livewire.find('<?php echo e($_instance->getId()); ?>').cc_name === 'string' && window.Livewire.find('<?php echo e($_instance->getId()); ?>').cc_name.trim() === '');
    },

    // باز کردن مودال پیش‌نمایش
    openPreviewModal(htmlContent) {
        this.previewHtml = htmlContent || '';
        const modalElement = document.getElementById('previewModal');
        if (modalElement) {
            const modal = bootstrap.Modal.getOrCreateInstance(modalElement);
            modal.show();
        }
    },

    // بستن مودال
    closePreviewModal() {
        const modalElement = document.getElementById('previewModal');
        if (modalElement) {
            const modalInstance = bootstrap.Modal.getInstance(modalElement);
            if (modalInstance) {
                modalInstance.hide();
            }
        }
    }
}"
     x-cloak
     x-init="
    // مقداردهی اولیه با Alpine
    $nextTick(() => {
        setTimeout(() => {
            if (document.getElementById('letter-content') && !tinymce.get('letter-content')) {
                initTinyMCEForLetter();
            }
        }, 350);
    });

    // گوش دادن به رویداد Livewire
    Livewire.on('open-preview-html', (event) => {
        openPreviewModal(event.htmlContent);
    });
">

    <style>
        :root {
            --primary: #0ea5e9;
            --primary-dark: #0284c7;
            --primary-light: #e0f2fe;
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #06b6d4 100%);
            --sky-blue: #38bdf8;
            --teal: #14b8a6;
            --success: #10b981;
            --warning: #f59e0b;
            --danger: #ef4444;
            --border: #e2e8f0;
            --light: #f8fafc;
            --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            --header-bg: #f1f5f9;
            --radius: 16px;
            --card-bg: #ffffff;
            --red-500: #ef4444;
            --blue-500: #3b82f6;
            --green-500: #22c55e;
            --purple-500: #a855f7;
            --yellow-500: #f59e0b;
        }

        .container-fluid {
            padding: 30px;
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            min-height: 100vh;
        }

        /* عنوان پروژه */
        .header-project {
            background: var(--primary-gradient);
            color: white;
            padding: 1.75rem 2.25rem;
            border-radius: var(--radius);
            margin-bottom: 2.5rem;
            box-shadow: var(--shadow-lg);
            border: none;
            position: relative;
            overflow: hidden;
            backdrop-filter: blur(10px);
        }

        .header-project::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, transparent 30%, rgba(255,255,255,0.1) 50%, transparent 70%);
            animation: shimmer 3s infinite;
        }

        @keyframes shimmer {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }

        .header-project h3 {
            position: relative;
            z-index: 1;
            font-weight: 700;
            font-size: 1.6rem;
            margin: 0;
            letter-spacing: -0.5px;
        }

        .header-project .project-info {
            position: relative;
            z-index: 1;
            margin-top: 0.75rem;
            opacity: 0.95;
            font-size: 0.95rem;
        }

        /* سکشن فرم */
        .form-section-modern {
            background: var(--card-bg);
            border-radius: var(--radius);
            padding: 2.5rem;
            margin-bottom: 2.5rem;
            border: 1px solid var(--border);
            box-shadow: var(--shadow);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }

        .form-section-modern:hover {
            box-shadow: 0 20px 40px rgba(14, 165, 233, 0.12);
            transform: translateY(-3px);
        }

        .form-section-modern::after {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 5px;
            height: 100%;
            background: linear-gradient(to bottom, var(--sky-blue), var(--teal));
            border-radius: 0 var(--radius) var(--radius) 0;
        }

        .form-section-modern h4 {
            font-size: 1.35rem;
            font-weight: 700;
            color: var(--primary-dark);
            padding-bottom: 1rem;
            margin-bottom: 2rem;
            display: flex;
            align-items: center;
            position: relative;
            border-bottom: 2px solid var(--primary-light);
        }

        .form-section-modern h4 i {
            background: var(--primary-light);
            padding: 12px;
            border-radius: 12px;
            margin-left: 12px;
            color: var(--primary);
            box-shadow: 0 4px 12px rgba(14, 165, 233, 0.15);
        }

        /* برچسب‌های فرم */
        .form-label-modern {
            font-weight: 700;
            color: #334155;
            font-size: 1rem;
            margin-bottom: 0.85rem;
            display: flex;
            align-items: center;
            padding-right: 5px;
            position: relative;
            letter-spacing: -0.3px;
        }

        .form-label-modern.required::after {
            content: ' *';
            color: var(--danger);
            font-size: 1.2em;
            margin-right: 4px;
            font-weight: bold;
        }

        /* فیلدهای ورودی تک خطی */
        .form-control-single {
            border-radius: 12px;
            border: 2px solid #e2e8f0;
            padding: 1.1rem 1.5rem;
            font-size: 1.05rem;
            transition: all 0.25s;
            background: #ffffff;
            box-shadow: inset 0 2px 4px rgba(0,0,0,0.04);
            width: 100%;
            line-height: 1.5;
        }

        .form-control-single:focus {
            border-color: var(--sky-blue);
            box-shadow: 0 0 0 4px rgba(56, 189, 248, 0.2), inset 0 2px 4px rgba(0,0,0,0.04);
            outline: none;
            background: white;
            /* transform: translateY(-2px); // حذف شد تا فیلدها حین فوکوس جابجا نشوند */
        }

        .form-control-single::placeholder {
            color: #94a3b8;
            font-weight: 400;
        }

        /* فیلدهای انتخاب */
        .form-select-modern {
            border-radius: 12px;
            border: 2px solid #e2e8f0;
            padding: 1rem 1.25rem;
            font-size: 1rem;
            transition: all 0.25s;
            background: #ffffff;
            box-shadow: inset 0 2px 4px rgba(0,0,0,0.04);
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%230ea5e9' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='M6 8l4 4 4-4'/%3e%3c/svg%3e");
            background-position: left 1rem center;
            background-repeat: no-repeat;
            background-size: 1.5em 1.5em;
            padding-left: 3rem;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }

        .form-select-modern:focus {
            border-color: var(--sky-blue);
            box-shadow: 0 0 0 4px rgba(56, 189, 248, 0.2), inset 0 2px 4px rgba(0,0,0,0.04);
            outline: none;
            background-color: white;
        }

        /* استایل‌های تک خطی برای موضوع، از طرف، به */
        .single-line-field {
            margin-bottom: 1.5rem; /* کاهش فاصله برای تراکم بهتر */
            animation: fadeIn 0.5s ease forwards;
            opacity: 0;
        }
        .single-line-field:nth-child(1) { animation-delay: 0.1s; }
        .single-line-field:nth-child(2) { animation-delay: 0.2s; }
        .single-line-field:nth-child(3) { animation-delay: 0.3s; }

        .single-line-field:last-child {
            margin-bottom: 2.5rem; /* فاصله بیشتر قبل از بخش بعدی */
        }

        /* رونوشت مدرن */
        .cc-tag-modern {
            background: linear-gradient(135deg, #e0f2fe 0%, #ccfbf1 100%);
            color: var(--primary-dark);
            padding: 0.7rem 1.3rem;
            border-radius: 50px;
            font-weight: 600;
            margin: 6px;
            display: inline-flex;
            align-items: center;
            border: 1.5px solid transparent;
            transition: all 0.25s cubic-bezier(0.4, 0, 0.2, 1);
            animation: fadeInUp 0.4s ease;
            box-shadow: 0 4px 6px rgba(14, 165, 233, 0.1);
        }
        .cc-tag-modern .text-muted {
            color: #64748b !important;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .cc-tag-modern:hover {
            border-color: var(--sky-blue);
            transform: translateY(-3px) scale(1.02);
            box-shadow: 0 8px 16px rgba(14, 165, 233, 0.2);
        }

        .cc-tag-modern button {
            color: #64748b;
            margin-right: 8px;
            font-size: 0.9em;
            cursor: pointer;
            background: none;
            border: none;
            padding: 4px 8px;
            border-radius: 50%;
            transition: all 0.2s;
        }

        .cc-tag-modern button:hover {
            color: var(--danger);
            background: rgba(239, 68, 68, 0.1);
            transform: rotate(90deg);
        }

        /* آپلود فایل مدرن */
        .uploader-box-modern {
            border: 2.5px dashed var(--sky-blue);
            background: linear-gradient(135deg, #f0f9ff 0%, #f0fdfa 100%);
            color: var(--primary-dark);
            border-radius: var(--radius);
            padding: 3.5rem 2rem;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
            position: relative;
            overflow: hidden;
        }

        .uploader-box-modern:hover {
            border-color: var(--teal);
            background: linear-gradient(135deg, #e0f2fe 0%, #d1fae5 100%);
            transform: translateY(-4px);
            box-shadow: 0 15px 30px rgba(14, 165, 233, 0.15);
        }

        .uploader-box-modern.dragover {
            border-color: var(--teal);
            background: linear-gradient(135deg, #bae6fd 0%, #a7f3d0 100%);
            transform: scale(1.02);
        }

        .uploader-icon-container-modern {
            width: 85px;
            height: 85px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--sky-blue), var(--teal));
            color: white;
            font-size: 34px;
            margin: 0 auto 20px;
            box-shadow: 0 10px 25px rgba(56, 189, 248, 0.3);
            transition: transform 0.3s;
        }

        .uploader-box-modern:hover .uploader-icon-container-modern {
            transform: rotate(10deg) scale(1.05);
        }

        /* لیست فایل‌ها */
        .file-list-modern li {
            border: 1.5px solid #e0f2fe;
            background: white;
            border-radius: 12px;
            padding: 1.1rem 1.6rem;
            margin-bottom: 0.85rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.25s;
            animation: slideInRight 0.3s ease;
        }

        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(-30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        .file-list-modern li:hover {
            border-color: var(--sky-blue);
            box-shadow: 0 6px 15px rgba(0,0,0,0.08);
            transform: translateX(8px);
        }

        /* دکمه‌های مدرن */
        .btn-modern-primary {
            background: linear-gradient(135deg, var(--sky-blue), var(--teal));
            border: none;
            border-radius: 14px;
            padding: 1.1rem 2.8rem;
            font-weight: 700;
            color: white;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 8px 25px rgba(14, 165, 233, 0.3);
            letter-spacing: 0.5px;
            position: relative;
            overflow: hidden;
        }

        .btn-modern-primary::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.7s;
        }

        .btn-modern-primary:hover::before {
            left: 100%;
        }

        .btn-modern-primary:hover {
            transform: translateY(-4px);
            box-shadow: 0 15px 35px rgba(14, 165, 233, 0.4);
            color: white;
        }

        .btn-modern-primary:active {
            transform: translateY(-1px);
        }

        .btn-modern-outline {
            background: white;
            border: 2px solid var(--sky-blue);
            color: var(--primary-dark);
            border-radius: 14px;
            padding: 1rem 2.5rem;
            font-weight: 700;
            transition: all 0.3s;
            position: relative;
            overflow: hidden;
        }

        .btn-modern-outline:hover {
            background: linear-gradient(135deg, rgba(56, 189, 248, 0.1), rgba(20, 184, 166, 0.1));
            border-color: var(--teal);
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(56, 189, 248, 0.2);
        }

        /* پیشنهادات رونوشت */
        .cc-suggestions-modern {
            position: absolute;
            z-index: 1000;
            background: white;
            border: 1.5px solid #e0f2fe;
            border-radius: 12px;
            box-shadow: var(--shadow-lg);
            max-height: 250px;
            overflow-y: auto;
            width: 100%;
            top: 100%;
            margin-top: 6px;
            animation: slideDown 0.25s ease;
        }

        @keyframes slideDown {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .cc-suggestions-item-modern {
            padding: 13px 17px;
            cursor: pointer;
            border-bottom: 1px solid #f1f5f9;
            transition: all 0.2s;
            display: flex;
            align-items: center;
        }

        .cc-suggestions-item-modern:last-child {
            border-bottom: none;
        }

        .cc-suggestions-item-modern:hover {
            background: linear-gradient(90deg, #f0f9ff, #f0fdfa);
            color: var(--primary-dark);
            padding-right: 22px;
            border-left: 4px solid var(--teal);
        }

        /* ادیتور TinyMCE */
        .tinymce-container-modern {
            position: relative;
            margin-top: 1.2rem;
            border-radius: 12px;
            overflow: hidden;
            border: 2px solid #e2e8f0;
            transition: all 0.3s;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
        }

        .tinymce-container-modern:focus-within {
            border-color: var(--sky-blue);
            box-shadow: 0 0 0 4px rgba(56, 189, 248, 0.15);
        }

        .editor-placeholder-modern {
            position: absolute;
            top: 18px;
            right: 22px;
            pointer-events: none;
            color: #94a3b8;
            font-size: 14px;
            font-style: italic;
            z-index: 1;
            font-weight: 500;
        }

        /* وضعیت ذخیره خودکار */
        .auto-save-indicator-modern {
            background: #f0fdf4;
            border: 2px solid #bbf7d0;
            color: #059669;
            padding: 0.9rem 1.2rem;
            border-radius: 12px;
            font-size: 0.95rem;
            margin-top: 1.2rem;
            display: inline-flex;
            align-items: center;
            animation: fadeIn 0.5s ease;
            box-shadow: 0 4px 8px rgba(16, 185, 129, 0.1);
        }

        /* چک‌باکس محرمانه */
        .confidential-checkbox {
            width: 26px;
            height: 26px;
            border-radius: 8px;
            border: 2px solid var(--sky-blue);
            cursor: pointer;
            position: relative;
            transition: all 0.2s;
            background: white;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            flex-shrink: 0;
        }

        .confidential-checkbox:checked {
            background: var(--teal);
            border-color: var(--teal);
        }

        .confidential-checkbox:checked::after {
            content: '✓';
            position: absolute;
            color: white;
            font-size: 16px;
            font-weight: bold;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        /* پاسخگو برای موبایل */
        @media (max-width: 768px) {
            .container-fluid {
                padding: 20px;
            }

            .form-section-modern {
                padding: 1.8rem;
            }

            .header-project {
                padding: 1.5rem;
            }

            .btn-modern-primary, .btn-modern-outline {
                padding: 0.9rem 1.8rem;
                width: 100%;
                margin-bottom: 12px;
            }

            .single-line-field {
                margin-bottom: 1.8rem;
            }

            .form-control-single {
                padding: 1rem 1.3rem;
            }
        }

        @media (max-width: 576px) {
            .container-fluid {
                padding: 15px;
            }

            .form-section-modern {
                padding: 1.5rem;
            }

            .header-project {
                padding: 1.2rem;
            }

            .header-project h3 {
                font-size: 1.4rem;
            }

            .form-footer-actions {
                flex-direction: column;
                gap: 1rem;
            }

            .form-footer-actions > div {
                width: 100%;
            }

            .input-group.d-flex.gap-3 {
                flex-direction: column;
                gap: 1rem !important;
            }

            .input-group.d-flex.gap-3 > div,
            .input-group.d-flex.gap-3 > input,
            .input-group.d-flex.gap-3 > button {
                flex: 1 !important;
                width: 100%;
            }
        }

        /* اسکرول بار زیبا */
        .cc-suggestions-modern::-webkit-scrollbar {
            width: 8px;
        }

        .cc-suggestions-modern::-webkit-scrollbar-track {
            background: #f1f5f9;
            border-radius: 10px;
        }

        .cc-suggestions-modern::-webkit-scrollbar-thumb {
            background: linear-gradient(to bottom, var(--sky-blue), var(--teal));
            border-radius: 10px;
        }

        /* دکمه‌های پایین فرم */
        .form-footer-actions {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 2rem 1rem 1rem;
            border-top: 2px solid #f1f5f9;
            margin-top: 3rem;
            flex-wrap: wrap;
            gap: 1.5rem;
        }

        /* بخش تک خطی */
        .single-line-group {
            margin-bottom: 1rem;
        }

        /* انیمیشن کلی */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* افکت‌های زیبا */
        .floating-effect {
            animation: float 6s ease-in-out infinite;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-5px); }
        }

        /* حاشیه‌های زیبا برای فیلدها */
        .form-control-single:focus, .form-select-modern:focus {
            background: linear-gradient(white, white) padding-box,
            linear-gradient(135deg, var(--sky-blue), var(--teal)) border-box;
            border: 2px solid transparent;
        }

        .field-grid-2 {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 2rem;
        }
    </style>

    <div class="container-fluid">
        <div class="header-project floating-effect">
            <h3>
                <i class="fas fa-project-diagram me-3"></i>
                ایجاد/ویرایش نامه برای پروژه:
                <span class="fw-bold"><?php echo e($project->name); ?> (<?php echo e($project->code); ?>)</span>
            </h3>
            <div class="project-info">
                <i class="fas fa-info-circle me-1"></i>
                تمامی فیلدهای ضروری با علامت <span class="fw-bold">*</span> مشخص شده‌اند
            </div>
        </div>

        <form wire:submit.prevent="save">
            <div class="form-section-modern">
                <h4><i class="fas fa-info-circle"></i> اطلاعات پایه و سربرگ</h4>

                <div class="single-line-group">

                    <div class="single-line-field">
                        <label class="form-label-modern required">
                            <i class="fas fa-heading me-2"></i>
                            عنوان نامه (موضوع)
                        </label>
                        <input type="text" class="form-control-single" wire:model="title" placeholder="موضوع اصلی نامه را اینجا وارد کنید...">
                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-2 fw-medium d-flex align-items-center">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            <?php echo e($message); ?>

                        </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="single-line-field">
                        <label class="form-label-modern required">
                            <i class="fas fa-user-edit me-2"></i>
                            از طرف
                        </label>
                        <input type="text" class="form-control-single" wire:model="from_who" placeholder="نام یا واحد فرستنده نامه را وارد کنید...">
                        <?php $__errorArgs = ['from_who'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-2 fw-medium d-flex align-items-center">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            <?php echo e($message); ?>

                        </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="single-line-field">
                        <label class="form-label-modern required">
                            <i class="fas fa-user-check me-2"></i>
                            به: (گیرنده اصلی)
                        </label>
                        <input type="text" class="form-control-single" wire:model="from_where" placeholder="نام یا واحد گیرنده نامه را وارد کنید...">
                        <?php $__errorArgs = ['from_where'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-2 fw-medium d-flex align-items-center">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            <?php echo e($message); ?>

                        </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="field-grid-2 mt-4">
                    <div class="single-line-field" style="animation-delay: 0.4s;">
                        <label class="form-label-modern required">
                            <i class="fas fa-calendar-alt me-2"></i> تاریخ نامه
                        </label>
                        <input
                            type="text"
                            class="form-control-single"
                            wire:model.live="letter_date_shamsi"
                            id="shamsi-date-input"
                            placeholder="روز/ماه/سال شمسی را انتخاب کنید"
                            value="<?php echo e($letter_date_shamsi); ?>"
                        >
                        <?php $__errorArgs = ['letter_date_shamsi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-2 fw-medium d-flex align-items-center">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            <?php echo e($message); ?>

                        </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="single-line-field" style="animation-delay: 0.5s;">
                        <label class="form-label-modern required">
                            <i class="fas fa-file-image me-2"></i> قالب سربرگ
                        </label>
                        <select class="form-select-modern" wire:model="background_id">
                            <option value="">-- قالب سربرگ را انتخاب کنید --</option>
                            <?php $__currentLoopData = $forms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $form): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($form->id); ?>"><?php echo e($form->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($forms->isEmpty()): ?>
                            <div class="text-danger small mt-2 fw-medium d-flex align-items-center">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                هیچ سربرگی برای شرکت شما مجاز نیست.
                            </div>
                        <?php endif; ?>
                        <?php $__errorArgs = ['background_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-2 fw-medium d-flex align-items-center">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            <?php echo e($message); ?>

                        </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="form-section-modern">
                <h4><i class="fas fa-pen-nib"></i> محتوای نامه</h4>
                <label class="form-label-modern required">
                    <i class="fas fa-align-right me-2"></i> متن نامه
                </label>
                <div class="tinymce-container-modern">
                    <div wire:ignore>
                        <textarea id="letter-content" wire:model="content"><?php echo e($content); ?></textarea>
                    </div>
                    <div class="editor-placeholder-modern">متن نامه خود را اینجا بنویسید...</div>
                </div>
                <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="text-danger mt-2 fw-medium d-flex align-items-center">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <?php echo e($message); ?>

                </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                <?php if($autoSaveEnabled && !$isEditing): ?>
                    <div class="auto-save-indicator-modern">
                        <i class="fas fa-save me-2"></i>
                        <span class="fw-bold">آخرین ذخیره خودکار:</span>
                        <span wire:poll.30s class="fw-bold me-2" style="font-family: monospace;"><?php echo e($lastAutoSavedAt ?? '—'); ?></span>
                        <span class="text-sm opacity-75">(هر ۳۰ ثانیه ذخیره می‌شود)</span>
                    </div>
                <?php endif; ?>
            </div>

            <div class="form-section-modern">
                <h4><i class="fas fa-signature"></i> تنظیمات امضا</h4>
                <div class="field-grid-2">
                    <div>
                        <label class="form-label-modern required">
                            <i class="fas fa-user-check me-2"></i> امضاکننده
                        </label>
                        <select class="form-select-modern" wire:model.live="signer_id">
                            <option value="">-- امضاکننده را انتخاب کنید --</option>
                            <?php $__currentLoopData = $allUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['signer_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-2 fw-medium d-flex align-items-center">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            <?php echo e($message); ?>

                        </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div>
                        <label class="form-label-modern required">
                            <i class="fas fa-user-tag me-2"></i> سمت امضاکننده
                        </label>
                        <select class="form-select-modern" wire:model.defer="signature_position" <?php if(empty($signerPositions)): ?> disabled <?php endif; ?>>
                            <?php if(empty($signerPositions)): ?>
                                <option value="">ابتدا امضاکننده را انتخاب کنید</option>
                            <?php else: ?>
                                <option value="">سمت امضاکننده را انتخاب کنید</option>
                                <?php $__currentLoopData = $signerPositions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $position): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($position); ?>"><?php echo e($position); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                        <?php $__errorArgs = ['signature_position'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-2 fw-medium d-flex align-items-center">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            <?php echo e($message); ?>

                        </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="form-section-modern">
                <h4><i class="fas fa-cogs"></i> تنظیمات متفرقه</h4>

                <div class="field-grid-2">
                    <div>
                        <label class="form-label-modern">
                            <i class="fas fa-hourglass-half me-2"></i> اولویت
                        </label>
                        <select class="form-select-modern" wire:model="priority">
                            <option value="low">کم</option>
                            <option value="normal">عادی</option>
                            <option value="high">بالا</option>
                            <option value="urgent">فوری</option>
                        </select>
                        <?php $__errorArgs = ['priority'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-2 fw-medium d-flex align-items-center">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            <?php echo e($message); ?>

                        </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div>
                        <label class="form-label-modern">
                            <i class="fas fa-tags me-2"></i> طبقه‌بندی (اختیاری)
                        </label>
                        <select class="form-select-modern" wire:model.defer="classification_id">
                            <option value="">-- طبقه‌بندی را انتخاب کنید --</option>
                            <?php $__currentLoopData = $classifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($classification->id); ?>"><?php echo e($classification->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['classification_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger mt-2 fw-medium d-flex align-items-center">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            <?php echo e($message); ?>

                        </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="mt-4">
                    <label class="form-label-modern">
                        <i class="fas fa-user-shield me-2"></i> محرمانگی (اختیاری)
                    </label>
                    <div class="d-flex align-items-center mt-3">
                        <input class="confidential-checkbox me-3" type="checkbox" wire:model.defer="confidential" id="confidential">
                        <label class="form-check-label text-gray-700 fw-bold me-3" for="confidential">
                            این نامه محرمانه است
                        </label>
                        <i class="fas fa-2x" :class="confidential ? 'fa-lock text-teal' : 'fa-lock-open text-sky-blue'"></i>
                    </div>
                </div>
            </div>

            <div class="form-section-modern">
                <h4><i class="fas fa-users"></i> رونوشت (CC)</h4>

                <div class="input-group mb-4 d-flex gap-3 flex-wrap">
                    <div class="position-relative" style="flex: 1.5; min-width: 200px;">
                        <input type="text" class="form-control-single" wire:model.live.debounce.250ms="cc_name" placeholder="نام شخص یا واحد برای رونوشت..."
                               x-on:keydown.escape="$wire.set('cc_users_suggestions', [])">
                        <?php if(!empty($cc_users_suggestions)): ?>
                            <div class="cc-suggestions-modern">
                                <?php $__currentLoopData = $cc_users_suggestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="cc-suggestions-item-modern" wire:click="selectCcUser(<?php echo e($user->id); ?>, '<?php echo e($user->name); ?>')">
                                        <i class="fas fa-user-circle me-3"></i>
                                        <span class="fw-medium"><?php echo e($user->name); ?></span>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                    </div>

                    <input type="text" class="form-control-single" wire:model.defer="cc_position" placeholder="سمت (اختیاری)" style="flex: 1; min-width: 150px;">
                    <button class="btn btn-modern-primary" type="button" wire:click="addCc" :disabled="isCcNameEmpty()" style="flex-shrink: 0;">
                        <i class="fas fa-plus me-2"></i> افزودن رونوشت
                    </button>
                </div>

                <?php $__errorArgs = ['cc_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="text-danger mt-2 fw-medium d-flex align-items-center">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <?php echo e($message); ?>

                </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                <div class="mt-4" style="min-height: 60px;">
                    <?php if(count($ccs)): ?>
                        <div class="card border-0" style="background: linear-gradient(135deg, #f0f9ff, #f0fdfa); border-radius: 12px;">
                            <div class="card-body p-4">
                                <div class="d-flex align-items-center mb-3">
                                    <i class="fas fa-users text-teal me-2 fa-lg"></i>
                                    <h6 class="mb-0 fw-bold text-primary-dark">لیست رونوشت‌های اضافه شده</h6>
                                    <span class="badge bg-sky-blue text-white ms-2"><?php echo e(count($ccs)); ?> نفر</span>
                                </div>
                                <div class="d-flex flex-wrap gap-2">
                                    <?php $__currentLoopData = $ccs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $cc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="cc-tag-modern" wire:key="cc-<?php echo e($i); ?>">
                                            <i class="fas fa-user-circle me-2 text-primary"></i>
                                            <span class="fw-bold"><?php echo e($cc['name']); ?></span>
                                            <?php if($cc['position']): ?>
                                                <span class="text-muted ms-1">(<?php echo e($cc['position']); ?>)</span>
                                            <?php endif; ?>
                                            <button type="button" wire:click="removeCc(<?php echo e($i); ?>)" title="حذف">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-5 text-gray-500" style="background: linear-gradient(135deg, #f8fafc, #f1f5f9); border-radius: 12px; border: 1px dashed #e2e8f0;">
                            <i class="fas fa-users fa-3x mb-3 text-sky-blue" style="opacity: 0.6;"></i>
                            <p class="mb-1 fw-medium">هنوز رونوشتی اضافه نشده است.</p>
                            <p class="text-sm opacity-75">افراد یا واحدهای مورد نظر را از فیلد بالا اضافه کنید.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="form-section-modern">
                <h4><i class="fas fa-paperclip"></i> پیوست‌ها</h4>

                <div class="mt-4">
                    <label class="form-label-modern">انتخاب فایل‌های پیوست (اختیاری)</label>
                    <label for="attachment-uploader" class="uploader-box-modern"
                           @dragover.prevent="event.currentTarget.classList.add('dragover')"
                           @dragleave.prevent="event.currentTarget.classList.remove('dragover')"
                           @drop.prevent="event.currentTarget.classList.remove('dragover'); $wire.set('attachments', [...$wire.attachments, ...event.dataTransfer.files])"
                    >
                        <div class="uploader-icon-container-modern">
                            <i class="fas fa-cloud-upload-alt"></i>
                        </div>
                        <p class="text-gray-800 font-bold mb-2 fs-5">فایل‌ها را بکشید و رها کنید</p>
                        <span class="text-gray-600 d-block mb-3">یا برای انتخاب فایل کلیک کنید</span>
                        <div class="mt-3 text-sm text-gray-500 d-flex justify-content-center flex-wrap gap-3">
                            <span class="d-flex align-items-center fw-medium">
                                <i class="fas fa-file-pdf text-danger me-1"></i> PDF
                            </span>
                            <span class="d-flex align-items-center fw-medium">
                                <i class="fas fa-file-word text-primary me-1"></i> Word
                            </span>
                            <span class="d-flex align-items-center fw-medium">
                                <i class="fas fa-file-excel text-success me-1"></i> Excel
                            </span>
                            <span class="d-flex align-items-center fw-medium">
                                <i class="fas fa-file-image text-purple-500 me-1"></i> تصاویر
                            </span>
                            <span class="d-flex align-items-center fw-medium">
                                <i class="fas fa-file-archive text-warning me-1"></i> فشرده
                            </span>
                        </div>
                        <div class="mt-2 text-xs text-danger fw-medium">
                            <i class="fas fa-info-circle me-1"></i>
                            حداکثر حجم هر فایل: ۱۰ مگابایت
                        </div>
                    </label>
                    <input type="file" id="attachment-uploader" class="form-control-single" multiple wire:model="attachments" style="display:none;">

                    <?php if(count($attachments)): ?>
                        <ul class="file-list-modern mt-4 list-unstyled">
                            <?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li wire:key="attachment-<?php echo e($index); ?>">
                                    <span class="d-flex align-items-center">
                                        <?php
                                            $ext = is_string($file) ? pathinfo($file, PATHINFO_EXTENSION) : $file->getClientOriginalExtension();
                                            $icons = [
                                                'pdf' => ['icon' => 'fa-file-pdf', 'color' => 'text-red-500', 'bg' => 'bg-red-50'],
                                                'doc' => ['icon' => 'fa-file-word', 'color' => 'text-blue-500', 'bg' => 'bg-blue-50'],
                                                'docx' => ['icon' => 'fa-file-word', 'color' => 'text-blue-500', 'bg' => 'bg-blue-50'],
                                                'xls' => ['icon' => 'fa-file-excel', 'color' => 'text-green-500', 'bg' => 'bg-green-50'],
                                                'xlsx' => ['icon' => 'fa-file-excel', 'color' => 'text-green-500', 'bg' => 'bg-green-50'],
                                                'jpg' => ['icon' => 'fa-file-image', 'color' => 'text-purple-500', 'bg' => 'bg-purple-50'],
                                                'jpeg' => ['icon' => 'fa-file-image', 'color' => 'text-purple-500', 'bg' => 'bg-purple-50'],
                                                'png' => ['icon' => 'fa-file-image', 'color' => 'text-purple-500', 'bg' => 'bg-purple-50'],
                                                'zip' => ['icon' => 'fa-file-archive', 'color' => 'text-yellow-500', 'bg' => 'bg-yellow-50'],
                                                'rar' => ['icon' => 'fa-file-archive', 'color' => 'text-yellow-500', 'bg' => 'bg-yellow-50'],
                                            ];
                                            $fileInfo = $icons[strtolower($ext)] ?? ['icon' => 'fa-file-alt', 'color' => 'text-gray-500', 'bg' => 'bg-gray-50'];
                                        ?>
                                        <div class="me-3 p-2 rounded" style="background: var(--primary-light);">
                                            <i class="fas <?php echo e($fileInfo['icon']); ?> <?php echo e($fileInfo['color']); ?> fa-lg"></i>
                                        </div>
                                        <div>
                                            <span class="d-block fw-bold text-truncate" style="max-width: 350px;">
                                                <?php echo e(is_string($file) ? $file : $file->getClientOriginalName()); ?>

                                            </span>
                                            <?php if(!is_string($file)): ?>
                                                <span class="text-xs text-gray-600">
                                                    <i class="fas fa-weight-hanging me-1"></i>
                                                    <?php echo e(number_format($file->getSize() / 1024, 1)); ?> کیلوبایت
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </span>
                                    <button type="button" class="btn btn-sm btn-outline-danger" x-on:click="removeAttachment(<?php echo e($index); ?>)" title="حذف فایل">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php endif; ?>
                    <?php $__errorArgs = ['attachments.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="text-danger mt-2 fw-medium d-flex align-items-center">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        <?php echo e($message); ?>

                    </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="form-footer-actions">
                <div>
                    <button type="button" class="btn btn-modern-outline" wire:click="previewLetter">
                        <i class="fas fa-eye me-2"></i> پیش‌نمایش نامه
                    </button>
                </div>
                <div class="d-flex gap-3">
                    <button type="button" class="btn btn-modern-outline" wire:click="$dispatch('close-modal')">
                        <i class="fas fa-times me-2"></i> انصراف
                    </button>

                    <button type="submit" class="btn btn-modern-primary" wire:loading.attr="disabled">
                        <span wire:loading.remove>
                            <?php if($isEditing): ?>
                                <i class="fas fa-save me-2"></i> به‌روزرسانی نامه
                            <?php elseif($isSelfSigning): ?>
                                <i class="fas fa-signature me-2"></i> ذخیره و امضای نهایی نامه
                            <?php else: ?>
                                <i class="fas fa-paper-plane me-2"></i> ذخیره و ارجاع برای امضا
                            <?php endif; ?>
                        </span>
                        <span wire:loading>
                            <span class="spinner-border spinner-border-sm me-2" role="status"></span>
                            <span class="fw-bold">در حال ذخیره...</span>
                        </span>
                    </button>
                </div>
            </div>
        </form>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script src="<?php echo e(url('panel/plugin/tinymce/tinymce.min.js')); ?>"></script>
        <script>
            // تابع اصلی مقداردهی TinyMCE
            function initTinyMCEForLetter() {
                const textarea = document.getElementById('letter-content');
                if (!textarea) {
                    console.warn('Textarea برای TinyMCE یافت نشد.');
                    return;
                }

                // حذف نمونه قبلی اگر وجود دارد
                if (tinymce.get('letter-content')) {
                    tinymce.remove('#letter-content');
                }

                const container = document.querySelector('.tinymce-container-modern');
                if (!container) return;

                const livewireElement = document.querySelector('[x-data]');
                if (!livewireElement) return;

                const componentId = livewireElement.getAttribute('wire:id');
                if (!componentId) {
                    console.warn('Component ID برای Livewire یافت نشد.');
                    return;
                }

                tinymce.init({
                    selector: '#letter-content',
                    license_key: 'gpl',
                    language: 'fa',
                    directionality: 'rtl',
                    height: 500,
                    menubar: 'file edit view insert format tools table help',
                    plugins: 'preview importcss searchreplace autolink directionality visualblocks visualchars fullscreen image link media codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
                    toolbar: 'undo redo | bold italic underline strikethrough | fontfamily fontsize blocks | alignleft aligncenter alignright alignjustify | outdent indent | numlist bullist | forecolor backcolor removeformat | table | link | fullscreen preview print | ltr rtl',
                    toolbar_mode: 'sliding',
                    quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',
                    fontsize_formats: '8pt 10pt 12pt 14pt 16pt 18pt 20pt 24pt 36pt',
                    font_family_formats: 'PeydaWebNoEn=PeydaWebNoEn, sans-serif; IRANSans=IRANSans, sans-serif; Vazir=Vazir, sans-serif; B Yekan=B Yekan, sans-serif; IranNastaliq=IranNastaliq, serif; dana=dana, sans-serif; Tahoma=Tahoma, Geneva, sans-serif; Arial=Arial, Helvetica, sans-serif; Times New Roman=Times New Roman, serif; BNazanin=BNazanin, serif;',
                    content_style: `
                /* تعریف فونت‌های ایرانی برای TinyMCE iframe */
                @font-face {
                    font-family: 'PeydaWebNoEn';
                    src: url('/panel/dist/fonts/PeydaWeb/Woff2/PeydaWeb-Regular.woff2') format('woff2'),
                         url('/panel/dist/fonts/PeydaWeb/Woff/PeydaWeb-Regular.woff') format('woff');
                    font-weight: normal;
                    font-style: normal;
                    font-display: swap;
                }

                @font-face {
                    font-family: 'PeydaWebNoEn';
                    src: url('/panel/dist/fonts/PeydaWeb/Woff2/PeydaWeb-Bold.woff2') format('woff2'),
                         url('/panel/dist/fonts/PeydaWeb/Woff/PeydaWeb-Bold.woff') format('woff');
                    font-weight: bold;
                    font-style: normal;
                    font-display: swap;
                }

                @font-face {
                    font-family: 'PeydaWebNoEn';
                    src: url('/panel/dist/fonts/PeydaWeb/Woff2/PeydaWeb-Medium.woff2') format('woff2'),
                         url('/panel/dist/fonts/PeydaWeb/Woff/PeydaWeb-Medium.woff') format('woff');
                    font-weight: 500;
                    font-style: normal;
                    font-display: swap;
                }

                @font-face {
                    font-family: 'Vazir';
                    src: url('/panel/dist/fonts/vazir/Vazir.woff2') format('woff2');
                    font-weight: normal;
                    font-style: normal;
                    font-display: swap;
                }

                @font-face {
                    font-family: 'Vazir';
                    src: url('/panel/dist/fonts/vazir/Vazir-Bold.woff2') format('woff2');
                    font-weight: bold;
                    font-style: normal;
                    font-display: swap;
                }

                @font-face {
                    font-family: 'BNazanin';
                    src: url('/panel/dist/fonts/BNazanin/BNazanin.woff2') format('woff2'),
                         url('/panel/dist/fonts/BNazanin/BNazanin.woff') format('woff'),
                         url('/panel/dist/fonts/BNazanin/BNazanin.ttf') format('truetype');
                    font-weight: normal;
                    font-style: normal;
                    font-display: swap;
                }

                /* استایل اصلی محتوا */
                body, .mce-content-body {
                    font-family: 'PeydaWebNoEn', 'Vazir', 'IRANSans', Tahoma, Arial, sans-serif !important;
                    font-size: 14.5pt;
                    direction: rtl;
                    text-align: right;
                    line-height: 1.8;
                    color: #334155;
                    padding: 1.8rem;
                    background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
                }

                /* برای زمانی که کاربر فونت را از منوی dropdown انتخاب می‌کند */
                *[style*="font-family: PeydaWebNoEn"] {
                    font-family: 'PeydaWebNoEn', 'Vazir', sans-serif !important;
                }

                *[style*="font-family: Vazir"] {
                    font-family: 'Vazir', Tahoma, Arial, sans-serif !important;
                }

                *[style*="font-family: BNazanin"] {
                    font-family: 'BNazanin', serif !important;
                }

                /* استایل‌های دیگر */
                h1, h2, h3, h4, h5, h6 {
                    font-family: 'PeydaWebNoEn', 'Vazir', sans-serif !important;
                    color: #0f766e;
                    margin-top: 1.8em;
                    font-weight: 700;
                    border-bottom: 2px solid #e2e8f0;
                    padding-bottom: 0.5em;
                }

                table {
                    border-collapse: collapse;
                    width: 100%;
                    margin: 1.5em 0;
                    border-radius: 8px;
                    overflow: hidden;
                    box-shadow: 0 4px 6px rgba(0,0,0,0.05);
                }

                table, th, td {
                    border: 1px solid #cbd5e1;
                }

                th {
                    background: linear-gradient(135deg, #e0f2fe, #ccfbf1);
                    color: #0f766e;
                    font-weight: 700;
                }

                th, td {
                    padding: 12px 15px;
                    text-align: right;
                    font-family: inherit !important;
                }

                tr:nth-child(even) {
                    background-color: #f8fafc;
                }

                a {
                    color: #0ea5e9;
                    text-decoration: none;
                    border-bottom: 1px dotted #0ea5e9;
                }

                a:hover {
                    color: #0284c7;
                    border-bottom: 2px solid #0284c7;
                }

                blockquote {
                    border-right: 4px solid #0ea5e9;
                    background: #f0f9ff;
                    padding: 1.5rem;
                    margin: 1.5rem 0;
                    border-radius: 0 12px 12px 0;
                    font-style: italic;
                }

                /* استایل‌های مربوط به وزن‌های مختلف فونت */
                strong, b {
                    font-weight: bold !important;
                    font-family: inherit !important;
                }

                .font-weight-light {
                    font-weight: 300 !important;
                }

                .font-weight-medium {
                    font-weight: 500 !important;
                }
            `,
                    branding: false,
                    promotion: false,
                    relative_urls: false,
                    remove_script_host: false,
                    convert_urls: true,

                    images_upload_handler: function (blobInfo, success, failure) {
                        return new Promise((resolve, reject) => {
                            const formData = new FormData();
                            formData.append('image', blobInfo.blob(), blobInfo.filename());
                            formData.append('_token', '<?php echo e(csrf_token()); ?>');

                            const uploadUrl = '<?php echo e(route("upload.tinymce.image")); ?>';

                            fetch(uploadUrl, {
                                method: 'POST',
                                body: formData,
                                headers: {
                                    'X-Requested-With': 'XMLHttpRequest'
                                }
                            })
                                .then(response => {
                                    if (!response.ok) {
                                        throw new Error(`خطای HTTP! وضعیت: ${response.status}`);
                                    }
                                    return response.json();
                                })
                                .then(data => {
                                    if (data.location) {
                                        success(data.location);
                                        resolve(data.location);
                                    } else {
                                        failure('آپلود تصویر با خطا مواجه شد.');
                                        reject('آپلود تصویر با خطا مواجه شد.');
                                    }
                                })
                                .catch(error => {
                                    failure('خطا در آپلود: ' + error.message);
                                    reject('خطا در آپلود: ' + error.message);
                                });
                        });
                    },

                    setup: (editor) => {
                        editor.on('init', () => {
                            // بارگذاری محتوای اولیه
                            editor.setContent(textarea.value || '');

                            // به‌روزرسانی Placeholder
                            const plainText = editor.getContent({ format: 'text' }).trim();
                            const placeholder = container.querySelector('.editor-placeholder-modern');
                            if (placeholder) {
                                placeholder.style.display = plainText ? 'none' : 'block';
                            }

                            console.log('TinyMCE initialized with Persian fonts');
                        });

                        editor.on('change keyup', () => {
                            const html = editor.getContent();
                            try {
                                if (window.Livewire && componentId) {
                                    // Livewire.set با پرچم defer: true
                                    window.Livewire.find(componentId).set('content', html, true);
                                }
                            } catch (e) {
                                console.warn('خطا در بروزرسانی Livewire content:', e);
                            }

                            // به‌روزرسانی Placeholder
                            const plainText = editor.getContent({ format: 'text' }).trim();
                            const placeholder = container.querySelector('.editor-placeholder-modern');
                            if (placeholder) {
                                placeholder.style.display = plainText ? 'none' : 'block';
                            }
                        });

                        editor.on('blur', () => {
                            const html = editor.getContent();
                            try {
                                if (window.Livewire && componentId) {
                                    // Livewire.set بدون پرچم defer برای اطمینان از ارسال نهایی
                                    window.Livewire.find(componentId).set('content', html);
                                }
                            } catch (e) {
                                console.warn('خطا در بروزرسانی Livewire content on blur:', e);
                            }
                        });
                    }
                });
            }

            // رویداد اصلی Livewire - با رفع خطای Livewire is not defined
            document.addEventListener('livewire:init', function() {
                console.log('Livewire initialized, setting up TinyMCE...');
                const livewireElement = document.querySelector('[x-data]');
                const componentId = livewireElement ? livewireElement.getAttribute('wire:id') : null;


                // 1. مقداردهی اولیه با تاخیر برای اطمینان از بارگذاری DOM
                setTimeout(() => {
                    if (document.getElementById('letter-content')) {
                        console.log('Initializing TinyMCE for first time...');
                        initTinyMCEForLetter();
                    }
                }, 400);

                // 2. گوش دادن به رویداد content-loaded برای بارگذاری محتوای کپی شده
                Livewire.on('content-loaded', () => {
                    console.log('content-loaded event received');

                    setTimeout(() => {
                        const editor = tinymce.get('letter-content');
                        const textarea = document.getElementById('letter-content');

                        if (editor && textarea) {
                            // اگر ادیتور وجود دارد، محتوای جدید را ست کن
                            editor.setContent(textarea.value || '');

                            // به‌روزرسانی Placeholder
                            const container = document.querySelector('.tinymce-container-modern');
                            const placeholder = container ? container.querySelector('.editor-placeholder-modern') : null;
                            const plainText = editor.getContent({ format: 'text' }).trim();
                            if (placeholder) {
                                placeholder.style.display = plainText ? 'none' : 'block';
                            }
                        } else if (textarea) {
                            // اگر ادیتور وجود ندارد ولی textarea هست، init کن
                            console.log('TinyMCE editor not found, re-initializing...');
                            initTinyMCEForLetter();
                        }
                    }, 200);
                });

                // 3. گوش دادن به تغییرات DOM برای re-initialization (مورد نیاز در صورت جابجایی کامپوننت)
                Livewire.hook('message.processed', (message, component) => {
                    // بررسی تغییرات مرتبط با content
                    const hasContentUpdate = message.updateQueue?.some(u =>
                        u.payload?.name === 'content' ||
                        u.payload?.name === 'title' ||
                        u.type === 'callMethod'
                    );

                    if (hasContentUpdate) {
                        setTimeout(() => {
                            const textarea = document.getElementById('letter-content');
                            if (textarea && !tinymce.get('letter-content')) {
                                console.log('Re-initializing TinyMCE after Livewire update...');
                                initTinyMCEForLetter();
                            }
                        }, 150);
                    }
                });

                // کدهای مربوط به تاریخ شمسی
                if (typeof $ === 'function' && $.fn.persianDatepicker && componentId) {
                    $('#shamsi-date-input').persianDatepicker({
                        altField: '#shamsi-date-input',
                        altFormat: 'YYYY/MM/DD',
                        format: 'YYYY/MM/DD',
                        calendar: { persian: { locale: 'fa' } },
                        onSelect: function(unix, obj) {
                            const shamsiDate = obj.model.view.formatDate(obj.model.state, 'YYYY/MM/DD');
                            Livewire.find(componentId).set('letter_date_shamsi', shamsiDate);
                        }
                    });
                } else if (document.getElementById('shamsi-date-input')) {
                    $('#shamsi-date-input').attr('type', 'date');
                }

                // Listener برای پاک کردن محتوای TinyMCE
                Livewire.on('clear-tinymce-content', () => {
                    const editor = tinymce.get('letter-content');
                    if (editor) {
                        editor.setContent('');
                        const container = document.querySelector('.tinymce-container-modern');
                        const placeholder = container ? container.querySelector('.editor-placeholder-modern') : null;
                        if (placeholder) placeholder.style.display = 'block';
                    }
                });
            });

            // مقداردهی اضافی زمانی که DOM کاملاً بارگذاری شده
            document.addEventListener('DOMContentLoaded', function() {
                // ابتدا بررسی کن آیا Livewire بارگذاری شده
                if (typeof Livewire === 'undefined') {
                    console.warn('Livewire not loaded yet, waiting...');
                    // اگر Livewire بارگذاری نشده، منتظر بمان
                    const checkLivewire = setInterval(function() {
                        if (typeof Livewire !== 'undefined') {
                            clearInterval(checkLivewire);
                            console.log('Livewire loaded after DOMContentLoaded');
                            initTinyMCEAfterDOMReady();
                        }
                    }, 100);
                } else {
                    initTinyMCEAfterDOMReady();
                }

                function initTinyMCEAfterDOMReady() {
                    setTimeout(() => {
                        if (document.getElementById('letter-content') && !tinymce.get('letter-content')) {
                            console.log('DOM fully loaded, initializing TinyMCE...');
                            initTinyMCEForLetter();
                        }
                    }, 500);
                }
            });

            // فالس‌گیری برای زمانی که Livewire کامپوننت را mount می‌کند
            Livewire.hook('component.initialized', (component) => {
                setTimeout(() => {
                    const textarea = document.getElementById('letter-content');
                    if (textarea && !tinymce.get('letter-content')) {
                        console.log('Component initialized, setting up TinyMCE...');
                        initTinyMCEForLetter();
                    }
                }, 300);
            });

        </script>
    <?php $__env->stopPush(); ?>

    <div class="modal fade" id="previewModal" tabindex="-1" aria-labelledby="previewModalLabel" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered modal-fullscreen">
            <div class="modal-content rounded-4 shadow-lg border-0">
                <div class="modal-header py-3 border-bottom-0" style="background: linear-gradient(135deg, var(--sky-blue), var(--teal)); color: white; border-radius: 16px 16px 0 0;">
                    <h5 class="modal-title fw-bold" id="previewModalLabel">
                        <i class="fas fa-eye me-2"></i> پیش‌نمایش نامه
                    </h5>
                    <button type="button" class="btn-close btn-close-white" x-on:click="closePreviewModal()" aria-label="Close"></button>
                </div>
                <div class="modal-body p-0 bg-light">
                    <div class="p-3 d-flex justify-content-center align-items-start min-vh-100">
                        <div x-html="previewHtml" class="shadow-lg" style="max-width: 800px; width: 100%; min-height: 80vh; background: white; padding: 40px; border-radius: 10px; box-shadow: 0 20px 60px rgba(0,0,0,0.1) !important;"></div>
                    </div>
                </div>
                <div class="modal-footer d-flex justify-content-between border-top-0 bg-light rounded-bottom-4">
                    <button type="button" class="btn btn-modern-outline" onclick="window.print()">
                        <i class="fas fa-print me-2"></i> پرینت نامه
                    </button>
                    <button type="button" class="btn btn-modern-primary" x-on:click="closePreviewModal()">
                        <i class="fas fa-check me-2"></i> تأیید و بستن
                    </button>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\project-letter\create-letter.blade.php ENDPATH**/ ?>