<div class="container-fluid px-4 py-4">

    
    <?php if(session()->has('success')): ?>
        <div class="alert alert-success alert-dismissible fade show d-flex align-items-center" role="alert">
            <i class="fas fa-check-circle me-2"></i>
            <strong>انجام شد!</strong> <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    
    <div class="card border-0 shadow-sm rounded-4 mb-4">
        <div class="card-body p-4 d-flex align-items-center gap-3 flex-wrap">
            <?php if($user->image): ?>
                <img src="<?php echo e(Storage::disk('users')->url($user->image)); ?>" class="rounded-circle border" width="78" height="78" style="object-fit:cover;">
            <?php else: ?>
                <span class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center"
                      style="width:78px;height:78px;font-size:1.2rem;">
                    <?php echo e(strtoupper(mb_substr($user->name,0,1))); ?>

                </span>
            <?php endif; ?>

            <div class="me-auto">
                <div class="fw-bold fs-4"><?php echo e($user->name); ?></div>
                <div class="text-muted small"><?php echo e($user->email); ?> · <?php echo e($user->mobile); ?></div>
                <div class="mt-2 d-flex gap-2">
                    <span class="badge text-bg-<?php echo e($user->status==='active'?'success':'secondary'); ?>"><?php echo e($user->status==='active'?'فعال':'غیرفعال'); ?></span>
                    <span class="badge text-bg-secondary"><?php echo e($user->role ?? 'user'); ?></span>
                    <?php if($user->gender): ?>
                        <span class="badge text-bg-light text-dark"><?php echo e($user->gender==='male'?'مرد':'زن'); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="d-flex gap-2">






                <button class="btn btn-outline-info" wire:click="openPasswordModal">
                    <i class="fas fa-key"></i> تغییر رمز
                </button>
            </div>
        </div>
    </div>

    
    <div class="card border-0 shadow-sm rounded-4">
        <div class="card-header bg-white p-0 border-bottom">
            <ul class="nav nav-tabs nav-fill border-0" role="tablist">
                <li class="nav-item"><a class="nav-link active py-3" data-bs-toggle="tab" href="#overview" role="tab">نمای کلی</a></li>
                <li class="nav-item"><a class="nav-link py-3" data-bs-toggle="tab" href="#work" role="tab">سازمانی</a></li>
                <li class="nav-item"><a class="nav-link py-3" data-bs-toggle="tab" href="#security" role="tab">امنیت</a></li>
                <li class="nav-item"><a class="nav-link py-3" data-bs-toggle="tab" href="#activity" role="tab">فعالیت</a></li>
            </ul>
        </div>

        <div class="card-body p-4">
            <div class="tab-content">

                
                <div class="tab-pane fade show active" id="overview" role="tabpanel">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="border rounded-3 p-3 h-100">
                                <div class="fw-semibold mb-2">اطلاعات تماس</div>
                                <div class="small text-muted">ایمیل: <span class="text-dark"><?php echo e($user->email); ?></span></div>
                                <div class="small text-muted">موبایل: <span class="text-dark"><?php echo e($user->mobile); ?></span></div>
                                <div class="small text-muted">کد ملی: <span class="text-dark"><?php echo e($user->ncode ?? '—'); ?></span></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="border rounded-3 p-3 h-100">
                                <div class="fw-semibold mb-2">وضعیت و نقش</div>
                                <div class="small text-muted">وضعیت: <span class="text-dark"><?php echo e($user->status==='active'?'فعال':'غیرفعال'); ?></span></div>
                                <div class="small text-muted">نقش: <span class="text-dark"><?php echo e($user->role ?? 'user'); ?></span></div>
                                <div class="small text-muted">مدرک: <span class="text-dark"><?php echo e($user->degree ?? '—'); ?></span></div>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="tab-pane fade" id="work" role="tabpanel">
                    <div class="border rounded-3 p-3">
                        <div class="row g-3 small">
                            <?php
                                $dept = $user->department;
                                $companyName = $user->company->name ?? optional($dept?->company)->name ?? '—';
                            ?>
                            <div class="col-md-4">شرکت: <span class="text-dark"><?php echo e($companyName); ?></span></div>
                            <div class="col-md-4">دپارتمان: <span class="text-dark"><?php echo e($dept->name ?? '—'); ?></span></div>
                            <div class="col-md-4">تاریخ عضویت: <span class="text-dark"><?php echo e($user->created_at->format('Y/m/d')); ?></span></div>
                        </div>
                    </div>
                </div>

                
                <div class="tab-pane fade" id="security" role="tabpanel">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="border rounded-3 p-3 h-100">
                                <div class="fw-semibold mb-2">ورود و نشست</div>
                                <div class="small text-muted">آخرین ورود: <span class="text-dark"><?php echo e($user->last_login_at ? $user->last_login_at->diffForHumans() : 'هرگز'); ?></span></div>
                                <div class="small text-muted">به‌روزرسانی: <span class="text-dark"><?php echo e($user->updated_at->diffForHumans()); ?></span></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="border rounded-3 p-3 h-100">
                                <div class="fw-semibold mb-2">احراز هویت</div>
                                <div class="small text-muted">2FA: <span class="text-dark"><?php echo e(isset($user->two_factor_confirmed_at) && $user->two_factor_confirmed_at ? 'فعال' : 'غیرفعال'); ?></span></div>
                                <div class="small text-muted">وضعیت حساب: <span class="text-dark"><?php echo e($user->status==='active'?'Active':'Inactive'); ?></span></div>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="tab-pane fade" id="activity" role="tabpanel">
                    <div class="border rounded-3 p-3 small">
                        <div class="mb-2">تایم‌لاین</div>
                        <ul class="list-unstyled m-0">
                            <li class="mb-1">ایجاد حساب: <span class="text-dark"><?php echo e($user->created_at->format('Y/m/d H:i')); ?></span></li>
                            <li class="mb-1">آخرین بروزرسانی: <span class="text-dark"><?php echo e($user->updated_at->format('Y/m/d H:i')); ?></span></li>
                            <li class="mb-1">آخرین ورود: <span class="text-dark"><?php echo e($user->last_login_at ? $user->last_login_at->format('Y/m/d H:i') : '—'); ?></span></li>
                        </ul>
                        
                    </div>
                </div>

            </div>
        </div>
    </div>

    
    <?php if($showPasswordModal): ?>
        <div class="modal fade show d-block"
             tabindex="-1" role="dialog" aria-modal="true"
             wire:click.self="closePasswordModal"
             wire:keydown.escape.window="closePasswordModal"
             style="display:block;">
            <div class="modal-dialog">
                <div class="modal-content border-0 rounded-4 shadow-lg">
                    <div class="modal-header bg-primary text-white rounded-top-4">
                        <h5 class="modal-title">تغییر رمز کاربر</h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="closePasswordModal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">رمز عبور جدید</label>
                            <input type="password" class="form-control <?php $__errorArgs = ['newPassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model.defer="newPassword">
                            <?php $__errorArgs = ['newPassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">تکرار رمز عبور</label>
                            <input type="password" class="form-control <?php $__errorArgs = ['newPasswordConfirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model.defer="newPasswordConfirmation">
                            <?php $__errorArgs = ['newPasswordConfirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="modal-footer border-0 pt-0">
                        <button type="button" class="btn btn-secondary px-4" wire:click="closePasswordModal">انصراف</button>
                        <button type="button" class="btn btn-primary px-4" wire:click="updatePassword" wire:loading.attr="disabled">
                            <span wire:loading.remove><i class="fas fa-save"></i> ذخیره رمز</span>
                            <span wire:loading><i class="fas fa-spinner fa-spin"></i> در حال ذخیره...</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    <?php endif; ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\users\user-profile.blade.php ENDPATH**/ ?>