<?php if($showAddGroupModal): ?>
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);" x-data>
        <div class="modal-dialog modal-sm modal-dialog-centered"> 
            <div class="modal-content rounded-3 border-0 shadow-lg">

                
                <div class="modal-header bg-primary text-white border-bottom-0 rounded-top-3 p-4">
                    <h5 class="modal-title fw-bolder d-flex align-items-center">
                        <i class="ti ti-folder-plus me-2 fs-4"></i>
                        ایجاد گروه جدید
                    </h5>
                    <button type="button" class="btn-close btn-close-white opacity-100" aria-label="بستن"
                            wire:click="closeAddGroupModal"></button>
                </div>

                <form wire:submit.prevent="saveGroup">
                    <div class="modal-body p-4">

                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">نام گروه</label>
                            <input type="text" wire:model.defer="newGroupName" class="form-control rounded-3"
                                   placeholder="مثلاً: دوستان، همکاران...">
                            <?php $__errorArgs = ['newGroupName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <?php if($hasColorColumn): ?>
                            
                            <div class="mb-3">
                                <label class="form-label fw-bold d-flex justify-content-between align-items-center">
                                    رنگ گروه (انتخابگر هگز)
                                    <span class="badge" style="background-color: <?php echo e($newGroupColor); ?>; color: <?php echo e($newGroupColor); ?>; border: 1px solid #ccc;">&nbsp;</span>
                                </label>

                                <div class="input-group">
                                    
                                    <span class="input-group-text rounded-start-3 text-muted">#</span>
                                    <input type="text" wire:model.defer="newGroupColor" class="form-control"
                                           placeholder="#4361EE" maxlength="7" style="direction: ltr; text-align: left;">

                                    
                                    <input type="color" wire:model.live="newGroupColor"
                                           class="form-control form-control-color" style="width: 50px; min-width: 50px;"
                                           title="انتخاب رنگ">
                                </div>
                                <?php $__errorArgs = ['newGroupColor'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <?php endif; ?>

                    </div>

                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-secondary rounded-pill px-4" wire:click="closeAddGroupModal">انصراف</button>
                        <button type="submit" class="btn btn-primary rounded-pill px-4 fw-bold" wire:loading.attr="disabled">
                            <span wire:loading.remove>ایجاد گروه</span>
                            <span wire:loading>... در حال ایجاد</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php endif; ?><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\contact\modals\add-group.blade.php ENDPATH**/ ?>