<div class="container-fluid py-4" x-data="{
    bulkMode: false,
    selectedRequests: <?php if ((object) ('selectedRequests') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('selectedRequests'->value()); ?>')<?php echo e('selectedRequests'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('selectedRequests'); ?>')<?php endif; ?>,
    expandedRow: null
}">
    <style>
        /* 💎 استایل‌های اختصاصی Premium v23 */
        .fw-black { font-weight: 900 !important; }
        .smaller-8 { font-size: 0.8rem; }
        .bg-light-primary { background-color: #f1f3ff !important; }
        .bg-light-success { background-color: #e8fff3 !important; }
        .bg-light-info { background-color: #e8faff !important; }
        .text-primary { color: #4e73df !important; }
        .transition-all { transition: all 0.3s ease; }
        .shadow-2xl { box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25) !important; }
        .rounded-5 { border-radius: 2rem !important; }

        .signature-box {
            min-height: 120px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .stamp-approved {
            width: 80px;
            position: absolute;
            top: 10px;
            right: 10px;
            opacity: 0.3;
            transform: rotate(-15deg);
            pointer-events: none;
        }

        /* طراحی آکاردئونی */
        .custom-scroll::-webkit-scrollbar { width: 5px; }
        .custom-scroll::-webkit-scrollbar-thumb { background: #e2e8f0; border-radius: 10px; }

        @media print {
            .no-print { display: none !important; }
            .modal { position: relative; display: block; border: none; }
            .modal-dialog { max-width: 100%; margin: 0; }
            .card { border: 1px solid #eee !important; box-shadow: none !important; }
        }
    </style>

    
    <div class="card border-0 shadow-sm mb-4 bg-dark text-white no-print" style="border-radius: 20px; background: linear-gradient(135deg, #1a1c2d 0%, #2d3154 100%);">
        <div class="card-body p-4">
            <div class="d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center">
                    <div class="p-3 bg-white bg-opacity-10 rounded-4 me-4 shadow-lg">
                        <i class="ti ti-layers-linked fs-1 text-primary"></i>
                    </div>
                    <div>
                        <h3 class="fw-black mb-1 text-white">مرکز فرماندهی تدارکات</h3>
                        <p class="mb-0 opacity-75 fw-bold smaller-8">نظارت بر زنجیره تأمین و مدیریت هوشمند تاییدات تدارکاتی</p>
                    </div>
                </div>
                <div class="d-flex gap-2">
                    <button wire:click="exportExcel" class="btn btn-primary rounded-pill px-4 fw-black shadow-lg border-0">
                        <i class="ti ti-file-spreadsheet me-2"></i>گزارش جامع
                    </button>
                    <button @click="bulkMode = !bulkMode" class="btn btn-warning rounded-pill px-4 fw-black shadow-sm text-dark border-0">
                        <i class="ti ti-layers-intersect me-2"></i>عملیات گروهی
                    </button>
                </div>
            </div>
        </div>
    </div>

    
    <div class="card border-0 shadow-sm mb-4 rounded-4 no-print">
        <div class="card-body p-4">
            <div class="row g-3 align-items-end">
                <div class="col-md-4">
                    <label class="form-label fw-black smaller-8 text-muted mb-2 pe-2">جستجوی متنی</label>
                    <div class="input-group">
                        <span class="input-group-text bg-light border-0 rounded-start-3"><i class="ti ti-search text-muted"></i></span>
                        <input type="text" class="form-control border-0 bg-light rounded-end-3 fw-bold" wire:model.live.debounce.300ms="search" placeholder="کد PR، پروژه یا متقاضی...">
                    </div>
                </div>
                <div class="col-md-2">
                    <label class="form-label fw-black smaller-8 text-muted mb-2 pe-2">وضعیت بررسی</label>
                    <select class="form-select border-0 bg-light rounded-3 fw-bold text-dark" wire:model.live="statusFilter">
                        <option value="">تمام وضعیت‌ها</option>
                        <option value="pending">⏳ در انتظار</option>
                        <option value="approved">✅ تایید نهایی</option>
                        <option value="rejected">❌ رد شده</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-black smaller-8 text-muted mb-2 pe-2">پروژه مقصد</label>
                    <select class="form-select border-0 bg-light rounded-3 fw-bold text-dark" wire:model.live="projectFilter">
                        <option value="">همه پروژه‌ها</option>
                        <?php $__currentLoopData = $this->projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($project->id); ?>"><?php echo e($project->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <button wire:click="resetFilters" class="btn btn-light w-100 rounded-3 fw-black border border-secondary border-opacity-10 py-2">
                        <i class="ti ti-refresh me-1"></i>بازنشانی فیلترها
                    </button>
                </div>
            </div>
        </div>
    </div>

    
    <div class="card border-0 shadow-lg rounded-4 overflow-hidden no-print">
        <div class="table-responsive">
            <table class="table align-middle mb-0">
                <thead class="bg-dark text-white">
                <tr>
                    <th class="py-3 px-4" x-show="bulkMode" x-cloak style="width: 50px;">-</th>
                    <th class="py-3 px-4">اطلاعات پرونده</th>
                    <th class="py-3">متقاضی ثبت</th>
                    <th class="py-3 text-center">مبلغ برآورد</th>
                    <th class="py-3 text-center" style="width: 200px;">وضعیت تایید</th>
                    <th class="py-3 text-center">عملیات</th>
                </tr>
                </thead>
                <tbody class="bg-white">
                <?php $__empty_1 = true; $__currentLoopData = $this->purchaseRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $totalApprovals = $request->approvals->count();
                        $approvedCount = $request->approvals->where('is_approved', true)->count();
                        $percent = $totalApprovals > 0 ? ($approvedCount / $totalApprovals) * 100 : 0;
                    ?>

                    <tr :class="expandedRow === <?php echo e($request->id); ?> ? 'bg-light-primary' : ''" class="transition-all">
                        <td class="px-4" x-show="bulkMode" x-cloak>
                            <input type="checkbox" class="form-check-input" value="<?php echo e($request->id); ?>" x-model="selectedRequests">
                        </td>
                        <td class="px-4">
                            <div class="d-flex align-items-center">
                                <button @click="expandedRow = (expandedRow === <?php echo e($request->id); ?> ? null : <?php echo e($request->id); ?>)"
                                        class="btn btn-sm btn-icon btn-white border rounded-circle me-3 shadow-sm">
                                    <i class="ti text-primary fs-5" :class="expandedRow === <?php echo e($request->id); ?> ? 'ti-minus' : 'ti-plus'"></i>
                                </button>
                                <div>
                                    <div class="fw-black text-dark fs-6">PR-<?php echo e($request->id); ?></div>
                                    <small class="text-muted fw-bold"><?php echo e(Str::limit($request->project->name, 25)); ?></small>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="<?php echo e($request->user->image ? asset('storage/' . $request->user->image) : 'https://ui-avatars.com/api/?name=' . urlencode($request->user->name) . '&background=f1f5f9&color=6366f1&bold=true'); ?>"
                                     class="rounded-4 me-3 avatar-lux shadow-sm" width="38" height="38">
                                <div>
                                    <span class="fw-black d-block text-dark"><?php echo e($request->user->name); ?></span>
                                    <span class="text-muted fw-bold smaller-8"><?php echo e(jdate($request->created_at)->format('Y/m/d')); ?></span>
                                </div>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="fw-black text-primary fs-5"><?php echo e(number_format($request->total_price)); ?></div>
                            <div class="smaller-8 fw-bold text-muted">IRR</div>
                        </td>
                        <td class="text-center">
                            <div class="d-flex flex-column align-items-center">
                                <div class="progress w-100 mb-2 shadow-sm" style="height: 8px; border-radius: 10px; background: #eee;">
                                    <div class="progress-bar bg-success progress-bar-striped progress-bar-animated" style="width: <?php echo e($percent); ?>%"></div>
                                </div>
                                <div class="d-flex justify-content-between w-100 px-1">
                                        <span class="smaller-8 fw-black text-<?php echo e($request->status == 'approved' ? 'success' : 'warning'); ?>">
                                            <?php echo e($request->status == 'approved' ? 'تایید نهایی' : 'در جریان'); ?>

                                        </span>
                                    <span class="smaller-8 fw-black text-muted"><?php echo e($approvedCount); ?>/<?php echo e($totalApprovals); ?></span>
                                </div>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="d-flex justify-content-center gap-2">
                                <button class="btn btn-icon btn-white border border-secondary border-opacity-10 btn-sm rounded-circle shadow-sm" data-bs-toggle="modal" data-bs-target="#detailModal<?php echo e($request->id); ?>">
                                    <i class="ti ti-file-search fs-5 text-primary"></i>
                                </button>
                                <button class="btn btn-icon btn-white border border-secondary border-opacity-10 btn-sm rounded-circle shadow-sm" wire:click="deleteRequest(<?php echo e($request->id); ?>)" wire:confirm="آیا از حذف این پرونده مطمئن هستید؟">
                                    <i class="ti ti-trash fs-5 text-danger"></i>
                                </button>
                            </div>
                        </td>
                    </tr>

                    
                    <tr x-show="expandedRow === <?php echo e($request->id); ?>" x-cloak x-transition>
                        <td colspan="7" class="p-0 border-0">
                            <div class="px-5 py-4 bg-light-primary border-start border-primary border-5 mx-4 my-2 rounded-4 shadow-inner">
                                <div class="row align-items-center">
                                    <div class="col-md-7">
                                        <h6 class="fw-black mb-3 text-primary smaller-8 uppercase"><i class="ti ti-list me-2"></i>اقلام کلیدی این درخواست:</h6>
                                        <div class="table-responsive bg-white rounded-4 shadow-sm border border-primary border-opacity-10">
                                            <table class="table table-sm mb-0">
                                                <thead class="bg-light">
                                                <tr class="smaller-8 fw-black text-muted">
                                                    <th class="ps-3 py-2">نام کالا/خدمت</th>
                                                    <th class="text-center">تعداد</th>
                                                    <th class="text-end pe-3">واحد</th>
                                                </tr>
                                                </thead>
                                                <tbody class="fw-bold">
                                                <?php $__currentLoopData = $request->items->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td class="ps-3 py-2 small"><?php echo e($item->displayName); ?></td>
                                                        <td class="text-center text-primary"><?php echo e($item->quantity); ?></td>
                                                        <td class="text-end pe-3 text-muted small">عدد</td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                        <div class="p-4 bg-white rounded-4 shadow-sm h-100 border border-secondary border-opacity-10">
                                            <div class="smaller-8 fw-black text-muted mb-2 pe-2 border-bottom pb-2 uppercase">توضیحات و شرح ضرورت:</div>
                                            <p class="small fw-bold text-dark mb-0" style="line-height: 1.8; text-align: justify;">
                                                <?php echo e($request->description ?: 'توضیحاتی ثبت نشده است.'); ?>

                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="10" class="text-center py-5 opacity-50 fw-black text-muted">هیچ درخواستی یافت نشد.</td></tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="card-footer bg-white border-0 p-4">
            <?php echo e($this->purchaseRequests->links()); ?>

        </div>
    </div>

    
    <div x-show="bulkMode && selectedRequests.length > 0"
         x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="transform translate-y-full opacity-0"
         x-transition:enter-end="transform translate-y-0 opacity-100"
         class="position-fixed bottom-0 start-50 translate-middle-x mb-4 z-3 shadow-lg no-print" x-cloak>
        <div class="bg-dark text-white rounded-pill px-5 py-3 d-flex align-items-center gap-4 border border-primary border-opacity-25 shadow-2xl">
            <span class="fw-black fs-5 text-primary" x-text="selectedRequests.length"></span>
            <span class="fw-bold fs-6">پرونده منتخب</span>
            <div class="vr opacity-25" style="height: 30px;"></div>
            <div class="d-flex gap-2">
                <button class="btn btn-success rounded-pill fw-black px-4 shadow-sm" wire:click="bulkApprove(selectedRequests)">تأیید دسته‌جمعی</button>
                <button class="btn btn-danger rounded-pill fw-black px-4 shadow-sm" wire:click="bulkReject(selectedRequests)">رد گروهی</button>
                <button class="btn btn-link text-white-50 btn-sm text-decoration-none fw-bold" @click="bulkMode = false; selectedRequests = []">انصراف</button>
            </div>
        </div>
    </div>

    
    
    <?php $__currentLoopData = $this->purchaseRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="modal fade" id="detailModal<?php echo e($request->id); ?>" tabindex="-1" wire:ignore.self>
            <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content border-0 rounded-5 shadow-2xl overflow-hidden">

                    <div class="modal-header bg-dark text-white p-4 border-0">
                        <div class="d-flex align-items-center">
                            <div class="p-3 bg-primary rounded-4 me-4 shadow-lg">
                                <i class="ti ti-file-certificate fs-1 text-white"></i>
                            </div>
                            <div>
                                <h4 class="fw-black mb-1 text-white">پرونده رسمی تدارکات</h4>
                                <div class="d-flex gap-4 smaller fw-bold opacity-75">
                                    <span>کد: #<?php echo e($request->id); ?></span>
                                    <span>ثبت: <?php echo e(jdate($request->created_at)->format('Y/m/d')); ?></span>
                                </div>
                            </div>
                        </div>
                        <button type="button" class="btn-close btn-close-white no-print" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body p-0 bg-white custom-scroll">
                        
                        <div class="p-5 pb-0">
                            <div class="row g-4">
                                <div class="col-md-4">
                                    <div class="p-4 rounded-4 border border-primary border-opacity-10 bg-light-primary h-100">
                                        <div class="smaller-8 fw-black text-primary mb-2 uppercase pe-2 border-start border-3 border-primary">پروژه مقصد</div>
                                        <div class="fw-black text-dark fs-5"><?php echo e($request->project->name); ?></div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="p-4 rounded-4 border border-info border-opacity-10 bg-light-info h-100">
                                        <div class="smaller-8 fw-black text-info mb-2 uppercase pe-2 border-start border-3 border-info">تاریخ نیاز</div>
                                        <div class="fw-black text-dark fs-5"><?php echo e(jdate($request->required_by)->format('Y/m/d')); ?></div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="p-4 rounded-4 border border-success border-opacity-10 bg-light-success h-100">
                                        <div class="smaller-8 fw-black text-success mb-2 uppercase pe-2 border-start border-3 border-success">برآورد کل</div>
                                        <div class="fw-black text-dark fs-4"><?php echo e(number_format($request->total_price)); ?> <small class="fs-6 opacity-50">ریال</small></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                        <?php if($request->status == 'pending'): ?>
                            <?php
                                // بررسی اینکه آیا کاربر فعلی اجازه تایید در این مرحله را دارد یا خیر
                                $userApproval = $request->approvals->where('user_id', auth()->id())->whereNull('is_approved')->first();
                            ?>

                            <?php if($userApproval): ?>
                                <div class="px-5 mt-5 no-print">
                                    <div class="p-4 rounded-5 border border-primary border-2 bg-light-primary shadow-sm">
                                        <div class="row align-items-center">
                                            <div class="col-md-7">
                                                <h6 class="fw-black text-primary mb-3"><i class="ti ti-writing-sign me-2"></i>بخش اقدام مدیریتی (منتظر نظر شما)</h6>
                                                <textarea class="form-control border-0 shadow-sm rounded-4 p-3 fw-bold"
                                                          wire:model="comment"
                                                          rows="2"
                                                          placeholder="یادداشت، دلیل رد یا توضیحات فنی خود را اینجا بنویسید..."></textarea>
                                            </div>
                                            <div class="col-md-5 text-md-end mt-3 mt-md-0">
                                                <div class="d-flex gap-3 justify-content-md-end">
                                                    <button wire:click="rejectRequest(<?php echo e($request->id); ?>)" class="btn btn-danger rounded-pill px-5 py-3 fw-black shadow-lg">
                                                        <i class="ti ti-x me-2"></i>رد درخواست
                                                    </button>
                                                    <button wire:click="approveRequest(<?php echo e($request->id); ?>)" class="btn btn-success rounded-pill px-5 py-3 fw-black shadow-lg">
                                                        <i class="ti ti-check me-2"></i>تایید و امضا
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>

                        
                        <div class="px-5 mt-5">
                            <div class="card border border-secondary border-opacity-10 shadow-none rounded-4 overflow-hidden">
                                <div class="card-header bg-light py-3"><h6 class="fw-black text-dark mb-0 small uppercase">ریز لیست اقلام</h6></div>
                                <div class="table-responsive">
                                    <table class="table table-hover align-middle mb-0">
                                        <thead class="bg-light-subtle">
                                        <tr class="smaller-8 fw-black text-muted">
                                            <th class="ps-4">شرح کالا</th>
                                            <th class="text-center">تعداد</th>
                                            <th class="text-end pe-4">جمع (ریال)</th>
                                        </tr>
                                        </thead>
                                        <tbody class="fw-bold">
                                        <?php $__currentLoopData = $request->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="ps-4"><?php echo e($item->displayName); ?></td>
                                                <td class="text-center"><?php echo e($item->quantity); ?></td>
                                                <td class="text-end pe-4 text-primary"><?php echo e(number_format($item->subtotal)); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        
                        <div class="p-5 mt-4 bg-light-subtle border-top border-secondary border-opacity-10">
                            <h6 class="fw-black text-dark mb-5 text-center fs-4"><i class="ti ti-signature me-2 text-primary"></i>چرخه تاییدات و امضای الکترونیک</h6>
                            <div class="row g-4 justify-content-center">
                                <?php $__currentLoopData = $request->approvals->sortBy('priority'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-4 col-lg-3">
                                        <div class="card border shadow-sm rounded-4 p-4 position-relative overflow-hidden <?php echo e($approval->is_approved ? 'bg-white border-success border-opacity-50' : 'bg-white bg-opacity-50 border-secondary border-opacity-10'); ?>">
                                            <div class="text-center mb-3">
                                                <div class="smaller-8 fw-black text-muted mb-1 uppercase"><?php echo e($approval->role->name); ?></div>
                                                <div class="fw-black text-dark border-bottom border-dark border-opacity-10 pb-2 d-inline-block"><?php echo e($approval->user->name ?? 'در انتظار'); ?></div>
                                            </div>
                                            <div class="signature-box position-relative">
                                                <div class="signature-box position-relative">
                                                    <?php if($approval->is_approved === true): ?>


                                                        
                                                        <?php
                                                            $userSign = $approval->user->sign;
                                                        ?>

                                                        <div class="d-flex align-items-center justify-content-center" style="min-height: 80px;">
                                                            <?php if($userSign): ?>
                                                                <img src="<?php echo e(asset('storage/' . $userSign)); ?>"
                                                                     style="max-width: 150px; max-height: 80px; filter: contrast(120%) sepia(100%) hue-rotate(190deg) saturate(200%); object-fit: contain;"
                                                                     alt="Signature">
                                                            <?php else: ?>
                                                                
                                                                <div class="text-primary opacity-50" style="font-family: 'Dancing Script', cursive; font-size: 1.5rem; border-bottom: 2px solid #4e73df;">
                                                                    <?php echo e($approval->user->name); ?>

                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                    <?php elseif($approval->is_approved === false): ?>
                                                        <div class="text-danger fw-black border border-danger border-2 p-2 rounded-3 shadow-sm"
                                                             style="transform: rotate(-5deg); border-style: dashed !important; background: rgba(220, 53, 69, 0.05);">
                                                            عدم تایید / ابطال
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="text-muted opacity-25 fw-bold italic small py-4 text-center">
                                                            <i class="ti ti-clock-pause d-block fs-2 mb-2"></i>
                                                            در انتظار بررسی...
                                                        </div>
                                                    <?php endif; ?>
                                                </div>










                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer bg-dark p-4 no-print border-0">
                        <div class="d-flex justify-content-between w-100 align-items-center">
                            <div class="text-white bg-white bg-opacity-10 px-4 py-2 rounded-pill smaller-8 fw-bold">
                                <i class="ti ti-file-type-pdf me-2 text-danger"></i>نسخه قابل دانلود جهت آرشیو فیزیکی
                            </div>
                            <div class="d-flex gap-2">
                                <button wire:click="downloadPdf(<?php echo e($request->id); ?>)" class="btn btn-danger rounded-pill px-4 fw-black">
                                    <i class="ti ti-download me-2"></i>دریافت PDF رسمی
                                </button>

                                <button class="btn btn-outline-light rounded-pill px-4 fw-black border-2" onclick="window.print()">
                                    <i class="ti ti-printer me-2"></i>چاپ سریع
                                </button>
                                <button type="button" class="btn btn-primary rounded-pill px-4 fw-black" data-bs-dismiss="modal">خروج</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\purchase\all-purchase-requests.blade.php ENDPATH**/ ?>