<div class="card mt-5 shadow border-0 modern-comments">
    <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center pb-1">
        <span class="fw-bold text-primary" style="font-size:1.15rem;">
            <i class="ti ti-message-dots ms-1"></i>
            گفت‌وگوها
        </span>
        <?php if($replyTo): ?>
            <button wire:click="cancelReply" class="btn btn-sm btn-outline-danger shadow-none ms-2">
                خروج از پاسخ
            </button>
        <?php endif; ?>
    </div>
    <div class="card-body modern-bg-light" style="min-height:120px;">

        <?php
            // 🛑 تابع بازگشتی برای نمایش کامنت‌ها و پاسخ‌ها
            function renderComments($comments, $replyToId, $depth = 0, $taskId, $component) {
                // رنگ‌های زمینه بر اساس عمق
                $bgColor = $depth === 0 ? '#FFFFFF' : '#FAFBFC';
                $isRoot = $depth === 0;

                foreach($comments as $comment) {
                    $margin = $depth * 25;
                    $isAssignee = $component->task->assigned_to == $comment->user_id;
                    $isReplyFormOpen = $replyToId == $comment->id;

                    // 💡 کلاس نهایی با عمق و سایه
                    $itemClass = $isRoot ? 'modern-comment-item-root' : 'modern-comment-item-reply';

                    echo '<div class="modern-comment-item mb-3 fadeIn '.$itemClass.'" style="margin-right:'.$margin.'px; background:'.$bgColor.';">';

                        // Header and Meta
                        echo '<div class="d-flex align-items-center justify-content-between gap-2">';

                            // User Info
                            echo    '<div class="d-flex align-items-center gap-2">';
                            // 💡 FIX: مسیر آواتار را به صورت واضح تعریف می‌کنیم
                            $avatar = $comment->user->image ? asset('storage/'.$comment->user->image) : asset('panel/dist/images/profile/user-default.svg');
                            echo        '<img src="'.$avatar.'" style="width:34px;height:34px" class="rounded-circle comment-avatar">';
                            echo        '<span class="fw-bold text-dark">'.e($comment->user->name ?? '—').'</span>';
                            if($isAssignee) echo '<span class="badge bg-action-primary-soft ms-1" style="font-size:0.80em">مسئول تسک</span>';
                            echo    '</div>';

                            // Time and Actions
                            echo    '<div class="d-flex align-items-center gap-3">';
                            echo        '<span class="text-muted small modern-time">'
                                            . (function_exists('verta') ? verta($comment->created_at)->formatDifference() : $comment->created_at->diffForHumans()).'</span>';
                            echo        '<button wire:click="setReply('.$comment->id.')" class="modern-reply btn btn-link btn-sm p-0 text-action-primary"><i class="ti ti-message-circle"></i> پاسخ</button>';
                            echo    '</div>';
                        echo '</div>'; // End Header

                        // Body
                        echo '<div class="mt-2 mb-2 px-1 text-body" style="font-size:1rem; white-space:pre-line; padding-right: 40px;">'.e($comment->body).'</div>';

                        // Attachment Display
                        if($comment->file_path) {
                            $fileUrl = asset('storage/'.$comment->file_path);
                            echo '<a href="'.$fileUrl.'" target="_blank" class="ms-2 small modern-attach text-primary d-inline-flex align-items-center"><i class="ti ti-paperclip me-1"></i> پیوست فایل</a>';
                        }

                        // 🛑 Conditional Reply Form
                        if ($isReplyFormOpen) {
                            echo '<div class="comment-input-form mt-3 border-top pt-3" id="reply-form-'.$comment->id.'">';
                            echo   '<form wire:submit.prevent="postComment('.$comment->task_id.', '.$comment->id.')" wire:key="reply-form-'.$comment->id.'">';
                            echo     '<textarea wire:model.defer="replyBody.'.$comment->id.'" class="form-control rounded-lg mb-2" rows="1" placeholder="پاسخ به '.e($comment->user->name ?? '—').'..."></textarea>';
                            echo     '<div class="d-flex justify-content-end">';
                            echo       '<button type="submit" class="btn btn-sm btn-primary rounded-pill fw-bold" wire:loading.attr="disabled">ارسال پاسخ</button>';
                            echo     '</div>';
                            echo   '</form>';
                            echo '</div>';
                        }

                        // 🛑 نمایش ریپلای‌ها
                        if($comment->replies->count()) {
                            renderComments($comment->replies, $replyToId, $depth+1, $taskId, $component);
                        }

                    echo '</div>'; // End modern-comment-item
                }
            }
        ?>

        <?php if($comments->isEmpty()): ?>
            <div class="no-comments-message text-muted text-center py-5 fs-5">
                <i class="ti ti-message-off me-2"></i> هنوز نظری ثبت نشده است!
            </div>
        <?php else: ?>
            <?php echo renderComments($comments, $replyTo, 0, $taskId, $this); ?>

        <?php endif; ?>

        
        <form wire:submit.prevent="addComment"
              class="modern-form border rounded-2 p-3 mt-4 d-flex flex-wrap align-items-center gap-2 shadow-sm"
              enctype="multipart/form-data">
            <input wire:model.defer="body" type="text"
                   class="form-control flex-fill modern-input <?php $__errorArgs = ['body'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                   placeholder="نظر جدید بنویسید">
            <label class="modern-attach-btn btn btn-light btn-sm px-3 rounded-pill mb-0 shadow-none">
                <input type="file" wire:model="file" class="d-none">
                <i class="ti ti-paperclip"></i>
                <span class="ms-1 d-none d-sm-inline">پیوست</span>
            </label>
            <button type="submit" class="btn btn-action-primary px-3 shadow-none modern-submit-btn">
                <i class="ti ti-send"></i> ارسال
            </button>
        </form>
        <?php $__errorArgs = ['body'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-1 small">محتوای نظر نباید خالی باشد.</div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        <?php $__errorArgs = ['file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-1 small">حجم یا فرمت فایل مجاز نیست.</div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

    </div>

    <style>
        /* --- Custom Styles for Modern Comments (FIXED PALETTE) --- */
        :root {
            --dark-primary: #1F2937;
            --action-primary: #4361EE;
            --primary-dark-hover: #3A4FCD;
            --primary-light-soft: #EEF4FF; /* New soft background */
            --success-color: #10B981;
            --danger-color: #EF4444;
            --border-light: #E5E7EB;
        }
        .modern-bg-light {background: #F8FAFC !important;}
        .modern-comment-item {
            border-radius: 1.11rem;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
            border: 1px solid var(--border-light);
            transition: all 0.3s ease;
            position: relative;
            padding: 1.25rem; /* افزایش پدینگ داخلی */
        }
        .modern-comment-item-reply {
            /* 💡 استایل‌های پاسخ‌های تو در تو */
            border-left: 3px solid var(--action-primary);
            padding-left: 15px !important;
            margin-right: -10px !important;
            margin-left: 15px; /* فرورفتگی بصری */
            padding-top: 1rem;
            padding-bottom: 1rem;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.03);
            background: #FAFBFC !important;
        }
        .modern-comment-item:hover {
            background:#FAFCFF!important;
            box-shadow: 0 8px 25px rgba(130,170,205,0.15);
        }
        .modern-form {background:#fafdff;}
        .modern-input {border-radius: .85rem!important; font-size:1rem;}
        .modern-submit-btn {border-radius:1.77rem!important; font-weight:bold;}
        .text-action-primary {color: var(--action-primary)!important;}
        .text-dark {color: var(--dark-primary)!important;}

        .modern-attach-btn {
            cursor: pointer;
            transition: all 0.2s;
        }
        .modern-attach-btn:hover {
            background-color: var(--primary-light-soft) !important;
            color: var(--action-primary);
        }
        .text-body {color: #343a40;}
        .comment-avatar {
            border: 2px solid var(--primary-light-soft);
            object-fit: cover;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }

        .modern-reply {color:#3893c6; font-weight:500;}

        /* Animation */
        .fadeIn {animation: fade-in-top .6s;}
        @keyframes fade-in-top { from{ opacity:0; transform:translateY(14px);} to{opacity:1;transform:none;}}

        @media (max-width: 600px) { .card-body { padding: 1rem .45rem } }

        /* Badges for Assignee */
        .bg-action-primary-soft { background: var(--primary-light-soft); color: var(--action-primary); }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\task\comment-list.blade.php ENDPATH**/ ?>