<ul class="referral-tree-list list-unstyled">
    <?php $__currentLoopData = $nodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $node): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li class="mb-2 position-relative">
            <!-- خط اتصال عمودی -->
            <div class="tree-connector-vertical position-absolute"></div>

            <div class="d-flex align-items-start position-relative">
                <!-- آواتار کاربر -->
                <div class="avatar avatar-sm me-3 flex-shrink-0">
                    <span class="avatar-initial bg-<?php echo e($node['referral']->status == 'approved' ? 'success' : ($node['referral']->status == 'rejected' ? 'danger' : ($node['referral']->status == 'pending' ? 'warning' : 'secondary'))); ?> text-white rounded-circle">
                        <?php echo e(mb_substr($node['referral']->user->name ?? '--', 0, 1)); ?>

                    </span>
                </div>

                <!-- محتوای اصلی -->
                <div class="flex-grow-1">
                    <div class="d-flex flex-wrap align-items-center mb-1">
                        <h6 class="mb-0 me-2 fw-bold"><?php echo e($node['referral']->user->name ?? 'سیستم'); ?></h6>

                        <?php if($node['referral']->type): ?>
                            <span class="badge bg-light text-dark me-2">
                                <i class="fas fa-tag me-1"></i><?php echo e($node['referral']->type); ?>

                            </span>
                        <?php endif; ?>

                        <span class="text-muted small me-2">
                            <i class="far fa-clock me-1"></i><?php echo e(jdate($node['referral']->created_at)->format('Y/m/d H:i')); ?>

                        </span>

                        <span class="badge rounded-pill status-badge me-2
                            <?php if($node['referral']->status=='approved'): ?> bg-success-light text-success
                            <?php elseif($node['referral']->status=='rejected'): ?> bg-danger-light text-danger
                            <?php elseif($node['referral']->status=='pending'): ?> bg-warning-light text-warning
                            <?php else: ?> bg-secondary-light text-secondary <?php endif; ?>">
                            <?php if($node['referral']->status=='approved'): ?> تایید شده
                            <?php elseif($node['referral']->status=='rejected'): ?> رد شده
                            <?php elseif($node['referral']->status=='pending'): ?> در انتظار
                            <?php else: ?> نامشخص
                            <?php endif; ?>
                        </span>
                    </div>

                    <?php if($node['referral']->description): ?>
                        <div class="alert alert-light p-2 mb-2 small">
                            <?php echo e($node['referral']->description); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- فرزندان -->
            <?php if(count($node['children'])): ?>
                <div class="position-relative ps-4 mt-2">
                    <!-- خط اتصال افقی -->
                    <div class="tree-connector-horizontal position-absolute"></div>
                    <?php echo $__env->make('components.referral-tree', ['nodes' => $node['children']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            <?php endif; ?>
        </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</ul>

<style>
    /* استایل‌های درخت ارجاعات */
    .referral-tree-list {
        position: relative;
    }

    .tree-connector-vertical {
        top: 0;
        bottom: 0;
        left: 16px;
        width: 2px;
        background-color: #e9ecef;
        z-index: 1;
    }

    .tree-connector-horizontal {
        top: 24px;
        left: 0;
        height: 2px;
        width: 20px;
        background-color: #e9ecef;
        z-index: 1;
    }

    .avatar {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        border-radius: 50%;
        font-weight: 600;
        position: relative;
        z-index: 2;
    }

    .avatar-sm {
        width: 36px;
        height: 36px;
        font-size: 1rem;
    }

    .avatar-initial {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        height: 100%;
        border-radius: inherit;
    }

    .status-badge {
        padding: 4px 10px;
        font-size: 0.75rem;
    }

    .bg-success-light {
        background-color: rgba(40, 167, 69, 0.1);
    }

    .bg-danger-light {
        background-color: rgba(220, 53, 69, 0.1);
    }

    .bg-warning-light {
        background-color: rgba(255, 193, 7, 0.1);
    }

    .bg-secondary-light {
        background-color: rgba(108, 117, 125, 0.1);
    }

    /* انیمیشن‌ها */
    .referral-tree-list li {
        transition: all 0.3s ease;
    }

    .referral-tree-list li:hover {
        transform: translateX(5px);
    }
</style>
<?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\components\referral-tree.blade.php ENDPATH**/ ?>