<div class="container py-4">
    <!-- اعلان موفقیت -->
    <?php if(session()->has('success')): ?>
        <div class="alert alert-success alert-dismissible fade show rounded-3 shadow-sm mb-4" role="alert">
            <i class="ti ti-check me-2"></i>
            <span class="fw-semibold"><?php echo e(session('success')); ?></span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <!-- --------------------------------------------------- -->
    <!--  فرم ثبت / ویرایش مجوز -->
    <!-- --------------------------------------------------- -->
    <div class="card shadow-lg border-0 rounded-4 mb-5 card-hover-effect">
        <div class="card-header bg-deep-blue text-white rounded-top-4 py-3">
            <h4 class="fw-bold mb-0">
                <i class="ti ti-shield-lock me-2"></i> <?php echo e($isEditMode ? 'ویرایش مجوز: ' . ($label ?? '---') : 'ثبت مجوز جدید'); ?>

            </h4>
        </div>
        <div class="card-body p-4">
            <form wire:submit.prevent="<?php echo e($isEditMode ? 'updatePermission' : 'SavePermission'); ?>">
                <div class="row g-4 align-items-center">

                    <!-- نام فنی (Name) -->
                    <div class="col-md-4">
                        <label for="name" class="form-label fw-medium">نام فنی (Code)</label>
                        <input
                            type="text"
                            class="form-control form-control-lg rounded-pill <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            wire:model.live.debounce.300ms="name"
                            id="name"
                            placeholder="مثال: manage_users"
                            <?php echo e($isEditMode ? 'disabled' : ''); ?>

                        >
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php if($isEditMode): ?> <div class="form-text">نام فنی پس از ثبت، قابل ویرایش نیست.</div> <?php endif; ?>
                    </div>

                    <!-- نام نمایشی (Label) -->
                    <div class="col-md-4">
                        <label for="label" class="form-label fw-medium">نام نمایشی (فارسی)</label>
                        <input
                            type="text"
                            class="form-control form-control-lg rounded-pill <?php $__errorArgs = ['label'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            wire:model.defer="label"
                            id="label"
                            placeholder="مثال: مدیریت کامل کاربران"
                        >
                        <?php $__errorArgs = ['label'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- گروه (Group) -->
                    <div class="col-md-4">
                        <label for="group" class="form-label fw-medium">گروه (ماژول)</label>
                        <input
                            type="text"
                            class="form-control form-control-lg rounded-pill <?php $__errorArgs = ['group'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            wire:model.defer="group"
                            id="group"
                            placeholder="مثال: projects یا finance"
                        >
                        <?php $__errorArgs = ['group'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>


                    <div class="col-12 pt-3 d-flex justify-content-end gap-2">
                        <?php if($isEditMode): ?>
                            <button type="button" wire:click="resetInput" class="btn btn-outline-secondary font-medium rounded-pill px-4">
                                <i class="ti ti-x me-2 fs-4"></i> انصراف
                            </button>
                        <?php endif; ?>
                        <button type="submit" class="btn btn-action-primary font-medium rounded-pill px-4">
                            <div class="d-flex align-items-center">
                                <i class="ti ti-<?php echo e($isEditMode ? 'refresh' : 'send'); ?> me-2 fs-4"></i>
                                <?php echo e($isEditMode ? 'بروزرسانی مجوز' : 'ثبت مجوز'); ?>

                            </div>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- --------------------------------------------------- -->
    <!--  جدول لیست مجوزها -->
    <!-- --------------------------------------------------- -->
    <div class="card shadow-lg rounded-4 overflow-hidden">
        <div class="card-header bg-light border-bottom py-3">
            <h5 class="fw-semibold mb-0 text-primary-dark">
                <i class="ti ti-list-check me-2"></i> لیست مجوزهای ثبت شده
            </h5>
        </div>
        <div class="table-responsive">
            <!-- استفاده از گروه بندی مجوزها -->
            <?php $__empty_1 = true; $__currentLoopData = $permissions->groupBy('group'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupName => $groupPermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <table class="table table-striped table-hover align-middle mb-0">
                    <thead class="bg-secondary-light text-primary-dark border-bottom-0">
                    <tr>
                        <th colspan="4" class="fw-bold py-3 px-4 border-bottom-0" style="background-color: #f0f4f9;">
                            <i class="ti ti-tag me-2"></i> گروه: <?php echo e($groupName); ?>

                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $groupPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="table-row-hover">
                            <td class="px-4 fw-medium text-primary-dark" style="width: 35%;">
                                <span class="badge bg-action-primary me-2"><?php echo e($permission->group); ?></span>
                                <?php echo e($permission->label); ?>

                            </td>
                            <td class="text-muted small d-none d-md-table-cell" style="width: 35%;"><code><?php echo e($permission->name); ?></code></td>
                            <!-- FIX: نمایش تاریخ شمسی با استایل مدرن -->
                            <td class="text-center fw-medium text-muted" style="width: 15%;"><?php echo e(Morilog\Jalali\Jalalian::fromDateTime($permission->created_at)->format('Y/m/d')); ?></td>
                            <td class="text-end text-nowrap px-4" style="width: 15%;">
                                <button wire:click="editPermission(<?php echo e($permission->id); ?>)" class="btn btn-sm btn-outline-secondary rounded-pill px-3" title="ویرایش">
                                    <i class="ti ti-edit fs-5"></i>
                                </button>
                                <button wire:click="deletePermission(<?php echo e($permission->id); ?>)"
                                        wire:confirm="آیا مطمئن هستید مجوز <?php echo e($permission->label); ?> حذف شود؟"
                                        class="btn btn-sm btn-outline-danger rounded-pill px-3" title="حذف">
                                    <i class="ti ti-trash fs-5"></i>
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="alert alert-info rounded-3 m-4 fw-medium text-center">
                    <i class="ti ti-info-circle me-2"></i> هیچ مجوزی برای نمایش ثبت نشده است.
                </div>
            <?php endif; ?>
        </div>


    </div>
    <script>
        // FIX: این اسکریپت تنها برای حذف دستی backdrop از modal است
        window.addEventListener('hide-modal', (event) => {
            document.body.classList.remove('modal-open');
            document.querySelectorAll('.modal-backdrop').forEach(el => el.remove());
        });
    </script>

    <style>
        :root {
            --primary-dark: #1A2538;
            --action-color: #4361EE;
        }
        .bg-deep-blue { background-color: var(--primary-dark) !important; }
        .text-primary-dark { color: var(--primary-dark) !important; }
        .bg-action-primary { background-color: var(--action-color) !important; }
        .btn-action-primary:hover { background-color: #3A4FCD !important; }

        .card-hover-effect:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
        }
        .table-row-hover:hover { background-color: #f0f4ff; }
        .rounded-pill { border-radius: 50rem !important; }
        .form-control, .form-select { border-radius: .8rem; }
        .bg-secondary-light { background-color: #f0f4f9 !important; }

        .form-control-lg, .form-select-lg {
            font-size: 1rem;
            height: calc(3rem + 2px); /* هماهنگی ارتفاع Input Group */
            padding: 0.5rem 1.5rem;
        }

    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\permission\add-permission.blade.php ENDPATH**/ ?>