<div class="letters-minimal-container" wire:ignore.self>

    <!-- Toast Notifications -->
    <div class="notification-container position-fixed top-0 end-0 p-3" style="z-index: 1100;">
        <?php if(session('success')): ?>
            <div class="toast show fade-in" role="alert" aria-live="assertive" aria-atomic="true">
                <div class="toast-header bg-success text-white">
                    <i class="fas fa-check-circle me-2"></i>
                    <strong class="me-auto">موفقیت</strong>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
                <div class="toast-body bg-light">
                    <?php echo e(session('success')); ?>

                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Header Section -->
    <div class="page-header mb-4">
        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between gap-3">
            <div>
                <h1 class="mb-0 fw-bold text-dark">صندوق نامه‌ها</h1>
                <p class="mb-0 text-muted small">مدیریت نامه‌های ارسالی و دریافتی</p>
            </div>
            <button class="btn btn-primary rounded-pill px-4 d-flex align-items-center gap-2"
                    wire:click="$dispatch('openModal', { component: 'admin.letter.create-letter' })">
                <i class="fas fa-plus"></i> نامه جدید
            </button>
        </div>
    </div>

    <!-- Search & Filters -->
    <div class="filters-section mb-4 p-3 bg-white rounded-3 shadow-sm">
        <div class="row g-3 align-items-center">
            <div class="col-md-3">
                <div class="input-group input-group-sm">
                    <span class="input-group-text bg-light border-end-0">
                        <i class="fas fa-search text-muted"></i>
                    </span>
                    <input type="text" class="form-control border-start-0"
                           wire:model.live.debounce.400ms="search"
                           placeholder="جستجوی عنوان نامه...">
                </div>
            </div>
            <div class="col-md-3">
                <div class="input-group input-group-sm">
                    <span class="input-group-text bg-light border-end-0">
                        <i class="fas fa-hashtag text-muted"></i>
                    </span>
                    <input type="text" class="form-control border-start-0"
                           wire:model.live.debounce.400ms="searchCode"
                           placeholder="جستجوی شماره نامه...">
                </div>
            </div>
            <div class="col-md-3">
                <select class="form-select form-select-sm"
                        wire:model.live="status">
                    <option value="all">همه وضعیت‌ها</option>
                    <option value="draft">پیش‌نویس</option>
                    <option value="pending_sign">در انتظار امضا</option>
                    <option value="signed">امضا شده</option>
                    <option value="approved">تایید شده</option>
                    <option value="rejected">رد شده</option>
                    <option value="correction">اصلاحیه</option>
                </select>
            </div>
            <div class="col-md-3 text-md-end">
                <?php if(count($selectedLetterIds)): ?>
                    <button class="btn btn-sm btn-outline-danger rounded-pill px-3 d-flex align-items-center gap-2"
                            wire:click="bulkDelete">
                        <i class="fas fa-trash"></i> حذف گروهی (<?php echo e(count($selectedLetterIds)); ?>)
                    </button>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Letters List -->
    <div class="card border-0 shadow-sm rounded-3">
        <div class="card-body p-0">
            <?php if($letters->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light">
                        <tr>
                            <th style="width: 5%;">
                                <input type="checkbox" wire:model="selectAll" class="form-check-input">
                            </th>
                            <th style="width: 12%;">کد نامه</th>
                            <th>عنوان نامه</th>
                            <th style="width: 12%;">وضعیت</th>
                            <th style="width: 15%;">گیرندگان</th>
                            <th style="width: 12%;">فرستنده</th>
                            <th style="width: 12%;">
                                تاریخ
                                <button class="btn btn-sm btn-link p-0 ms-2" wire:click="toggleSortId" title="مرتب‌سازی">
                                    <?php if($SortId): ?>
                                        <i class="fas fa-arrow-up text-primary"></i>
                                    <?php else: ?>
                                        <i class="fas fa-arrow-down text-primary"></i>
                                    <?php endif; ?>
                                </button>
                            </th>
                            <th style="width: 10%;">عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $letters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $letter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover-row">
                                <td>
                                    <input type="checkbox" wire:model="selectedLetterIds" value="<?php echo e($letter->id); ?>" class="form-check-input">
                                </td>
                                <td>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="letter-code"><?php echo e($letter->code); ?></span>
                                        <button onclick="navigator.clipboard.writeText('<?php echo e($letter->code); ?>')"
                                                class="btn btn-sm btn-outline-secondary rounded-circle p-1"
                                                title="کپی شماره">
                                            <i class="fas fa-copy"></i>
                                        </button>
                                    </div>
                                </td>
                                <td>
                                    <a wire:click="showPreview(<?php echo e($letter->id); ?>)"
                                       class="text-primary text-decoration-none cursor-pointer fw-medium">
                                        <?php echo e($letter->title); ?>

                                    </a>
                                </td>
                                <td>
                                        <span class="status-badge status-<?php echo e($letter->status); ?>">
                                            <?php echo e(__("statuses.{$letter->status}")); ?>

                                        </span>
                                </td>
                                <td>
                                    <div class="receivers-list">
                                        <?php $__currentLoopData = $letter->receivers->take(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receiver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="receiver-badge"><?php echo e($receiver->name); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($letter->receivers->count() > 2): ?>
                                            <span class="receiver-badge">+<?php echo e($letter->receivers->count() - 2); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td><?php echo e(optional($letter->sender)->name ?? 'سیستم'); ?></td>
                                <td class="text-muted small">
                                    <?php echo e(jdate($letter->created_at)->format('Y/m/d')); ?>

                                    <div><?php echo e(jdate($letter->created_at)->format('H:i')); ?></div>
                                </td>
                                <td>
                                    <div class="d-flex gap-1">
                                        <button wire:click="showPreview(<?php echo e($letter->id); ?>)"
                                                class="btn btn-sm btn-outline-primary rounded-circle p-1"
                                                title="پیش‌نمایش">
                                            <i class="fas fa-eye"></i>
                                        </button>

                                        <?php if($letter->status == 'pending_sign'): ?>
                                            <button wire:click="signLetter(<?php echo e($letter->id); ?>)"
                                                    class="btn btn-sm btn-outline-success rounded-circle p-1"
                                                    title="امضا">
                                                <i class="fas fa-signature"></i>
                                            </button>
                                        <?php endif; ?>

                                        <div class="dropdown">
                                            <button class="btn btn-sm btn-outline-secondary rounded-circle p-1"
                                                    type="button"
                                                    data-bs-toggle="dropdown"
                                                    aria-expanded="false">
                                                <i class="fas fa-ellipsis-v"></i>
                                            </button>
                                            <ul class="dropdown-menu">
                                                <li>
                                                    <a class="dropdown-item" href="#"
                                                       wire:click="$dispatch('openModal', { component: 'admin.letter.edit-letter', arguments: { letterId: <?php echo e($letter->id); ?> } })">
                                                        <i class="fas fa-edit me-2"></i> ویرایش
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="#"
                                                       wire:click="$dispatch('openModal', { component: 'admin.letter.refer-letter', arguments: { letterId: <?php echo e($letter->id); ?> } })">
                                                        <i class="fas fa-paper-plane me-2"></i> ارجاع
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="#"
                                                       wire:click="$dispatch('openModal', { component: 'admin.letter.print-letter', arguments: { letterId: <?php echo e($letter->id); ?> } })">
                                                        <i class="fas fa-print me-2"></i> چاپ/دانلود
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="#"
                                                       wire:click="$dispatch('openModal', { component: 'admin.letter.history-letter', arguments: { letterId: <?php echo e($letter->id); ?> } })">
                                                        <i class="fas fa-history me-2"></i> گردش‌کار
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="px-3 py-3 border-top">
                    <?php echo e($letters->onEachSide(1)->links()); ?>

                </div>
            <?php else: ?>
                <!-- Empty State -->
                <div class="text-center py-5">
                    <div class="mb-4">
                        <i class="fas fa-envelope-open-text fa-3x text-muted opacity-50"></i>
                    </div>
                    <h4 class="text-muted mb-2">هیچ نامه‌ای یافت نشد</h4>
                    <p class="text-muted mb-4">با تغییر فیلترها یا ایجاد نامه جدید شروع کنید</p>
                    <button class="btn btn-primary rounded-pill px-4"
                            wire:click="$dispatch('openModal', { component: 'admin.letter.create-letter' })">
                        <i class="fas fa-plus me-2"></i> ایجاد نامه جدید
                    </button>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Preview Modal -->
    <?php if($showPreviewModal && $previewLetter): ?>
        <div class="modal fade show d-block" style="background: rgba(0,0,0,0.5);">
            <div class="modal-dialog modal-lg modal-dialog-centered">
                <div class="modal-content border-0 rounded-4 shadow-lg">
                    <div class="modal-header bg-light border-0">
                        <div class="d-flex align-items-center gap-3">
                            <h5 class="modal-title fw-bold">پیش‌نمایش نامه</h5>
                            <span class="badge bg-primary"><?php echo e($previewLetter->code); ?></span>
                            <span class="status-badge status-<?php echo e($previewLetter->status); ?>">
                                <?php echo e(__("statuses.{$previewLetter->status}")); ?>

                            </span>
                        </div>
                        <button type="button" class="btn-close" wire:click="closePreview"></button>
                    </div>
                    <div class="modal-body p-4">
                        <div class="mb-4">
                            <h6 class="fw-bold text-primary mb-3">اطلاعات نامه</h6>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="info-item">
                                        <label class="text-muted small">عنوان:</label>
                                        <div class="fw-medium"><?php echo e($previewLetter->title); ?></div>
                                    </div>
                                    <div class="info-item">
                                        <label class="text-muted small">فرستنده:</label>
                                        <div class="fw-medium"><?php echo e(optional($previewLetter->sender)->name ?? 'سیستم'); ?></div>
                                    </div>
                                    <div class="info-item">
                                        <label class="text-muted small">طبقه‌بندی:</label>
                                        <div class="fw-medium"><?php echo e(optional($previewLetter->classification)->name ?? '-'); ?></div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="info-item">
                                        <label class="text-muted small">تاریخ ایجاد:</label>
                                        <div class="fw-medium"><?php echo e(jdate($previewLetter->created_at)->format('Y/m/d H:i')); ?></div>
                                    </div>
                                    <div class="info-item">
                                        <label class="text-muted small">گیرندگان:</label>
                                        <div class="receivers-list">
                                            <?php $__currentLoopData = $previewLetter->receivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receiver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span class="receiver-badge"><?php echo e($receiver->name); ?></span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php if($previewLetter->content): ?>
                            <div class="content-preview p-3 bg-light rounded-3">
                                <h6 class="fw-bold text-primary mb-3">محتوای نامه</h6>
                                <div class="content-text">
                                    <?php echo Str::limit($previewLetter->content, 500); ?>

                                    <?php if(strlen($previewLetter->content) > 500): ?>
                                        <div class="mt-2">
                                            <a href="#" class="text-primary">مشاهده کامل محتوا</a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="modal-footer bg-light border-0 d-flex justify-content-between">
                        <button type="button" class="btn btn-outline-secondary rounded-pill px-4" wire:click="closePreview">
                            بستن
                        </button>
                        <div class="btn-group">
                            <button class="btn btn-outline-primary rounded-pill px-4">
                                <i class="fas fa-print me-2"></i> چاپ
                            </button>
                            <button class="btn btn-primary rounded-pill px-4">
                                <i class="fas fa-download me-2"></i> دانلود PDF
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Global Styles -->
    <style>
        .letters-minimal-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 20px;
        }

        .page-header {
            padding: 20px 0;
        }

        .filters-section {
            border: 1px solid #e9ecef;
        }

        .table th {
            font-weight: 600;
            color: #495057;
            background: #f8f9fa;
            padding: 16px;
            border: none;
        }
        .table td {
            vertical-align: middle;
            padding: 16px;
            border: none;
            border-bottom: 1px solid #e9ecef;
        }

        .hover-row {
            transition: all 0.2s ease;
        }
        .hover-row:hover {
            background-color: #f8f9fa;
        }

        .letter-code {
            background: linear-gradient(90deg, #ecf8ff 35%, #bfdff5 100%);
            color: #26446f;
            font-weight: 700;
            padding: .3em .8em;
            border-radius: 1em;
            font-size: .95rem;
            display: inline-block;
        }

        .status-badge {
            padding: .3em .8em;
            border-radius: 1em;
            font-size: .85rem;
            font-weight: 500;
            display: inline-block;
        }
        .status-draft { background: #e6e6e6; color: #726e6e; }
        .status-pending_sign { background: #fff9db; color: #9d803c; }
        .status-signed { background: #d6e8ff; color: #217fbc; }
        .status-approved { background: #e5f7ea; color: #1b7645; }
        .status-rejected { background: #fde6e6; color: #ba2222; }
        .status-correction { background: #e8faee; color: #236e3a; }

        .receiver-badge {
            display: inline-block;
            background: #f8f9fa;
            color: #495057;
            padding: .2em .6em;
            border-radius: .8em;
            font-size: .85rem;
            margin-right: .3em;
            margin-bottom: .3em;
        }

        .info-item {
            margin-bottom: .8rem;
        }
        .info-item label {
            display: block;
            margin-bottom: .2rem;
        }

        .content-preview {
            border: 1px solid #e9ecef;
        }
        .content-text {
            line-height: 1.6;
            color: #333;
        }

        /* ریسپانسیو */
        @media (max-width: 768px) {
            .letters-minimal-container {
                padding: 15px;
            }
            .table th, .table td {
                padding: 12px 8px;
                font-size: .9rem;
            }
            .btn {
                padding: .375rem .75rem;
                font-size: .875rem;
            }
        }

        /* انیمیشن‌ها */
        .fade-in {
            animation: fadeIn 0.3s ease-in-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>

    <!-- Scripts -->
    <?php $__env->startPush('scripts'); ?>
        <script>
            document.addEventListener('livewire:initialized', function () {
                // Initialize tooltips
                var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
                var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                    return new bootstrap.Tooltip(tooltipTriggerEl, {
                        placement: 'top',
                        trigger: 'hover'
                    })
                });

                // Toast notifications
                Livewire.on('show-toast', function(event) {
                    const t = document.createElement('div');
                    t.className = 'position-fixed bottom-0 start-50 translate-middle-x mb-3 px-3 py-2 bg-dark text-white rounded-pill small';
                    t.style.zIndex = 1055;
                    t.textContent = event.detail.message;
                    document.body.appendChild(t);
                    setTimeout(()=> t.remove(), 3000);
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\letter\letters.blade.php ENDPATH**/ ?>