<div class="letter-edit-container" wire:ignore.self>

    <!-- Toast Notifications -->
    <div class="notification-container position-fixed top-0 end-0 p-3" style="z-index: 1100;">
        <?php if(session('success')): ?>
            <div class="toast show fade-in" role="alert" aria-live="assertive" aria-atomic="true">
                <div class="toast-header bg-success text-white">
                    <i class="fas fa-check-circle me-2"></i>
                    <strong class="me-auto">موفقیت</strong>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
                <div class="toast-body bg-light">
                    <?php echo e(session('success')); ?>

                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Header Section -->
    <div class="page-header bg-gradient-primary rounded-4 py-4 px-4 mb-4 shadow-lg position-relative overflow-hidden">
        <div class="position-absolute top-0 start-0 w-100 h-100 opacity-10">
            <svg width="100%" height="100%" xmlns="http://www.w3.org/2000/svg">
                <defs>
                    <pattern id="grid" width="40" height="40" patternUnits="userSpaceOnUse">
                        <path d="M 40 0 L 0 0 0 40" fill="none" stroke="rgba(255,255,255,0.1)" stroke-width="1"/>
                    </pattern>
                </defs>
                <rect width="100%" height="100%" fill="url(#grid)" />
            </svg>
        </div>
        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between gap-3">
            <div class="d-flex align-items-center">
                <div class="header-icon bg-white bg-opacity-20 p-3 rounded-3 me-3">
                    <i class="fas fa-edit text-white fs-3"></i>
                </div>
                <div>
                    <h1 class="mb-0 text-white fw-bold">ویرایش نامه</h1>
                    <p class="mb-0 text-white-75">ویرایش نامه: <?php echo e(Str::limit($letter->title, 50)); ?></p>
                </div>
            </div>
            <div class="d-flex gap-2">
                <a href="<?php echo e(route('letters.show', $letter->id)); ?>" class="btn btn-outline-light rounded-pill px-4 d-flex align-items-center gap-2">
                    <i class="fas fa-times me-1"></i> انصراف
                </a>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="card shadow-sm border-0 rounded-4 overflow-hidden">
        <div class="card-body p-4">
            <form wire:submit.prevent="updateLetter" class="needs-validation" novalidate>
                <div class="row g-4">
                    <div class="col-12">
                        <label for="title" class="form-label fw-bold text-primary">
                            <i class="fas fa-heading me-2"></i> عنوان نامه
                        </label>
                        <input type="text"
                               class="form-control form-control-lg rounded-3 <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               id="title"
                               wire:model="title"
                               placeholder="عنوان نامه را وارد کنید...">
                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-6">
                        <label for="from_who" class="form-label fw-bold text-primary">
                            <i class="fas fa-user me-2"></i> فرستنده
                        </label>
                        <input type="text"
                               class="form-control form-control-lg rounded-3 <?php $__errorArgs = ['from_who'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               id="from_who"
                               wire:model="from_who"
                               placeholder="نام/واحد فرستنده...">
                        <?php $__errorArgs = ['from_who'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-6">
                        <label for="from_where" class="form-label fw-bold text-primary">
                            <i class="fas fa-map-pin me-2"></i> گیرنده
                        </label>
                        <input type="text"
                               class="form-control form-control-lg rounded-3 <?php $__errorArgs = ['from_where'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               id="from_where"
                               wire:model="from_where"
                               placeholder="نام/واحد گیرنده...">
                        <?php $__errorArgs = ['from_where'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-6">
                        <label for="classification_id" class="form-label fw-bold text-primary">
                            <i class="fas fa-layer-group me-2"></i> طبقه‌بندی
                        </label>
                        <select class="form-select form-select-lg rounded-3 <?php $__errorArgs = ['classification_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                id="classification_id"
                                wire:model="classification_id">
                            <option value="">انتخاب طبقه‌بندی...</option>
                            <?php $__currentLoopData = $classifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($classification->id); ?>"><?php echo e($classification->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['classification_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-6">
                        <label for="type" class="form-label fw-bold text-primary">
                            <i class="fas fa-exclamation-circle me-2"></i> نوع نامه
                        </label>
                        <select class="form-select form-select-lg rounded-3 <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                id="type"
                                wire:model="type">
                            <option value="">انتخاب نوع...</option>
                            <option value="0">عادی</option>
                            <option value="1">فوری</option>
                        </select>
                        <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-12">
                        <label for="signature_position" class="form-label fw-bold text-primary">
                            <i class="fas fa-id-badge me-2"></i> سمت امضاکننده
                        </label>
                        <input type="text"
                               class="form-control form-control-lg rounded-3 <?php $__errorArgs = ['signature_position'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               id="signature_position"
                               wire:model="signature_position"
                               placeholder="سمت امضاکننده...">
                        <?php $__errorArgs = ['signature_position'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-12">
                        <label for="content" class="form-label fw-bold text-primary">
                            <i class="fas fa-file-alt me-2"></i> محتوای نامه
                        </label>
                        <div wire:ignore>
                            <textarea id="editorContent"
                                      class="form-control <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                      rows="15"
                                      placeholder="محتوای نامه را وارد کنید..."><?php echo e($content); ?></textarea>
                        </div>
                        <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block mt-2"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Existing Attachments -->
                    <?php if($letter->attachments->count() > 0): ?>
                        <div class="col-12">
                            <h5 class="fw-bold text-primary mb-3">
                                <i class="fas fa-paperclip me-2"></i> پیوست‌های موجود
                            </h5>
                            <div class="row g-3">
                                <?php $__currentLoopData = $letter->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-12 col-md-6">
                                        <div class="attachment-card bg-white border rounded-3 p-3 d-flex align-items-center justify-content-between shadow-sm">
                                            <div class="d-flex align-items-center gap-3">
                                                <?php
                                                    $extension = pathinfo($attachment->original_name, PATHINFO_EXTENSION);
                                                    $isImage = in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp']);
                                                    $isPdf = strtolower($extension) === 'pdf';
                                                ?>

                                                <div class="avatar avatar-lg bg-primary bg-opacity-10 text-primary rounded-circle">
                                                    <?php if($isImage): ?>
                                                        <i class="fas fa-image"></i>
                                                    <?php elseif($isPdf): ?>
                                                        <i class="fas fa-file-pdf"></i>
                                                    <?php else: ?>
                                                        <i class="fas fa-file-alt"></i>
                                                    <?php endif; ?>
                                                </div>

                                                <div>
                                                    <div class="fw-bold text-dark"><?php echo e($attachment->original_name); ?></div>
                                                    <div class="text-muted small">
                                                        <?php echo e(number_format($attachment->size / 1024, 1)); ?> KB
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="d-flex align-items-center gap-2">
                                                <a href="<?php echo e(Storage::url($attachment->file_path)); ?>"
                                                   class="btn btn-sm btn-outline-primary rounded-circle"
                                                   download title="دانلود">
                                                    <i class="fas fa-download"></i>
                                                </a>

                                                <?php if($isImage || $isPdf): ?>
                                                    <a href="<?php echo e(Storage::url($attachment->file_path)); ?>"
                                                       class="btn btn-sm btn-outline-secondary rounded-circle"
                                                       target="_blank" title="پیش‌نمایش">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                <?php endif; ?>

                                                <button type="button"
                                                        class="btn btn-sm btn-outline-danger rounded-circle"
                                                        wire:click="removeAttachment(<?php echo e($attachment->id); ?>)"
                                                        wire:confirm="آیا مطمئن هستید که می‌خواهید این پیوست را حذف کنید؟"
                                                        title="حذف">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- New Attachments -->
                    <div class="col-12">
                        <label for="newAttachments" class="form-label fw-bold text-primary">
                            <i class="fas fa-cloud-upload-alt me-2"></i> افزودن پیوست جدید
                        </label>
                        <div class="dropzone border rounded-3 p-4 text-center bg-light"
                             ondrop="event.preventDefault(); document.getElementById('newAttachments').click();"
                             ondragover="event.preventDefault();">
                            <i class="fas fa-cloud-upload-alt fa-2x text-primary mb-2"></i>
                            <p class="text-muted mb-2">فایل‌ها را اینجا بکشید و رها کنید یا برای انتخاب کلیک کنید</p>
                            <input type="file"
                                   id="newAttachments"
                                   wire:model="newAttachments"
                                   class="form-control d-none"
                                   multiple>
                            <button type="button"
                                    class="btn btn-outline-primary btn-sm mt-2"
                                    onclick="document.getElementById('newAttachments').click()">
                                انتخاب فایل
                            </button>

                            <?php if($newAttachments): ?>
                                <div class="mt-3">
                                    <?php $__currentLoopData = $newAttachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="d-flex align-items-center justify-content-between bg-white border rounded-2 p-2 mb-2">
                                            <span class="text-dark">
                                                <i class="fas fa-file me-2"></i>
                                                <?php echo e($file->getClientOriginalName()); ?>

                                                <span class="text-muted ms-2">(<?php echo e(number_format($file->getSize()/1024,1)); ?> KB)</span>
                                            </span>
                                            <button type="button"
                                                    class="btn btn-link text-danger p-0"
                                                    wire:click="removeNewAttachment(<?php echo e($index); ?>)">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>

                            <?php $__errorArgs = ['newAttachments.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small mt-2"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-between mt-4 pt-3 border-top">
                    <a href="<?php echo e(route('letters.show', $letter->id)); ?>"
                       class="btn btn-lg btn-outline-secondary rounded-pill px-4 d-flex align-items-center gap-2">
                        <i class="fas fa-times me-1"></i> انصراف
                    </a>
                    <button type="submit"
                            class="btn btn-lg btn-primary rounded-pill px-4 d-flex align-items-center gap-2"
                            wire:loading.attr="disabled">
                        <span wire:loading.remove>
                            <i class="fas fa-save me-1"></i> ذخیره تغییرات
                        </span>
                        <span wire:loading>
                            <span class="spinner-border spinner-border-sm me-2"></span> در حال ذخیره...
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Global Styles -->
    <style>
        .letter-edit-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 20px;
        }

        /* گرادیانت‌های مدرن */
        .bg-gradient-primary {
            background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
        }

        /* آواتارها */
        .avatar {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            font-weight: 600;
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
        }
        .avatar:hover {
            transform: scale(1.05);
        }
        .avatar-lg {
            width: 48px;
            height: 48px;
            font-size: 1.2rem;
        }

        /* کارت‌ها */
        .card {
            border-radius: 1.2em !important;
            border: none;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
            transition: all 0.3s ease;
            overflow: hidden;
        }
        .card:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 30px rgba(0,0,0,0.1);
        }

        /* فرم‌ها */
        .form-control, .form-select {
            border: 2px solid #e9ecef;
            transition: all 0.3s ease;
        }
        .form-control:focus, .form-select:focus {
            border-color: #4361ee;
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
        }
        .form-control-lg {
            padding: 12px 16px;
            font-size: 1.1rem;
        }

        /* دکمه‌ها */
        .btn {
            border-radius: 0.8rem;
            padding: 12px 24px;
            font-weight: 500;
            transition: all 0.2s ease;
        }
        .btn-lg {
            padding: 14px 28px;
            font-size: 1.1rem;
        }
        .btn-icon {
            width: 40px;
            height: 40px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 0;
            border-radius: 50%;
        }

        /* پیوست‌ها */
        .attachment-card {
            transition: all 0.3s ease;
        }
        .attachment-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        }

        /* Dropzone */
        .dropzone {
            border: 2px dashed #dee2e6;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        .dropzone:hover {
            border-color: #4361ee;
            background-color: #f8f9fa;
        }

        /* ریسپانسیو */
        @media (max-width: 768px) {
            .letter-edit-container {
                padding: 15px;
            }
            .page-header {
                padding: 30px 20px;
            }
            .btn {
                padding: 10px 20px;
                font-size: 0.9rem;
            }
            .btn-lg {
                padding: 12px 24px;
                font-size: 1rem;
            }
        }

        /* انیمیشن‌ها */
        .fade-in {
            animation: fadeIn 0.3s ease-in-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>

    <!-- Scripts -->
    <?php $__env->startPush('scripts'); ?>
        <script src="https://cdn.ckeditor.com/ckeditor5/41.4.2/classic/ckeditor.js"></script>
        <script>
            document.addEventListener('livewire:initialized', function () {
                initializeCKEditor();
            });

            function initializeCKEditor() {
                if (typeof ClassicEditor === 'undefined') {
                    setTimeout(initializeCKEditor, 100);
                    return;
                }

                const editorElement = document.querySelector('#editorContent');
                if (!editorElement) return;

                if (window.ckEditorInstance) {
                    window.ckEditorInstance.destroy().then(() => {
                        window.ckEditorInstance = null;
                        createEditor();
                    }).catch(err => {
                        console.error('Destroy failed:', err);
                        createEditor();
                    });
                } else {
                    createEditor();
                }
            }

            function createEditor() {
                ClassicEditor
                    .create(document.querySelector('#editorContent'), {
                        toolbar: {
                            items: [
                                'undo', 'redo', '|',
                                'heading', '|',
                                'bold', 'italic', 'underline', 'strikethrough', '|',
                                'alignment', '|',
                                'bulletedList', 'numberedList', '|',
                                'link', 'blockQuote', '|',
                                'imageUpload', 'insertTable', '|',
                                'findAndReplace', 'sourceEditing'
                            ]
                        },
                        language: 'fa',
                        image: {
                            toolbar: [
                                'imageTextAlternative',
                                'toggleImageCaption',
                                'imageStyle:inline',
                                'imageStyle:wrapText',
                                'imageStyle:breakText'
                            ]
                        }
                    })
                    .then(editor => {
                        window.ckEditorInstance = editor;
                        editor.model.document.on('change:data', () => {
                            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('content', editor.getData());
                        });
                    })
                    .catch(error => {
                        console.error('CKEditor Error:', error);
                    });
            }

            // Initialize tooltips
            document.addEventListener('livewire:initialized', function () {
                var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
                var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                    return new bootstrap.Tooltip(tooltipTriggerEl, {
                        placement: 'top',
                        trigger: 'hover'
                    })
                });

                // Toast notifications
                Livewire.on('show-toast', function(event) {
                    const t = document.createElement('div');
                    t.className = 'position-fixed bottom-0 start-50 translate-middle-x mb-3 px-3 py-2 bg-dark text-white rounded-pill small';
                    t.style.zIndex = 1055;
                    t.textContent = event.detail.message;
                    document.body.appendChild(t);
                    setTimeout(()=> t.remove(), 3000);
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\letter\letter-edit.blade.php ENDPATH**/ ?>