<div class="container py-4">
    <div class="card shadow-lg border-0 rounded-4 p-0">

        <div class="card-header bg-primary text-white rounded-top-4 py-3">
            <h5 class="fw-bold mb-0">
                <i class="ti ti-hand-grab me-2 fs-5"></i> تخصیص نقش به کاربر در پروژه
            </h5>
        </div>

        <div class="card-body p-4">

            <?php if(session()->has('success') || session()->has('error')): ?>
                <div class="alert-custom <?php echo e(session()->has('success') ? 'alert-success' : 'alert-danger'); ?> rounded-3 shadow-sm mb-4">
                    <i class="ti ti-<?php echo e(session()->has('success') ? 'check-circle' : 'alert-triangle'); ?> me-2"></i>
                    <span class="fw-semibold"><?php echo e(session('success') ?? session('error')); ?></span>
                </div>
            <?php endif; ?>

            <form wire:submit.prevent="assignProjectRole">

                <div class="input-group-modern mb-3">
                    <label for="user" class="input-label-modern">
                        <i class="ti ti-user me-2"></i> کاربر مورد نظر
                    </label>
                    <select wire:model.defer="selectedUser" id="user" class="form-select form-select-lg rounded-3 <?php $__errorArgs = ['selectedUser'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <option value="">-- برای تخصیص، یک کاربر را انتخاب کنید --</option>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?> (<?php echo e($user->email); ?>)</option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['selectedUser'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="input-group-modern mb-3">
                    <label for="project" class="input-label-modern">
                        <i class="ti ti-building me-2"></i> انتخاب پروژه
                    </label>
                    <select wire:model.defer="selectedProject" id="project" class="form-select form-select-lg rounded-3 <?php $__errorArgs = ['selectedProject'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <option value="">-- پروژه مرتبط را انتخاب کنید --</option>
                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($project->id); ?>"><?php echo e($project->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['selectedProject'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="input-group-modern mb-4">
                    <label for="role" class="input-label-modern">
                        <i class="ti ti-shield-lock me-2"></i> نقش در این پروژه
                    </label>
                    <select wire:model.defer="selectedRole" id="role" class="form-select form-select-lg rounded-3 <?php $__errorArgs = ['selectedRole'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <option value="">-- نقش مورد نظر را انتخاب کنید --</option>
                        <?php $__currentLoopData = $projectRoles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($role->id); ?>"><?php echo e($role->label ?? $role->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['selectedRole'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <button type="submit" class="btn btn-action-primary w-100 fw-bold btn-lg rounded-3 shadow-sm">
                    <span wire:loading.remove>
                        <i class="ti ti-device-floppy me-2"></i> تخصیص و ثبت نقش
                    </span>
                    <span wire:loading class="spinner-border spinner-border-sm"></span>
                </button>
            </form>

            <div class="mt-4 border-top pt-3 text-center text-muted small">
                برای مشاهده و حذف دسترسی‌های کنونی، به بخش مدیریت اعضای پروژه مراجعه کنید.
            </div>

        </div>
    </div>
    <style>
        /* استایل‌های سفارشی برای فرم مدرن */
        :root {
            --primary: #4361ee;
            --success-light: #e6ffed;
            --danger-light: #fff3f0;
            --text-dark: #343a40;
        }

        .card {
            max-width: 600px;
            margin: 0 auto;
            border-radius: 1.5rem !important;
        }

        .card-header {
            background-color: var(--primary) !important;
            border-bottom: none;
            padding: 1.5rem !important;
        }

        /* استایل گروه‌بندی ورودی‌ها */
        .input-group-modern {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }

        .input-label-modern {
            font-weight: 600;
            color: var(--text-dark);
            font-size: 0.95rem;
            display: flex;
            align-items: center;
        }

        .form-select-lg {
            padding: 0.75rem 1.25rem;
            font-size: 1rem;
            transition: border-color 0.2s;
        }
        .form-select-lg:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
        }

        /* استایل دکمه اصلی */
        .btn-action-primary {
            background-color: var(--primary);
            color: white;
            transition: background-color 0.2s;
        }
        .btn-action-primary:hover {
            background-color: #3a56d4;
        }

        /* استایل آلارم سفارشی */
        .alert-custom {
            padding: 1rem 1.5rem;
            border-left: 5px solid;
            font-size: 0.95rem;
        }
        .alert-success {
            background-color: var(--success-light);
            border-color: #2ecc71;
            color: #27ae60;
        }
        .alert-danger {
            background-color: var(--danger-light);
            border-color: #e74c3c;
            color: #c0392b;
        }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\project\project-role-assignment.blade.php ENDPATH**/ ?>