<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title><?php echo e($letter->title ?? 'نامه اداری'); ?></title>
    <style>
        @font-face {
            font-family: 'Vazirmatn';
            src: url('<?php echo e(public_path('fonts/Vazirmatn-Regular.ttf')); ?>') format('truetype');
            font-weight: 400;
            font-style: normal;
        }
        @font-face {
            font-family: 'Vazirmatn';
            src: url('<?php echo e(public_path('fonts/Vazirmatn-Bold.ttf')); ?>') format('truetype');
            font-weight: 700;
            font-style: normal;
        }
        @font-face {
            font-family: 'BNazanin';
            src: url('<?php echo e(public_path('fonts/B-NAZANIN.ttf')); ?>') format('truetype');
            font-weight: 400;
            font-style: normal;
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Vazirmatn', 'BNazanin', Tahoma, sans-serif;
            font-size: 11pt;
            line-height: 1.65;
            color: #2d3748;
            direction: rtl;
            text-align: justify;
            padding: 25mm 25mm 30mm 25mm; /* حاشیه استاندارد A4 */
            position: relative;
            background: #fff;
        }

        /* ———— سربرگ: فقط در گوشه چپ بالا ———— */
        .letter-meta {
            position: absolute;
            top: 20mm;
            left: 25mm;
            text-align: left;
            font-size: 9pt;
            color: #555;
            line-height: 1.5;
            width: auto;
            max-width: 180px;
        }
        .meta-item {
            display: flex;
            align-items: center;
            margin-bottom: 3px;
        }
        .meta-label {
            font-weight: 600;
            color: #4a5568;
            min-width: 42px;
            text-align: left;
        }
        .meta-value {
            font-weight: 500;
            color: #2d3748;
            margin-left: 5px;
        }
        .priority-badge {
            display: inline-block;
            width: 6px;
            height: 6px;
            border-radius: 50%;
            margin-left: 4px;
            vertical-align: middle;
        }
        .priority-urgent { background-color: #e53e3e; }
        .priority-high   { background-color: #dd6b20; }
        .priority-normal { background-color: #38a169; }
        .priority-low    { background-color: #3182ce; }

        /* ———— عنوان و اطلاعات نامه (فرستنده، گیرنده، موضوع) ———— */
        .letter-header {
            margin-top: 32mm;
            margin-bottom: 22px;
            padding-bottom: 10px;
            border-bottom: 1px solid #cbd5e0;
        }
        .header-row {
            display: flex;
            margin-bottom: 6px;
        }
        .header-label {
            font-weight: 800;
            color: #4a5568;
            min-width: 50px;
            margin-left: 6px;
        }
        .header-value {
            flex: 1;
            font-weight: 800;
            color: #2d3748;
            word-break: break-word;
        }
        .header-subject {
            font-size: 12.5pt;
            font-weight: 800;
            color: #1a202c;
            text-align: center;
            margin-top: 12px;
            padding-top: 10px;
            border-top: 1px dashed #e2e8f0;
            line-height: 1.4;
        }

        /* ———— محتوای نامه ———— */
        .letter-content {
            font-size: 11pt;
            line-height: 1.7;
            color: #2d3748;
            margin-bottom: 40px;
        }
        .letter-content p {
            margin-bottom: 12px;
            text-align: justify;
        }
        .letter-content h2 {
            font-size: 12pt;
            font-weight: 700;
            color: #2c5282;
            margin: 18px 0 10px;
            padding-bottom: 4px;
            border-bottom: 1px solid #edf2f7;
        }
        .letter-content h3 {
            font-size: 11pt;
            font-weight: 600;
            color: #2b6cb0;
            margin: 14px 0 8px;
        }
        .letter-content ul,
        .letter-content ol {
            margin: 12px 0;
            padding-right: 20px;
        }
        .letter-content li {
            margin-bottom: 6px;
            line-height: 1.6;
        }
        .letter-content table {
            width: 100%;
            border-collapse: collapse;
            margin: 16px 0;
            font-size: 10pt;
        }
        .letter-content th,
        .letter-content td {
            border: 1px solid #e2e8f0;
            padding: 6px 10px;
            text-align: right;
        }
        .letter-content th {
            background-color: #f7fafc;
            font-weight: 700;
            color: #2d3748;
        }

        /* ———— بخش امضا ———— */
        .signature-section {
            margin-top: 50px;
            text-align: left;
            float: left;
            clear: both;
        }
        .signature-wrapper {
            min-width: 200px;
        }
        .signature-line {
            height: 1px;
            background: #a0aec0;
            margin-bottom: 8px;
            position: relative;
        }
        .signature-line::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 100%;
            height: 1px;
            background: #fff;
        }
        .signature-img {
            max-height:95px;
            max-width: 190px;
            margin-bottom: 6px;
            display: block;
        }
        .signer-name {
            font-size: 11.5pt;
            font-weight: 800;
            color: #1a202c;
            margin-bottom: 2px;
        }
        .signer-position {
            font-size: 11.5pt;
            color: #4a5568;
            font-weight: 800;
        }
        .signature-date {
            font-size: 8.5pt;
            color: #718096;
            margin-top: 4px;
        }

        /* ———— پیوست‌ها ———— */
        .attachments-section {
            clear: both;
            margin-top: 30px;
            padding-top: 12px;
            border-top: 1px solid #e2e8f0;
        }
        .attachments-title {
            font-size: 9.5pt;
            font-weight: 600;
            color: #4a5568;
            margin-bottom: 6px;
        }
        .attachments-list {
            display: flex;
            flex-wrap: wrap;
            gap: 6px;
        }
        .attachment-item {
            background: #f8fafc;
            color: #4a5568;
            padding: 4px 10px;
            border-radius: 4px;
            font-size: 8.5pt;
            border: 1px solid #e2e8f0;
        }

        /* ———— رونوشت‌ها ———— */
        .cc-section {
            margin-top: 25px;
            padding-top: 12px;
            border-top: 1px solid #e2e8f0;
        }
        .cc-title {
            font-size: 9.5pt;
            font-weight: 600;
            color: #4a5568;
            margin-bottom: 6px;
        }
        .cc-list {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
        }
        .cc-item {
            font-size: 9pt;
            color: #4a5568;
        }
        .cc-item span.position {
            color: #718096;
            font-weight: 400;
        }

        /* ———— فوتر ثابت ———— */
        .letter-footer {
            position: absolute;
            bottom: 20mm;
            left: 25mm;
            right: 25mm;
            font-size: 7.5pt;
            color: #718096;
            border-top: 1px solid #e2e8f0;
            padding-top: 8px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .footer-left span {
            white-space: nowrap;
        }
        .footer-sep {
            margin: 0 8px;
            opacity: 0.6;
        }

        /* ———— واترمارک رسمی (اختیاری) ———— */
        .watermark {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 72px;
            color: rgba(0, 0, 0, 0.02);
            font-weight: 800;
            pointer-events: none;
            z-index: -1;
            white-space: nowrap;
        }

        @media print {
            body {
                padding: 25mm 25mm 30mm 25mm;
            }
            .letter-footer {
                position: fixed;
            }
        }
    </style>
</head>
<body>
<!-- واترمارک (اختیاری) -->




<!-- سربرگ: فقط در گوشه چپ بالا -->
<div class="letter-meta">
    <div class="meta-item">
        <span class="meta-label">شماره:</span>
        <span class="meta-value"><?php echo e($letter->code ?? '—'); ?></span>
    </div>
    <div class="meta-item">
        <span class="meta-label">تاریخ:</span>
        <span class="meta-value">

                <?php echo e($letter->letter_date_shamsi ?? ($letter->created_at ? \Morilog\Jalali\Jalalian::fromCarbon($letter->created_at)->format('Y/m/d') : '—')); ?>

            </span>
    </div>
    <div class="meta-item">
        <span class="meta-label">پیوست:</span>
        <span class="meta-value">
                <?php echo e(count($letter->attachments ?? []) > 0 ? 'دارد' : 'ندارد'); ?>

            </span>
    </div>
    <?php if($letter->priority): ?>
        <div class="meta-item">
            <span class="meta-label">اولویت:</span>
            <span class="meta-value">
                    <?php echo e($letter->priorityLabel() ?? '—'); ?>

                    <span class="priority-badge priority-<?php echo e($letter->priority); ?>"></span>
                </span>
        </div>
    <?php endif; ?>
</div>

<!-- اطلاعات نامه -->
<div class="letter-header">
    <div class="header-row">
        <span class="header-label">از:</span>
        <span class="header-value"><?php echo e($letter->from_who ?? '—'); ?></span>
    </div>
    <div class="header-row">
        <span class="header-label">به:</span>
        <span class="header-value"><?php echo e($letter->from_where ?? '—'); ?></span>
    </div>
    <div class="header-row">
        <span class="header-label">موضوع:</span>
        <?php echo e($letter->title ?? 'بدون موضوع'); ?>

    </div>
</div>

<!-- محتوای نامه -->
<div class="letter-content">
    <?php echo $letter->content; ?>

</div>

<!-- امضا -->
<div class="signature-section">
    <div class="signature-wrapper">
        <?php if(isset($signatureData) && $signatureData): ?>
            <img src="<?php echo e($signatureData); ?>" class="signature-img" alt="امضا">
        <?php else: ?>
            <div class="signature-line"></div>
        <?php endif; ?>
        <div class="signer-name">
            <?php echo e($letter->signer_name ?? ($letter->user->name ?? '—')); ?>

        </div>
        <div class="signer-position">
            <?php echo e($letter->signature_position ?? '—'); ?>

        </div>
        <?php if($letter->signature_date || $letter->signed_at): ?>
            <div class="signature-date">
                تاریخ امضا: <?php echo e(\Morilog\Jalali\Jalalian::fromCarbon(\Carbon\Carbon::parse($letter->signature_date ?? $letter->signed_at))->format('Y/m/d')); ?>

            </div>
        <?php endif; ?>
    </div>
</div>

<!-- پیوست‌ها -->
<?php if(!empty($letter->attachments) && count($letter->attachments) > 0): ?>
    <div class="attachments-section">
        <div class="attachments-title">📎 پیوست‌ها (<?php echo e(count($letter->attachments)); ?> مورد)</div>
        <div class="attachments-list">
            <?php $__currentLoopData = $letter->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $att): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <span class="attachment-item">
                        <?php echo e(\Illuminate\Support\Str::limit($att['original_name'] ?? $att['name'], 24)); ?>

                    </span>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
<?php endif; ?>

<!-- رونوشت‌ها -->
<?php if(!empty($letter->ccs) && count($letter->ccs) > 0): ?>
    <div class="cc-section">
        <div class="cc-title">👥 رونوشت</div>
        <div class="cc-list">
            <?php $__currentLoopData = $letter->ccs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <span class="cc-item">
                        <?php echo e($cc['name']); ?>

                    <?php if($cc['position']): ?>
                        <span class="position">(<?php echo e($cc['position']); ?>)</span>
                    <?php endif; ?>
                    </span>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
<?php endif; ?>

<!-- فوتر -->
<div class="letter-footer">
    <div class="footer-left">
        <span>پروژه: <?php echo e($letter->project->name ?? '—'); ?></span>
        <span class="footer-sep">|</span>
        <span>تاریخ تولید: <?php echo e(now()->format('Y/m/d')); ?></span>
    </div>
    <div>
        صفحه <span>1</span>
    </div>
</div>
</body>
</html><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\letter\pdf-show.blade.php ENDPATH**/ ?>