<div class="container py-4">

    
    <div class="card bg-header-dark text-white shadow-lg border-0 rounded-4 mb-4">
        <div class="card-body p-4">
            <h3 class="mb-1 fw-bold d-flex align-items-center">
                <i class="ti ti-calendar-stats me-2 fs-4 text-warning-custom"></i>
                زمان‌بندی پروژه: <span class="ms-2 text-info-custom"><?php echo e($projectName); ?></span>
            </h3>
            <span class="small text-muted-light">کد پروژه: <?php echo e($projectCode); ?></span>
        </div>
    </div>

    
    <?php if(session()->has('message')): ?>
        <div class="alert alert-success alert-dismissible fade show rounded-3 shadow-sm mb-4 d-flex align-items-center">
            <i class="ti ti-check me-2 fs-5"></i>
            <span><?php echo e(session('message')); ?></span>
            <button type="button" class="btn-close ms-auto" data-bs-dismiss="alert" aria-label="بستن"></button>
        </div>
    <?php endif; ?>

    
    <form wire:submit.prevent="saveSchedule" class="card p-5 shadow-2xl rounded-4 mb-5 border-0 bg-white">
        <h5 class="fw-bold text-primary-dark mb-4 border-bottom pb-3">
            <i class="ti ti-alarm me-2 text-warning-custom-icon"></i> تعیین مهلت‌های کلیدی
        </h5>

        <div class="row g-4">

            <div class="col-md-6">
                <label for="LOA_date" class="form-label fw-medium">تاریخ واگذاری (LOA):</label>
                <div class="input-group input-group-lg">
                    <span class="input-group-text"><i class="ti ti-file-check"></i></span>
                    <input type="date" id="LOA_date" wire:model.lazy="LOA_date" class="form-control <?php $__errorArgs = ['LOA_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="YYYY-MM-DD" />
                </div>
                <small class="text-muted small-hint d-block mt-1">
                    <i class="ti ti-info-circle small me-1"></i> تاریخ شروع رسمی (به صورت میلادی وارد کنید)
                </small>
                <?php $__errorArgs = ['LOA_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="col-md-6">
                <label for="contract_date" class="form-label fw-medium">تاریخ قرارداد:</label>
                <div class="input-group input-group-lg">
                    <span class="input-group-text"><i class="ti ti-calendar-event"></i></span>
                    <input type="date" id="contract_date" wire:model.lazy="contract_date" class="form-control <?php $__errorArgs = ['contract_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="YYYY-MM-DD" />
                </div>
                <small class="text-muted small-hint d-block mt-1">تاریخ امضای قرارداد (به صورت میلادی وارد کنید)</small>
                <?php $__errorArgs = ['contract_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="col-md-6">
                <label for="execution_duration" class="form-label fw-medium">مدت زمان اجرا (روز):</label>
                <div class="input-group input-group-lg">
                    <span class="input-group-text"><i class="ti ti-hourglass"></i></span>
                    <input type="number" id="execution_duration" wire:model.lazy="execution_duration" class="form-control <?php $__errorArgs = ['execution_duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" min="1" placeholder="مدت زمان کل اجرا (به روز)" />
                </div>
                <?php $__errorArgs = ['execution_duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="col-md-6">
                <label for="actual_completion_date" class="form-label fw-medium">تاریخ پایان واقعی:</label>
                <div class="input-group input-group-lg">
                    <span class="input-group-text"><i class="ti ti-flag-check"></i></span>
                    <input type="date" id="actual_completion_date" wire:model.lazy="actual_completion_date" class="form-control <?php $__errorArgs = ['actual_completion_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="YYYY-MM-DD" />
                </div>
                <small class="text-muted small-hint d-block mt-1">اختیاری - تاریخ اتمام پروژه (میلادی)</small>
                <?php $__errorArgs = ['actual_completion_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
        </div>

        <div class="mt-5 text-end border-top pt-4">
            <button type="submit" class="btn btn-action-primary fw-bold px-5 py-2 rounded-pill">
                <span wire:loading.remove><i class="ti ti-device-floppy me-1"></i> ذخیره زمان‌بندی</span>
                <span wire:loading>
                    <span class="spinner-border spinner-border-sm me-1" role="status"></span>
                    در حال ذخیره...
                </span>
            </button>
        </div>
    </form>

    
    <?php if($schedules->isNotEmpty()): ?>
        <div class="card shadow-lg rounded-4 overflow-hidden mt-5">
            <div class="card-header bg-white border-bottom py-3">
                <h5 class="fw-bold text-primary-dark mb-0">
                    <i class="ti ti-clock-hour-4 me-2 text-action-primary"></i> تاریخچه‌ زمان‌بندی‌ها
                </h5>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle mb-0">
                    <thead class="bg-primary-dark-table text-white">
                    <tr>
                        <th class="px-4 py-3">پروژه</th>
                        <th class="py-3">تاریخ LOA (شمسی)</th>
                        <th class="py-3">تاریخ قرارداد (شمسی)</th>
                        <th class="py-3">مدت اجرا (روز)</th>
                        <th class="py-3">تاریخ پایان واقعی</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr <?php if($schedule->project_id == $project_id): ?> class="table-info-custom" <?php endif; ?>>
                            <td class="px-4 fw-semibold"><?php echo e($schedule->project->name ?? 'پروژه نامشخص'); ?></td>
                            <td><?php echo e($this->getPersianDate($schedule->LOA_date)); ?></td>
                            <td><?php echo e($this->getPersianDate($schedule->contract_date)); ?></td>
                            <td><?php echo e(number_format($schedule->execution_duration)); ?></td>
                            <td><?php echo e($this->getPersianDate($schedule->actual_completion_date)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>

    <style>
        /* 🛑 استایل‌های نهایی و مدرن */
        :root {
            --primary-dark: #1A2538;
            --action-color: #4361EE;
            --action-dark-hover: #3A4FCD;
            --warning-custom: #f39c12;
            --info-custom: #81d4fa;
            --bg-header-dark: #202F40;
            --bg-primary-dark-table: #34495E;
            --bg-table-info-custom: #E0E7FF;
        }

        .bg-header-dark { background-color: var(--bg-header-dark) !important; }
        .text-action-primary { color: var(--action-color) !important; }
        .text-warning-custom { color: var(--warning-custom) !important; }
        .text-warning-custom-icon { color: var(--warning-custom) !important; } /* برای رنگ آیکون در فرم */
        .text-info-custom { color: var(--info-custom); }
        .text-muted-light { color: #f1f1f1 !important; }
        .text-primary-dark { color: var(--primary-dark) !important; }
        .bg-primary-dark-table { background-color: var(--bg-primary-dark-table) !important; }
        .table-info-custom { background-color: var(--bg-table-info-custom) !important; font-weight: bold; }

        /* Forms */
        .form-control, .form-select {
            border-radius: 50rem !important; /* گرد شدن فرم‌ها */
            border-color: #D1D5DB;
            transition: all 0.2s ease;
        }
        .form-control:focus, .form-select:focus {
            border-color: var(--action-color);
            box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.15);
        }
        .input-group-lg > .form-control, .input-group-lg > .form-select, .input-group-lg > .input-group-text {
            height: 3.5rem;
            padding: 0.75rem 1rem;
            font-size: 1rem;
        }
        .input-group-text {
            background-color: #F8FAFC;
            border-radius: 50rem 0 0 50rem !important; /* گرد شدن ابتدا */
        }
        .input-group-lg > .form-control {
            border-radius: 0 50rem 50rem 0 !important; /* گرد شدن انتها */
        }

        /* Buttons */
        .btn-action-primary {
            background-color: var(--action-color);
            border-color: var(--action-color);
            color: white;
            transition: all 0.2s ease;
        }
        .btn-action-primary:hover {
            background-color: var(--action-dark-hover) !important;
        }

        /* Tables */
        .shadow-2xl {
            box-shadow: 0 1rem 3rem rgba(0, 0, 0, 0.175) !important;
        }
        .table-responsive {
            border-radius: 0 0 1rem 1rem;
        }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\projects\schedule\project-schedule-create.blade.php ENDPATH**/ ?>