<?php
    use Morilog\Jalali\Jalalian;
    use Illuminate\Support\Str;
?>

<div class="dashboard-container rtl" dir="rtl" x-data="{
    isRefreshing: <?php if ((object) ('isRefreshing') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('isRefreshing'->value()); ?>')<?php echo e('isRefreshing'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('isRefreshing'); ?>')<?php endif; ?>,
    // ... (Alpine code for toasts, etc., remains outside this snippet)
}">
    <style>
        /* Modern & Minimalist Styles */
        :root {
            --primary: #4361ee;
            --primary-dark: #3a0ca3;
            --primary-light: #eef2ff;
            --success: #10b981;
            --warning: #f59e0b;
            --danger: #ef4444;
            --info: #4cc9f0;
            --text: #1e293b;
            --text-muted: #64748b;
            --border: #e5e7eb;
            --shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            --shadow-lg: 0 12px 30px rgba(58, 12, 163, 0.3);
            --transition: all 0.25s cubic-bezier(0.16, 1, 0.3, 1);
        }
        .dashboard-container {
            max-width: 1500px;
            margin: 0 auto;
            padding: 20px;
        }
        .header-card {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            border-radius: 20px;
            box-shadow: var(--shadow-lg);
            padding: 40px;
        }
        .stat-card-small {
            background: white;
            border-radius: 16px; /* کمی بزرگتر */
            box-shadow: var(--shadow);
            padding: 1.5rem;
            transition: var(--transition);
        }
        .stat-card-small:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
        }
        .stat-icon-circle {
            width: 48px;
            height: 48px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            font-size: 1.4rem;
            flex-shrink: 0;
            opacity: 0.9;
        }
        .task-list-item {
            border-bottom: 1px solid #f0f0f0;
            padding: 1rem 0;
            transition: background 0.2s;
        }
        .task-list-item:hover {
            background: var(--primary-light);
        }
        .task-action-btn {
            background: var(--primary);
            color: white;
            padding: 6px 14px;
            border-radius: 12px;
            font-size: 0.85rem;
            font-weight: 600;
            text-decoration: none;
            transition: background 0.2s;
        }
        .task-action-btn:hover {
            background: var(--primary-dark);
        }
        /* انیمیشن رفرش دستی */
        @keyframes rotate {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
        .animate-spin {
            animation: rotate 1s linear infinite;
        }
        /* Progress Bar Styling */
        .progress-bar-thin {
            height: 6px;
            border-radius: 3px;
        }
        .progress-circle-lg {
            width: 90px;
            height: 90px;
            position: relative;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            background: var(--primary-light);
            border-radius: 50%;
        }
        .access-card {
            background: var(--primary-light);
            border-radius: 16px;
            padding: 20px;
            box-shadow: var(--shadow-sm);
            transition: var(--transition);
        }
        .access-card:hover {
            background: #d4e0ff;
            transform: translateY(-2px);
        }

        /* Timeline Styling */
        .timeline-item {
            border-inline-start: 3px solid #e5e7eb;
            padding-inline-start: 15px;
            padding-bottom: 20px;
            position: relative;
        }
        .timeline-badge {
            position: absolute;
            inset-inline-start: -10px;
            top: 5px;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            background: white;
            border: 3px solid var(--primary);
        }
        .timeline-badge.info { border-color: var(--warning); }
        .timeline-badge.success { border-color: var(--success); }
    </style>

    <div class="header-card mb-5">
        <div class="d-flex justify-content-between align-items-start">
            <div>
                <h2 class="fw-bold mb-1">مرکز عملیات نامه‌نگاری</h2>
                <p class="text-white-75">خلاصه فعالیت‌های نامه‌نگاری شما تا امروز</p>
            </div>
            <div class="d-flex align-items-center gap-3">
                <button class="btn btn-light btn-lg rounded-pill px-4 fw-bold"
                        wire:click="loadData"
                        :disabled="isRefreshing">
                    <i class="fas fa-sync-alt me-2" :class="{'animate-spin': isRefreshing}"></i>
                    به‌روزرسانی آمار
                </button>
                <a href="<?php echo e(route('admin.create.letter')); ?>" class="btn btn-success btn-lg rounded-pill px-4 fw-bold">
                    <i class="fas fa-plus me-2"></i> نامه جدید
                </a>
            </div>
        </div>
    </div>

    <div class="row g-4 mb-5" wire:loading.class="opacity-50">

        <div class="col-lg-3 col-md-6">
            <div class="stat-card-small">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <div class="text-muted small fw-bold">وظایف در انتظار (Pending)</div>
                        <div class="fw-bold mt-1 fs-3 text-danger"><?php echo e($this->stats['totalPendingReferrals']); ?></div>
                    </div>
                    <div class="progress-circle-lg p-3 position-relative">
                        <div class="position-absolute top-50 start-50 translate-middle fw-bold text-primary"><?php echo e($this->stats['completionRate']); ?>%</div>
                        <div class="progress-circle" style="
                            background: conic-gradient(var(--success) <?php echo e($this->stats['completionRate']); ?>%, var(--border) 0%);
                            border-radius: 50%;
                            width: 100%;
                            height: 100%;
                        "></div>
                    </div>
                </div>
                <div class="progress progress-bar-thin mt-3" role="progressbar" style="height: 6px;" aria-valuenow="<?php echo e($this->stats['completionRate']); ?>" aria-valuemin="0" aria-valuemax="100">
                    <div class="progress-bar bg-success" style="width: <?php echo e($this->stats['completionRate']); ?>%"></div>
                </div>
                <p class="text-muted small mt-2">نرخ تکمیل وظایف: <span class="fw-bold text-dark"><?php echo e($this->stats['completionRate']); ?>%</span></p>
            </div>
        </div>

        <div class="col-lg-3 col-md-6">
            <div class="stat-card-small">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <div class="text-muted small fw-bold">ارجاعات فوری/فشار بالا</div>
                        <div class="fw-bold mt-1 fs-3 text-danger"><?php echo e($this->stats['urgentPendingCount']); ?></div>
                    </div>
                    <div class="stat-icon-circle bg-danger bg-opacity-10 text-danger">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                </div>
                <p class="text-muted small mt-2">جدید امروز: <span class="fw-bold text-dark"><?php echo e($this->stats['pendingToday']); ?></span></p>
            </div>
        </div>

        <div class="col-lg-3 col-md-6">
            <div class="stat-card-small">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <div class="text-muted small fw-bold">کل نامه‌های ارسالی شما</div>
                        <div class="fw-bold mt-1 fs-3 text-info"><?php echo e($this->stats['totalSent']); ?></div>
                    </div>
                    <div class="stat-icon-circle bg-info bg-opacity-10 text-info">
                        <i class="fas fa-paper-plane"></i>
                    </div>
                </div>
                <p class="text-muted small mt-2">وارده‌های ثبت شده: <span class="fw-bold text-dark"><?php echo e($this->stats['incomingRegisteredCount']); ?></span></p>
            </div>
        </div>

        <div class="col-lg-3 col-md-6">
            <div class="stat-card-small">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <div class="text-muted small fw-bold">کل ارجاعات دریافتی</div>
                        <div class="fw-bold mt-1 fs-3 text-primary"><?php echo e($this->stats['totalReceived']); ?></div>
                    </div>
                    <div class="stat-icon-circle bg-primary bg-opacity-10 text-primary">
                        <i class="fas fa-inbox"></i>
                    </div>
                </div>
                <p class="text-muted small mt-2">وظایف تکمیل شده: <span class="fw-bold text-success"><?php echo e($this->stats['completedCount']); ?></span></p>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-lg-7">
            <div class="card border-0 rounded-4 shadow-sm mb-4">
                <div class="card-header bg-white border-0 py-3">
                    <h5 class="fw-bold text-danger mb-0">
                        <i class="fas fa-exclamation-circle me-2"></i> وظایف فوری و معوق (Top 5)
                    </h5>
                </div>
                <div class="card-body p-0">
                    <ul class="list-unstyled mb-0">
                        <?php $__empty_1 = true; $__currentLoopData = $this->topPendingRefs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ref): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <li class="task-list-item px-4 d-flex justify-content-between align-items-center">
                                <div>
                                    <span class="badge <?php echo e($ref->letter->priority === 'urgent' ? 'bg-danger' : 'bg-warning'); ?> me-2"><?php echo e($ref->letter->priority); ?></span>
                                    <a href="#" class="text-dark fw-medium text-decoration-none" title="<?php echo e($ref->letter->title); ?>">
                                        <?php echo e(Str::limit($ref->letter->title, 50)); ?>

                                    </a>
                                    <span class="text-muted small ms-3">(<?php echo e($ref->letter->code); ?>)</span>
                                </div>
                                <a href="#" wire:click.prevent="performActionOnReferral(<?php echo e($ref->id); ?>)" class="task-action-btn bg-danger">
                                    <i class="fas fa-arrow-left me-1"></i> اقدام
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <li class="p-4 text-center text-success">
                                <i class="fas fa-check-circle me-1"></i> هیچ وظیفه فوری در حال حاضر ندارید.
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="card-footer bg-white border-0 text-end">
                    <a href="<?php echo e(route('admin.mycorrespondence.hub')); ?>" class="small text-primary fw-bold">مشاهده همه ارجاعات ></a>
                </div>
            </div>

            <div class="card border-0 rounded-4 shadow-sm">
                <div class="card-header bg-white border-0 py-3">
                    <h5 class="fw-bold text-primary mb-0">
                        <i class="fas fa-paper-plane me-2"></i> آخرین نامه‌های ارسالی
                    </h5>
                </div>
                <div class="card-body p-4">
                    <ul class="list-unstyled small">
                        <?php $__empty_1 = true; $__currentLoopData = $this->recentSent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $letter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <li class="d-flex justify-content-between mb-2 pb-2 border-bottom">
                                <a href="<?php echo e(route('letter.show', $letter->id)); ?>" class="text-dark fw-medium text-decoration-none">
                                    <?php echo e(Str::limit($letter->title, 40)); ?>

                                </a>
                                <span class="text-muted small"><?php echo e(Jalalian::fromDateTime($letter->created_at)->ago()); ?></span>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <li class="p-2 text-center text-muted">
                                <i class="fas fa-file-alt me-1"></i> تاکنون نامه‌ای ارسال نکرده‌اید.
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="card-footer bg-white border-0 text-end">
                    <a href="<?php echo e(route('user.letter')); ?>" class="small text-primary fw-bold">مشاهده همه ارسالی‌ها ></a>
                </div>
            </div>
        </div>

        <div class="col-lg-5">
            <div class="card border-0 rounded-4 shadow-sm mb-4">
                <div class="card-header bg-white border-0 py-3">
                    <h5 class="fw-bold text-primary mb-0">
                        <i class="fas fa-history me-2"></i> تایم‌لاین فعالیت‌های اخیر
                    </h5>
                </div>
                <div class="card-body p-4">
                    <div class="timeline">
                        <?php $__empty_1 = true; $__currentLoopData = $this->activityTimeline; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="timeline-item">
                                <div class="timeline-badge <?php echo e($activity['status'] === 'success' ? 'success' : 'info'); ?>"></div>
                                <div class="fw-bold small text-dark mb-1">
                                    <?php echo e($activity['type']); ?>

                                </div>
                                <p class="text-muted small mb-0">
                                    <?php echo e(Str::limit($activity['subject'], 60)); ?>

                                </p>
                                <span class="text-muted small position-absolute" style="inset-inline-start: 15px; top: 35px;">
                                    <i class="far fa-clock me-1"></i>
                                    <?php echo e(Jalalian::fromDateTime($activity['time'])->ago()); ?>

                                </span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="p-2 text-center text-muted">
                                <i class="fas fa-clipboard-list me-1"></i> فعالیت اخیر ثبت نشده است.
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="row g-3">
                <div class="col-6">
                    <a href="<?php echo e(route('user.letter')); ?>" class="d-block access-card text-dark text-center">
                        <i class="fas fa-inbox fa-2x mb-2 text-primary"></i>
                        <div class="fw-bold small">لیست نامه‌های دریافتی</div>
                    </a>
                </div>
                <div class="col-6">
                    <a href="<?php echo e(route('admin.register.incoming')); ?>" class="d-block access-card text-dark text-center">
                        <i class="fas fa-file-import fa-2x mb-2 text-success"></i>
                        <div class="fw-bold small">ثبت نامه وارده جدید</div>
                    </a>
                </div>
            </div>

        </div>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\letter\my-correspondence-hub.blade.php ENDPATH**/ ?>