<div wire:ignore.self class="modal fade" id="formModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 shadow-2xl rounded-5 overflow-hidden backdrop-blur-xl bg-white bg-opacity-95">
            <form wire:submit.prevent="saveDocument">
                <div class="modal-header bg-navy-obsidian text-white p-4 border-0" style="background: #0f172a;">
                    <div class="d-flex align-items-center">
                        <div class="p-2 bg-primary bg-opacity-20 rounded-3 me-3 shadow-sm">
                            <i class="ti ti-edit-circle fs-3 text-info"></i>
                        </div>
                        <div>
                            <h5 class="modal-title fw-black mb-0"><?php echo e($editId ? 'اصلاح شناسنامه فنی' : 'ثبت سند مهندسی جدید'); ?></h5>
                            <small class="opacity-50 fw-bold small uppercase tracking-wider">Document Identity Console</small>
                        </div>
                    </div>
                    <button type="button" class="btn-close btn-close-white shadow-none" data-bs-dismiss="modal" wire:click="closeForm"></button>
                </div>

                <div class="modal-body p-4 bg-light bg-opacity-30">
                    <div class="row g-4">
                        <div class="col-md-5">
                            <label class="form-label small fw-black text-muted text-uppercase tracking-wider">Document Number / شماره سند</label>
                            <div class="input-group">
                                <span class="input-group-text bg-white border-end-0 rounded-start-4"><i class="ti ti-hash text-primary"></i></span>
                                <input type="text" wire:model.defer="document_number" class="form-control form-input-lux border-start-0 shadow-none <?php $__errorArgs = ['document_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="P-ENG-DWG-001">
                            </div>
                            <?php $__errorArgs = ['document_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger fw-bold mt-1 d-block"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-7">
                            <label class="form-label small fw-black text-muted text-uppercase tracking-wider">Document Title / عنوان کامل سند</label>
                            <input type="text" wire:model.defer="title" class="form-control form-input-lux shadow-none <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="مثلاً: نقشه‌های اجرایی فاز دو معماری">
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger fw-bold mt-1 d-block"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label small fw-black text-muted text-uppercase tracking-wider">Discipline / دیسپلین فنی</label>
                            <div class="input-group">
                                <select wire:model.defer="discipline_id" class="form-select form-select-lux rounded-start-4">
                                    <option value="">انتخاب کنید...</option>
                                    <?php $__currentLoopData = $disciplines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($d->id); ?>"><?php echo e($d->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <button class="btn btn-primary px-3 shadow-none" type="button" x-data @click="$($refs.newDisc).toggleClass('d-none')"><i class="ti ti-plus"></i></button>
                            </div>
                            <div class="mt-2 d-none d-flex gap-1 animate-fade-in" x-ref="newDisc">
                                <input type="text" wire:model.defer="new_discipline" class="form-control form-control-sm rounded-3" placeholder="نام دیسپلین جدید...">
                                <button class="btn btn-success btn-sm rounded-3" wire:click.prevent="addDiscipline">ثبت</button>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label small fw-black text-muted text-uppercase tracking-wider">Category / کلاس سند</label>
                            <div class="input-group">
                                <select wire:model.defer="category_id" class="form-select form-select-lux rounded-start-4">
                                    <option value="">انتخاب کنید...</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <button class="btn btn-primary px-3 shadow-none" type="button" x-data @click="$($refs.newCat).toggleClass('d-none')"><i class="ti ti-plus"></i></button>
                            </div>
                            <div class="mt-2 d-none d-flex gap-1 animate-fade-in" x-ref="newCat">
                                <input type="text" wire:model.defer="new_category" class="form-control form-control-sm rounded-3" placeholder="نام کلاس جدید...">
                                <button class="btn btn-success btn-sm rounded-3" wire:click.prevent="addCategory">ثبت</button>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label small fw-black text-muted text-uppercase tracking-wider">Weight (WF) / ارزش وزنی</label>
                            <div class="input-group">
                                <input type="number" step="0.01" wire:model.defer="weight" class="form-control form-input-lux shadow-none">
                                <span class="input-group-text bg-white border-start-0 rounded-end-4 text-muted small">%</span>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <label class="form-label small fw-black text-muted text-uppercase tracking-wider">Status / وضعیت تهیه مدرک</label>
                            <select wire:model.defer="status" class="form-select form-select-lux">
                                <option value="">پیش‌فرض سیستم</option>
                                <?php $__currentLoopData = \App\Models\MasterDocument::STATUSES; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($v); ?>"><?php echo e($v); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-12">
                            <label class="form-label small fw-black text-muted text-uppercase tracking-wider">Specs / توضیحات و ملاحظات فنی</label>
                            <textarea wire:model.defer="document_type" class="form-control form-input-lux shadow-none" rows="2" placeholder="ارجاعات یا جزییات نسخه..."></textarea>
                        </div>

                        <?php if(!$editId): ?>
                            <div class="col-12">
                                <div class="p-5 border-2 border-dashed rounded-5 text-center bg-white upload-dropzone transition-all">
                                    <i class="ti ti-cloud-upload display-3 text-primary mb-3 opacity-25"></i>
                                    <h6 class="fw-black mb-1">بارگذاری نسخه اولیه مدرک</h6>
                                    <p class="text-muted small mb-3">فایل‌های مجاز: PDF, DWG, Office (حداکثر ۲۰ مگابایت)</p>
                                    <input type="file" wire:model="files" multiple class="form-control shadow-none border-0 bg-light rounded-pill px-4">
                                    <div wire:loading wire:target="files" class="mt-3">
                                        <div class="spinner-border spinner-border-sm text-primary"></div>
                                        <span class="small fw-bold ms-2">در حال بارگذاری در مخزن موقت...</span>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="modal-footer border-0 p-4 bg-light bg-opacity-50">
                    <button type="button" class="btn btn-light rounded-pill px-4 fw-black border" data-bs-dismiss="modal" wire:click="closeForm">انصراف</button>
                    <button type="submit" class="btn btn-primary rounded-pill px-5 fw-black shadow-lg py-2">
                        <span wire:loading.remove wire:target="saveDocument"><i class="ti ti-device-floppy me-1"></i> تایید و ثبت نهایی</span>
                        <span wire:loading wire:target="saveDocument" class="spinner-border spinner-border-sm"></span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div wire:ignore.self class="modal fade" id="revisionModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content border-0 shadow-2xl rounded-5 overflow-hidden bg-white">
            <div class="modal-header border-bottom p-4 bg-white sticky-top z-index-10">
                <div class="d-flex align-items-center">
                    <div class="p-2 bg-indigo bg-opacity-10 rounded-3 me-3">
                        <i class="ti ti-history fs-3 text-indigo"></i>
                    </div>
                    <div>
                        <h5 class="modal-title fw-black text-navy mb-0">مهندسی تغییرات و تاریخچه رویژن‌ها</h5>
                        <small class="text-muted fw-bold small">DOCUMENT REVISION LOG & ATTACHMENTS</small>
                    </div>
                </div>
                <button type="button" class="btn-close shadow-none" data-bs-dismiss="modal" wire:click="closeRevisionModal"></button>
            </div>

            <div class="modal-body p-0">
                <div class="row g-0">
                    <div class="col-md-7 border-start p-4 scroll-y scrollbar-lux" style="max-height: 75vh; overflow-y: auto;">
                        <div class="timeline-mdr px-3">
                            <?php $__empty_1 = true; $__currentLoopData = $revisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rev): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="timeline-item-lux position-relative pb-5 border-end pr-5">
                                    <div class="timeline-badge bg-navy text-white fw-black shadow-lg"><?php echo e($rev->revision); ?></div>
                                    <div class="card border-0 bg-white shadow-sm rounded-4 border-start border-4 border-indigo overflow-hidden">
                                        <div class="card-header bg-light bg-opacity-50 border-0 p-3 d-flex justify-content-between align-items-center">
                                            <span class="badge bg-indigo text-white px-3 py-1 rounded-pill fw-black" style="font-size: 0.65rem;">POI: <?php echo e($rev->poi_type); ?></span>
                                            <small class="text-muted fw-bold"><i class="ti ti-clock me-1"></i><?php echo e(jdate($rev->date)->format('Y/m/d H:i')); ?></small>
                                        </div>
                                        <div class="card-body p-3 pt-2">
                                            <p class="small fw-bold text-dark mb-3 leading-relaxed"><?php echo e($rev->remark ?: 'یادداشت فنی برای این نسخه ثبت نشده است.'); ?></p>

                                            <div class="d-flex flex-wrap gap-2 mb-3">
                                                <?php $__currentLoopData = $rev->files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="bg-light border rounded-3 p-2 d-flex align-items-center gap-2 shadow-xs transition-all hover-shadow">
                                                        <i class="ti ti-file-certificate text-primary fs-5"></i>
                                                        <span class="smaller fw-black text-truncate" style="max-width: 120px;" title="<?php echo e($file->file_name); ?>"><?php echo e($file->file_name); ?></span>
                                                        <a href="<?php echo e(asset('storage/' . $file->file_path)); ?>" target="_blank" class="btn btn-sm btn-white rounded-circle p-1 shadow-sm text-primary"><i class="ti ti-download"></i></a>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>

                                            <div class="border-top pt-3 d-flex justify-content-between align-items-center">
                                                <div class="d-flex gap-2">
                                                    <button class="btn btn-sm btn-light rounded-pill px-3 fw-bold border text-primary" wire:click="$set('addFileToRevisionId', <?php echo e($rev->id); ?>)">
                                                        <i class="ti ti-file-plus me-1"></i> الحاق فایل جدید
                                                    </button>
                                                    <button wire:click="deleteRevision(<?php echo e($rev->id); ?>)" onclick="return confirm('حذف نسخه دائمی است. ادامه می‌دهید؟')" class="btn btn-sm btn-outline-danger border-0 opacity-50 hover-opacity-100 fw-bold">
                                                        <i class="ti ti-trash"></i> حذف رویژن
                                                    </button>
                                                </div>
                                            </div>

                                            <?php if($addFileToRevisionId == $rev->id): ?>
                                                <div class="mt-3 p-3 bg-indigo bg-opacity-5 rounded-4 border border-dashed border-indigo animate-slide-up">
                                                    <input type="file" wire:model="new_files_for_revision" multiple class="form-control form-control-sm mb-2 shadow-none">
                                                    <div class="d-flex gap-2">
                                                        <button class="btn btn-indigo btn-sm rounded-pill px-3 fw-black" wire:click="addFilesToRevision(<?php echo e($rev->id); ?>)" wire:loading.attr="disabled">آپلود</button>
                                                        <button class="btn btn-light btn-sm rounded-pill px-3" wire:click="$set('addFileToRevisionId', null)">انصراف</button>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="text-center py-5 opacity-25">
                                    <i class="ti ti-stack-2 display-1 mb-3 d-block"></i>
                                    <h5 class="fw-black">تاریخچه‌ای یافت نشد</h5>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-md-5 p-5 bg-light bg-opacity-30 border-end">
                        <div class="sticky-top" style="top: 2rem;">
                            <div class="card border-0 shadow-xl rounded-5 p-4 overflow-hidden position-relative">
                                <div class="position-absolute top-0 end-0 p-4 opacity-10"><i class="ti ti-cloud-upload display-1"></i></div>
                                <h6 class="fw-black mb-4 text-primary d-flex align-items-center">
                                    <i class="ti ti-circle-plus-filled me-2 fs-4"></i> ثبت رویژن جدید (New Issue)
                                </h6>
                                <form wire:submit.prevent="addRevision">
                                    <div class="mb-3">
                                        <label class="form-label smaller fw-black opacity-50">Issue/Revision Number</label>
                                        <input type="text" wire:model.defer="new_revision_number" class="form-control form-input-lux" placeholder="مثلاً: Rev.B">
                                        <?php $__errorArgs = ['new_revision_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="text-danger fw-bold"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label smaller fw-black opacity-50">Purpose of Issue (POI)</label>
                                        <select wire:model.defer="new_revision_poi_type" class="form-select form-select-lux">
                                            <option value="">-- انتخاب هدف انتشار --</option>
                                            <?php $__currentLoopData = \App\Models\DocumentRevision::POI_TYPES; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"><?php echo e($key); ?> - <?php echo e($label); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label smaller fw-black opacity-50">Remark / ملاحظات فنی</label>
                                        <textarea wire:model.defer="new_revision_remark" class="form-control form-input-lux" rows="3" placeholder="تغییرات این نسخه نسبت به قبل..."></textarea>
                                    </div>
                                    <div class="mb-4">
                                        <label class="form-label smaller fw-black opacity-50">Document Files / فایل‌های نسخه</label>
                                        <input type="file" wire:model="new_revision_files" multiple class="form-control shadow-none rounded-4 p-2 bg-light">
                                    </div>
                                    <button type="submit" class="btn btn-navy w-100 py-3 rounded-pill fw-black shadow-lg" style="background: #0f172a; color: white;">
                                        <span wire:loading.remove wire:target="addRevision"><i class="ti ti-cloud-upload me-1"></i> ثبت و آرشیو رویژن</span>
                                        <span wire:loading wire:target="addRevision" class="spinner-border spinner-border-sm"></span>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div wire:ignore.self class="modal fade" id="previewModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content border-0 rounded-5 overflow-hidden shadow-2xl bg-dark">
            <div class="modal-header border-0 p-4" style="background: rgba(0,0,0,0.7); backdrop-filter: blur(10px);">
                <div class="d-flex align-items-center">
                    <div class="p-2 bg-info bg-opacity-20 rounded-3 me-3">
                        <i class="ti ti-scan fs-3 text-info"></i>
                    </div>
                    <div>
                        <h6 class="modal-title fw-black text-white mb-0">کنسول مشاهده آنلاین مستندات</h6>
                        <small class="text-white-50 fw-bold fs-xs uppercase">Engineering Live Preview</small>
                    </div>
                </div>
                <button type="button" class="btn-close btn-close-white shadow-none" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-0" style="height: 82vh; background: #121212;">
                <?php if($previewFileUrl): ?>
                    <?php if(str_ends_with($previewFileUrl, '.pdf')): ?>
                        <iframe src="<?php echo e($previewFileUrl); ?>#toolbar=0" width="100%" height="100%" class="border-0"></iframe>
                    <?php else: ?>
                        <div class="h-100 d-flex align-items-center justify-content-center p-3">
                            <img src="<?php echo e($previewFileUrl); ?>" class="img-fluid rounded-4 shadow-2xl" style="max-height: 100%; object-fit: contain; border: 1px solid rgba(255,255,255,0.1);">
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="h-100 d-flex align-items-center justify-content-center text-white-50">
                        <div class="text-center animate-pulse">
                            <div class="spinner-grow text-info mb-3" style="width: 3rem; height: 3rem;"></div>
                            <p class="fw-black fs-5">در حال فراخوانی فایل از سرور اسناد...</p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<style>
    /* 🛠️ Engineering UI Kits v13 */
    .timeline-mdr { position: relative; padding-right: 3rem; border-right: 4px solid #f8fafc; }
    .timeline-badge {
        position: absolute; right: -21px; top: 0;
        width: 40px; height: 40px; border-radius: 50%;
        display: flex; align-items: center; justify-content: center;
        font-size: 0.8rem; border: 5px solid #f8fafc; z-index: 5;
    }
    .timeline-item-lux:last-child { border-right: none !important; }

    .form-input-lux, .form-select-lux {
        border: 2px solid #eef2f6; border-radius: 18px; padding: 12px 18px; font-weight: 700; background: #fff;
    }
    .form-input-lux:focus, .form-select-lux:focus {
        border-color: var(--p-indigo); background: #fff; box-shadow: 0 0 0 5px rgba(99, 102, 241, 0.1);
    }

    .upload-dropzone:hover {
        background: #f0f7ff !important;
        border-color: var(--p-indigo) !important;
    }

    .scrollbar-lux::-webkit-scrollbar { width: 6px; }
    .scrollbar-lux::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 10px; }
    .leading-relaxed { line-height: 1.8 !important; }
    .shadow-xs { box-shadow: 0 2px 4px rgba(0,0,0,0.03); }
</style><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\m-d-r\mdr-modals.blade.php ENDPATH**/ ?>