<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <title>سرامان</title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="handheldfriendly" content="true" />
    <meta name="MobileOptimized" content="width" />
    <meta name="description" content="Mersa" />
    <meta name="author" content="" />
    <meta name="keywords" content="Mersa" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>


    <link rel="stylesheet" href="<?php echo e(asset('panel/dist/libs/owl.carousel/dist/assets/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('panel/dist/css/style.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('panel/dist/js/persian-datepicker.min.css')); ?>">

    <style>
        :root {
            --sidebar-bg: #ffffff;
            --sidebar-text: #4b5563;
            --sidebar-text-muted: #9ca3af;
            --sidebar-border: #e5e7eb;
            --sidebar-primary: #2563eb;   /* آبی اصلی */
            --sidebar-primary-soft: #e0edff;
            --sidebar-primary-soft-2: #eff4ff;
            --sidebar-hover-bg: #f3f4ff;
            --sidebar-scroll: #cbd5f5;
        }



        body {
            background-color: #F3F4F6;
            color: #1F2A44;
            font-family: IRANSans, system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;

            font-variant-numeric: proportional-nums;
            -moz-font-feature-settings: "ss01";
            -webkit-font-feature-settings: "ss01";
            font-feature-settings: "ss01"; /* این ویژگی در اکثر فونت‌های فارسی اعداد را فارسی می‌کند */
        }

        /* ====== SIDEBAR WRAPPER ====== */
        .left-sidebar {
            background: var(--sidebar-bg);
            box-shadow: 0 12px 30px rgba(15, 23, 42, 0.06);
            border-radius: 16px 0 0 16px;
            border-left: 1px solid var(--sidebar-border);
            padding-top: 8px;
            transition: all .25s ease;
            min-height: 100vh;
            overflow: hidden;
        }

        .page-wrapper[data-sidebartype="mini-sidebar"] .left-sidebar {
            border-radius: 0;
        }

        .brand-logo {
            border-bottom: 1px solid var(--sidebar-border);
            padding-bottom: 1rem !important;
            margin-bottom: .25rem;
        }

        .brand-logo img {
            max-height: 40px;
            object-fit: contain;
        }

        /* ====== GROUP TITLE / nav-small-cap ====== */
        .nav-small-cap {
            color: var(--sidebar-text-muted);
            font-weight: 600;
            font-size: .82rem;
            padding: 10px 18px 4px;
            margin-top: 10px;
            margin-bottom: 2px;
            text-transform: uppercase;
            letter-spacing: .08em;
            border-bottom: 0;
            display: flex;
            align-items: center;
            gap: 8px;
            position: relative;
        }

        .nav-small-cap::before {
            content: "";
            position: absolute;
            right: 18px;
            bottom: 3px;
            width: 32px;
            height: 2px;
            border-radius: 999px;
            background: linear-gradient(to left, var(--sidebar-primary), transparent);
            opacity: .35;
        }

        .nav-small-cap-icon {
            font-size: 14px;
            color: var(--sidebar-primary);
        }

        .nav-small-cap + .sidebar-item {
            margin-top: 2px;
        }

        /* ====== LINKS ====== */
        .sidebar-link {
            color: var(--sidebar-text);
            transition: all 0.18s ease;
            border-radius: 999px;
            padding: 9px 14px;
            margin: 2px 10px;
            display: flex;
            align-items: center;
            gap: 10px;
            position: relative;
            font-size: .9rem;
            white-space: nowrap;
        }

        .sidebar-link span.hide-menu {
            font-weight: 500;
        }

        .sidebar-link.has-arrow::after {
            left: 14px;
            right: auto;
            transform-origin: center;
            opacity: .6;
        }

        .sidebar-item.active > .sidebar-link.has-arrow::after,
        .sidebar-item > .sidebar-link[aria-expanded="true"].has-arrow::after {
            transform: rotate(180deg);
            opacity: 1;
        }

        .sidebar-link:hover {
            background-color: var(--sidebar-hover-bg);
            color: #111827;
        }

        .sidebar-item.active > .sidebar-link,
        .sidebar-item > .sidebar-link[aria-expanded="true"] {
            background: #EEF2FF;
            color: #1D4ED8;
            box-shadow: none;
        }

        .sidebar-item.active > .sidebar-link .hide-menu,
        .sidebar-item > .sidebar-link[aria-expanded="true"] .hide-menu {
            color: #1D4ED8;
        }

        .sidebar-item.active > .sidebar-link::before,
        .sidebar-item > .sidebar-link[aria-expanded="true"]::before {
            content: "";
            position: absolute;
            right: 10px;
            top: 7px;
            bottom: 7px;
            width: 3px;
            border-radius: 999px;
            background: linear-gradient(to bottom, #2563eb, #1d4ed8);
        }

        .round-16,
        .sidebar-link > span.d-flex i {
            width: 28px;
            height: 28px;
            font-size: 1.05rem;
            border-radius: 999px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: transparent;
            color: var(--sidebar-primary);
            flex-shrink: 0;
            transition: all .18s ease;
        }

        .sidebar-link:hover .round-16,
        .sidebar-link:hover > span.d-flex i {
            background: rgba(37, 99, 235, 0.08);
            transform: translateY(-1px);
        }

        .sidebar-item.active > .sidebar-link .round-16,
        .sidebar-item.active > .sidebar-link > span.d-flex i,
        .sidebar-item > .sidebar-link[aria-expanded="true"] .round-16 {
            background: rgba(37, 99, 235, 0.10);
            color: #1D4ED8;
        }

        /* ====== SUBMENU ====== */
        .collapse.first-level {
            padding: 2px 0 6px;
            margin: 0 8px 6px;
            border-radius: 12px;
            background: #F9FAFB;
            border: 1px solid #E5E7EB;
        }

        .collapse.first-level .sidebar-link {
            padding-right: 34px;
            margin-inline: 4px;
            font-size: .85rem;
            background: transparent;
        }

        .collapse.first-level .sidebar-link:hover {
            background: #FFFFFF;
        }

        .collapse.first-level .round-16 {
            width: 24px;
            height: 24px;
            font-size: .95rem;
            background: rgba(37, 99, 235, 0.04);
        }

        /* ====== SCROLLBAR ====== */
        [data-simplebar] {
            direction: rtl;
        }

        .scroll-sidebar .simplebar-track.simplebar-vertical {
            width: 6px;
            left: 3px;
            right: auto;
        }

        .scroll-sidebar .simplebar-scrollbar::before {
            background: var(--sidebar-scroll);
            border-radius: 4px;
        }

        /* ====== HEADER BASE ====== */
        .app-header {
            background-color: #ffffff;
            border-bottom: 1px solid #e5e7eb;
            box-shadow: 0 4px 16px rgba(15, 23, 42, 0.04);
        }

        .navbar-nav .nav-link {
            color: #111827;
            font-weight: 500;
        }

        .navbar-nav .nav-link:hover {
            color: var(--sidebar-primary);
        }

        .nav-icon-hover {
            border-radius: 999px;
            padding: 6px 9px;
            transition: background-color .18s ease, color .18s ease;
        }

        .nav-icon-hover:hover {
            background: #eff4ff;
            color: var(--sidebar-primary);
        }

        /* ====== ثابت پروفایل پایین سایدبار ====== */
        .fixed-profile {
            background: var(--sidebar-primary-soft);
            border-radius: 18px;
            margin: 8px 14px 16px;
            border: 1px solid rgba(37, 99, 235, 0.12);
        }

        .fixed-profile .john-title h6 {
            color: #111827;
        }

        .fixed-profile .john-title span {
            font-size: .8rem;
            color: var(--sidebar-text-muted);
        }

        .fixed-profile i.ti-power {
            transition: transform .15s ease, color .15s ease;
        }

        .fixed-profile a:hover i.ti-power {
            transform: scale(1.1);
            color: #dc2626;
        }

        /* ====== DROPDOWN ====== */
        .dropdown-menu {
            border-radius: 14px;
            box-shadow: 0 18px 45px rgba(15, 23, 42, 0.18);
            border: 1px solid #e5e7eb;
        }

        .dropdown-item {
            border-radius: 10px;
            margin: 2px 4px;
            transition: background-color 0.12s ease, transform 0.12s ease;
        }

        .dropdown-item:hover {
            background-color: #f3f4ff !important;
            transform: translateX(-2px);
        }

        /* ====== SEARCH MODAL ====== */
        #exampleModal .modal-content {
            border-radius: 18px;
            border: 1px solid #e5e7eb;
            box-shadow: 0 18px 40px rgba(15, 23, 42, 0.16);
        }

        #exampleModal .modal-header input {
            border-radius: 999px;
            background: #f9fafb;
            border: 1px solid #e5e7eb;
        }

        #exampleModal .modal-header input:focus {
            box-shadow: 0 0 0 1px var(--sidebar-primary);
            border-color: var(--sidebar-primary);
            background: #ffffff;
        }

        @media (max-width: 992px) {
            .left-sidebar {
                border-radius: 0;
                box-shadow: 0 0 0 rgba(0,0,0,0);
            }
        }

        @media (max-width: 768px) {
            .sidebar-link {
                padding: 8px 12px;
                font-size: 0.86rem;
            }
            .nav-small-cap {
                font-size: .78rem;
                padding: 10px 16px 4px;
            }
        }

        /* ====== LOGO ====== */
        .logo-main {
            text-decoration: none;
            color: inherit;
        }

        .logo-badge {
            position: relative;
            padding: 10px;
            border-radius: 20px;
            background: linear-gradient(135deg, #06b6d4, #2563eb);
            box-shadow: 0 10px 25px rgba(37, 99, 235, 0.35);
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: transform .6s ease, box-shadow .4s ease;
        }

        .logo-badge::before {
            content: "";
            position: absolute;
            inset: -8px;
            border-radius: inherit;
            background: radial-gradient(circle at 10% 0%, rgba(255,255,255,.4), transparent 55%);
            opacity: 0;
            transform: scale(.9);
            transition: opacity .6s ease, transform .6s ease;
        }

        .logo-svg {
            width: 32px;
            height: 32px;
            color: #ffffff;
            transition: transform 0.9s ease;
            transform-origin: center;
        }

        .logo-text-wrapper {
            gap: 2px;
        }

        .logo-title {
            font-weight: 800;
            font-size: 1.15rem;
            color: #111827;
            letter-spacing: .02em;
        }

        .logo-subtitle {
            font-size: .75rem;
            color: #6b7280;
        }

        .brand-logo:hover .logo-badge {
            transform: rotate(4deg) translateY(-1px);
            box-shadow: 0 14px 30px rgba(37, 99, 235, 0.45);
        }

        .brand-logo:hover .logo-badge::before {
            opacity: 1;
            transform: scale(1.05);
        }

        .brand-logo:hover .logo-svg {
            transform: rotate(360deg);
        }

        @media (max-width: 768px) {
            .logo-badge {
                padding: 8px;
                border-radius: 16px;
            }
            .logo-svg {
                width: 26px;
                height: 26px;
            }
            .logo-title {
                font-size: 1rem;
            }
            .logo-subtitle {
                font-size: .7rem;
            }
        }

        .logo-badge--nav {
            padding: 8px;
            border-radius: 18px;
            box-shadow: 0 14px 30px rgba(37, 99, 235, 0.4);
        }

        .logo-svg--nav {
            width: 26px;
            height: 26px;
        }

        .navbar .logo-main:hover .logo-badge {
            transform: rotate(4deg) translateY(-1px);
        }

        .navbar .logo-main:hover .logo-badge::before {
            opacity: 1;
            transform: scale(1.05);
        }

        .navbar .logo-main:hover .logo-svg {
            transform: rotate(360deg);
        }

        /* ====== THEME LOGIN ====== */
        body.theme-login {
            --sidebar-bg: linear-gradient(180deg, #ecfeff, #e0f2fe);
            --sidebar-text: #475569;
            --sidebar-text-muted: #9ca3af;
            --sidebar-border: rgba(125, 211, 252, 0.9);
            --sidebar-primary: #06b6d4;
            --sidebar-hover-bg: rgba(255,255,255,0.7);
            --sidebar-primary-soft: rgba(204, 251, 241, 0.9);
        }

        body.theme-login .left-sidebar {
            background: var(--sidebar-bg);
            border-radius: 18px 0 0 18px;
            border-left: 1px solid var(--sidebar-border);
            box-shadow:
                0 22px 55px rgba(8, 47, 73, 0.28),
                0 0 0 1px rgba(186, 230, 253, 0.9);
        }

        body.theme-login .brand-logo {
            border-bottom: 1px solid rgba(125, 211, 252, 0.6);
        }

        body.theme-login .sidebar-link:hover {
            background: rgba(255,255,255,0.9);
            color: #0f172a;
        }

        body.theme-login .sidebar-item.active > .sidebar-link,
        body.theme-login .sidebar-item > .sidebar-link[aria-expanded="true"] {
            background: linear-gradient(90deg, #06b6d4, #3b82f6);
            color: #ffffff;
            box-shadow: 0 16px 40px rgba(37, 99, 235, 0.45);
        }

        body.theme-login .sidebar-item.active > .sidebar-link::before,
        body.theme-login .sidebar-item > .sidebar-link[aria-expanded="true"]::before {
            display: none;
        }

        body.theme-login .round-16,
        body.theme-login .sidebar-link > span.d-flex i {
            background: rgba(255,255,255,0.7);
            color: #0ea5e9;
        }

        body.theme-login .sidebar-item.active > .sidebar-link .round-16,
        body.theme-login .sidebar-item.active > .sidebar-link > span.d-flex i {
            background: rgba(15, 23, 42, 0.18);
            color: #ffffff;
        }

        body.theme-login .collapse.first-level {
            background: rgba(255, 255, 255, 0.96);
            border-radius: 18px;
            border: 1px solid rgba(191, 219, 254, 0.9);
        }

        body.theme-login .logo-badge {
            padding: 11px;
            border-radius: 24px;
            background: linear-gradient(135deg, #06b6d4, #2563eb);
            box-shadow:
                0 24px 50px rgba(59, 130, 246, 0.55),
                0 0 0 1px rgba(125, 211, 252, 0.9);
        }

        body.theme-login .logo-badge::before {
            background: radial-gradient(circle at 10% 0%, rgba(255,255,255,.9), transparent 55%);
        }

        body.theme-login .logo-svg {
            width: 32px;
            height: 32px;
        }

        body.theme-login .app-header {
            background: #ffffff;
            border-bottom: 1px solid #e5e7eb;
            box-shadow: 0 18px 40px rgba(15, 23, 42, 0.06);
        }

        /* ====== LOGO UPGRADE ====== */
        .enhanced-logo {
            padding: 14px !important;
            border-radius: 28px !important;
            background: linear-gradient(135deg, #0ea5e9, #2563eb);
            box-shadow:
                0 25px 55px rgba(37, 99, 235, 0.45),
                0 0 0 2px rgba(186, 230, 253, 0.8);
            transition: all .5s ease;
            position: relative;
        }

        .enhanced-logo::before {
            content: "";
            position: absolute;
            inset: -12px;
            border-radius: inherit;
            background: radial-gradient(circle at 10% 0%, rgba(255,255,255,.95), transparent 65%);
            opacity: 0;
            transform: scale(.85);
            transition: all .7s ease;
        }

        .enhanced-svg {
            width: 44px !important;
            height: 44px !important;
            transition: transform 1.3s ease;
        }

        .logo-main:hover .enhanced-logo {
            transform: rotate(5deg) scale(1.06);
            box-shadow:
                0 32px 70px rgba(37, 99, 235, 0.55),
                0 0 0 3px rgba(125, 211, 252, 1);
        }

        .logo-main:hover .enhanced-logo::before {
            opacity: 1;
            transform: scale(1.08);
        }

        .logo-main:hover .enhanced-svg {
            transform: rotate(420deg);
        }

        .bigger-title {
            font-size: 1.35rem !important;
            font-weight: 900;
        }

        .bigger-subtitle {
            font-size: .82rem !important;
            opacity: .9;
        }

        /* ====== SMART HEADER (فیکس اصلی: نقطه قبل از کلاس) ====== */
        .app-header.smart-header {
            background: rgba(255, 255, 255, 0.96);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border-bottom: 1px solid rgba(226, 232, 240, 0.9);
            box-shadow: 0 14px 40px rgba(15, 23, 42, 0.06);
            position: sticky;
            top: 0;
            z-index: 1020;
            padding-block: 6px;
        }

        .header-shell {
            min-height: 72px;
            display: flex;
            align-items: center;
        }

        .topbar-icon,
        .nav-icon-hover {
            border-radius: 999px !important;
            padding: 6px 9px !important;
            transition: background-color .18s ease, color .18s ease, transform .12s ease;
        }

        .topbar-icon i {
            font-size: 1.1rem;
        }

        .nav-icon-hover:hover,
        .topbar-icon:hover {
            background: #eff4ff;
            color: var(--sidebar-primary);
            transform: translateY(-1px);
        }

        .topbar-actions {
            padding: 4px 8px;
            border-radius: 999px;
            background: rgba(248, 250, 252, 0.8);
            border: 1px solid rgba(226, 232, 240, 0.9);
            box-shadow: 0 10px 30px rgba(15, 23, 42, 0.04);
        }

        .header-user-pill {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            padding: 6px 14px;
            margin-top: 4px;
            border-radius: 999px;
            background: #f9fafb;
            box-shadow: 0 10px 25px rgba(15, 23, 42, 0.06);
            border: 1px solid #e5e7eb;
            max-width: 240px;
        }

        .header-user-text {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            text-align: right;
            line-height: 1.1;
        }

        .header-user-name {
            font-size: 0.9rem;
            font-weight: 700;
            color: #0f172a;
            white-space: nowrap;
            max-width: 140px;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .header-user-role {
            font-size: 0.75rem;
            color: #9ca3af;
            margin-top: 2px;
        }

        .header-user-avatar img {
            width: 34px;
            height: 34px;
            border-radius: 999px;
            object-fit: cover;
            box-shadow: 0 2px 6px rgba(15, 23, 42, 0.18);
        }

        .profile-trigger {
            border-radius: 999px !important;
            padding-inline: 6px !important;
            padding-block: 3px !important;
            transition: background-color .18s ease, box-shadow .18s ease, transform .1s ease;
        }

        .profile-trigger:hover {
            background: #eff6ff;
            box-shadow: 0 10px 25px rgba(15, 23, 42, 0.06);
            transform: translateY(-1px);
        }

        .profile-name {
            font-size: 0.85rem;
            font-weight: 700;
            color: #0f172a;
        }

        .profile-role {
            font-size: 0.7rem;
            color: #6b7280;
        }

        .header-user-bell {
            display: none !important;
        }

        @media (max-width: 992px) {
            .topbar-actions {
                background: transparent;
                border: 0;
                box-shadow: none;
                padding: 0;
            }

            .header-user-pill {
                max-width: 210px;
                padding-inline: 10px;
            }

            .header-user-name {
                max-width: 120px;
            }
        }
    </style>



</head>
<body class="theme-login">
<div class="page-wrapper" id="main-wrapper" data-theme="custom_theme" data-layout="vertical" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">


    <aside class="left-sidebar overflow-y-auto">
        <div>
            <div class="brand-logo d-flex align-items-center justify-content-between p-4">
                <a href="<?php echo e(route('dashboard')); ?>" class="text-nowrap d-flex align-items-center gap-3 logo-main">

                    <!-- لوگو با استایل جدید -->
                    <div class="logo-badge enhanced-logo">
                        <svg xmlns="http://www.w3.org/2000/svg"
                             viewBox="0 0 850.39 866.3"
                             class="logo-svg enhanced-svg">
                            <path fill="currentColor"
                                  d="m538.99,140.11c158.99,1.77,296,128.26,310.88,286.82,1.81,19.31-.37,36.9-18.12,48.4-26.16,16.95-60.13.25-63.53-32.51-4.61-44.38-18.34-84.89-43.97-121.48-61.46-87.76-174.07-123.45-266.88-84.16-29.57,12.52-54.58,30.91-71.72,58.71-21.12,34.27-14.36,61.85,20.63,80.99,22.18,12.13,44.64,23.92,67.64,34.38,107.55,48.86,99.27,161.14,43.66,223.74-79.12,89.07-178.41,109.59-289.18,78.16C101.3,677.08,14.16,568.77.38,436.29c-2.98-28.69,11.85-48.87,37.46-50.96,26.19-2.13,43.41,14.21,45.8,43.47,10.29,125.52,119.14,222.11,243.93,215.79,45.68-2.31,85.62-19.21,118.49-51.55,11.84-11.65,21.15-25.06,26.62-40.89,8.82-25.51-.39-49.31-24.4-61.67-27.07-13.94-54.22-27.77-81.63-41.03-84.96-41.11-87.26-132.1-54.57-187.74,36.65-62.39,92.2-98.09,161.34-114.81,21.57-5.21,43.46-6.92,65.56-6.78Z" />
                            <path fill="#ffffff"
                                  d="m432.95.02c26.42-.59,43.4,13.83,44.81,38.03,1.38,23.71-15.4,41.73-41.13,44.2-111.21,10.64-198.34,90.76-216.12,198.73-13.47,81.81,31.3,167.24,102.62,195.41,7.8,3.08,16.13,4.81,24.16,7.33,23.69,7.44,37.39,30.68,30.97,52.38-6.79,22.97-28.65,34.66-53.34,28.53-95.93-23.81-172.38-109.7-186.49-210.8C113.06,172.11,252.51,15.55,428.74.24c1.4-.12,2.81-.15,4.21-.22Z" />
                            <path fill="#ffffff"
                                  d="m715.62,557.39c.04,147.17-113.58,278.87-262.47,304.11-10.61,1.8-21.31,3.12-32,4.42-25.23,3.07-45.36-12.77-48.25-37.82-2.75-23.77,13.82-43.12,39.79-44.67,45.27-2.69,85.54-18.12,122.73-43.74,78.83-54.33,117.13-160.91,86.68-246.54-19.72-55.47-56.14-94.23-115.03-109.26-26.11-6.67-39.05-30.37-31.48-55.17,7.08-23.21,28.16-33.32,53.94-25.85,111.99,32.43,186.05,133.74,186.08,254.53Z" />
                        </svg>
                    </div>

                    <!-- متن کنار لوگو -->
                    <div class="logo-text-wrapper d-flex flex-column justify-content-center">
                        <span class="logo-title bigger-title">سرآمان</span>
                        <span class="logo-subtitle bigger-subtitle">سامانه یکپارچه هوشمند</span>
                    </div>
                </a>

                <div class="close-btn d-lg-none d-block sidebartoggler cursor-pointer" id="sidebarCollapse">
                    <i class="ti ti-x text-white"></i>
                </div>
            </div>

            <nav class="sidebar-nav scroll-sidebar" data-simplebar>
                <ul id="sidebarnav" class="text-sm">

                    <!-- 🔹 سازمان و کاربران -->
                    <li class="nav-small-cap">
                        <i class="ti ti-dots nav-small-cap-icon"></i>
                        <span class="hide-menu">سازمان و کاربران</span>
                    </li>

                    <!-- کاربران -->
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-users"></i></span>
                            <span class="hide-menu">کاربران</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.users.add')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت کاربر">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-user-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت کاربر</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.users')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="کاربران">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-users"></i>
                                    </div>
                                    <span class="hide-menu">کاربران</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.users.list')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست کاربران">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">لیست کاربران</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.users.RoleManagement')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="مدیریت مجوز کاربران">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-shield-check"></i>
                                    </div>
                                    <span class="hide-menu">مدیریت مجوز کاربران</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- جایگاه‌ها -->
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-building"></i></span>
                            <span class="hide-menu">جایگاه‌ها</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.user.position.create')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت جایگاه">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-building-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت جایگاه</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.user.position')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="جایگاه‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-building"></i>
                                    </div>
                                    <span class="hide-menu">جایگاه‌ها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.user.position.list')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست جایگاه‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">لیست جایگاه‌ها</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- شرکت‌ها -->
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-building-community"></i></span>
                            <span class="hide-menu">شرکت‌ها</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.create.company')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت شرکت">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-building-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت شرکت</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.companies')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="شرکت‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-building-community"></i>
                                    </div>
                                    <span class="hide-menu">شرکت‌ها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.list.company')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست شرکت‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">لیست شرکت‌ها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.departments')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="دپارتمان">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-sitemap"></i>
                                    </div>
                                    <span class="hide-menu">دپارتمان</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- نقش‌ها و مجوزها (قبلاً پایین‌تر بود، آوردیم کنار کاربران) -->
                    <li class="nav-small-cap">
                        <i class="ti ti-dots nav-small-cap-icon"></i>
                        <span class="hide-menu">دسترسی‌ها</span>
                    </li>

                    <!-- نقش‌ها -->
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-user-shield"></i></span>
                            <span class="hide-menu">نقش‌ها</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.create.role')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت نقش">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-user-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت نقش</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.roles')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="نقش‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-user-shield"></i>
                                    </div>
                                    <span class="hide-menu">نقش‌ها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.list.roles')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست نقش‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">لیست نقش‌ها</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- مجوزها -->
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-shield"></i></span>
                            <span class="hide-menu">مجوزها</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.create.permissions')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت مجوز">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-shield-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت مجوز</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.permissions')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="مجوزها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-shield"></i>
                                    </div>
                                    <span class="hide-menu">مجوزها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.list.permissions')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست مجوزها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">لیست مجوزها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.roles.permissions.manage')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="مدیریت مجوز کاربران">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">مدیریت مجوز کاربران</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.projects.assign.roles')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="مدیریت مجوز پرووژه">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">مدیریت مجوز پرووژه</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- 🔹 مدیریت پروژه‌ها و اسناد -->
                    <li class="nav-small-cap">
                        <i class="ti ti-dots nav-small-cap-icon"></i>
                        <span class="hide-menu">مدیریت پروژه‌ها</span>
                    </li>

                    <!-- پروژه‌ها -->
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-briefcase"></i></span>
                            <span class="hide-menu">پروژه‌ها</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.create.project')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت پروژه">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-briefcase-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت پروژه</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.projects')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="پروژه‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-briefcase"></i>
                                    </div>
                                    <span class="hide-menu">پروژه‌ها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.project.dashboard')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="داشبورد پروژه">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-dashboard"></i>
                                    </div>
                                    <span class="hide-menu">داشبورد پروژه</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.list.projects')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست پروژه‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">لیست پروژه‌ها</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- نوع پروژه‌ها -->
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-tags"></i></span>
                            <span class="hide-menu">نوع پروژه‌ها</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.create.project.type')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت نوع پروژه">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-tag-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت نوع پروژه</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.project.types')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="نوع پروژه‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-tags"></i>
                                    </div>
                                    <span class="hide-menu">نوع پروژه‌ها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.list.project.type')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست نوع پروژه‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">لیست نوع پروژه‌ها</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- بخش‌بندی پروژه‌ها -->
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-layout-kanban"></i></span>
                            <span class="hide-menu">بخش‌بندی پروژه‌ها</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.create.section')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت بخش">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-layout-kanban-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت بخش</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.sections')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="بخش‌بندی‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-layout-kanban"></i>
                                    </div>
                                    <span class="hide-menu">بخش‌بندی‌ها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.list.sections')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست بخش‌بندی‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">لیست بخش‌بندی‌ها</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- ترنسمیتال -->
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-mail-forward"></i></span>
                            <span class="hide-menu">ترنسمیتال</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('transmittal.create')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت ترنسمیتال">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-mail-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت ترنسمیتال</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('transmittals.index')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست ترنسمیتال">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-mail"></i>
                                    </div>
                                    <span class="hide-menu">لیست ترنسمیتال</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.transmittal.template.create')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="قالب‌های ترنسمیتال">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-template"></i>
                                    </div>
                                    <span class="hide-menu">قالب‌های ترنسمیتال</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- مدیریت فایل -->
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                            <span class="d-flex"><i class="ti ti-files"></i></span>
                            <span class="hide-menu">مدیریت فایل</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.create.file')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت فایل">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-file-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت فایل</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.projectfiles.list')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="فایل‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-files"></i>
                                    </div>
                                    <span class="hide-menu">فایل‌ها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.projectfiles')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست فایل">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">لیست فایل</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- 🔹 حضور و غیاب -->
                    <li class="nav-small-cap">
                        <i class="ti ti-dots nav-small-cap-icon"></i>
                        <span class="hide-menu">حضور و غیاب</span>
                    </li>

                    <li class="sidebar-item <?php echo e(request()->routeIs('admin.attendence.*') ? 'active' : ''); ?>">
                        <a class="sidebar-link has-arrow flex items-center" href="#"
                           aria-expanded="<?php echo e(request()->routeIs('admin.attendence.*') ? 'true' : 'false'); ?>">
                        <span class="d-flex">
                            <i class="ti ti-calendar-stats"></i>
                        </span>
                            <span class="hide-menu">درخواست‌ها</span>
                        </a>
                        <ul aria-expanded="<?php echo e(request()->routeIs('admin.attendence.*') ? 'true' : 'false'); ?>"
                            class="collapse first-level <?php echo e(request()->routeIs('admin.attendence.*') ? 'in' : ''); ?>">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.attendence.requests.create')); ?>"
                                   class="sidebar-link flex items-center"
                                   data-bs-toggle="tooltip" title="ثبت درخواست مرخصی/ماموریت">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-calendar-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت درخواست</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.attendence.requests.index')); ?>"
                                   class="sidebar-link flex items-center"
                                   data-bs-toggle="tooltip" title="درخواست‌های من">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-calendar"></i>
                                    </div>
                                    <span class="hide-menu">درخواست‌های من</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.attendence.approvals.inbox')); ?>"
                                   class="sidebar-link flex items-center"
                                   data-bs-toggle="tooltip" title="در انتظار تایید من">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-checks"></i>
                                    </div>
                                    <span class="hide-menu">در انتظار تایید من</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.attendence.managerule')); ?>"
                                   class="sidebar-link flex items-center"
                                   data-bs-toggle="tooltip" title="قوانین">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-checks"></i>
                                    </div>
                                    <span class="hide-menu">قوانین </span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- 🔹 مالی و خرید -->
                    <li class="nav-small-cap">
                        <i class="ti ti-dots nav-small-cap-icon"></i>
                        <span class="hide-menu">مالی و خرید</span>
                    </li>

                    <!-- فاکتور فروش (AR) -->
                    <li class="sidebar-item <?php echo e(request()->routeIs('admin.sales.*') ? 'active' : ''); ?>">
                        <a class="sidebar-link has-arrow" href="#" aria-expanded="false">
                        <span class="d-flex round-16 align-items-center justify-content-center">
                            <i class="ti ti-file-invoice"></i>
                        </span>
                            <span class="hide-menu">فاکتور فروش (AR)</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.sales.invoice.create')); ?>" class="sidebar-link">
                                <span class="round-16 d-flex align-items-center justify-content-center">
                                    <i class="ti ti-file-plus"></i>
                                </span>
                                    <span class="hide-menu">ثبت فاکتور جدید</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.sales.list')); ?>" class="sidebar-link">
                                <span class="round-16 d-flex align-items-center justify-content-center">
                                    <i class="ti ti-list"></i>
                                </span>
                                    <span class="hide-menu">لیست فاکتورها</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- تنخواه -->
                    <li class="nav-small-cap">
                        <span class="hide-menu">تنخواه</span>
                    </li>
                    <li class="sidebar-item <?php echo e(request()->routeIs('admin.PettyCash.*') ? 'active' : ''); ?>">
                        <a class="sidebar-link has-arrow" href="#" aria-expanded="false">
                        <span class="d-flex round-16 align-items-center justify-content-center">
                            <i class="ti ti-file-PettyCash"></i>
                        </span>
                            <span class="hide-menu">تنخواه</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.petty-cash.create')); ?>" class="sidebar-link">
                                <span class="round-16 d-flex align-items-center justify-content-center">
                                    <i class="ti ti-file-plus"></i>
                                </span>
                                    <span class="hide-menu">ثبت تنخواه</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.petty-cash.index')); ?>" class="sidebar-link">
                                <span class="round-16 d-flex align-items-center justify-content-center">
                                    <i class="ti ti-list"></i>
                                </span>
                                    <span class="hide-menu">تایید تنخواه</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.petty-cash.rules')); ?>" class="sidebar-link">
                                <span class="round-16 d-flex align-items-center justify-content-center">
                                    <i class="ti ti-list"></i>
                                </span>
                                    <span class="hide-menu">مدیریت قوانین تنخواه</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- خرید -->
                    <li class="nav-small-cap">
                        <i class="ti ti-dots nav-small-cap-icon"></i>
                        <span class="hide-menu">خرید</span>
                    </li>
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                        <span class="d-flex">
                            <i class="ti ti-shopping-cart"></i>
                        </span>
                            <span class="hide-menu">درخواست خرید</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.purchase_request')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت درخواست خرید">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-shopping-cart-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت درخواست خرید</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.all_purchase')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست درخواست خریدها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">لیست درخواست خریدها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.item_management')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت کالا">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-package"></i>
                                    </div>
                                    <span class="hide-menu">ثبت کالا</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.itemlist')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست کالا">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">لیست کالا</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('purchase.dashboard')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="داشبورد درخواست‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-dashboard"></i>
                                    </div>
                                    <span class="hide-menu">داشبورد درخواست‌ها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('purchase.my-requests')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="درخواست‌های خرید من">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-shopping-cart"></i>
                                    </div>
                                    <span class="hide-menu">درخواست‌های خرید من</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('purchase.budget')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="مدیریت بودجه">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-wallet"></i>
                                    </div>
                                    <span class="hide-menu">مدیریت بودجه</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.approvers')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="قوانین امضا">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-signature"></i>
                                    </div>
                                    <span class="hide-menu">قوانین امضا</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('purchase-approvals.inbox')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="تایید درخواست">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-check"></i>
                                    </div>
                                    <span class="hide-menu">تایید درخواست</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.payee.management')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="مدیریت ذینفعان">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-check"></i>
                                    </div>
                                    <span class="hide-menu">مدیریت ذینفعان </span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.payees.list')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست ذینفعان">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-check"></i>
                                    </div>
                                    <span class="hide-menu">لیست ذینفعان </span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.sign_settings')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="تنظیمات امضا">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-settings"></i>
                                    </div>
                                    <span class="hide-menu">تنظیمات امضا</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.list.contract.status')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست قراردادها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">لیست قراردادها</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- درخواست وجه -->
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                        <span class="d-flex">
                            <i class="ti ti-wallet"></i>
                        </span>
                            <span class="hide-menu">درخواست وجه (صدور چک)</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.payment.create')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت درخواست وجه">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-cash"></i>
                                    </div>
                                    <span class="hide-menu">ثبت درخواست وجه</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.payment.mine')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="درخواست‌های وجه من">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-files"></i>
                                    </div>
                                    <span class="hide-menu">درخواست‌های وجه من</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.payment.approval.inbox')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="تأیید درخواست‌های وجه">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-shield-check"></i>
                                    </div>
                                    <span class="hide-menu">تأیید درخواست‌های وجه</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.payment.rule.management')); ?>"
                                   class="sidebar-link flex items-center"
                                   data-bs-toggle="tooltip" title="قوانین تایید درخواست وجه ">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-checks"></i>
                                    </div>
                                    <span class="hide-menu">قوانین تایید درخواست وجه </span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.payment.list')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست کلی درخواست‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list-check"></i>
                                    </div>
                                    <span class="hide-menu">لیست کلی درخواست‌ها</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- قراردادها -->
                    <li class="nav-small-cap">
                        <i class="ti ti-dots nav-small-cap-icon"></i>
                        <span class="hide-menu">قراردادها</span>
                    </li>
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                        <span class="d-flex">
                            <i class="ti ti-file-text"></i>
                        </span>
                            <span class="hide-menu">قراردادها</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.create.contract.status')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت نوع قرارداد">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-file-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت نوع قرارداد</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.contract.status')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="قراردادها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-file-text"></i>
                                    </div>
                                    <span class="hide-menu">قراردادها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.list.contract.status')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست قراردادها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">لیست قراردادها</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- 🔹 مکاتبات و اطلاع‌رسانی -->
                    <li class="nav-small-cap">
                        <i class="ti ti-dots nav-small-cap-icon"></i>
                        <span class="hide-menu">نامه‌نگاری</span>
                    </li>

                    <!-- تنظیمات طبقه‌بندی -->
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                        <span class="d-flex">
                            <i class="ti ti-mail-cog"></i>
                        </span>
                            <span class="hide-menu">تنظیمات طبقه‌بندی</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.create.letter.classification')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت نوع طبقه‌بندی">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-mail-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت نوع طبقه‌بندی</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.letter.classifications')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="طبقه‌بندی‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-mail-cog"></i>
                                    </div>
                                    <span class="hide-menu">طبقه‌بندی‌ها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.letter.classifications.list')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست طبقه‌بندی‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-list"></i>
                                    </div>
                                    <span class="hide-menu">لیست طبقه‌بندی‌ها</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- نامه‌نگاری -->
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                        <span class="d-flex">
                            <i class="ti ti-mail"></i>
                        </span>
                            <span class="hide-menu">نامه‌نگاری</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.create.letter')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ایجاد نامه">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-mail-plus"></i>
                                    </div>
                                    <span class="hide-menu">ایجاد نامه</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('LetterFormList')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ایجاد نامه 2">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-mail-plus"></i>
                                    </div>
                                    <span class="hide-menu">ایجاد نامه 2</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.register.incoming')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت وارده">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-mail-plus"></i>
                                    </div>
                                    <span class="hide-menu">ثبت وارده</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.incoming.list')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="لیست نامه های  وارده">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-mail-plus"></i>
                                    </div>
                                    <span class="hide-menu">لیست نامه های  وارده</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('letters.index')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="نامه‌ها">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-mail"></i>
                                    </div>
                                    <span class="hide-menu">نامه‌ها</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('user.letter')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="نامه‌های شخصی">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-mail-star"></i>
                                    </div>
                                    <span class="hide-menu">نامه‌های شخصی</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('letters.received')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="نامه‌های دریافتی">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-mail-down"></i>
                                    </div>
                                    <span class="hide-menu">نامه‌های دریافتی</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('referrals.index')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ارجاع نامه">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-mail-forward"></i>
                                    </div>
                                    <span class="hide-menu">ارجاع نامه</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('archive.index')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ثبت صادره">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-archive"></i>
                                    </div>
                                    <span class="hide-menu">ثبت صادره</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.letter.reminder')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="یادآوری نامه">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-bell"></i>
                                    </div>
                                    <span class="hide-menu">یادآوری نامه</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.letter.report')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ریپورت نامه">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-report"></i>
                                    </div>
                                    <span class="hide-menu">ریپورت نامه</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.letter.form.create')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ایجاد فرم">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-file-text"></i>
                                    </div>
                                    <span class="hide-menu">ایجاد فرم</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.letter.templates.index')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ایجاد تمپلیت">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-template"></i>
                                    </div>
                                    <span class="hide-menu">ایجاد تمپلیت</span>
                                </a>
                            </li>

                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.mycorrespondence.hub')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="داشبرد نامه">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-template"></i>
                                    </div>
                                    <span class="hide-menu">داشبرد نامه</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <!-- اطلاع‌رسانی -->
                    <li class="nav-small-cap">
                        <i class="ti ti-dots nav-small-cap-icon"></i>
                        <span class="hide-menu">اطلاع‌رسانی</span>
                    </li>
                    <li class="sidebar-item">
                        <a class="sidebar-link has-arrow flex items-center" href="#" aria-expanded="false">
                        <span class="d-flex">
                            <i class="ti ti-bell"></i>
                        </span>
                            <span class="hide-menu">اطلاع‌رسانی</span>
                        </a>
                        <ul aria-expanded="false" class="collapse first-level">
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.announcements.create')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="ارسال اطلاعیه">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-bell-plus"></i>
                                    </div>
                                    <span class="hide-menu">ارسال اطلاعیه</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('user.posts')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="اخبار شرکت">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-news"></i>
                                    </div>
                                    <span class="hide-menu">بلاگ</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                            <a href="<?php echo e(route('admin.create.post')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="اخبار شرکت">
                                <div class="round-16 d-flex align-items-center justify-content-center">
                                    <i class="ti ti-news"></i>
                                </div>
                                <span class="hide-menu">ایجاد محتوا</span>
                            </a>
                    </li>

                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.categories.index')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="اخبار شرکت">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-news"></i>
                                    </div>
                                    <span class="hide-menu">مدیریت دسته بندی های</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('user.inbox')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="صندوق ورودی">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-inbox"></i>
                                    </div>
                                    <span class="hide-menu">صندوق ورودی</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('user.sent-announcements')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="اطلاعیه‌های ارسالی من">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-send"></i>
                                    </div>
                                    <span class="hide-menu">ارسالی‌های من</span>
                                </a>
                            </li>
                            <li class="sidebar-item">
                                <a href="<?php echo e(route('admin.my-posts')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="اطلاعیه‌های ارسالی من">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-send"></i>
                                    </div>
                                    <span class="hide-menu">محتواهای ارسال شده </span>
                                </a>
                            </li>

                            <li class="sidebar-item">
                                <a href="<?php echo e(route('contact.contact_book')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="تاریخچه ورودهای اخیر">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-history"></i>
                                    </div>
                                    <span class="hide-menu">مخاطبین</span>
                                </a>
                            </li>

                            <li class="sidebar-item">
                                <a href="<?php echo e(route('contact.call_reminders')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="تاریخچه ورودهای اخیر">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-history"></i>
                                    </div>
                                    <span class="hide-menu">یادآوری تماس</span>
                                </a>
                            </li>


                            <li class="sidebar-item">
                                <a href="<?php echo e(route('user.login.history')); ?>" class="sidebar-link flex items-center" data-bs-toggle="tooltip" title="تاریخچه ورودهای اخیر">
                                    <div class="round-16 d-flex align-items-center justify-content-center">
                                        <i class="ti ti-history"></i>
                                    </div>
                                    <span class="hide-menu">تاریخچه ورود</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                </ul>
            </nav>

            <!-- باکس پروفایل پایین سایدبار (همون قبلیه) -->
            <div class="fixed-profile p-3 bg-teal-50 rounded sidebar-ad mt-3">
                <div class="hstack gap-3">
                    <div class="john-img">
                        <img src="<?php echo e(Auth::user()->image ? asset('storage/' . Auth::user()->image) : asset('panel/dist/images/profile/user-1.jpg')); ?>"
                             class="rounded-circle"
                             width="40"
                             height="40"
                             alt="<?php echo e(Auth::user()->name); ?>"
                             onerror="this.src='<?php echo e(asset('panel/dist/images/profile/user-1.jpg')); ?>'">
                    </div>
                    <div class="john-title">
                        <h6 class="mb-0 fs-4 fw-semibold"><?php echo e(Auth::user()->name); ?></h6>
                        <span class="fs-2 text-dark"><?php echo e(Auth::user()->role ?? 'کاربر'); ?></span>
                    </div>
                    <a href="<?php echo e(route('logout')); ?>"
                       class="border-0 bg-transparent text-amber-500 ms-auto"
                       tabindex="0"
                       aria-label="logout"
                       data-bs-toggle="tooltip"
                       data-bs-placement="top"
                       data-bs-title="خروج"
                       onclick="event.preventDefault(); document.getElementById('logout-form-sidebar').submit();">
                        <i class="ti ti-power fs-6"></i>
                    </a>
                    <form id="logout-form-sidebar" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                        <?php echo csrf_field(); ?>
                    </form>
                </div>
            </div>
        </div>
    </aside>

    <div class="body-wrapper">

        <header class="app-header smart-header">
            <nav class="navbar navbar-expand-lg navbar-light">
                <div class="w-100 d-flex align-items-center px-2 px-lg-4 header-shell">

                    
                    <div class="d-flex align-items-center gap-1 gap-lg-2 header-left">
                        
                        <a class="nav-link sidebartoggler nav-icon-hover topbar-icon ms-n1 ms-lg-0"
                           id="headerCollapse"
                           href="javascript:void(0)">
                            <i class="ti ti-menu-2"></i>
                        </a>

                        
                        <a class="nav-link nav-icon-hover topbar-icon d-none d-lg-flex"
                           href="javascript:void(0)"
                           data-bs-toggle="modal"
                           data-bs-target="#exampleModal">
                            <i class="ti ti-search"></i>
                        </a>
                    </div>

                    
                    <div class="d-flex d-lg-none align-items-center justify-content-center flex-grow-1 header-logo-mobile">
                        <a href="<?php echo e(route('admin.dashboard')); ?>" class="d-flex align-items-center gap-2 logo-main">
                            <div class="logo-badge logo-badge--nav enhanced-logo">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                     viewBox="0 0 850.39 866.3"
                                     class="logo-svg logo-svg--nav enhanced-svg">
                                    <path fill="currentColor"
                                          d="m538.99,140.11c158.99,1.77,296,128.26,310.88,286.82,1.81,19.31-.37,36.9-18.12,48.4-26.16,16.95-60.13.25-63.53-32.51-4.61-44.38-18.34-84.89-43.97-121.48-61.46-87.76-174.07-123.45-266.88-84.16-29.57,12.52-54.58,30.91-71.72,58.71-21.12,34.27-14.36,61.85,20.63,80.99,22.18,12.13,44.64,23.92,67.64,34.38,107.55,48.86,99.27,161.14,43.66,223.74-79.12,89.07-178.41,109.59-289.18,78.16C101.3,677.08,14.16,568.77.38,436.29c-2.98-28.69,11.85-48.87,37.46-50.96,26.19-2.13,43.41,14.21,45.8,43.47,10.29,125.52,119.14,222.11,243.93,215.79,45.68-2.31,85.62-19.21,118.49-51.55,11.84-11.65,21.15-25.06,26.62-40.89,8.82-25.51-.39-49.31-24.4-61.67-27.07-13.94-54.22-27.77-81.63-41.03-84.96-41.11-87.26-132.1-54.57-187.74,36.65-62.39,92.2-98.09,161.34-114.81,21.57-5.21,43.46-6.92,65.56-6.78Z" />
                                    <path fill="#ffffff"
                                          d="m432.95.02c26.42-.59,43.4,13.83,44.81,38.03,1.38,23.71-15.4,41.73-41.13,44.2-111.21,10.64-198.34,90.76-216.12,198.73-13.47,81.81,31.3,167.24,102.62,195.41,7.8,3.08,16.13,4.81,24.16,7.33,23.69,7.44,37.39,30.68,30.97,52.38-6.79,22.97-28.65,34.66-53.34,28.53-95.93-23.81-172.38-109.7-186.49-210.8C113.06,172.11,252.51,15.55,428.74.24c1.4-.12,2.81-.15,4.21-.22Z" />
                                    <path fill="#ffffff"
                                          d="m715.62,557.39c.04,147.17-113.58,278.87-262.47,304.11-10.61,1.8-21.31,3.12-32,4.42-25.23,3.07-45.36-12.77-48.25-37.82-2.75-23.77,13.82-43.12,39.79-44.67,45.27-2.69,85.54-18.12,122.73-43.74,78.83-54.33,117.13-160.91,86.68-246.54-19.72-55.47-56.14-94.23-115.03-109.26-26.11-6.67-39.05-30.37-31.48-55.17,7.08-23.21,28.16-33.32,53.94-25.85,111.99,32.43,186.05,133.74,186.08,254.53Z" />
                                </svg>
                            </div>
                            <div class="logo-text-wrapper d-flex flex-column justify-content-center">
                                <span class="logo-title bigger-title">سرآمان</span>
                                <span class="logo-subtitle bigger-subtitle">سامانه یکپارچه هوشمند</span>
                            </div>
                        </a>
                    </div>

                    
                    <div class="d-flex align-items-center ms-auto gap-1 gap-lg-3 header-right">

                        
                        <button class="navbar-toggler p-0 border-0 topbar-icon d-lg-none"
                                type="button"
                                data-bs-toggle="collapse"
                                data-bs-target="#navbarNav"
                                aria-controls="navbarNav"
                                aria-expanded="false"
                                aria-label="Toggle navigation">
                    <span class="p-2">
                        <i class="ti ti-dots fs-7"></i>
                    </span>
                        </button>

                        <div class="collapse navbar-collapse show-on-lg" id="navbarNav">
                            <div class="d-flex align-items-center justify-content-end gap-2 gap-lg-3 topbar-actions">
                                
                                <a href="javascript:void(0)"
                                   class="nav-link d-flex d-lg-none align-items-center justify-content-center topbar-icon"
                                   type="button"
                                   data-bs-toggle="offcanvas"
                                   data-bs-target="#mobilenavbar"
                                   aria-controls="offcanvasWithBothOptions">
                                    <i class="ti ti-align-justified fs-7"></i>
                                </a>

                                <ul class="navbar-nav flex-row align-items-center justify-content-center gap-1 gap-lg-2">

                                    
                                    <li class="nav-item">
                                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('layout.notifications-dropdown');

$__html = app('livewire')->mount($__name, $__params, 'lw-2967902187-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                    </li>

                                    
                                    <li class="nav-item dropdown">
                                        <a class="nav-link pe-0" href="javascript:void(0)" id="drop1" data-bs-toggle="dropdown" aria-expanded="false">
                                            <div class="header-user-pill">
                                                <div class="header-user-text">
                                            <span class="header-user-name">
                                                <?php echo e(Auth::user()->name); ?>

                                            </span>
                                                    <span class="header-user-role">
                                                <?php echo e(Auth::user()->role ?? 'کاربر'); ?>

                                            </span>
                                                </div>

                                                <div class="header-user-avatar">
                                                    <img src="<?php echo e(Auth::user()->image ? asset('storage/' . Auth::user()->image) : asset('panel/dist/images/profile/user-1.jpg')); ?>"
                                                         alt="<?php echo e(Auth::user()->name); ?>"
                                                         onerror="this.src='<?php echo e(asset('panel/dist/images/profile/user-1.jpg')); ?>'">
                                                </div>
                                            </div>
                                        </a>

                                        <div class="dropdown-menu content-dd dropdown-menu-end dropdown-menu-animate-up"
                                             aria-labelledby="drop1"
                                             style="text-align: right; direction: rtl;">
                                            <div class="profile-dropdown position-relative" data-simplebar>
                                                <div class="py-3 px-7 pb-0">
                                                    <h5 class="mb-0 fs-5 fw-semibold">پروفایل کاربر</h5>
                                                </div>
                                                <div class="d-flex align-items-center py-9 mx-7 border-bottom">
                                                    <img src="<?php echo e(Auth::user()->image ? asset('storage/' . Auth::user()->image) : asset('panel/dist/images/profile/user-1.jpg')); ?>"
                                                         class="rounded-circle"
                                                         width="80"
                                                         height="80"
                                                         alt="<?php echo e(Auth::user()->name); ?>"
                                                         onerror="this.src='<?php echo e(asset('panel/dist/images/profile/user-1.jpg')); ?>'">
                                                    <div class="ms-3">
                                                        <h5 class="mb-1 fs-3"><?php echo e(Auth::user()->name); ?></h5>
                                                        <span class="mb-1 d-block text-dark"><?php echo e(Auth::user()->role ?? 'کاربر'); ?></span>
                                                        <p class="mb-0 d-flex text-dark align-items-center gap-2">
                                                            <i class="ti ti-mail fs-4"></i> <?php echo e(Auth::user()->email); ?>

                                                        </p>
                                                    </div>
                                                </div>
                                                <div class="message-body">
                                                    <a href="<?php echo e(route('user.profile.edit')); ?>" class="py-8 px-7 mt-8 d-flex align-items-center">
                                                <span class="d-flex align-items-center justify-content-center bg-light rounded-1 p-6">
                                                    <img src="<?php echo e(asset('panel/dist/images/svgs/icon-account.svg')); ?>" alt="" width="24" height="24">
                                                </span>
                                                        <div class="w-75 d-inline-block v-middle ps-3">
                                                            <h6 class="mb-1 bg-hover-primary fw-semibold">پروفایل من</h6>
                                                            <span class="d-block text-dark">تنظیمات حساب</span>
                                                        </div>
                                                    </a>
                                                    <a href="<?php echo e(route('user.inbox')); ?>" class="py-8 px-7 d-flex align-items-center">
                                                <span class="d-flex align-items-center justify-content-center bg-light rounded-1 p-6">
                                                    <img src="<?php echo e(asset('panel/dist/images/svgs/icon-inbox.svg')); ?>" alt="" width="24" height="24">
                                                </span>
                                                        <div class="w-75 d-inline-block v-middle ps-3">
                                                            <h6 class="mb-1 bg-hover-primary fw-semibold">صندوق ورودی من</h6>
                                                            <span class="d-block text-dark">پیام‌ها و ایمیل‌ها</span>
                                                        </div>
                                                    </a>
                                                    <a href="<?php echo e(route('user.sent-announcements')); ?>" class="py-8 px-7 d-flex align-items-center">
                                                <span class="d-flex align-items-center justify-content-center bg-light rounded-1 p-6">
                                                    <img src="<?php echo e(asset('panel/dist/images/svgs/icon-send.svg')); ?>" alt="" width="24" height="24">
                                                </span>
                                                        <div class="w-75 d-inline-block v-middle ps-3">
                                                            <h6 class="mb-1 bg-hover-primary fw-semibold">ارسالی‌های من</h6>
                                                            <span class="d-block text-dark">اطلاعیه‌های ارسال شده</span>
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="d-grid py-4 px-7 pt-8">
                                                    <a href="<?php echo e(route('logout')); ?>"
                                                       class="btn btn-outline-primary"
                                                       onclick="event.preventDefault(); document.getElementById('logout-form-header').submit();">
                                                        خروج
                                                    </a>
                                                    <form id="logout-form-header" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                                        <?php echo csrf_field(); ?>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                    </li>
                                </ul>
                            </div>
                        </div>

                    </div>

                </div>
            </nav>
        </header>


        <div class="container-fluid">
            <?php echo e($slot); ?>

        </div>
    </div>
    <div class="dark-transparent sidebartoggler"></div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-scrollable modal-lg">
        <div class="modal-content rounded-1">
            <div class="modal-header border-bottom">
                <input type="search" class="form-control fs-3" placeholder="جستجو کنید" id="search" />
                <span data-bs-dismiss="modal" class="lh-1 cursor-pointer">
                    <i class="ti ti-x fs-5 ms-3"></i>
                </span>
            </div>
            <div class="modal-body message-body" data-simplebar></div>
        </div>
    </div>
</div>

<script src="<?php echo e(asset('panel/dist/libs/jquery/dist/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('panel/dist/libs/bootstrap/dist/js/bootstrap.bundle.min.js')); ?>"></script>

<script src="<?php echo e(asset('panel/dist/libs/simplebar/dist/simplebar.min.js')); ?>"></script>

<script src="<?php echo e(asset('panel/dist/js/app.min.js')); ?>"></script>
<script src="<?php echo e(asset('panel/dist/js/app.init.js')); ?>"></script>
<script src="<?php echo e(asset('panel/dist/js/app-style-switcher.js')); ?>"></script>
<script src="<?php echo e(asset('panel/dist/js/sidebarmenu.js')); ?>"></script>
<script src="<?php echo e(asset('panel/dist/js/custom.js')); ?>"></script>
<script src="<?php echo e(asset('panel/dist/js/custom1.js')); ?>"></script>
<script src="<?php echo e(asset('panel/dist/js/persian-date.js')); ?>"></script>
<script src="<?php echo e(asset('panel/dist/js/persian-datepicker.min.js')); ?>"></script>



<script>
    function initializeMersaPlugins() {
        // این شرط برای اطمینان از تعریف $ و bootstrap است.
        if (typeof $ === 'undefined' || typeof bootstrap === 'undefined') {
            // اگر تعریف نشده، صبر کن. این در Livewire SPA حیاتی است.
            setTimeout(initializeMersaPlugins, 100);
            return;
        }

        // ۱. مقداردهی اولیه Tooltipها و Collapseها
        $('[data-bs-toggle="tooltip"]').each(function () {
            const existingTooltip = bootstrap.Tooltip.getInstance(this);
            if (existingTooltip) {
                existingTooltip.dispose();
            }
            new bootstrap.Tooltip(this, {
                container: 'body',
                trigger: 'hover'
            });
        });

        // ۲. فراخوانی منطق سایدبار
        // مطمئن شوید که initSidebarMenu در فایل sidebarmenu.js به صورت سراسری تعریف شده است.
        if (typeof initSidebarMenu === 'function') {
            initSidebarMenu();
        }

        // ۳. SimpleBar (اسکرول سایدبار)
        if (typeof SimpleBar !== 'undefined') {
            document.querySelectorAll('[data-simplebar]').forEach(el => {
                // اگر قبلاً مقداردهی نشده باشد، دوباره مقداردهی کن.
                if (!el.simplebar) {
                    new SimpleBar(el);
                }
            });
        }

        // ۴. مقداردهی Datepicker
        if (typeof $('.persian-date-picker').pDatepicker === 'function') {
            $('.persian-date-picker').pDatepicker({ /* تنظیمات شما */ });
        }
    }

    // ۱. اجرای اولیه پس از لود کامل صفحه (برای اسکریپت‌هایی که در ready نیستند)
    $(document).ready(initializeMersaPlugins);

    // ۲. اجرای مجدد پس از هر ناوبری Livewire (SPA)
    // Livewire ممکن است اسکریپت‌ها را کمی زودتر از DOM آماده اجرا کند،
    // بنابراین از initializeMersaPlugins که خودش شرط تأخیر دارد، استفاده می‌کنیم.
    document.addEventListener('livewire:navigated', initializeMersaPlugins);

    // ۳. اجرای مجدد پس از به‌روزرسانی محتوای Livewire (مثل کلیک روی یک دکمه)
    document.addEventListener('livewire:updated', initializeMersaPlugins);
</script>



<script>
    /**
     * تابع هوشمند تبدیل اعداد نمایشی به فارسی
     */
    function safePersianNumbers() {
        const persianDigits = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];

        // فقط جستجو در گره‌های متنی (Text Nodes)
        const walk = document.createTreeWalker(document.body, NodeFilter.SHOW_TEXT, null, false);
        let node;

        while (node = walk.nextNode()) {
            // جلوگیری از تغییر اعداد در تگ‌های اسکریپت و استایل
            const parent = node.parentNode.nodeName;
            if (parent === 'SCRIPT' || parent === 'STYLE' || parent === 'TEXTAREA') continue;

            // فقط جایگزینی اعداد در مقدار متنی، نه ویژگی‌ها (Attributes)
            node.nodeValue = node.nodeValue.replace(/\d/g, (d) => persianDigits[d]);
        }
    }

    // اجرا در زمان لود و آپدیت‌های Livewire
    document.addEventListener('DOMContentLoaded', safePersianNumbers);
    document.addEventListener('livewire:navigated', safePersianNumbers);
    document.addEventListener('livewire:updated', safePersianNumbers);
</script>

<?php echo $__env->yieldPushContent('scripts'); ?>
<?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

</body>
</html>
<?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\admin\master.blade.php ENDPATH**/ ?>