<div class="container-fluid px-3 px-md-4 py-3 py-md-4">
    
    <?php if(session('ok')): ?>
        <div class="alert alert-success alert-dismissible fade show d-flex align-items-center mb-4" role="alert">
            <i class="fas fa-check-circle fs-4 me-3 text-success"></i>
            <div class="flex-grow-1">
                <strong class="d-block">عملیات موفقیت‌آمیز</strong>
                <?php echo e(session('ok')); ?>

            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <?php if($errors->any()): ?>
        <div class="alert alert-danger alert-dismissible fade show d-flex align-items-center mb-4" role="alert">
            <i class="fas fa-exclamation-triangle fs-4 me-3 text-danger"></i>
            <div class="flex-grow-1">
                <strong class="d-block">خطا!</strong> لطفاً خطاهای فرم را برطرف کنید.
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4 gap-3">
        <div>
            <h4 class="fw-bold m-0 text-primary">
                <i class="fas fa-calendar-plus me-2"></i>
                <?php echo e($this->isEditMode ? 'ویرایش پیش‌نویس' : 'ثبت درخواست جدید'); ?>

            </h4>
            <p class="text-muted mb-0 mt-1 small">لطفاً اطلاعات درخواست خود را با دقت وارد کنید.</p>
        </div>
        <span class="badge rounded-pill text-bg-info">مرحله ۱ از ۱</span>
    </div>

    <div class="row g-4">
        
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm rounded-4">
                <div class="card-header bg-white py-3 px-4 border-bottom-0">
                    
                    <div class="btn-group w-100" role="group" aria-label="نوع درخواست">
                        <button type="button" class="btn btn-outline-primary w-50 <?php echo e($type==='leave' ? 'active' : ''); ?>"
                                wire:click="$set('type','leave')">
                            <i class="fas fa-umbrella-beach me-1"></i> مرخصی
                        </button>
                        <button type="button" class="btn btn-outline-primary w-50 <?php echo e($type==='mission' ? 'active' : ''); ?>"
                                wire:click="$set('type','mission')">
                            <i class="fas fa-briefcase me-1"></i> ماموریت
                        </button>
                    </div>
                </div>

                <div class="card-body px-4 pb-4 pt-0">
                    
                    <div class="mb-3">
                        <label class="form-label fw-semibold">عنوان (اختیاری)</label>
                        <div class="input-group input-group-lg">
                            <span class="input-group-text bg-light"><i class="fas fa-heading text-muted"></i></span>
                            <input type="text" class="form-control" placeholder="مثلاً: مرخصی استحقاقی" wire:model.defer="title">
                        </div>
                    </div>

                    
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">از (شمسی: YYYY/MM/DD HH:MM)</label>
                            <div class="input-group input-group-lg">
                                <span class="input-group-text bg-light"><i class="fas fa-calendar-alt text-muted"></i></span>
                                <input type="text" class="form-control <?php $__errorArgs = ['start_jalali'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       placeholder="1404/06/23 08:30" wire:model.live="start_jalali" id="startJalali">
                                <?php $__errorArgs = ['start_jalali'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">تا (شمسی: YYYY/MM/DD HH:MM)</label>
                            <div class="input-group input-group-lg">
                                <span class="input-group-text bg-light"><i class="fas fa-calendar-check text-muted"></i></span>
                                <input type="text" class="form-control <?php $__errorArgs = ['end_jalali'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       placeholder="1404/06/23 17:00" wire:model.live="end_jalali" id="endJalali">
                                <?php $__errorArgs = ['end_jalali'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    
                    <div class="d-flex flex-wrap align-items-center gap-2 mt-3">
                        <div class="small text-muted me-2">میان‌بُر:</div>
                        <div class="btn-group btn-group-sm" role="group">
                            <button type="button" class="btn btn-outline-secondary" wire:click="preset('today')">امروز</button>
                            <button type="button" class="btn btn-outline-secondary" wire:click="preset('tomorrow')">فردا</button>
                            <button type="button" class="btn btn-outline-secondary" wire:click="preset('half_am')">نیم‌روز صبح</button>
                            <button type="button" class="btn btn-outline-secondary" wire:click="preset('half_pm')">نیم‌روز عصر</button>
                            <button type="button" class="btn btn-outline-secondary" wire:click="preset('next2days')">دو روز آینده</button>
                        </div>
                        <div class="form-check form-switch ms-auto">
                            <input class="form-check-input" type="checkbox" id="fullDay" wire:model="is_full_day">
                            <label class="form-check-label" for="fullDay">تمام‌روز</label>
                        </div>
                        <?php if($this->durationText): ?>
                            <span class="badge rounded-pill text-bg-success">
                                <i class="fas fa-hourglass-half me-1"></i> مدت: <?php echo e($this->durationText); ?>

                            </span>
                        <?php endif; ?>
                    </div>

                    
                    <div class="form-check form-switch mt-3">
                        <input class="form-check-input" type="checkbox" id="overlapOk" wire:model="overlap_ok">
                        <label class="form-check-label fw-semibold" for="overlapOk">
                            <i class="fas fa-exclamation-triangle text-warning me-1"></i>
                            اجازه همپوشانی زمانی با درخواست‌های قبلی
                        </label>
                        <div class="form-text text-muted">
                            اگر نیاز دارید این درخواست با درخواست‌های دیگر همپوشانی داشته باشد، این گزینه را فعال کنید.
                        </div>
                    </div>

                    
                    <div class="mt-4">
                        <label class="form-label fw-semibold">توضیحات</label>
                        <textarea class="form-control form-control-lg" rows="4"
                                  placeholder="هر توضیحی که به تایید کمک می‌کند..." wire:model.defer="description"></textarea>
                    </div>

                    
                    <?php if($type === 'leave'): ?>
                        <div class="border rounded-3 p-3 mt-4 bg-light">
                            <label class="form-label fw-semibold">نوع مرخصی</label>
                            <select class="form-select form-select-lg <?php $__errorArgs = ['leave_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model="leave_type">
                                <option value="annual">استحقاقی</option>
                                <option value="sick">استعلاجی</option>
                                <option value="unpaid">بدون حقوق</option>
                                <option value="overtime_comp">جبرانی</option>
                                <option value="other">سایر</option>
                            </select>
                            <?php $__errorArgs = ['leave_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    <?php else: ?>
                        <div class="border rounded-3 p-3 mt-4 bg-light">
                            <div class="mb-3">
                                <label class="form-label fw-semibold">پروژه <span class="text-danger">*</span></label>
                                <div class="d-flex flex-column flex-md-row gap-2">
                                    <input type="text" class="form-control" placeholder="جستجو نام/کد پروژه..."
                                           wire:model.live.debounce.300ms="projectQuery" style="max-width: 320px;">
                                    <select class="form-select <?php $__errorArgs = ['project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            wire:model.live="project_id">
                                        <option value="">انتخاب پروژه...</option>
                                        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($p->id); ?>">
                                                <?php echo e($p->name); ?><?php echo e($p->code ? ' — '.$p->code : ''); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <?php $__errorArgs = ['project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">شهر مأموریت</label>
                                    <input type="text" class="form-control form-control-lg"
                                           wire:model.defer="mission_city" placeholder="مثلاً: تهران">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">هدف/موضوع</label>
                                    <input type="text" class="form-control form-control-lg"
                                           wire:model.defer="mission_purpose" placeholder="جلسه، بازدید، ...">
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                
                <div class="card-footer bg-white d-flex justify-content-between align-items-center">
                    <div class="small text-muted">
                        میان‌بُر: <span class="badge text-bg-light">Ctrl + S</span> برای ذخیرهٔ پیش‌نویس
                    </div>
                    <div class="d-flex gap-2">
                        <button type="button" class="btn btn-outline-secondary px-4" wire:click="saveDraft" wire:loading.attr="disabled">
                            <span wire:loading.remove wire:target="saveDraft"><i class="fas fa-save me-1"></i> ذخیره پیش‌نویس</span>
                            <span wire:loading wire:target="saveDraft"><i class="fas fa-spinner fa-spin me-1"></i> در حال ذخیره...</span>
                        </button>
                        <button type="button" class="btn btn-primary px-4" wire:click="submit" wire:loading.attr="disabled">
                            <span wire:loading.remove wire:target="submit"><i class="fas fa-paper-plane me-1"></i> ارسال جهت تأیید</span>
                            <span wire:loading wire:target="submit"><i class="fas fa-spinner fa-spin me-1"></i> در حال ارسال...</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="col-lg-4">
            
            <div class="card border-0 shadow-sm rounded-4">
                <div class="card-header bg-white border-0">
                    <ul class="nav nav-tabs nav-fill border-0" role="tablist">
                        <li class="nav-item" role="presentation">
                            <a class="nav-link active text-dark fw-semibold py-3 px-4"
                               data-bs-toggle="tab" href="#summary" role="tab">
                                <i class="fas fa-list-ul me-1"></i> خلاصه
                            </a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link text-secondary fw-semibold py-3 px-4"
                               data-bs-toggle="tab" href="#helper" role="tab">
                                <i class="fas fa-lightbulb me-1"></i> راهنما
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="card-body pt-3">
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="summary" role="tabpanel">
                            <ul class="list-group list-group-flush small">
                                <li class="list-group-item d-flex justify-content-between">
                                    <span class="text-muted">نوع:</span>
                                    <span class="fw-semibold"><?php echo e($type==='leave' ? 'مرخصی' : 'ماموریت'); ?></span>
                                </li>
                                <li class="list-group-item">
                                    <div class="text-muted">بازه:</div>
                                    <div class="fw-semibold"><?php echo e($start_jalali); ?> <span class="text-muted">تا</span> <?php echo e($end_jalali); ?></div>
                                </li>
                                <?php if($this->durationText): ?>
                                    <li class="list-group-item d-flex justify-content-between">
                                        <span class="text-muted">مدت:</span>
                                        <span class="fw-semibold"><?php echo e($this->durationText); ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if($type==='leave'): ?>
                                    <?php $map=['annual'=>'استحقاقی','sick'=>'استعلاجی','unpaid'=>'بدون حقوق','overtime_comp'=>'جبرانی','other'=>'سایر']; ?>
                                    <li class="list-group-item d-flex justify-content-between">
                                        <span class="text-muted">نوع مرخصی:</span>
                                        <span class="fw-semibold"><?php echo e($map[$leave_type] ?? '—'); ?></span>
                                    </li>
                                <?php else: ?>
                                    <li class="list-group-item d-flex justify-content-between">
                                        <span class="text-muted">پروژه:</span>
                                        <span class="fw-semibold">
                                            <?php $p = $project_id ? \App\Models\Project::find($project_id) : null; ?>
                                            <?php echo e($p ? ($p->name.($p->code?' — '.$p->code:'')) : '—'); ?>

                                        </span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between">
                                        <span class="text-muted">شهر:</span>
                                        <span class="fw-semibold"><?php echo e($mission_city ?: '—'); ?></span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between">
                                        <span class="text-muted">هدف:</span>
                                        <span class="fw-semibold"><?php echo e($mission_purpose ?: '—'); ?></span>
                                    </li>
                                <?php endif; ?>
                                <li class="list-group-item d-flex justify-content-between">
                                    <span class="text-muted">همپوشانی مجاز:</span>
                                    <span class="fw-semibold">
                                        <span class="badge rounded-pill text-bg-<?php echo e($overlap_ok ? 'success' : 'secondary'); ?>">
                                            <?php echo e($overlap_ok ? 'بله' : 'خیر'); ?>

                                        </span>
                                    </span>
                                </li>
                            </ul>
                        </div>
                        <div class="tab-pane fade" id="helper" role="tabpanel">
                            <div class="alert alert-light border small mb-0">
                                <ul class="mb-0">
                                    <li>تاریخ‌ها را با تقویم شمسی انتخاب کنید.</li>
                                    <li>اگر «تمام‌روز» روشن باشد، ساعت‌ها خودکار پر می‌شود.</li>
                                    <li>در صورت نیاز به همپوشانی زمانی با درخواست‌های قبلی، گزینه مربوطه را فعال کنید.</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer bg-white text-center small text-muted">
                    شماره فرم پس از ثبت ساخته می‌شود.
                </div>
            </div>

            
            <div class="card border-0 shadow-sm rounded-4 mt-3">
                <div class="card-header bg-white border-0 d-flex align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-route me-1 text-primary"></i> زنجیرهٔ تأیید (پیش‌نمایش)</h6>
                    <span class="badge text-bg-light"><?php echo e(count($approverPreview)); ?> نفر</span>
                </div>
                <div class="card-body">
                    <?php if(count($approverPreview)): ?>
                        <ul class="approval-steps list-unstyled m-0">
                            <?php $__currentLoopData = $approverPreview; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $ap): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="approval-step d-flex align-items-center gap-3 mb-3">
                                    <div class="step-index"><?php echo e($i+1); ?></div>
                                    <div class="avatar-circle">
                                        <?php echo e(strtoupper(mb_substr($ap['name'],0,1))); ?>

                                    </div>
                                    <div class="flex-fill">
                                        <div class="fw-semibold"><?php echo e($ap['name']); ?></div>
                                        <div class="small text-muted"><?php echo e($ap['email']); ?></div>
                                        <div class="mt-1">
                                            <span class="badge rounded-pill text-bg-secondary"><?php echo e($ap['role_text']); ?></span>
                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php else: ?>
                        <div class="alert alert-warning small mb-0">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            هیچ تأییدکننده‌ای برای این درخواست پیدا نشد. لطفاً با مدیر سیستم تماس بگیرید.
                        </div>
                    <?php endif; ?>
                </div>
                <div class="card-footer bg-white small text-muted">
                    ترتیب تأیید بر اساس قوانین تعریف شده در سیستم تعیین می‌شود.
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
    <script src="https://cdn.jsdelivr.net/npm/persian-date@1.1.0/dist/persian-date.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>
    <script>
        document.addEventListener('livewire:initialized', () => {
            const bindPicker = (id) => {
                const $el = $('#'+id);
                if (!$el.length) return;
                $el.pDatepicker({
                    format: 'YYYY/MM/DD HH:mm',
                    timePicker: { enabled: true },
                    autoClose: true,
                    calendar: { persian: { locale: 'fa' } },
                    onSelect: function(){ $el.val($el.val()).trigger('input'); }
                });
            };
            bindPicker('startJalali');
            bindPicker('endJalali');

            // Ctrl+S => ذخیره پیش‌نویس
            window.addEventListener('keydown', (e) => {
                if ((e.ctrlKey || e.metaKey) && e.key.toLowerCase() === 's') {
                    e.preventDefault();
                    Livewire.getByName('admin.attendence.requests.create')[0]?.call('saveDraft');
                }
            });
        });
    </script>
    <style>
        .btn-group .btn.active{ box-shadow: inset 0 0 0 1px var(--bs-primary); }
        .card .list-group-item{ padding: .65rem .75rem; }
        /* استایل مدرن تایم‌لاین تاییدکنندگان */
        .approval-step:last-child { margin-bottom: 0; }
        .avatar-circle{
            width: 40px; height: 40px; border-radius: 50%;
            background: var(--bs-primary); color: #fff; display:flex; align-items:center; justify-content:center;
            font-weight: 700;
        }
        .step-index{
            width: 28px; height: 28px; border-radius: 50%;
            background: var(--bs-light); color: var(--bs-dark);
            display:flex; align-items:center; justify-content:center;
            font-size: 12px; border: 1px solid var(--bs-border-color);
        }
        /* موبایل فرندلی */
        @media (max-width: 768px) {
            .btn-group .btn {
                font-size: 0.875rem;
                padding: 0.375rem 0.5rem;
            }
        }
    </style>
<?php $__env->stopPush(); ?><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\attendence\requests\create.blade.php ENDPATH**/ ?>