<div class="container-fluid px-3 px-md-4 py-3 py-md-4">
    
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4 gap-3">
        <div>
            <h4 class="fw-bold m-0 text-primary"><i class="fas fa-inbox me-2"></i> در انتظار تأیید من</h4>
            <p class="text-muted mb-0 mt-1 small">درخواست‌هایی که نیاز به بررسی و تصمیم‌گیری شما دارند.</p>
        </div>
        <div class="d-flex flex-wrap gap-2">
            <button class="btn btn-outline-secondary btn-sm" wire:click="exportCsv">
                <i class="fas fa-file-export me-1"></i> خروجی CSV
            </button>
        </div>
    </div>

    
    <div class="card border-0 shadow-sm rounded-4 mb-4 position-sticky top-0 z-2" style="backdrop-filter: blur(2px);">
        <div class="card-header bg-white border-0">
            <h6 class="m-0 fw-bold"><i class="fas fa-filter me-2 text-muted"></i> فیلترها</h6>
        </div>
        <div class="card-body p-3 p-md-4">
            <div class="d-flex flex-wrap gap-3 align-items-end">
                <div class="flex-grow-1" style="min-width: 240px;">
                    <label class="form-label small text-uppercase text-muted mb-1">جستجو</label>
                    <div class="input-group input-group-sm">
                        <input type="text" class="form-control" placeholder="نام/ایمیل/عنوان/شهر/هدف..."
                               wire:model.live.debounce.500ms="search">
                        <span class="input-group-text bg-light"><i class="fas fa-search text-muted"></i></span>
                    </div>
                </div>
                <div>
                    <label class="form-label small text-uppercase text-muted mb-1">نوع</label>
                    <select class="form-select form-select-sm" wire:model.live="type" style="min-width: 140px;">
                        <option value="">همه انواع</option>
                        <option value="leave">مرخصی</option>
                        <option value="mission">ماموریت</option>
                    </select>
                </div>
                <div>
                    <label class="form-label small text-uppercase text-muted mb-1">از تاریخ (شمسی)</label>
                    <div class="input-group input-group-sm">
                        <input type="text" class="form-control" id="fromJ" placeholder="YYYY/MM/DD HH:mm"
                               wire:model.live.debounce.400ms="from_j">
                        <span class="input-group-text bg-light"><i class="fas fa-calendar-alt text-muted"></i></span>
                    </div>
                </div>
                <div>
                    <label class="form-label small text-uppercase text-muted mb-1">تا تاریخ (شمسی)</label>
                    <div class="input-group input-group-sm">
                        <input type="text" class="form-control" id="toJ" placeholder="YYYY/MM/DD HH:mm"
                               wire:model.live.debounce.400ms="to_j">
                        <span class="input-group-text bg-light"><i class="fas fa-calendar-check text-muted"></i></span>
                    </div>
                </div>
                <div>
                    <label class="form-label small text-uppercase text-muted mb-1">سورت</label>
                    <select class="form-select form-select-sm" wire:model.live="sortField">
                        <option value="submitted_at">زمان ارسال</option>
                        <option value="start_datetime">شروع درخواست</option>
                        <option value="end_datetime">پایان درخواست</option>
                        <option value="id">شماره</option>
                    </select>
                </div>
                <div>
                    <label class="form-label small text-uppercase text-muted mb-1">جهت</label>
                    <select class="form-select form-select-sm" wire:model.live="sortDirection">
                        <option value="desc">نزولی</option>
                        <option value="asc">صعودی</option>
                    </select>
                </div>
                <div>
                    <label class="form-label small text-uppercase text-muted mb-1">نمایش</label>
                    <select class="form-select form-select-sm" wire:model.live="perPage">
                        <option>10</option><option>15</option><option>25</option><option>50</option>
                    </select>
                </div>
                <div class="ms-auto d-flex gap-2">
                    <div class="btn-group btn-group-sm">
                        <button class="btn btn-outline-secondary" wire:click="presetRange('today')">امروز</button>
                        <button class="btn btn-outline-secondary" wire:click="presetRange('week')">این هفته</button>
                        <button class="btn btn-outline-secondary" wire:click="presetRange('month')">این ماه</button>
                        <button class="btn btn-outline-secondary" wire:click="presetRange('clear')" title="پاک‌سازی تاریخ">
                            <i class="fas fa-eraser"></i>
                        </button>
                    </div>
                    <button class="btn btn-outline-dark btn-sm" wire:click="resetFilters"><i class="fas fa-undo me-1"></i> پاک‌سازی</button>
                </div>
            </div>
        </div>
    </div>

    
    <div class="d-flex justify-content-between align-items-center mb-3">
        <div class="d-flex flex-wrap gap-2 align-items-center">
            <button class="btn btn-success btn-sm"
                    wire:click="bulkApproveSelected"
                    wire:loading.attr="disabled"
                <?php if(!count($selected)): echo 'disabled'; endif; ?>>
                <span wire:loading.remove wire:target="bulkApproveSelected"><i class="fas fa-check-double me-1"></i> تأیید سریعِ گروهی</span>
                <span wire:loading wire:target="bulkApproveSelected"><i class="fas fa-spinner fa-spin me-1"></i> در حال تأیید...</span>
            </button>
            <button type="button" class="btn btn-outline-secondary btn-sm"
                    wire:click='toggleSelectAllOnPage(<?php echo \Illuminate\Support\Js::from($pageIds)->toHtml() ?>)'>
                <?php echo e($selectAllOnPage ? 'لغو انتخاب همه' : 'انتخاب همهٔ این صفحه'); ?>

            </button>
            <?php if(count($selected)): ?>
                <span class="badge text-bg-light">انتخاب شده: <?php echo e(count($selected)); ?></span>
            <?php endif; ?>
        </div>
        <div class="d-none d-md-block"><?php echo e($items->onEachSide(1)->links()); ?></div>
    </div>

    
    <div class="row g-3">
        <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-12" wire:key="row-<?php echo e($r->id); ?>">
                <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
                    <div class="card-body p-3 p-md-4">
                        <div class="d-flex flex-wrap align-items-start gap-3">
                            
                            <div class="pt-2">
                                <input class="form-check-input" type="checkbox"
                                       value="<?php echo e($r->id); ?>" wire:model="selected">
                            </div>
                            
                            <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center"
                                 style="width:46px;height:46px;">
                                <?php echo e(strtoupper(mb_substr($r->user->name,0,1))); ?>

                            </div>
                            
                            <div class="flex-grow-1">
                                <div class="d-flex flex-wrap align-items-center gap-2 mb-2">
                                    <a href="javascript:void(0)" class="fw-bold text-decoration-none link-dark"
                                       wire:click="openQuickView(<?php echo e($r->id); ?>)" title="نمایش سریع">
                                        <?php echo e($r->user->name); ?>

                                    </a>
                                    
                                    <span class="badge rounded-pill text-bg-<?php echo e($r->type==='leave' ? 'info' : 'warning'); ?> py-2 px-3">
                                        <?php echo e($r->type==='leave' ? 'مرخصی' : 'ماموریت'); ?>

                                    </span>
                                    
                                    <?php if($r->type==='leave' && optional($r->details)->leave_type): ?>
                                        <?php $lt=['annual'=>'استحقاقی','sick'=>'استعلاجی','unpaid'=>'بدون حقوق','overtime_comp'=>'جبرانی','other'=>'سایر']; ?>
                                        <span class="badge rounded-pill text-bg-light py-2 px-3"><?php echo e($lt[$r->details->leave_type] ?? $r->details->leave_type); ?></span>
                                    <?php endif; ?>
                                    <span class="badge text-bg-light py-2 px-3">#<?php echo e($r->id); ?></span>
                                </div>
                                <div class="text-muted small mb-2">
                                    <?php echo e($r->title ?: 'بدون عنوان'); ?>

                                </div>
                                
                                <div class="text-muted small d-flex flex-wrap gap-3">
                                    <span><i class="fas fa-calendar-alt me-1"></i> از: <span class="text-dark fw-semibold"><?php echo e(optional($r->details)->start_j ?? '—'); ?></span></span>
                                    <span><i class="fas fa-calendar-check me-1"></i> تا: <span class="text-dark fw-semibold"><?php echo e(optional($r->details)->end_j ?? '—'); ?></span></span>
                                    <?php if($r->type==='mission'): ?>
                                        <span><i class="fas fa-city me-1"></i> شهر: <span class="text-dark fw-semibold"><?php echo e($r->details->mission_city ?? '—'); ?></span></span>
                                        <span><i class="fas fa-bullseye me-1"></i> هدف: <span class="text-dark fw-semibold"><?php echo e($r->details->mission_purpose ?? '—'); ?></span></span>
                                    <?php endif; ?>
                                    <?php if(optional($r->details)->duration_hours): ?>
                                        <span><i class="fas fa-hourglass-half me-1"></i> مدت: <span class="text-dark fw-semibold"><?php echo e($r->details->duration_hours); ?></span> ساعت</span>
                                    <?php endif; ?>
                                    <?php if(optional($r->details)->overlap_ok): ?>
                                        <span><i class="fas fa-exclamation-triangle me-1 text-warning"></i> <span class="text-warning fw-semibold">همپوشانی مجاز</span></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="ms-auto d-flex flex-wrap gap-2">
                                <a href="<?php echo e(route('admin.attendence.requests.show',$r)); ?>" class="btn btn-outline-secondary btn-sm" data-bs-toggle="tooltip" title="بازکردن صفحه‌ی درخواست">
                                    <i class="fas fa-eye"></i> بررسی
                                </a>
                                <button wire:click="approveQuick(<?php echo e($r->id); ?>)"
                                        wire:loading.attr="disabled"
                                        class="btn btn-success btn-sm">
                                    <span wire:loading.remove wire:target="approveQuick(<?php echo e($r->id); ?>)"><i class="fas fa-check"></i> تأیید</span>
                                    <span wire:loading wire:target="approveQuick(<?php echo e($r->id); ?>)"><i class="fas fa-spinner fa-spin"></i></span>
                                </button>
                                <button wire:click="openRejectModal(<?php echo e($r->id); ?>)" class="btn btn-danger btn-sm">
                                    <i class="fas fa-times"></i> رد
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer bg-white small text-muted d-flex align-items-center justify-content-between">
                        <div>
                            <i class="fas fa-paper-plane me-1"></i>
                            ارسال:
                            <?php if($r->submitted_at): ?>
                                <?php echo e(\Morilog\Jalali\Jalalian::fromCarbon($r->submitted_at)->format('Y/m/d H:i')); ?>

                            <?php else: ?>
                                —
                            <?php endif; ?>
                        </div>
                        <div class="d-none d-md-inline">برای جزییات سریع، روی نام کاربر کلیک کنید.</div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12">
                <div class="card border-0 shadow-sm rounded-4">
                    <div class="card-body text-center text-muted py-5">
                        <i class="fas fa-inbox fa-2x opacity-50 mb-2"></i>
                        <div class="fw-semibold">موردی برای تأیید وجود ندارد.</div>
                        <div class="small mt-2">درخواست‌های جدید به محض ارسال در این لیست ظاهر می‌شوند.</div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    
    <div class="mt-4 d-md-none"><?php echo e($items->onEachSide(0)->links()); ?></div>

    
    <div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectModalLabel" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 rounded-4 shadow">
                <div class="modal-header bg-danger text-white rounded-top-4">
                    <h5 class="modal-title" id="rejectModalLabel"><i class="fas fa-times-circle me-2"></i> رد درخواست</h5>
                    <button type="button" class="btn-close btn-close-white" aria-label="Close" wire:click="closeRejectModal"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="mb-4">
                        <label class="form-label fw-bold">علت رد <span class="text-danger">*</span></label>
                        <textarea class="form-control form-control-lg <?php $__errorArgs = ['rejectReason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                  rows="5" wire:model.defer="rejectReason" placeholder="علت رد را واضح و کوتاه بنویسید..."></textarea>
                        <?php $__errorArgs = ['rejectReason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <div class="form-text text-muted">
                            این علت برای ثبت در سابقه و اطلاع‌رسانی به درخواست‌دهنده استفاده می‌شود.
                        </div>
                    </div>

                    <div class="alert alert-danger border-0 small">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        پس از رد درخواست، امکان بازگشت آن وجود ندارد.
                    </div>
                </div>
                <div class="modal-footer border-0 pt-0">
                    <button type="button" class="btn btn-lg btn-outline-secondary px-4 py-2" wire:click="closeRejectModal">
                        <i class="fas fa-times me-2"></i> انصراف
                    </button>
                    <button type="button" class="btn btn-lg btn-danger px-4 py-2" wire:click="submitReject" wire:loading.attr="disabled">
                        <span wire:loading.remove wire:target="submitReject"><i class="fas fa-paper-plane me-2"></i> ثبت رد نهایی</span>
                        <span wire:loading wire:target="submitReject"><i class="fas fa-spinner fa-spin me-2"></i> در حال ثبت...</span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    
    <div class="offcanvas offcanvas-end" tabindex="-1" id="quickViewCanvas" aria-labelledby="quickViewLabel" style="width:440px" wire:ignore.self>
        <div class="offcanvas-header border-bottom">
            <h5 class="offcanvas-title" id="quickViewLabel">نمایش سریع</h5>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close" wire:click="closeQuickView"></button>
        </div>
        <div class="offcanvas-body">
            <?php if($showQuickView && $quickReq): ?>
                <div class="d-flex align-items-center gap-3 mb-4">
                    <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center"
                         style="width:56px;height:56px; font-size: 1.5rem; font-weight: 700;">
                        <?php echo e(strtoupper(mb_substr($quickReq->user->name,0,1))); ?>

                    </div>
                    <div>
                        <div class="fw-bold fs-5"><?php echo e($quickReq->user->name); ?></div>
                        <div class="small text-muted"><?php echo e($quickReq->user->email); ?></div>
                    </div>
                </div>
                <div class="border rounded-3 p-4 mb-4 bg-light">
                    <div class="mb-2"><span class="text-muted small">نوع:</span> <span class="fw-semibold fs-5"><?php echo e($quickReq->type==='leave'?'مرخصی':'ماموریت'); ?></span></div>
                    <div class="mb-2"><span class="text-muted small">عنوان:</span> <span class="fw-semibold fs-5"><?php echo e($quickReq->title ?: '—'); ?></span></div>
                    <div class="mb-2"><span class="text-muted small">بازه:</span> <span class="fw-semibold fs-5"><?php echo e($quickReq->details->start_j ?? '—'); ?> <span class="text-muted">تا</span> <?php echo e($quickReq->details->end_j ?? '—'); ?></span></div>
                    <?php if($quickReq->type==='mission'): ?>
                        <div class="mb-2"><span class="text-muted small">شهر:</span> <span class="fw-semibold fs-5"><?php echo e($quickReq->details->mission_city ?? '—'); ?></span></div>
                        <div class="mb-2"><span class="text-muted small">هدف:</span> <span class="fw-semibold fs-5"><?php echo e($quickReq->details->mission_purpose ?? '—'); ?></span></div>
                    <?php else: ?>
                        <?php if($quickReq->details?->leave_type): ?>
                            <?php $lt=['annual'=>'استحقاقی','sick'=>'استعلاجی','unpaid'=>'بدون حقوق','overtime_comp'=>'جبرانی','other'=>'سایر']; ?>
                            <div class="mb-2"><span class="text-muted small">نوع مرخصی:</span> <span class="fw-semibold fs-5"><?php echo e($lt[$quickReq->details->leave_type] ?? $quickReq->details->leave_type); ?></span></div>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if($quickReq->details?->overlap_ok): ?>
                        <div class="mb-2"><span class="text-muted small">همپوشانی:</span> <span class="fw-semibold fs-5 text-warning">مجاز است</span></div>
                    <?php endif; ?>
                </div>
                
                <div class="mb-4">
                    <div class="fw-bold fs-5 mb-3"><i class="fas fa-route me-2 text-primary"></i> مراحل تأیید</div>
                    <ul class="list-unstyled m-0">
                        <?php $__currentLoopData = $quickReq->approvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $st): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $stLabel = $st->status === \App\Models\ApprovalStep::ST_APPROVED ? 'تأیید' :
                                           ($st->status === \App\Models\ApprovalStep::ST_REJECTED ? 'رد' :
                                           ($st->status === \App\Models\ApprovalStep::ST_SKIPPED ? 'پرش' : 'در انتظار'));
                                $badge = $st->status === \App\Models\ApprovalStep::ST_APPROVED ? 'success' :
                                         ($st->status === \App\Models\ApprovalStep::ST_REJECTED ? 'danger' :
                                         ($st->status === \App\Models\ApprovalStep::ST_SKIPPED ? 'secondary' : 'warning'));
                            ?>
                            <li class="d-flex align-items-start gap-3 mb-4">
                                <div class="timeline-dot bg-<?php echo e($badge); ?>"></div>
                                <div class="flex-fill">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <div class="fw-bold fs-5"><?php echo e($st->approver?->name ?? '—'); ?></div>
                                        <span class="badge rounded-pill text-bg-<?php echo e($badge); ?> py-2 px-3"><?php echo e($stLabel); ?></span>
                                        <span class="badge rounded-pill text-bg-light small">مرحله <?php echo e($st->step_order); ?></span>
                                    </div>
                                    <?php if($st->decided_at): ?>
                                        <div class="small text-muted mb-1">تاریخ تصمیم: <?php echo e($this->toJ($st->decided_at)); ?></div>
                                    <?php endif; ?>
                                    <?php if($st->comment): ?>
                                        <div class="mt-2 bg-light border rounded p-3">
                                            <div class="d-flex align-items-center gap-2 mb-1">
                                                <i class="fas fa-quote-right text-muted"></i>
                                                <span class="fw-semibold small">یادداشت:</span>
                                            </div>
                                            <div class="small"><?php echo e($st->comment); ?></div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <div class="d-flex gap-3">
                    <a class="btn btn-outline-secondary btn-lg flex-grow-1" href="<?php echo e(route('admin.attendence.requests.show', $quickReq)); ?>">
                        <i class="fas fa-eye me-2"></i> صفحه درخواست
                    </a>
                    <button class="btn btn-success btn-lg" wire:click="approveQuick(<?php echo e($quickReq->id); ?>)">
                        <i class="fas fa-check me-2"></i> تأیید
                    </button>
                    <button class="btn btn-danger btn-lg" wire:click="openRejectModal(<?php echo e($quickReq->id); ?>)">
                        <i class="fas fa-times me-2"></i> رد
                    </button>
                </div>
            <?php else: ?>
                <div class="text-muted small">موردی برای نمایش انتخاب نشده است.</div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
    <script src="https://cdn.jsdelivr.net/npm/persian-date@1.1.0/dist/persian-date.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>
    <script>
        document.addEventListener('livewire:initialized', () => {
            const bindPicker = (id) => {
                const $el = $('#'+id);
                if (!$el.length) return;
                $el.pDatepicker({
                    format: 'YYYY/MM/DD HH:mm',
                    timePicker: { enabled: true },
                    autoClose: true,
                    calendar: { persian: { locale: 'fa' } },
                    onSelect: function(){ $el.val($el.val()).trigger('input'); }
                });
            };
            bindPicker('fromJ');
            bindPicker('toJ');

            // Offcanvas
            const offEl = document.getElementById('quickViewCanvas');
            const offc = offEl ? new bootstrap.Offcanvas(offEl, { backdrop: true }) : null;
            window.addEventListener('open-offcanvas', ()=> offc?.show());
            window.addEventListener('close-offcanvas', ()=> offc?.hide());

            // Modal رد
            const modalEl = document.getElementById('rejectModal');
            const modal = modalEl ? new bootstrap.Modal(modalEl, { backdrop: 'static' }) : null;
            window.addEventListener('showRejectModal', () => modal?.show());
            window.addEventListener('hideRejectModal', () => modal?.hide());

            // Tooltips
            const initTooltips = () => {
                document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(el => {
                    if (bootstrap.Tooltip.getInstance(el)) {
                        bootstrap.Tooltip.getInstance(el).dispose();
                    }
                    new bootstrap.Tooltip(el);
                });
            };
            initTooltips();
            Livewire.hook('morph.updated', initTooltips);

            // Toast رویداد عمومی
            window.addEventListener('toast', (e) => {
                const { type='success', text='انجام شد' } = e.detail || {};
                const el = document.createElement('div');
                el.className = 'toast align-items-center text-bg-' + type + ' border-0 show position-fixed bottom-0 end-0 m-3';
                el.innerHTML = `
                <div class="d-flex">
                    <div class="toast-body fs-5 fw-bold">${text}</div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" onclick="this.closest('.toast').remove()"></button>
                </div>`;
                document.body.appendChild(el);
                setTimeout(()=> el.remove(), 3000);
            });
        });
    </script>
    <style>
        .position-sticky.top-0 { top: .75rem; }
        .card .list-group-item{ padding: .65rem .75rem; }
        /* تایم‌لاین مراحل */
        .timeline-dot{
            width: 12px;
            height: 12px;
            border-radius: 50%;
            margin-top: .5rem;
            background: currentColor;
        }
        /* بَج‌های مدرن */
        .badge.rounded-pill {
            font-weight: 600;
            border-radius: 50rem !important;
        }
        /* ظرافت کارت‌ها */
        .card {
            --bs-card-border-radius: 1rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }
        /* موبایل فرندلی */
        @media (max-width: 768px) {
            .offcanvas { width: 100% !important; }
            .btn-lg {
                padding: 0.5rem 1rem !important;
                font-size: 0.875rem !important;
            }
            .fs-5 {
                font-size: 1rem !important;
            }
            .p-4 {
                padding: 1rem !important;
            }
            .gap-3 {
                gap: 0.75rem !important;
            }
        }
    </style>
<?php $__env->stopPush(); ?><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\attendence\requests\approver-inbox.blade.php ENDPATH**/ ?>