<div class="container-fluid py-5">
    <div class="row justify-content-center">
        <div class="col-12 col-xxl-9">

            
            <?php if(session()->has('success') || session()->has('error')): ?>
                <div
                    class="alert alert-<?php echo e(session()->has('success') ? 'success' : 'danger'); ?> alert-dismissible fade show d-flex align-items-center mb-4 border-0 shadow-sm rounded-4 notification-alert"
                    role="alert"
                >
                    <i class="ti ti-<?php echo e(session()->has('success') ? 'check-circle' : 'alert-octagon'); ?> fs-4 me-3"></i>
                    <div class="flex-grow-1 fw-medium">
                        <?php echo e(session('success') ?? session('error')); ?>

                    </div>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <div class="bg-gradient-header rounded-4 p-5 mb-4 text-white position-relative overflow-hidden shadow-lg header-card">
                <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 position-relative">
                    <div>
                        <h2 class="mb-1 fw-bold fs-3">📬 اطلاعیه‌های ارسالی من</h2>
                        <p class="mb-0 opacity-90">
                            مدیریت و مشاهده وضعیت بازدید <?php echo e($announcements->total()); ?> اطلاعیه
                        </p>
                    </div>
                    <a href="<?php echo e(route('admin.announcements.create')); ?>"
                       class="btn btn-light text-primary-dark rounded-pill px-4 py-2 fw-bold shadow-sm hover-scale">
                        <i class="ti ti-plus fs-5 me-2"></i> ارسال جدید
                    </a>
                </div>
                <div class="header-card-icon">
                    <i class="ti ti-bell-ringing opacity-50"></i>
                </div>
            </div>

            
            <div class="bg-white rounded-4 p-4 shadow-sm mb-4 filter-container">
                <div class="row g-3 align-items-center">
                    <div class="col-6 col-md-3">
                        <select class="form-select form-select-lg rounded-3 shadow-sm filter-select-improved" wire:model="perPage">
                            <option value="5">۵ در صفحه</option>
                            <option value="10">۱۰ در صفحه</option>
                            <option value="15">۱۵ در صفحه</option>
                            <option value="20">۲۰ در صفحه</option>
                            <option value="50">۵۰ در صفحه</option>
                        </select>
                    </div>
                    <div class="col-6 col-md-3">
                        <select class="form-select form-select-lg rounded-3 shadow-sm filter-select-improved" wire:model="sort">
                            <option value="newest">جدیدترین</option>
                            <option value="oldest">قدیمی‌ترین</option>
                        </select>
                    </div>
                    <div class="col-12 col-md-6">
                        <div class="input-group input-group-lg search-box-improved">
                            <input type="text"
                                   class="form-control form-control-lg shadow-none"
                                   placeholder="🔍 جستجو در عنوان و متن..."
                                   wire:model.debounce.400ms="search">
                            <span class="input-group-text bg-white">
                                <i class="ti ti-search text-primary"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            
            <div wire:loading.delay class="text-center my-3">
                <div class="spinner-border spinner-border-sm text-primary" role="status">
                    <span class="visually-hidden">در حال به‌روزرسانی...</span>
                </div>
            </div>

            
            <div class="announcements-list">

                <?php $__empty_1 = true; $__currentLoopData = $announcements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $isExpanded     = $expandedId === $a->id;
                        $totalCount     = $a->total_count > 0 ? $a->total_count : 1;
                        $readPercentage = round(($a->read_count / $totalCount) * 100);

                        $percentClass = $readPercentage === 100
                            ? 'percent-green'
                            : ($readPercentage > 50 ? 'percent-yellow' : 'percent-red');
                    ?>

                    
                    <div class="announcement-item d-flex align-items-center justify-content-between mb-3" wire:key="sent-<?php echo e($a->id); ?>">
                        
                        <div class="d-flex align-items-center gap-3">

                            
                            <button
                                type="button"
                                class="accordion-toggle-btn"
                                wire:click.stop="toggleExpansion(<?php echo e($a->id); ?>)"
                            >
                                <i class="ti ti-chevron-<?php echo e($isExpanded ? 'up' : 'down'); ?>"></i>
                            </button>

                            <div class="d-flex align-items-center gap-2">
                                <span class="pill-percent <?php echo e($percentClass); ?>">
                                    <?php echo e($readPercentage); ?>%
                                </span>

                                <span class="read-counter">
                                    <?php echo e($a->read_count); ?>/<?php echo e($a->total_count); ?>

                                    <i class="ti ti-eye ms-1"></i>
                                </span>
                            </div>
                        </div>

                        
                        <div class="flex-grow-1 text-end px-3">
                            <a href="javascript:void(0);"
                               class="announcement-title"
                               wire:click.prevent.stop="toggleExpansion(<?php echo e($a->id); ?>)">
                                <?php echo e($a->title); ?>

                            </a>
                        </div>

                        
                        <div class="d-flex align-items-center gap-3 text-nowrap">
                            <?php if($a->attachments->count() > 0 || $a->file): ?>
                                <i class="ti ti-paperclip small text-primary"></i>
                            <?php endif; ?>

                            <div class="announcement-date">
                                <i class="ti ti-calendar-event me-1"></i>
                                <?php echo e($a->created_at->translatedFormat('j F Y, H:i')); ?>

                            </div>
                        </div>
                    </div>

                    
                    <div class="announcement-details <?php echo e($isExpanded ? 'show' : ''); ?> mb-3">
                        <?php if($isExpanded): ?>
                            
                            <div class="details-content mb-3">
                                <?php echo e($a->content); ?>

                            </div>

                            
                            <?php if($a->attachments->count() > 0 || $a->file): ?>
                                <div class="attachments-section p-3 bg-gray-100 rounded-3 mb-3 border border-dashed border-gray-200">
                                    <div class="fw-bold text-dark d-flex align-items-center gap-2 mb-2 border-bottom pb-2">
                                        <i class="ti ti-paperclip fs-5 text-primary-dark"></i>
                                        <span>فایل‌های پیوست (<?php echo e($a->attachments->count() + ($a->file ? 1 : 0)); ?>)</span>
                                    </div>

                                    <div class="d-flex flex-wrap gap-2 pt-2">
                                        <?php if($a->file): ?>
                                            <a href="<?php echo e(asset('storage/' . $a->file)); ?>"
                                               class="btn btn-sm btn-outline-primary rounded-pill fw-medium"
                                               download>
                                                <i class="ti ti-download fs-5 me-1"></i> فایل اصلی
                                            </a>
                                        <?php endif; ?>

                                        <?php $__currentLoopData = $a->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $att): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(asset('storage/' . $att->path)); ?>"
                                               class="btn btn-sm btn-outline-secondary rounded-pill fw-medium"
                                               download>
                                                <i class="ti ti-file fs-5 me-1"></i>
                                                <?php echo e(\Illuminate\Support\Str::limit($att->original_name, 15)); ?>

                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            
                            <?php if($expandedRecipients->isNotEmpty()): ?>
                                <div class="recipients-status-section p-4 bg-primary-light rounded-4 mb-3">
                                    <div class="d-flex align-items-center justify-content-between mb-3 border-bottom border-primary-dark border-opacity-25 pb-3">
                                        <h6 class="fw-bold text-primary-dark mb-0 d-flex align-items-center gap-2">
                                            <i class="ti ti-users fs-5"></i>
                                            وضعیت مشاهده دریافت‌کنندگان
                                        </h6>

                                        <div class="d-flex gap-2">
                                            <span class="badge bg-success text-white px-3 py-2 rounded-pill shadow-sm">
                                                دیده: <?php echo e($a->read_count); ?>

                                            </span>
                                            <span class="badge bg-danger text-white px-3 py-2 rounded-pill shadow-sm">
                                                ندیده: <?php echo e($a->total_count - $a->read_count); ?>

                                            </span>
                                        </div>
                                    </div>

                                    <div class="recipients-grid-improved">
                                        <?php $__currentLoopData = $expandedRecipients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recipient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $isRead = $recipient->read_at !== null; ?>

                                            <div class="recipient-item-improved p-3 rounded-3 shadow-sm transition-all <?php echo e($isRead ? 'bg-white border border-success' : 'bg-white border border-danger-subtle'); ?>">
                                                <div class="d-flex align-items-center">
                                                    <div class="status-icon-improved me-3 text-<?php echo e($isRead ? 'success' : 'danger'); ?>">
                                                        <i class="ti ti-user-check fs-4"></i>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <div class="fw-bold text-dark small mb-1">
                                                            <?php echo e($recipient->name ?? 'نامشخص'); ?>

                                                        </div>
                                                        <div class="text-muted small status-date-improved">
                                                            <?php if($isRead): ?>
                                                                <i class="ti ti-clock-check me-1 text-success"></i>
                                                                خوانده شده:
                                                                <?php echo e(\Carbon\Carbon::parse($recipient->read_at)->diffForHumans()); ?>

                                                            <?php else: ?>
                                                                <i class="ti ti-clock-off me-1 text-danger"></i>
                                                                هنوز ندیده است
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            
                            <div class="mt-3 pt-3 border-top d-flex justify-content-end">
                                <button
                                    type="button"
                                    class="btn btn-danger rounded-pill px-4 hover-scale shadow-sm"
                                    wire:click.stop="deleteAnnouncement(<?php echo e($a->id); ?>)"
                                    onclick="if (!confirm('آیا مطمئنید می‌خواهید این اطلاعیه را حذف کنید؟ این عمل غیرقابل بازگشت است.')) { event.stopImmediatePropagation(); return false; }"
                                >
                                    <i class="ti ti-trash me-2"></i>
                                    حذف اطلاعیه
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center py-5 bg-white rounded-4 shadow-lg border border-dashed border-gray-300">
                        <div class="p-4 bg-gray-50 rounded-circle d-inline-block mb-4">
                            <i class="ti ti-bell-off fs-1 text-muted opacity-50"></i>
                        </div>
                        <h4 class="text-muted fw-bold mb-2">📭 هنوز اطلاعیه‌ای ارسال نکرده‌اید</h4>
                        <p class="text-muted mb-4">اولین اطلاعیه خود را برای همکاران ارسال کنید.</p>
                        <a href="<?php echo e(route('admin.announcements.create')); ?>"
                           class="btn btn-lg btn-primary rounded-pill px-5 shadow-lg hover-scale">
                            <i class="ti ti-plus fs-5 me-2"></i> ارسال اطلاعیه جدید
                        </a>
                    </div>
                <?php endif; ?>

                
                <?php if($announcements->hasPages()): ?>
                    <div class="d-flex justify-content-center mt-4">
                        <div class="pagination-wrapper rounded-pill shadow-lg p-2 bg-white">
                            <?php echo e($announcements->links('pagination.custom-modern')); ?>

                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <style>
        :root {
            --primary: #0f766e;
            --primary-light: #ccfbf1;
            --primary-dark: #115e59;
            --gray-50: #f9fafb;
            --gray-100: #f3f4f6;
            --gray-200: #e5e7eb;
        }

        .bg-gradient-header {
            background: linear-gradient(135deg, var(--primary-dark), var(--primary));
        }

        .hover-scale { transition: transform 0.2s ease, box-shadow 0.2s ease; }
        .hover-scale:hover { transform: scale(1.03); box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1); }

        .header-card-icon {
            position: absolute;
            top: -20px;
            left: -20px;
            font-size: 10rem;
            color: rgba(255, 255, 255, 0.1);
            transform: rotate(-15deg);
        }

        .notification-alert {
            background: linear-gradient(135deg, #10b981, #059669) !important;
            color: white !important;
        }
        .btn-close-white { filter: brightness(0) invert(1); }

        .search-box-improved .input-group-text,
        .search-box-improved .form-control {
            border: 1px solid var(--gray-200) !important;
            box-shadow: none !important;
        }
        .search-box-improved .input-group-text {
            border-right: none !important;
            background-color: var(--gray-50) !important;
        }
        .search-box-improved .form-control {
            border-left: none !important;
        }

        /* ردیف اطلاعیه‌ها */
        .announcement-item {
            background: #f5f7fb;
            border-radius: 18px;
            padding: 14px 18px;
            box-shadow: 0 4px 14px rgba(15, 23, 42, 0.04);
        }
        .announcement-item:hover {
            background: #eef3ff;
        }

        .accordion-toggle-btn {
            width: 32px;
            height: 32px;
            border-radius: 999px;
            border: none;
            outline: none;
            background: #ffffff;
            box-shadow: 0 2px 6px rgba(15, 23, 42, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: transform .2s ease, box-shadow .2s ease, background-color .15s ease;
        }
        .accordion-toggle-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 10px rgba(15, 23, 42, 0.15);
            background-color: #f9fafb;
        }

        .pill-percent {
            padding: 4px 10px;
            border-radius: 999px;
            font-size: 0.8rem;
            font-weight: 600;
            box-shadow: 0 1px 4px rgba(148, 163, 184, 0.4);
            background: #ffffff;
        }
        .percent-green { color: #16a34a; }
        .percent-yellow { color: #f59e0b; }
        .percent-red { color: #ef4444; }

        .read-counter {
            font-size: 0.8rem;
            color: #64748b;
        }

        .announcement-title {
            font-weight: 600;
            color: #0f172a;
            text-decoration: none;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        .announcement-title:hover {
            color: #2563eb;
        }

        .announcement-date {
            font-size: 0.8rem;
            color: #60a5fa;
        }

        .announcement-details {
            max-height: 0;
            overflow: hidden;
            opacity: 0;
            transform-origin: top;
            transition: max-height .35s ease, opacity .25s ease, padding .2s ease, margin .2s ease;
            border-radius: 0 0 18px 18px;
        }
        .announcement-details.show {
            background: #ffffff;
            padding: 14px 18px 18px;
            margin-top: -10px;
            box-shadow: 0 10px 20px rgba(15, 23, 42, 0.06);
            max-height: 800px;
            opacity: 1;
        }

        .details-content {
            font-size: 0.9rem;
            line-height: 1.8;
            color: #334155;
            white-space: pre-wrap;
        }

        .recipients-grid-improved {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 1rem;
        }

        .pagination-wrapper {
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            border-radius: 50px;
        }
        .pagination-wrapper .pagination { margin-bottom: 0; }

        .pagination-modern-nav .page-link {
            border: none;
            color: #0f766e;
            font-weight: 500;
            margin: 0 4px;
            min-width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            transition: all 0.2s ease;
            box-shadow: 0 1px 3px rgba(0,0,0,0.05);
        }
        .pagination-modern-nav .page-arrow {
            background-color: var(--gray-100);
            color: #115e59;
        }
        .pagination-modern-nav .page-item.active .page-link {
            background-color: #0f766e !important;
            color: #fff !important;
            font-weight: 700;
            box-shadow: 0 3px 8px rgba(0,0,0,0.2);
        }
        .pagination-modern-nav .page-link:hover:not(.page-item.disabled .page-link):not(.page-item.active .page-link) {
            background-color: var(--primary-light) !important;
            color: #115e59;
        }
        .pagination-modern-nav .page-item.disabled .page-link {
            opacity: 0.4;
            pointer-events: none;
        }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\user\sent-announcements.blade.php ENDPATH**/ ?>