<div class="container-fluid" x-data="{}">

    <div class="mb-3 d-flex justify-content-between align-items-center">
        <span class="badge status-badge
            <?php if($status == 'approved'): ?> bg-success
            <?php elseif($status == 'rejected'): ?> bg-danger
            <?php else: ?> bg-info text-white
            <?php endif; ?>
            fs-6 px-4 py-2 shadow-sm rounded-pill">
            <i class="ti me-1
                <?php if($status == 'approved'): ?> ti-check
                <?php elseif($status == 'rejected'): ?> ti-x
                <?php else: ?> ti-clock
                <?php endif; ?>
            "></i>
            وضعیت:
            <?php if($status == 'approved'): ?> تأیید نهایی شده
            <?php elseif($status == 'rejected'): ?> رد شده
            <?php else: ?> در انتظار ویرایش
            <?php endif; ?>
        </span>
        <a href="<?php echo e(route('purchase.my-requests')); ?>" class="btn btn-outline-secondary rounded-pill px-4 shadow-sm">
            <i class="ti ti-arrow-back-up me-1"></i>بازگشت به لیست
        </a>
    </div>

    <div class="row g-3 mb-4">
        <div class="col-md-6">
            <div class="alert alert-success-subtle text-success d-flex justify-content-between align-items-center py-3 rounded-3 shadow-sm">
                <i class="ti ti-coins fs-4"></i>
                <div>
                    <span class="fw-bold me-2">جمع مبلغ کل:</span>
                    <span class="fs-5 fw-bold"><?php echo e(number_format($this->totalAmount)); ?></span> ریال
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="alert alert-primary-subtle text-primary d-flex justify-content-between align-items-center py-3 rounded-3 shadow-sm">
                <i class="ti ti-package fs-4"></i>
                <div>
                    <span class="fw-bold me-2">تعداد کل آیتم‌ها:</span>
                    <span class="fs-5 fw-bold"><?php echo e(number_format($this->totalCount)); ?></span> عدد
                </div>
            </div>
        </div>
    </div>

    <?php if(isset($projectBudget) && $this->totalAmount > $projectBudget): ?>
        <div class="alert alert-danger shadow-sm rounded-3">
            <i class="ti ti-alert-triangle me-2"></i>
            **هشدار بودجه:** مبلغ کل درخواست (<?php echo e(number_format($this->totalAmount)); ?> ریال) از سقف بودجه پروژه (<?php echo e(number_format($projectBudget)); ?> ریال) بیشتر است!
        </div>
    <?php endif; ?>

    <div class="card shadow-lg border-0 rounded-3">
        <div class="card-body">
            <h4 class="mb-4 text-primary-darker d-flex align-items-center gap-2 border-bottom pb-2">
                <i class="ti ti-edit fs-3"></i>
                ویرایش درخواست خرید #<?php echo e($requestId); ?>

            </h4>

            <?php if(session()->has('message')): ?>
                <div class="alert alert-success alert-dismissible fade show shadow-sm rounded-3">
                    <i class="ti ti-check me-2"></i>
                    <?php echo e(session('message')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <form wire:submit.prevent="updateRequest">
                <div class="row g-3 mb-4 p-3 bg-light-subtle rounded-3 shadow-sm">
                    <div class="col-md-6">
                        <label class="form-label fw-semibold text-primary-darker">پروژه</label>
                        <select class="form-select shadow-sm <?php $__errorArgs = ['project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model="project_id">
                            <option value="">انتخاب پروژه</option>
                            <?php $__currentLoopData = $this->projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($project->id); ?>"><?php echo e($project->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-semibold text-primary-darker">توضیحات</label>
                        <textarea class="form-control shadow-sm <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model="description" rows="2" placeholder="توضیح تکمیلی یا دلیل درخواست"></textarea>
                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <h6 class="mt-4 mb-2 text-primary-darker fw-bold d-flex align-items-center gap-2 border-bottom pb-1">
                    <i class="ti ti-list-details"></i> اقلام درخواستی (ویرایش)
                </h6>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover align-middle bg-white rounded-3 shadow-sm">
                        <thead class="bg-primary-darker text-white">
                        <tr>
                            <th>آیتم / خدمت</th>
                            <th>تعداد</th>
                            <th>قیمت واحد (ریال)</th>
                            <th>جمع (ریال)</th>
                            <th>عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $sum = (float)($item['quantity'] ?? 0) * (float)($item['price'] ?? 0);
                                $isService = empty($item['item_id']) && !empty($item['id']); // آیتم قبلی که بدون item_id است، خدمت است
                            ?>
                            <tr class="align-middle">
                                <td class="item-selector-cell">
                                    <?php if($isService): ?>
                                        <textarea class="form-control shadow-sm bg-info-subtle" wire:model="items.<?php echo e($index); ?>.name" rows="2" placeholder="شرح خدمت"></textarea>
                                        <span class="badge bg-info mt-1">خدمت آزاد</span>
                                    <?php else: ?>
                                        <select class="form-select shadow-sm <?php $__errorArgs = ['items.' . $index . '.item_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model="items.<?php echo e($index); ?>.item_id">
                                            <option value="">انتخاب کالا</option>
                                            <?php $__currentLoopData = $this->availableItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($itm->id); ?>"><?php echo e($itm->name); ?> (<?php echo e($itm->code); ?>)</option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    <?php endif; ?>
                                    <?php $__errorArgs = ['items.' . $index . '.item_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </td>
                                <td>
                                    <input type="number" min="1" class="form-control shadow-sm <?php $__errorArgs = ['items.' . $index . '.quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model="items.<?php echo e($index); ?>.quantity">
                                    <?php $__errorArgs = ['items.' . $index . '.quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </td>
                                <td>
                                    <input type="number" min="0" class="form-control shadow-sm <?php $__errorArgs = ['items.' . $index . '.price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model="items.<?php echo e($index); ?>.price">
                                    <?php $__errorArgs = ['items.' . $index . '.price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><i class="ti ti-alert-circle"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </td>
                                <td>
                                    <span class="fw-bold text-success"><?php echo e(number_format($sum)); ?></span>
                                </td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-danger rounded-pill"
                                            wire:click="removeItemRow(<?php echo e($index); ?>)"
                                            <?php if(count($items) == 1): ?> disabled <?php endif; ?>>
                                        <i class="ti ti-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr class="table-primary-subtle">
                            <td colspan="3" class="text-end fw-bold text-primary-darker">جمع کل:</td>
                            <td class="fw-bold text-success fs-5"><?php echo e(number_format($this->totalAmount)); ?></td>
                            <td></td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <button type="button" class="btn btn-outline-primary-darker rounded-pill px-4 shadow-sm" wire:click="addItemRow">
                    <i class="ti ti-plus"></i> افزودن آیتم
                </button>

                <div class="mt-5 d-flex justify-content-end align-items-center gap-3">
                    <button type="submit" class="btn btn-success rounded-pill px-5 py-2 shadow-lg">
                        <i class="ti ti-edit me-1"></i> ذخیره تغییرات
                    </button>
                </div>
            </form>
        </div>
    </div>
    <style>
        .status-badge {
            border-radius: 1rem;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            font-weight: 600;
        }
        .text-primary-darker { color: #004d99 !important; }
        .bg-primary-darker { background-color: #004d99 !important; }
        .btn-outline-primary-darker {
            --bs-btn-color: #004d99;
            --bs-btn-border-color: #004d99;
            --bs-btn-hover-color: #fff;
            --bs-btn-hover-bg: #004d99;
        }
        .alert-success-subtle { background-color: #e6fbe6 !important; border-color: #c8e6c8; }
        .alert-primary-subtle { background-color: #e0f2ff !important; border-color: #b3d9ff; }
        .table-primary-subtle { background-color: #e0f2ff !important; }
        .form-select, .form-control { border-radius: 0.7rem !important; }
        .table thead th { font-weight: bold; }
        .shadow-sm { box-shadow: 0 2px 12px rgba(0, 0, 0, 0.05) !important; }
    </style>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        });
    </script>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\purchase\edit-purchase-request.blade.php ENDPATH**/ ?>