<div>
    <div class="letters-container rtl" dir="rtl"
         x-data="{
             toastStore: {
                 toasts: [],
                 add(type, msg, isGlobal = false) {
                     const id = Date.now();
                     const toastType = isGlobal ? 'global' : type;
                     this.toasts.push({id, type: toastType, message: msg, visible: true});
                     setTimeout(() => {
                         const t = this.toasts.find(t => t.id === id);
                         if (t) t.visible = false;
                         setTimeout(() => this.toasts = this.toasts.filter(t => t.id !== id), isGlobal ? 6500 : 3800);
                     }, isGlobal ? 6500 : 3800);
                 }
             },
             init() {
                 Livewire.on('show-toast', (e) => {
                     const data = Array.isArray(e) ? e[0] : e;
                     this.toastStore.add(data.type || 'info', data.message || 'پیام نامشخص');
                 });
                 // Listener برای پیام‌های session flash
                 <?php if(session()->has('message')): ?>
                    this.toastStore.add('success', '<?php echo e(session('message')); ?>');
                 <?php endif; ?>
             }
         }"
         style="font-family: 'Vazirmatn', 'Segoe UI', sans-serif;"
    >
        <style>
            :root {
                --primary: #4338CA;
                --primary-light: #EDE9FE;
                --primary-dark: #3730A3;
                --success: #10B981;
                --danger: #EF4444;
                --warning: #FF9F1C;
                --info: #3B82F6;
                --gray-50: #F9FAFB;
                --gray-200: #E5E7EB;
                --gray-600: #4B5563;
                --gray-900: #111827;
                --card: #FFFFFF;
                --shadow: 0 4px 12px rgba(0,0,0,0.05);
                --shadow-hover: 0 10px 30px rgba(0, 0, 0, 0.1);
                --transition: all 0.3s ease-in-out;
            }

            .card { border-radius: 20px; transition: var(--transition); border: 1px solid var(--gray-200); box-shadow: var(--shadow); }
            .card:hover { box-shadow: var(--shadow-hover); transform: none; } /* حذف translateY در هاور برای کل کارت */
            .table thead th { background: #F3F4F6; font-weight: 700; color: #1f2937; border-bottom: 2px solid var(--primary); font-size: 0.9rem; }
            .table-responsive { border: 1px solid var(--gray-200); border-radius: 16px; overflow: hidden; }
            .bg-primary-light { background-color: var(--primary-light); }
            .company-logo-preview { object-fit: cover; transition: all 0.3s ease; }
            .company-logo-preview:hover { transform: scale(1.05); }
            .modal-content { border-radius: 20px !important; }

            /* Badges for Details Modal */
            .detail-badge {
                padding: 6px 12px;
                border-radius: 12px; /* گردتر شد */
                margin-bottom: 8px;
                display: flex;
                align-items: center;
                gap: 8px;
                background: var(--gray-50);
                border: 1px solid var(--gray-200);
            }
            .detail-badge strong {
                color: var(--primary);
                min-width: 80px; /* فضای بیشتر برای عنوان */
                font-weight: 600;
            }
            .detail-badge span {
                font-weight: 500;
                color: var(--gray-900);
                word-break: break-word; /* شکستن کلمات طولانی */
            }

            /* Custom Modal Styles */
            .modal-header-gradient {
                background: linear-gradient(80deg, var(--primary-dark), var(--primary));
                color: white;
            }
            .btn-primary { background: var(--primary); border-color: var(--primary); }
            .btn-close-white { filter: invert(1); }

            /* Custom Avatars */
            .user-initial-avatar {
                background-color: var(--primary-light);
                color: var(--primary-dark);
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 0.8rem;
                font-weight: 700;
            }

            /* Toast Container */
            .notification-container {
                position: fixed;
                top: 0;
                right: 0;
                z-index: 1200;
                padding: 1rem;
            }
        </style>

        <div class="notification-container">
            <template x-for="t in toastStore.toasts" :key="t.id">
                <div x-show="t.visible"
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 translate-x-full"
                     x-transition:enter-end="opacity-100 translate-x-0"
                     x-transition:leave="transition ease-in duration-300"
                     x-transition:leave-start="opacity-100 translate-x-0"
                     x-transition:leave-end="opacity-0 translate-x-full"
                     class="toast show mb-3 overflow-hidden"
                     role="alert"
                     style="border-radius: 12px; max-width: 350px;">
                    <div class="toast-header p-3"
                         :class="{
                             'bg-success text-white': t.type === 'success',
                             'bg-danger text-white': t.type === 'error',
                             'bg-info text-white': t.type === 'info'
                         }">
                        <i class="me-2" :class="{'ti ti-check-circle': t.type === 'success', 'ti ti-alert-triangle': t.type === 'error', 'ti ti-info-circle': t.type === 'info'}"></i>
                        <strong class="me-auto" x-text="t.type === 'success' ? 'موفقیت' : (t.type === 'error' ? 'خطا' : 'اطلاعات')"></strong>
                        <button type="button" class="btn-close btn-close-white" @click="t.visible = false"></button>
                    </div>
                    <div class="toast-body bg-white text-dark" x-text="t.message"></div>
                </div>
            </template>
        </div>


        <div class="card border-0 shadow-lg rounded-4">
            <div class="card-header modal-header-gradient py-4 rounded-top-4">
                <h3 class="mb-0 fw-bold d-flex align-items-center justify-content-center gap-2">
                    <i class="ti ti-building-community fs-3"></i>
                    لیست شرکت‌ها
                </h3>
                <p class="mb-0 opacity-90 mt-2 text-center">مدیریت شرکت‌ها و اطلاعات مرتبط</p>
            </div>
            <div class="card-body p-4 p-md-5">
                <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap gap-3">
                    <a href="<?php echo e(route('admin.create.company')); ?>" class="btn btn-success btn-lg rounded-pill fw-bold d-flex align-items-center gap-2 shadow-md">
                        <i class="ti ti-building-plus fs-4"></i>
                        ثبت شرکت جدید
                    </a>
                    <div class="d-flex gap-3 flex-wrap flex-grow-1 justify-content-end">
                        <div class="col-12 col-md-5" style="min-width: 250px;">
                            <div class="input-group">
                                <span class="input-group-text bg-light border-end-0"><i class="ti ti-search text-muted"></i></span>
                                <input type="text" class="form-control border-start-0 rounded-end-pill" wire:model.live="search" placeholder="جستجوی نام، تلفن یا فکس...">
                            </div>
                        </div>
                        <div class="col-12 col-md-3" style="min-width: 150px;">
                            <input type="date" wire:model.live="createdAtFilter" class="form-control rounded-pill" title="فیلتر بر اساس تاریخ ایجاد">
                        </div>
                        <div class="col-12 col-md-3" style="min-width: 150px;">
                            <button class="btn btn-outline-secondary rounded-pill w-100" wire:click="toggleSortId">
                                <i class="ti ti-sort-ascending-2 me-1"></i>
                                مرتب‌سازی (ID)
                            </button>
                        </div>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                        <tr>
                            <th style="width: 80px;">#</th>
                            <th>نام شرکت</th>
                            <th><i class="ti ti-phone fs-5 me-1"></i> تلفن</th>
                            <th><i class="ti ti-map fs-5 me-1"></i> آدرس (مختصر)</th>
                            <th><i class="ti ti-calendar fs-5 me-1"></i> تاریخ ایجاد</th>
                            <th class="text-center" style="width: 180px;">عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="align-middle">
                                <td class="fw-bold text-primary"><?php echo e($company->id); ?></td>
                                <td>
                                    <a href="javascript:void(0)" class="d-flex align-items-center text-decoration-none text-dark" wire:click="showCompanyDetails(<?php echo e($company->id); ?>)">
                                        <?php if($company->image): ?>
                                            <img src="<?php echo e(asset('app/images/company/logo/' . $company->image)); ?>" width="40" height="40" class="rounded-circle me-3 border shadow-sm company-logo-preview">
                                        <?php else: ?>
                                            <div class="user-initial-avatar rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                                <i class="ti ti-building fs-4 text-primary"></i>
                                            </div>
                                        <?php endif; ?>
                                        <span class="fw-medium"><?php echo e($company->name); ?></span>
                                    </a>
                                </td>
                                <td><?php echo e($company->tel ?? '—'); ?></td>
                                <td><?php echo e(Str::limit($company->address ?? '—', 30)); ?></td>
                                <td><?php echo e($company->created_at); ?></td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm">
                                        <button class="btn btn-outline-info" wire:click="editCompany(<?php echo e($company->id); ?>)" title="ویرایش">
                                            <i class="ti ti-edit fs-5"></i>
                                        </button>
                                        <button class="btn btn-outline-danger" onclick="confirm('آیا مطمئن هستید؟') || event.stopImmediatePropagation()" wire:click="deleteCompany(<?php echo e($company->id); ?>)" title="حذف">
                                            <i class="ti ti-trash fs-5"></i>
                                        </button>
                                        <button class="btn btn-outline-primary" wire:click="showCompanyDetails(<?php echo e($company->id); ?>)" title="جزئیات">
                                            <i class="ti ti-eye fs-5"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center py-5 text-muted">
                                    <i class="ti ti-building-x fs-1 opacity-50 mb-3"></i><br>
                                    <strong>شرکتی یافت نشد.</strong>
                                </td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <div class="mt-4 p-3">
                    <div class="d-flex justify-content-center">
                        <?php echo e($companies->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>
            </div>
        </div>

        
        <?php if($updateMode): ?>
            <div class="modal show d-block" tabindex="-1" role="dialog" aria-modal="true"
                 wire:click.self="$set('updateMode', false)"
                 wire:keydown.escape.window="$set('updateMode', false)"
                 style="display: block; background: rgba(0,0,0,0.5);">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content border-0 rounded-4 shadow-lg">
                        <div class="modal-header modal-header-gradient rounded-top-4">
                            <h5 class="modal-title fw-bold">ویرایش شرکت: <?php echo e($name); ?></h5>
                            <button type="button" class="btn-close btn-close-white" wire:click="$set('updateMode', false)"></button>
                        </div>
                        <div class="modal-body">
                            <form wire:submit.prevent="updateCompany">
                                <div class="row g-3">
                                    <div class="col-12 text-center mb-3">
                                        <?php if($image && is_object($image)): ?>
                                            <img src="<?php echo e($image->temporaryUrl()); ?>" class="rounded-circle border border-3 border-primary shadow-sm" width="80" height="80" style="object-fit: cover;">
                                        <?php elseif($companyImage): ?>
                                            <img src="<?php echo e($this->getCompanyLogoUrl($companyImage)); ?>" class="rounded-circle border border-3 border-primary shadow-sm" width="80" height="80" style="object-fit: cover;">
                                        <?php else: ?>
                                            <div class="user-initial-avatar rounded-circle d-flex align-items-center justify-content-center mx-auto" style="width: 80px; height: 80px;">
                                                <i class="ti ti-building fs-2 text-primary"></i>
                                            </div>
                                        <?php endif; ?>
                                        <div class="mt-2 small text-muted">لوگوی فعلی</div>
                                    </div>

                                    <div class="col-12">
                                        <label class="form-label">نام شرکت</label>
                                        <input type="text" wire:model="name" class="form-control rounded-3" placeholder="نام شرکت">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">تلفن</label>
                                        <input type="text" wire:model="tel" class="form-control rounded-3" placeholder="تلفن">
                                        <?php $__errorArgs = ['tel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">فکس</label>
                                        <input type="text" wire:model="fax" class="form-control rounded-3" placeholder="فکس">
                                        <?php $__errorArgs = ['fax'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label">آدرس</label>
                                        <textarea wire:model="address" class="form-control rounded-3" rows="2" placeholder="آدرس کامل شرکت"></textarea>
                                        <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label">لوگو (Max 2MB)</label>
                                        <input type="file" wire:model="image" class="form-control rounded-3">
                                        <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="modal-footer px-0 pb-0 pt-4">
                                    <button type="button" class="btn btn-secondary py-2 px-4 rounded-3 fw-bold" wire:click="$set('updateMode', false)">انصراف</button>
                                    <button type="submit" class="btn btn-primary py-2 px-4 rounded-3 fw-bold" wire:loading.attr="disabled">
                                        <span wire:loading.remove><i class="ti ti-device-floppy fs-4 me-2"></i> ذخیره تغییرات</span>
                                        <span wire:loading><i class="ti ti-loader fs-4 me-2 animate-spin"></i> در حال ذخیره...</span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        
        <?php if($showDetailsModal && $selectedCompany): ?>
            <div class="modal show d-block" tabindex="-1" role="dialog" aria-modal="true"
                 wire:click.self="closeCompanyDetailsModal"
                 wire:keydown.escape.window="closeCompanyDetailsModal"
                 style="display: block; background: rgba(0,0,0,0.5);">
                <div class="modal-dialog modal-xl modal-dialog-centered">
                    <div class="modal-content border-0 rounded-4 shadow-lg">
                        <div class="modal-header modal-header-gradient rounded-top-4">
                            <h5 class="modal-title fw-bold">جزئیات شرکت: <?php echo e($selectedCompany->name); ?></h5>
                            <button type="button" class="btn-close btn-close-white" wire:click="closeCompanyDetailsModal"></button>
                        </div>
                        <div class="modal-body">
                            <div class="row g-4">
                                <div class="col-12 col-lg-4">
                                    <div class="card border-0 shadow-sm rounded-3 mb-4">
                                        <div class="card-body">
                                            <div class="text-center mb-4">
                                                <?php if($selectedCompany->image): ?>
                                                    <img src="<?php echo e(asset('app/images/company/logo/' . $selectedCompany->image)); ?>" width="120" height="120" class="rounded-circle border border-3 border-primary shadow-sm company-logo-preview">
                                                <?php else: ?>
                                                    <div class="user-initial-avatar rounded-circle d-flex align-items-center justify-content-center mx-auto" style="width: 120px; height: 120px;">
                                                        <i class="ti ti-building fs-1 text-primary"></i>
                                                    </div>
                                                <?php endif; ?>
                                                <h4 class="mt-3 fw-bold"><?php echo e($selectedCompany->name); ?></h4>
                                            </div>
                                            <div class="small">
                                                <div class="detail-badge"><strong class="text-muted">تلفن:</strong> <span><?php echo e($selectedCompany->tel ?? '—'); ?></span></div>
                                                <div class="detail-badge"><strong class="text-muted">فکس:</strong> <span><?php echo e($selectedCompany->fax ?? '—'); ?></span></div>
                                                <div class="detail-badge"><strong class="text-muted">تاریخ ایجاد:</strong> <span><?php echo e($this->formatShamsiDate($selectedCompany->created_at, 'Y/m/d')); ?></span></div>
                                                <div class="detail-badge align-items-start"><strong class="text-muted">آدرس:</strong> <span><?php echo e($selectedCompany->address ?? '—'); ?></span></div>
                                            </div>
                                        </div>
                                    </div>

                                    
                                    <div class="card border-0 shadow-sm rounded-3">
                                        <div class="card-header modal-header-gradient py-3">
                                            <h6 class="mb-0 fw-bold">قالب‌های سربرگ مجاز</h6>
                                        </div>
                                        <div class="card-body p-3" style="max-height: 250px; overflow-y: auto;">
                                            <?php $__empty_1 = true; $__currentLoopData = $companyLetterForms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $form): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <div class="d-flex align-items-center mb-2 p-2 bg-light rounded-2 border">
                                                    <div class="user-initial-avatar rounded me-3" style="width: 30px; height: 30px;">
                                                        <i class="ti ti-file-text fs-6"></i>
                                                    </div>
                                                    <span class="fw-medium text-dark flex-grow-1" style="font-size: 0.9rem;"><?php echo e($form->name); ?></span>
                                                    <span class="badge bg-<?php echo e($form->is_global ? 'success' : 'primary'); ?>-subtle text-<?php echo e($form->is_global ? 'success' : 'primary'); ?> rounded-pill" style="font-size: 0.75rem;"><?php echo e($form->is_global ? 'عمومی' : 'اختصاصی'); ?></span>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <div class="text-center py-2 text-muted small">
                                                    <i class="ti ti-file-off me-1"></i> هیچ قالب اختصاصی یافت نشد.
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12 col-lg-8">
                                    <div class="card border-0 shadow-sm rounded-3">
                                        <div class="card-header bg-light py-3">
                                            <h5 class="mb-0 fw-bold">دپارتمان‌ها (<?php echo e($departments->count()); ?>)</h5>
                                        </div>
                                        <div class="card-body">
                                            <?php if($departments->count()): ?>
                                                <div class="row g-3">
                                                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-12 col-md-6">
                                                            <div class="card border shadow-sm">
                                                                <div class="card-body p-3">
                                                                    <h6 class="fw-bold text-primary"><?php echo e($department->name); ?></h6>
                                                                    <div class="small text-muted mb-2">
                                                                        <i class="ti ti-users fs-6 me-1"></i>
                                                                        تعداد اعضا: <?php echo e($department->users->count()); ?>

                                                                    </div>
                                                                    <button class="btn btn-sm btn-outline-primary rounded-pill" wire:click="showDepartmentUsers(<?php echo e($department->id); ?>)">
                                                                        <i class="ti ti-eye fs-6 me-1"></i>
                                                                        مشاهده اعضا
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            <?php else: ?>
                                                <div class="text-center py-4 text-muted">
                                                    <i class="ti ti-sitemap-off fs-1 opacity-50 mb-3"></i><br>
                                                    <strong>هیچ دپارتمانی برای این شرکت وجود ندارد.</strong>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer border-0 pt-0">
                            <button type="button" class="btn btn-secondary px-4 py-2 rounded-3" wire:click="closeCompanyDetailsModal">بستن</button>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        
        <?php if($showDepartmentUsersModal && $selectedDepartment): ?>
            <div class="modal show d-block" tabindex="-1" role="dialog" aria-modal="true"
                 wire:click.self="closeDepartmentUsersModal"
                 wire:keydown.escape.window="closeDepartmentUsersModal"
                 style="display: block; background: rgba(0,0,0,0.5);">
                <div class="modal-dialog modal-xl modal-dialog-centered">
                    <div class="modal-content border-0 rounded-4 shadow-lg">
                        <div class="modal-header modal-header-gradient rounded-top-4">
                            <h5 class="modal-title fw-bold">اعضای دپارتمان: <?php echo e($selectedDepartment->name); ?></h5>
                            <button type="button" class="btn-close btn-close-white" wire:click="closeDepartmentUsersModal"></button>
                        </div>
                        <div class="modal-body p-4">
                            <?php if($departmentUsers->count()): ?>
                                <div class="table-responsive">
                                    <table class="table table-hover align-middle mb-0">
                                        <thead class="table-light">
                                        <tr>
                                            <th style="width: 60px;">#</th>
                                            <th>نام کاربر</th>
                                            <th><i class="ti ti-phone fs-5 me-1"></i> موبایل</th>
                                            <th><i class="ti ti-id fs-5 me-1"></i> کد ملی</th>
                                            <th><i class="ti ti-award fs-5 me-1"></i> مدرک</th>
                                            <th><i class="ti ti-user-check fs-5 me-1"></i> وضعیت</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $departmentUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="align-middle">
                                                <td><?php echo e($index + 1); ?></td>
                                                <td>
                                                    <a href="javascript:void(0)" class="d-flex align-items-center text-decoration-none text-dark">
                                                        <?php if($user->image): ?>
                                                            <img src="<?php echo e(asset('storage/' . $user->image)); ?>" width="36" height="36" class="rounded-circle me-2 border shadow-sm" style="object-fit: cover;">
                                                        <?php else: ?>
                                                            <div class="user-initial-avatar rounded-circle me-2" style="width: 36px; height: 36px;">
                                                                <span class="fs-6 fw-bold"><?php echo e(strtoupper(mb_substr($user->name, 0, 1, 'UTF-8'))); ?></span>
                                                            </div>
                                                        <?php endif; ?>
                                                        <span class="fw-medium"><?php echo e($user->name); ?></span>
                                                    </a>
                                                </td>
                                                <td><?php echo e($user->mobile ?? '—'); ?></td>
                                                <td><?php echo e($user->ncode ?? '—'); ?></td>
                                                <td><?php echo e($user->degree ?? '—'); ?></td>
                                                <td>
                                <span class="badge bg-<?php echo e($user->is_active ? 'success' : 'secondary'); ?> rounded-pill">
                                    <?php echo e($user->is_active ? 'فعال' : 'غیرفعال'); ?>

                                </span>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4 text-muted">
                                    <i class="ti ti-users fs-1 opacity-50 mb-3"></i><br>
                                    <strong>هیچ عضوی در این دپارتمان وجود ندارد.</strong>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="modal-footer border-0 pt-0">
                            <button type="button" class="btn btn-secondary px-4 py-2 rounded-3" wire:click="closeDepartmentUsersModal">بستن</button>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\company\company-list.blade.php ENDPATH**/ ?>