<?php

use App\Livewire\Forms\LoginForm;
use Illuminate\Support\Facades\Session;
use Livewire\Attributes\Layout;
use Livewire\Volt\Component;

?>

<div class="min-h-screen flex flex-col lg:flex-row items-center justify-center bg-gradient-to-br from-cyan-50 via-blue-50 to-indigo-100 px-4 py-12 relative overflow-hidden"
     dir="rtl">

    <!-- پس‌زمینه داینامیک (روشن‌تر و نرم‌تر) -->
    <div class="absolute inset-0 opacity-15 pointer-events-none">
        <div class="absolute top-1/4 left-1/4 w-64 h-64 bg-cyan-200 rounded-full animate-pulse-slow"></div>
        <div class="absolute bottom-1/3 right-1/3 w-80 h-80 bg-blue-200 rounded-full animate-pulse-slow animation-delay-2000"></div>
        <div class="absolute top-2/3 left-1/2 w-72 h-72 bg-teal-100 rounded-full animate-pulse-slow animation-delay-4000"></div>
    </div>

    <!-- گرید پس‌زمینه (بسیار کم‌رنگ) -->
    <div class="absolute inset-0 opacity-4 pointer-events-none">
        <svg class="w-full h-full" viewBox="0 0 1440 800" xmlns="http://www.w3.org/2000/svg">
            <defs>
                <pattern id="grid" width="60" height="60" patternUnits="userSpaceOnUse">
                    <path d="M 60 0 L 0 0 0 60" fill="none" stroke="rgba(14, 165, 233, 0.08)" stroke-width="1"></path>
                </pattern>
            </defs>
            <rect width="100%" height="100%" fill="url(#grid)"></rect>
        </svg>
    </div>

    <!-- بخش سمت چپ - لوگو و توضیحات -->
    <div class="lg:w-1/2 lg:pr-12 flex-shrink-0 relative z-10 hidden lg:flex items-center justify-center">
        <div class="text-center max-w-2xl mx-auto space-y-6 animate-fade-in">
            <div class="flex justify-center mb-6">
                <div class="relative group">
                    <!-- حلقه پس‌زمینه -->
                    <div class="absolute -inset-5 bg-gradient-to-r from-cyan-300 to-teal-200 rounded-full opacity-40 transition-all duration-700 group-hover:opacity-60 group-hover:scale-110"></div>

                    <!-- لوگوی اصلی با انیمیشن چرخش -->
                    <div class="relative bg-gradient-to-br from-cyan-500 to-blue-600 p-5 rounded-3xl shadow-lg transition-transform duration-700 group-hover:rotate-6 group-active:rotate-0">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 850.39 866.3" class="w-28 h-28 lg:w-32 lg:h-32 text-white transition-transform duration-1000 ease-out group-hover:rotate-[360deg]">
                            <path fill="currentColor" d="m538.99,140.11c158.99,1.77,296,128.26,310.88,286.82,1.81,19.31-.37,36.9-18.12,48.4-26.16,16.95-60.13.25-63.53-32.51-4.61-44.38-18.34-84.89-43.97-121.48-61.46-87.76-174.07-123.45-266.88-84.16-29.57,12.52-54.58,30.91-71.72,58.71-21.12,34.27-14.36,61.85,20.63,80.99,22.18,12.13,44.64,23.92,67.64,34.38,107.55,48.86,99.27,161.14,43.66,223.74-79.12,89.07-178.41,109.59-289.18,78.16C101.3,677.08,14.16,568.77.38,436.29c-2.98-28.69,11.85-48.87,37.46-50.96,26.19-2.13,43.41,14.21,45.8,43.47,10.29,125.52,119.14,222.11,243.93,215.79,45.68-2.31,85.62-19.21,118.49-51.55,11.84-11.65,21.15-25.06,26.62-40.89,8.82-25.51-.39-49.31-24.4-61.67-27.07-13.94-54.22-27.77-81.63-41.03-84.96-41.11-87.26-132.1-54.57-187.74,36.65-62.39,92.2-98.09,161.34-114.81,21.57-5.21,43.46-6.92,65.56-6.78Z"/>
                            <path fill="#0d88" d="m432.95.02c26.42-.59,43.4,13.83,44.81,38.03,1.38,23.71-15.4,41.73-41.13,44.2-111.21,10.64-198.34,90.76-216.12,198.73-13.47,81.81,31.3,167.24,102.62,195.41,7.8,3.08,16.13,4.81,24.16,7.33,23.69,7.44,37.39,30.68,30.97,52.38-6.79,22.97-28.65,34.66-53.34,28.53-95.93-23.81-172.38-109.7-186.49-210.8C113.06,172.11,252.51,15.55,428.74.24c1.4-.12,2.81-.15,4.21-.22Z"/>
                            <path fill="#0d88" d="m715.62,557.39c.04,147.17-113.58,278.87-262.47,304.11-10.61,1.8-21.31,3.12-32,4.42-25.23,3.07-45.36-12.77-48.25-37.82-2.75-23.77,13.82-43.12,39.79-44.67,45.27-2.69,85.54-18.12,122.73-43.74,78.83-54.33,117.13-160.91,86.68-246.54-19.72-55.47-56.14-94.23-115.03-109.26-26.11-6.67-39.05-30.37-31.48-55.17,7.08-23.21,28.16-33.32,53.94-25.85,111.99,32.43,186.05,133.74,186.08,254.53Z"/>
                        </svg>
                    </div>
                </div>
            </div>

            <h2 class="text-5xl font-extrabold text-gray-800 leading-tight mt-4">
                به <span class="bg-gradient-to-r from-cyan-600 to-teal-600 text-transparent bg-clip-text animate-gradient">سامانه سرآمان</span> خوش آمدید
            </h2>

            <p class="text-gray-600 leading-relaxed text-lg max-w-md mx-auto">
                پلتفرم یکپارچه و هوشمند برای مدیریت پیشرفته پروژه‌ها و مستندات سازمانی.
            </p>

            <div class="mt-8">
                <div class="text-center text-gray-500 text-sm mb-3">دسترسی سریع</div>
                <div class="flex justify-center space-x-3 space-x-reverse">
                    <div class="px-4 py-2 bg-cyan-50 text-cyan-700 rounded-xl text-sm font-medium shadow-sm hover:bg-cyan-100 transition-colors duration-300 cursor-pointer">
                        مستندات
                    </div>
                    <div class="px-4 py-2 bg-emerald-50 text-emerald-700 rounded-xl text-sm font-medium shadow-sm hover:bg-emerald-100 transition-colors duration-300 cursor-pointer">
                        راهنما
                    </div>
                    <div class="px-4 py-2 bg-violet-50 text-violet-700 rounded-xl text-sm font-medium shadow-sm hover:bg-violet-100 transition-colors duration-300 cursor-pointer">
                        پشتیبانی
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- بخش سمت راست - فرم ورود -->
    <div class="w-full lg:w-1/2 lg:pl-12 relative z-20 flex justify-center items-center">
        <div class="w-full max-w-md mx-auto px-8 py-10 shadow-xl rounded-3xl border border-cyan-200 bg-white text-gray-800 transition-all duration-500 hover:shadow-2xl hover:shadow-cyan-200/30 hover:border-cyan-300 transform hover:-translate-y-1">

            <!-- هدر فرم -->
            <div class="text-center mb-8">
                <div class="flex justify-center mb-4">
                    <div class="relative group">
                        <div class="absolute -inset-3 bg-cyan-300 rounded-full opacity-50 transition-all duration-700 group-hover:opacity-70 group-hover:scale-110"></div>
                        <div class="relative bg-gradient-to-br from-cyan-500 to-blue-600 p-3.5 rounded-2xl shadow-lg transition-transform duration-700 group-hover:rotate-3 group-active:rotate-0">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 850.39 866.3" class="w-14 h-14 text-white transition-transform duration-1000 ease-out group-hover:rotate-[360deg]">
                                <path fill="currentColor" d="m538.99,140.11c158.99,1.77,296,128.26,310.88,286.82,1.81,19.31-.37,36.9-18.12,48.4-26.16,16.95-60.13.25-63.53-32.51-4.61-44.38-18.34-84.89-43.97-121.48-61.46-87.76-174.07-123.45-266.88-84.16-29.57,12.52-54.58,30.91-71.72,58.71-21.12,34.27-14.36,61.85,20.63,80.99,22.18,12.13,44.64,23.92,67.64,34.38,107.55,48.86,99.27,161.14,43.66,223.74-79.12,89.07-178.41,109.59-289.18,78.16C101.3,677.08,14.16,568.77.38,436.29c-2.98-28.69,11.85-48.87,37.46-50.96,26.19-2.13,43.41,14.21,45.8,43.47,10.29,125.52,119.14,222.11,243.93,215.79,45.68-2.31,85.62-19.21,118.49-51.55,11.84-11.65,21.15-25.06,26.62-40.89,8.82-25.51-.39-49.31-24.4-61.67-27.07-13.94-54.22-27.77-81.63-41.03-84.96-41.11-87.26-132.1-54.57-187.74,36.65-62.39,92.2-98.09,161.34-114.81,21.57-5.21,43.46-6.92,65.56-6.78Z"/>
                                <path fill="#ffffff" d="m432.95.02c26.42-.59,43.4,13.83,44.81,38.03,1.38,23.71-15.4,41.73-41.13,44.2-111.21,10.64-198.34,90.76-216.12,198.73-13.47,81.81,31.3,167.24,102.62,195.41,7.8,3.08,16.13,4.81,24.16,7.33,23.69,7.44,37.39,30.68,30.97,52.38-6.79,22.97-28.65,34.66-53.34,28.53-95.93-23.81-172.38-109.7-186.49-210.8C113.06,172.11,252.51,15.55,428.74.24c1.4-.12,2.81-.15,4.21-.22Z"/>
                                <path fill="#ffffff" d="m715.62,557.39c.04,147.17-113.58,278.87-262.47,304.11-10.61,1.8-21.31,3.12-32,4.42-25.23,3.07-45.36-12.77-48.25-37.82-2.75-23.77,13.82-43.12,39.79-44.67,45.27-2.69,85.54-18.12,122.73-43.74,78.83-54.33,117.13-160.91,86.68-246.54-19.72-55.47-56.14-94.23-115.03-109.26-26.11-6.67-39.05-30.37-31.48-55.17,7.08-23.21,28.16-33.32,53.94-25.85,111.99,32.43,186.05,133.74,186.08,254.53Z"/>
                            </svg>
                        </div>
                    </div>
                </div>
                <h2 class="text-3xl font-bold text-gray-800 mb-2">
                    ورود به سامانه
                </h2>
                <p class="text-gray-600 text-sm">لطفاً اطلاعات کاربری خود را وارد کنید</p>
            </div>

            <!-- خطاها -->
            <?php $__errorArgs = ['form.email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="bg-red-50 border-r-4 border-red-500 text-red-700 p-4 rounded-xl mb-5 text-sm font-medium flex items-center animate-fade-in">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 ml-2 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <span><?php echo e($message); ?></span>
            </div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

            <form wire:submit="login" class="space-y-6">
                <!-- ایمیل -->
                <div class="relative">
                    <label for="email" class="block mb-2 font-medium text-gray-700 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-2 text-cyan-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                        </svg>
                        آدرس ایمیل
                    </label>
                    <input wire:model="form.email"
                           id="email"
                           class="w-full text-right border border-gray-300 focus:border-cyan-500 focus:ring-2 focus:ring-cyan-200 rounded-xl py-3.5 px-4 bg-white text-gray-800 placeholder:text-gray-400 text-sm transition-colors duration-300"
                           type="email"
                           required
                           placeholder="name@company.com" />
                </div>

                <!-- رمز عبور -->
                <div class="relative">
                    <label for="password" class="block mb-2 font-medium text-gray-700 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-2 text-cyan-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                        </svg>
                        رمز عبور
                    </label>
                    <input wire:model="form.password"
                           id="password"
                           class="w-full text-right border border-gray-300 focus:border-cyan-500 focus:ring-2 focus:ring-cyan-200 rounded-xl py-3.5 px-4 bg-white text-gray-800 placeholder:text-gray-400 text-sm transition-colors duration-300"
                           type="password"
                           required
                           placeholder="••••••••" />
                    <?php $__errorArgs = ['form.password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-2 text-red-600 text-xs flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <?php echo e($message); ?>

                    </p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- گزینه‌ها -->
                <div class="flex items-center justify-between text-sm pt-1">
                    <label class="flex items-center cursor-pointer">
                        <input wire:model="form.remember" type="checkbox" class="rounded text-cyan-600 focus:ring-cyan-500 border-gray-300">
                        <span class="mr-2 text-gray-700">مرا به خاطر بسپار</span>
                    </label>

                    <?php if(Route::has('password.request')): ?>
                        <a href="<?php echo e(route('password.request')); ?>" wire:navigate class="text-cyan-600 hover:text-cyan-700 font-medium flex items-center group">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1 group-hover:scale-110 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                            </svg>
                            فراموشی رمز عبور
                        </a>
                    <?php endif; ?>
                </div>

                <!-- دکمه ورود -->
                <button type="submit"
                        class="w-full py-3.5 bg-gradient-to-r from-cyan-600 to-blue-600 hover:from-cyan-500 hover:to-blue-500 rounded-xl shadow-md text-white font-bold text-base transition-all duration-300 mt-4 flex items-center justify-center group relative overflow-hidden"
                        wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="login" class="flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-2 transition-transform group-hover:translate-x-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1" />
                        </svg>
                        ورود به سیستم
                    </span>
                    <span wire:loading wire:target="login" class="flex items-center">
                        <svg class="animate-spin h-4 w-4 ml-2 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        در حال اتصال...
                    </span>
                </button>
            </form>

            <!-- ثبت‌نام -->
            <div class="mt-10 pt-6 border-t border-gray-200 text-center">
                <p class="text-gray-600 text-sm mb-3">حساب کاربری ندارید؟</p>
                <a href="<?php echo e(route('multi.register')); ?>" wire:navigate
                   class="inline-flex items-center px-5 py-2.5 border-2 border-cyan-500 text-cyan-600 hover:bg-cyan-50 rounded-xl text-sm font-semibold transition-colors group">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1.5 group-hover:scale-110 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z" />
                    </svg>
                    ایجاد حساب جدید
                </a>
            </div>
        </div>
    </div>

    <style>
        @keyframes fade-in {
            from { opacity: 0; transform: translateY(12px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes pulse-slow {
            0%, 100% { opacity: 0.15; transform: scale(1); }
            50% { opacity: 0.3; transform: scale(1.03); }
        }

        @keyframes ping-slow {
            0% { transform: scale(0.8); opacity: 0.7; }
            75%, 100% { transform: scale(1.4); opacity: 0; }
        }

        @keyframes gradient {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        .animate-fade-in {
            animation: fade-in 0.6s ease-out;
        }

        .animate-pulse-slow {
            animation: pulse-slow 10s infinite;
        }

        .animate-ping-slow {
            animation: ping-slow 4s infinite;
        }

        .animation-delay-2000 {
            animation-delay: 2s;
        }

        .animation-delay-4000 {
            animation-delay: 4s;
        }

        .animate-gradient {
            background-size: 200% 200%;
            animation: gradient 5s ease infinite;
        }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\pages\auth\login.blade.php ENDPATH**/ ?>