<div class="container-fluid py-4">
    <style>
        /* 💡 استایل‌های نهایی برای تم فروش (سبز زمردی) */
        :root {
            --primary: #4f46e5;
            --success: #10b981; /* Emerald Green */
            --danger: #ef4444;
            --gray-100: #f3f4f6;
            --gray-700: #374151;
            --gray-900: #111827;
            --radius-lg: 1rem;
            --shadow-card: 0 4px 20px rgba(0,0,0,0.04);
            --success-bg: #e6fbe6;
            --info-light-bg: #f0f7ff;
            --success-border: #16a34a;
        }

        .modern-card {
            background: white;
            border-radius: var(--radius-lg);
            padding: 1.75rem;
            box-shadow: var(--shadow-card);
            border: 1px solid var(--gray-200);
            overflow: hidden;
        }

        .card-header-modern {
            background: linear-gradient(135deg, var(--success) 0%, #34d399 100%); /* Green Gradient for AR */
            color: white;
            padding: 1.25rem 1.75rem;
            margin: -1.75rem -1.75rem 1.5rem -1.75rem;
            border-radius: var(--radius-lg) var(--radius-lg) 0 0 !important;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 0.75rem 0;
            border-bottom: 1px solid var(--gray-100);
        }
        .info-label { font-weight: 600; color: var(--gray-700); font-size: 0.95rem; }
        .info-value { color: var(--gray-900); font-weight: 500; }
        .purpose-box { background: var(--gray-100); border-radius: var(--radius-lg); padding: 1.25rem; margin-top: 0.5rem; }
        .total-summary-box {
            background: var(--success-bg);
            border-left: 5px solid var(--success);
            padding: 1.5rem;
            border-radius: var(--radius-lg);
        }
        .total-amount-display { font-size: 1.5rem; font-weight: 800; color: var(--success); }

        .attachment-item { border: 1px solid var(--border-color-subtle); padding: 0.75rem; border-radius: 0.5rem; margin-bottom: 0.5rem; background: white; box-shadow: var(--shadow-subtle); display: flex; align-items: center; justify-content: space-between; }
        .attachment-icon-box { width: 32px; height: 32px; border-radius: 0.5rem; background: var(--success-light); color: var(--success); display: flex; align-items: center; justify-content: center; flex-shrink: 0; }

        @media print {
            .no-print { display: none !important; }
            .modern-card { box-shadow: none !important; border: none !important; padding: 0; }
        }
    </style>

    <div class="row justify-content-center">
        <div class="col-12 col-xl-10">
            <div class="modern-card no-print mb-4">
                <div class="d-flex justify-content-between align-items-center">
                    <a href="<?php echo e(route('admin.sales.list')); ?>" class="back-button btn btn-outline-secondary rounded-pill">
                        <i class="ti ti-arrow-left me-2"></i> بازگشت به لیست فاکتورها
                    </a>

                    <div class="action-bar-top d-flex gap-2">
                        <?php if($request->status === 'issued'): ?>
                            <button wire:click="recordPayment" wire:confirm="آیا مطمئن هستید که پرداخت این فاکتور دریافت شده است؟" class="btn btn-success action-btn-lg rounded-pill">
                                <i class="ti ti-cash me-2"></i> ثبت دریافت وجه
                            </button>
                        <?php endif; ?>
                        <button wire:click="printInvoice" class="btn btn-outline-primary action-btn-lg rounded-pill">
                            <i class="ti ti-printer me-2"></i> چاپ (PDF)
                        </button>
                    </div>
                </div>
            </div>

            <?php if(session()->has('message') || session()->has('error')): ?>
                <div class="alert alert-<?php echo e(session()->has('message') ? 'success' : 'danger'); ?> mb-3 no-print">
                    <?php echo e(session('message') ?? session('error')); ?>

                </div>
            <?php endif; ?>

            <div class="modern-card" id="invoice-document">
                <div class="card-header-modern">
                    <h2 class="mb-0 fw-bold">فاکتور فروش: #<?php echo e($request->invoice_number); ?></h2>
                </div>

                <div class="row g-4">
                    
                    <div class="col-lg-6">
                        <h5 class="fw-bold text-gray-700 mb-3">مشخصات اصلی فاکتور</h5>
                        <div class="p-4 border rounded-3 bg-light-info">
                            <div class="info-row">
                                <span class="info-label">پروژه:</span>
                                <span class="info-value"><?php echo e($request->project->name ?? '—'); ?></span>
                            </div>
                            <div class="info-row">
                                <span class="info-label">ثبت‌کننده:</span>
                                <span class="info-value"><?php echo e($request->user->name ?? '—'); ?></span>
                            </div>
                            <div class="info-row">
                                <span class="info-label">مشتری/خریدار:</span>
                                <span class="info-value fw-bold"><?php echo e($request->client_name); ?></span>
                            </div>
                            <div class="info-row">
                                <span class="info-label">تاریخ صدور:</span>
                                <span class="info-value"><?php echo e($this->created_at_shamsi); ?></span>
                            </div>
                            <div class="info-row border-bottom-0">
                                <span class="info-label">تاریخ سررسید:</span>
                                <span class="info-value text-primary fw-bold"><?php echo e($this->due_date_shamsi); ?></span>
                            </div>
                        </div>

                        <div class="mt-4">
                            <h6 class="fw-bold text-gray-700 mb-2">توضیحات فاکتور</h6>
                            <div class="purpose-box">
                                <?php echo e($request->description ?? '—'); ?>

                            </div>
                        </div>

                        <?php if($request->attachments->isNotEmpty()): ?>
                            <div class="mt-4 pt-3 border-top">
                                <h5 class="fw-bold text-gray-700 mb-3">پیوست‌ها (<?php echo e($request->attachments->count()); ?>)</h5>
                                <?php $__currentLoopData = $request->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="attachment-item">
                                        <div class="attachment-icon-box">
                                            <i class="ti ti-file-invoice text-success"></i>
                                        </div>
                                        <div class="attachment-name">
                                            <?php echo e($attachment->original_name); ?>

                                        </div>
                                        <a href="<?php echo e($attachment->getUrlAttribute()); ?>" target="_blank" class="btn btn-sm btn-outline-success">
                                            <i class="ti ti-download"></i>
                                        </a>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>

                        <div class="d-grid mt-4 gap-2 no-print">
                            <?php if($request->status === 'issued'): ?>
                                <button wire:click="recordPayment" wire:confirm="آیا مطمئن هستید که پرداخت این فاکتور دریافت شده است؟" class="btn btn-lg btn-success rounded-pill">
                                    <i class="ti ti-cash me-2"></i> ثبت دریافت وجه
                                </button>
                            <?php endif; ?>
                            <?php if($request->status === 'issued' || $request->status === 'pending'): ?>
                                <button wire:click="cancelInvoice" wire:confirm="آیا مطمئن هستید که می‌خواهید فاکتور را لغو کنید؟" class="btn btn-sm btn-outline-danger rounded-pill">
                                    <i class="ti ti-x me-2"></i> لغو فاکتور
                                </button>
                            <?php endif; ?>
                            <button wire:click="printInvoice" class="btn btn-sm btn-outline-secondary rounded-pill">
                                <i class="ti ti-printer me-2"></i> چاپ فاکتور (PDF)
                            </button>
                        </div>
                    </div>

                    
                    <div class="col-lg-6">
                        <h5 class="fw-bold text-gray-700 mb-3">آیتم‌های فاکتور</h5>
                        <div class="table-responsive mb-4">
                            <table class="table table-sm table-striped mb-0">
                                <thead class="table-item-head bg-success">
                                <tr>
                                    <th>شرح</th>
                                    <th>تعداد</th>
                                    <th>قیمت واحد (<?php echo e($request->currency); ?>)</th>
                                    <th>جمع جزء (<?php echo e($request->currency); ?>)</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $request->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="fw-medium"><?php echo e($item->description); ?></td>
                                        <td><?php echo e($item->quantity); ?></td>
                                        <td><?php echo e(number_format($item->unit_price)); ?></td>
                                        <td><?php echo e(number_format($item->subtotal)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="total-summary-box mt-4">
                            <h5 class="fw-bold text-success border-bottom pb-2 mb-3">خلاصه مالی</h5>

                            <div class="detail-row">
                                <span class="info-label">مبلغ خالص (Net):</span>
                                <span class="fw-bold"><?php echo e(number_format($request->net_amount)); ?> <?php echo e($request->currency); ?></span>
                            </div>
                            <div class="detail-row">
                                <span class="info-label">مالیات / ارزش افزوده:</span>
                                <span class="fw-bold text-danger"><?php echo e(number_format($request->tax_amount)); ?> <?php echo e($request->currency); ?></span>
                            </div>

                            <div class="total-summary-final">
                                <div class="d-flex justify-content-between pt-2">
                                    <span class="info-label fs-5">مبلغ نهایی (<?php echo e($request->currency); ?>):</span>
                                    <span class="fw-bold fs-5 text-success"><?php echo e(number_format($request->total_amount)); ?></span>
                                </div>
                                <?php if($request->currency !== 'IRR'): ?>
                                    <div class="d-flex justify-content-between pt-2 mt-2 border-top">
                                        <span class="info-label text-primary">معادل ریالی نهایی:</span>
                                        <span class="fw-bold text-primary"><?php echo e(number_format($request->total_amount_irr)); ?> IRR</span>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // 💡 اجرای چاپ
                Livewire.on('print-document', () => {
                    window.print();
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\sales\show-sales-invoice.blade.php ENDPATH**/ ?>