<div wire:ignore.self class="modal fade" id="revisionModal" tabindex="-1" aria-labelledby="revisionModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header bg-secondary text-white" style="border-radius: 14px 14px 0 0;">
                <h5 class="modal-title" id="revisionModalLabel">
                    <i class="fas fa-history me-2"></i>
                    <?php echo e(__('تاریخچه رویژن‌ها')); ?> (<?php echo e($revisionDocId ? MasterDocument::find($revisionDocId)?->document_number : 'N/A'); ?>)
                </h5>
                <button type="button" class="btn-close btn-close-white" wire:click="closeRevisionModal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">

                <button class="btn btn-outline-primary btn-modern mb-3" type="button" data-bs-toggle="collapse" data-bs-target="#addRevisionCollapse" aria-expanded="false">
                    <i class="fas fa-plus me-1"></i> <?php echo e(__('افزودن رویژن جدید')); ?>

                </button>

                <div class="collapse mb-4 p-3 border rounded-3 bg-light" id="addRevisionCollapse">
                    <h6 class="fw-bold mb-3"><?php echo e(__('جزئیات رویژن جدید')); ?></h6>
                    <form wire:submit.prevent="addRevision" class="row g-3">
                        <div class="col-md-3">
                            <div class="form-floating">
                                <input type="text" class="form-control <?php $__errorArgs = ['new_revision_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Rev.XX" wire:model.defer="new_revision_number">
                                <label><?php echo e(__('شماره رویژن')); ?> *</label>
                                <?php $__errorArgs = ['new_revision_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label d-block"><?php echo e(__('نوع POI (اختیاری)')); ?></label>
                            <select class="form-select <?php $__errorArgs = ['new_revision_poi_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model.defer="new_revision_poi_type">
                                <option value=""><?php echo e(__('بدون POI')); ?></option>
                                <option value="IFC">IFC</option>
                                <option value="IFA">IFA</option>
                                <option value="AFC">AFC</option>
                                <option value="IFI">IFI</option>
                                <option value="Rec">Rec</option>
                            </select>
                            <?php $__errorArgs = ['new_revision_poi_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating">
                                <input type="text" class="form-control <?php $__errorArgs = ['new_revision_remark'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(__('شرح تغییرات')); ?>" wire:model.defer="new_revision_remark">
                                <label><?php echo e(__('شرح تغییرات (اختیاری)')); ?></label>
                                <?php $__errorArgs = ['new_revision_remark'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="form-label d-block"><i class="fas fa-file-upload me-1"></i> <?php echo e(__('فایل(ها)ی رویژن')); ?></label>
                            <input type="file" class="form-control <?php $__errorArgs = ['new_revision_files.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model="new_revision_files" multiple>
                            <div wire:loading wire:target="new_revision_files" class="text-info mt-1"><i class="fas fa-spinner fa-spin"></i> <?php echo e(__('در حال بارگذاری فایل‌ها...')); ?></div>
                            <?php $__errorArgs = ['new_revision_files.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-12 text-end">
                            <button type="submit" class="btn btn-success btn-modern" wire:loading.attr="disabled">
                                <span wire:loading wire:target="addRevision"><i class="fas fa-spinner fa-spin"></i></span>
                                <span wire:loading.remove wire:target="addRevision"><i class="fas fa-check me-1"></i> <?php echo e(__('ثبت رویژن')); ?></span>
                            </button>
                        </div>
                    </form>
                </div>

                <h6 class="fw-bold mb-3 mt-4"><?php echo e(__('لیست رویژن‌ها')); ?></h6>
                <?php $__empty_1 = true; $__currentLoopData = $revisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $revision): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $statusClass = match($revision->status) {
                            'تایید شده' => 'bg-success',
                            'رد شده' => 'bg-danger',
                            'ارسال شده' => 'bg-warning text-dark',
                            default => 'bg-secondary'
                        };
                    ?>
                    <div class="card mb-3 shadow-sm" wire:key="revision-<?php echo e($revision->id); ?>">
                        <div class="card-body p-3">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <h5 class="mb-1 fw-bold" style="color: var(--brand-dark);">
                                        <i class="fas fa-code-branch me-2"></i>
                                        <?php echo e($revision->revision); ?>

                                        <span class="badge <?php echo e($statusClass); ?> text-white ms-2"><?php echo e($revision->status); ?></span>
                                    </h5>
                                    <p class="mb-1 text-muted small">
                                        <?php echo e(__('تاریخ')); ?>: <?php echo e($revision->date_formatted); ?> |
                                        <?php echo e(__('نوع')); ?>: <?php echo e($revision->revision_type); ?>

                                        <?php if($revision->poi_type): ?> | <span class="badge bg-primary"><?php echo e(__('POI')); ?>: <?php echo e($revision->poi_type); ?></span> <?php endif; ?>
                                    </p>
                                    <?php if($revision->remark): ?>
                                        <p class="mb-1 fst-italic"><i class="fas fa-comment-dots me-1"></i> <?php echo e($revision->remark); ?></p>
                                    <?php endif; ?>
                                </div>
                                <div class="d-flex flex-column gap-2 align-items-end">
                                    <button class="btn btn-icon btn-sm btn-outline-danger" onclick="confirm('<?php echo e(__('آیا مطمئن هستید؟')); ?>') || event.stopImmediatePropagation()" wire:click="deleteRevision(<?php echo e($revision->id); ?>)" title="<?php echo e(__('حذف رویژن')); ?>">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </div>
                            <hr class="my-2">

                            <h6 class="fw-bold mt-2 mb-2"><?php echo e(__('فایل‌های پیوست')); ?> (<?php echo e($revision->files->count()); ?>)</h6>
                            <div class="d-flex flex-wrap gap-2 mb-2">
                                <?php $__empty_2 = true; $__currentLoopData = $revision->files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                    <a href="<?php echo e(asset('storage/' . $file->file_path)); ?>" target="_blank" class="btn btn-sm btn-outline-dark btn-modern" title="<?php echo e($file->file_name); ?>">
                                        <i class="fas fa-file-alt me-1"></i> <?php echo e(Str::limit($file->file_name, 20)); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                    <span class="text-muted small"><?php echo e(__('هیچ فایلی برای این رویژن آپلود نشده است.')); ?></span>
                                <?php endif; ?>
                            </div>

                            <button class="btn btn-sm btn-outline-info mt-2" type="button" wire:click="$toggle('addFileToRevisionId', <?php echo e($revision->id); ?>)">
                                <i class="fas fa-plus me-1"></i> <?php echo e(__('افزودن فایل به این رویژن')); ?>

                            </button>

                            <?php if($addFileToRevisionId == $revision->id): ?>
                                <form wire:submit.prevent="addFilesToRevision(<?php echo e($revision->id); ?>)" class="mt-2 p-2 border rounded bg-white">
                                    <label class="form-label small fw-bold"><?php echo e(__('آپلود فایل جدید')); ?> *</label>
                                    <input type="file" class="form-control form-control-sm <?php $__errorArgs = ['new_files_for_revision.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model="new_files_for_revision" multiple>
                                    <div wire:loading wire:target="new_files_for_revision" class="text-info mt-1"><i class="fas fa-spinner fa-spin"></i> <?php echo e(__('در حال بارگذاری...')); ?></div>
                                    <?php $__errorArgs = ['new_files_for_revision.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <?php $__errorArgs = ['new_files_for_revision'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <button type="submit" class="btn btn-success btn-sm mt-2" wire:loading.attr="disabled">
                                        <span wire:loading wire:target="addFilesToRevision"><i class="fas fa-spinner fa-spin"></i></span>
                                        <?php echo e(__('ثبت فایل‌ها')); ?>

                                    </button>
                                </form>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="alert alert-warning text-center">
                        <i class="fas fa-exclamation-circle me-1"></i> <?php echo e(__('هیچ رویژنی ثبت نشده است.')); ?>

                    </div>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-modern" wire:click="closeRevisionModal"><?php echo e(__('بستن')); ?></button>
            </div>
        </div>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\m-d-r\modals\revision-modal.blade.php ENDPATH**/ ?>