<div>
    <div>
        <section class="mt-4">
            <div class="card shadow-lg border-0 rounded-4 overflow-hidden">
                <div class="card-header bg-light border-bottom py-3">
                    <h5 class="fw-semibold mb-0 text-primary-dark">
                        <i class="ti ti-list me-2"></i> لیست نقش‌های موجود در سیستم
                    </h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover align-middle mb-0">
                            <thead class="bg-deep-blue text-white shadow-sm">
                            <tr>
                                <th class="py-3 px-4 fw-bold" style="width: 70%;">نام نقش</th>
                                <th class="py-3 px-4 fw-bold text-center" style="width: 30%; min-width: 170px;">عملیات</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="table-row-hover">
                                    <td class="px-4 fw-medium text-primary-dark fs-6"><?php echo e($role->name); ?></td>
                                    <td class="text-center">
                                        <div class="d-flex justify-content-center gap-2">
                                            <!-- دکمه ویرایش: ارسال رویداد edit-role-request -->
                                            <button wire:click="dispatchEditRole(<?php echo e($role->id); ?>)" class="btn btn-sm btn-action-secondary-light text-dark rounded-pill px-3 py-2" title="ویرایش">
                                                <i class="ti ti-edit fs-5"></i>
                                            </button>

                                            <!-- دکمه حذف: استفاده از Livewire Confirm و ارسال رویداد delete-role-request -->
                                            <button wire:click="dispatchDeleteRole(<?php echo e($role->id); ?>)"
                                                    wire:confirm="آیا مطمئن هستید که نقش <?php echo e($role->name); ?> حذف شود؟"
                                                    class="btn btn-sm btn-danger rounded-pill px-3 py-2" title="حذف">
                                                <i class="ti ti-trash fs-5"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="2" class="text-center py-4 text-muted fw-medium">
                                        <i class="ti ti-info-circle me-2"></i> نقشی برای نمایش وجود ندارد.
                                    </td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- استایل‌های سفارشی (برای هماهنگی با طرح قبلی) -->
    <style>
        /* Color Palettes - باید با کامپوننت AddRoles یکسان باشد */
        :root {
            --primary-dark: #1A2538;
            --action-color: #4361EE;
            --action-dark: #3A4FCD;
            --action-secondary: #00BF63;
            --action-secondary-light: #E0F7EB;
        }

        .bg-deep-blue { background-color: var(--primary-dark) !important; }
        .text-primary-dark { color: var(--primary-dark) !important; }

        .btn-action-secondary-light {
            background-color: var(--action-secondary-light) !important;
            border-color: var(--action-secondary-light);
            color: var(--primary-dark) !important;
        }
        .btn-action-secondary-light:hover {
            background-color: #C8F0DD !important;
            border-color: #C8F0DD !important;
        }

        .table-row-hover:hover {
            background-color: #f0f4ff;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
    </style>

</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\roles\roles-list.blade.php ENDPATH**/ ?>